/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.AbstractFileAdvisor;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProhibitUnusedImportsAdvisor
extends AbstractFileAdvisor {
    public static final String ID_PROHIBIT_UNUSED_IMPORT_PROBLEM = "com.ibm.team.process.definitions.prohibitUnusedImportProblem";
    public static final String ID_PROHIBIT_UNUSED_IMPORTS = "com.ibm.team.process.deliver.prohibitUnusedImports";
    private List fFilesWithUnusedImports;

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fFilesWithUnusedImports = new ArrayList();
        super.run(operation, advisorConfiguration, collector, monitor);
        if (this.fFilesWithUnusedImports.size() > 0) {
            IAdvisorInfo problem = collector.createProblemInfo(Messages.ProhibitUnusedImportsAdvisor_0, Messages.ProhibitUnusedImportsAdvisor_1, ID_PROHIBIT_UNUSED_IMPORT_PROBLEM);
            problem.setProblemObject((Object)this.fFilesWithUnusedImports);
            collector.addInfo((IReportInfo)problem);
        }
    }

    protected IReportInfo getProblem(IFile file, IAdvisorInfoCollector collector, IProgressMonitor monitor) {
        monitor.beginTask(Messages.ProhibitUnusedImportsAdvisor_2, 1);
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.jdt.core.problem", false, 2);
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                int id = marker.getAttribute("id", -1);
                if (id == 268435844) {
                    this.fFilesWithUnusedImports.add(file);
                    break;
                }
                ++i;
            }
            return null;
        }
        catch (CoreException e) {
            IAdvisorInfo iAdvisorInfo = collector.createExceptionInfo(NLS.bind((String)Messages.ProhibitUnusedImportsAdvisor_3, (Object)file.getFullPath().toString()), (Throwable)e);
            return iAdvisorInfo;
        }
        finally {
            monitor.done();
        }
    }

    protected void appendToProblemData(Element dataElement, Object custom, Document doc) {
    }
}

