/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui;

import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.Messages;
import com.ibm.team.process.internal.ide.ui.EditorUtilities;
import com.ibm.team.process.internal.ide.ui.TeamRepositoryExceptionNode;
import com.ibm.team.process.internal.ide.ui.editors.TeamAreaCategory;
import com.ibm.team.process.internal.ide.ui.editors.util.AbstractDeferredContentProvider;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaCategory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class WorkItemCategoriesDomain
extends Domain {
    private static final String PAGE_ID = "com.ibm.team.workitem.category";
    private WorkItemCategoriesContentProvider fWorkItemCategoriesContentProvider;
    private WorkItemCategoryLabelProvider fWorkItemCategoryLabelProvider;

    public boolean supportsCategory(Category category) {
        if (category instanceof IProcessAreaCategory) {
            return ((IProcessAreaCategory)category).isTeamAreaCategory();
        }
        return false;
    }

    public boolean confineToSupportedCategories() {
        return true;
    }

    public ITreePathContentProvider getContentProvider() {
        if (this.fWorkItemCategoriesContentProvider == null) {
            this.fWorkItemCategoriesContentProvider = new WorkItemCategoriesContentProvider();
        }
        return this.fWorkItemCategoriesContentProvider;
    }

    public ITreePathLabelProvider getLabelProvider() {
        if (this.fWorkItemCategoryLabelProvider == null) {
            this.fWorkItemCategoryLabelProvider = new WorkItemCategoryLabelProvider();
        }
        return this.fWorkItemCategoryLabelProvider;
    }

    public void dispose() {
        if (this.fWorkItemCategoriesContentProvider != null) {
            this.fWorkItemCategoriesContentProvider.dispose();
            this.fWorkItemCategoriesContentProvider = null;
        }
        if (this.fWorkItemCategoryLabelProvider != null) {
            this.fWorkItemCategoryLabelProvider.dispose();
            this.fWorkItemCategoryLabelProvider.dispose();
        }
        super.dispose();
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        final IWorkbenchPartSite workbenchPartSite = this.getWorkbenchPart().getSite();
        manager.appendToGroup("jazz.open.group", (IAction)new Action(Messages.WorkItemCategoriesDomain_3){

            public void run() {
                TeamAreaCategory category = (TeamAreaCategory)WorkItemCategoriesDomain.this.getCategory();
                ITeamArea teamArea = category.getTeamArea();
                EditorUtilities.openProjectAreaEditor((IWorkbenchPage)workbenchPartSite.getPage(), (IProjectAreaHandle)teamArea.getProjectArea(), (String)WorkItemCategoriesDomain.PAGE_ID);
            }
        });
    }

    public boolean contains(Object element) {
        return element instanceof ICategory || element instanceof CategoryNode;
    }

    public Object convertToModel(Object object) {
        if (object instanceof CategoryNode) {
            CategoryNode node = (CategoryNode)object;
            return node.fWorkItemCategory;
        }
        return super.convertToModel(object);
    }

    public Object convertToSelection(Object object) {
        if (object instanceof ICategory) {
            return new CategoryNode((ICategory)object);
        }
        return super.convertToSelection(object);
    }

    private static class CategoryNode {
        private final ICategory fWorkItemCategory;
        private final String fHierarchicalName;
        private final CategoryId fCategoryId;

        public CategoryNode(ICategory category) {
            this(category, category.getCategoryId(), null);
        }

        public CategoryNode(CategoryId categoryId) {
            this(null, categoryId, null);
        }

        public CategoryNode(ICategory category, String hierarchicalName) {
            this(category, category.getCategoryId(), hierarchicalName);
        }

        private CategoryNode(ICategory category, CategoryId categoryId, String hierarchicalName) {
            this.fWorkItemCategory = category;
            this.fCategoryId = categoryId;
            this.fHierarchicalName = hierarchicalName;
        }

        public String getName() {
            if (this.fHierarchicalName != null) {
                return this.fHierarchicalName;
            }
            if (this.fWorkItemCategory != null) {
                return this.fWorkItemCategory.getName();
            }
            return this.fCategoryId.getInternalRepresentation();
        }

        public CategoryId getCategoryId() {
            return this.fCategoryId;
        }

        public int hashCode() {
            return this.getCategoryId().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            return this.getCategoryId().equals((Object)((CategoryNode)o).getCategoryId());
        }
    }

    private class WorkItemCategoriesContentProvider
    extends AbstractDeferredContentProvider {
        private List fRoots = new ArrayList();
        private List fChildren = new ArrayList();
        private HashMap fParentChildrenMap = new HashMap();

        private WorkItemCategoriesContentProvider() {
        }

        protected Object[] computeChildren(Object parentElement, IProgressMonitor monitor) {
            if (parentElement instanceof DomainSubtreeRoot) {
                ITeamArea area = (ITeamArea)((DomainSubtreeRoot)parentElement).getCategoryElement();
                ITeamRepository repository = (ITeamRepository)area.getOrigin();
                IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                monitor.beginTask(Messages.WorkItemCategoriesDomain_0, 500);
                try {
                    List categories = workItemClient.findCategoriesOfTeamArea((ITeamAreaHandle)area, ICategory.DEFAULT_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.buildTree(categories, workItemClient, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
                    Object[] objectArray = this.fRoots.toArray();
                    return objectArray;
                }
                catch (TeamRepositoryException x) {
                    DefinitionsIdeUIPlugin.getDefault().log(NLS.bind((String)Messages.WorkItemCategoriesDomain_1, (Object[])new Object[]{area.getName()}), x);
                    Object[] objectArray = new Object[]{new TeamRepositoryExceptionNode(x)};
                    return objectArray;
                }
                finally {
                    monitor.done();
                }
            }
            return EMPTY;
        }

        private void buildTree(List categories, IWorkItemClient workItemClient, IProgressMonitor monitor) throws TeamRepositoryException {
            Collections.sort(categories, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ICategory c1 = (ICategory)o1;
                    ICategory c2 = (ICategory)o2;
                    return c1.getCategoryId().compareTo(c2.getCategoryId());
                }
            });
            monitor.beginTask(Messages.WorkItemCategoriesDomain_2, categories.size() * 100);
            try {
                for (ICategory category : categories) {
                    if (category.isArchived()) continue;
                    CategoryNode parent = new CategoryNode(category.getParentId2());
                    if (this.isTreeNode(parent)) {
                        ArrayList<CategoryNode> directChildren = (ArrayList<CategoryNode>)this.fParentChildrenMap.get(parent);
                        if (directChildren == null) {
                            directChildren = new ArrayList<CategoryNode>();
                            this.fParentChildrenMap.put(parent, directChildren);
                        }
                        CategoryNode child = new CategoryNode(category);
                        directChildren.add(child);
                        this.fChildren.add(child);
                        monitor.worked(100);
                        continue;
                    }
                    String hierarchicalName = workItemClient.resolveHierarchicalName((ICategoryHandle)category, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.fRoots.add(new CategoryNode(category, hierarchicalName));
                }
            }
            finally {
                monitor.done();
            }
        }

        private boolean isTreeNode(CategoryNode parent) {
            return this.fRoots.contains(parent) || this.fChildren.contains(parent);
        }

        public boolean hasChildren(Object parentElement) {
            if (parentElement instanceof CategoryNode) {
                return this.fParentChildrenMap.containsKey(parentElement);
            }
            return super.hasChildren(parentElement);
        }

        public Object[] getChildren(Object parentElement) {
            List children;
            if (parentElement instanceof CategoryNode && (children = (List)this.fParentChildrenMap.get(parentElement)) != null) {
                return children.toArray();
            }
            return super.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }
    }

    private static class WorkItemCategoryLabelProvider
    extends TypeLabelProvider
    implements ITreePathLabelProvider {
        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof CategoryNode) {
                ImageDescriptor descriptor = DefinitionsIdeUIPlugin.getImageDescriptor("icons/obj16/category_obj.gif");
                Image image = this.getResources().createImageWithDefault(descriptor);
                label.setImage(image);
                CategoryNode node = (CategoryNode)element;
                label.setText(node.getName());
            }
        }

        public void updateLabel(ViewerLabel label, TreePath elementPath) {
            this.updateLabel(label, elementPath.getLastSegment());
        }
    }
}

