/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.internal.definitions.ide.ui.Messages;
import com.ibm.team.process.rcp.ui.RepositoryCreationWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.dialogs.ListDialog;

public class DeployProcessDefinitions
implements IViewActionDelegate {
    private Job fRunningJob;
    private IViewPart fViewPart;

    public void init(IViewPart view) {
        this.fViewPart = view;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IAction action) {
        final ITeamRepository repository = this.getTeamRepository();
        if (repository == null) {
            return;
        }
        if (this.fRunningJob == null) {
            DeployProcessDefinitions deployProcessDefinitions = this;
            synchronized (deployProcessDefinitions) {
                if (this.fRunningJob == null) {
                    this.fRunningJob = new Job(Messages.DeployProcessDefinitions_0){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                try {
                                    monitor.beginTask(Messages.DeployProcessDefinitions_1, -1);
                                    if (!repository.loggedIn()) {
                                        repository.login((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                    IProcessItemService clientService = (IProcessItemService)repository.getClientLibrary(IProcessItemService.class);
                                    clientService.deployPredefinedProcessDefinitions(null, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                                }
                                catch (TeamRepositoryException x) {
                                    Status status = new Status(4, "com.ibm.team.process.definitions.ide.ui", 0, x.getMessage(), (Throwable)x);
                                    DeployProcessDefinitions.this.fRunningJob = null;
                                    monitor.done();
                                    return status;
                                }
                            }
                            finally {
                                DeployProcessDefinitions.this.fRunningJob = null;
                                monitor.done();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                }
            }
            this.fRunningJob.setUser(true);
            this.fRunningJob.schedule();
        }
    }

    private ITeamRepository getTeamRepository() {
        Object element;
        IStructuredSelection ss;
        ISelection selection;
        ISelectionProvider selectionProvider = this.fViewPart.getSite().getSelectionProvider();
        if (selectionProvider != null && !(selection = selectionProvider.getSelection()).isEmpty() && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof ITeamRepository) {
            return (ITeamRepository)element;
        }
        return this.selectTeamRepository();
    }

    private ITeamRepository selectTeamRepository() {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        if (repositories == null || repositories.length == 0) {
            WizardDialog wd = new WizardDialog(this.getShell(), (IWizard)new RepositoryCreationWizard());
            wd.open();
            repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            if (repositories == null || repositories.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.DeployProcessDefinitions_0, (String)Messages.DeployProcessDefinitions_3);
                return null;
            }
        }
        ITeamRepository repo = null;
        if (repositories.length == 1) {
            repo = repositories[0];
        } else {
            ListDialog dialog = new ListDialog(this.getShell());
            dialog.setTitle(Messages.DeployProcessDefinitions_4);
            dialog.setLabelProvider((ILabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
            dialog.setContentProvider(new IStructuredContentProvider(){
                private Object[] fInput;

                public Object[] getElements(Object inputElement) {
                    return this.fInput;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    this.fInput = (Object[])newInput;
                }
            });
            dialog.setInput((Object)repositories);
            dialog.setInitialSelections((Object[])new ITeamRepository[]{repositories[0]});
            if (dialog.open() == 0 && dialog.getResult().length == 1) {
                Object[] result = dialog.getResult();
                repo = (ITeamRepository)result[0];
            }
        }
        return repo;
    }

    private Shell getShell() {
        return this.fViewPart.getSite().getShell();
    }
}

