/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.ITeamData;
import com.ibm.team.process.internal.common.InternalProcessCommon;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ProcessFactory;
import com.ibm.team.process.internal.common.TeamDataRecord;
import com.ibm.team.process.internal.common.TeamDataRecord2;
import com.ibm.team.process.internal.common.impl.ProjectAreaImpl;
import com.ibm.team.process.internal.common.impl.TeamAreaImpl;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.TeamDataRecordsListener;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.model.impl.AuditableImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TeamData
implements ITeamData {
    private ProjectAreaImpl fProjectAreaImpl;
    private TeamAreaImpl fTeamAreaImpl;
    private ItemHandleAwareHashMap fContributorMap;
    private TeamDataRecordsListener fListener;

    public TeamData(ProjectAreaImpl impl) {
        this.fProjectAreaImpl = impl;
    }

    public TeamData(TeamAreaImpl impl) {
        this.fTeamAreaImpl = impl;
    }

    public String getContributorData(IContributorHandle contributor, String key) {
        this.initialize();
        Map contributorData = (Map)this.fContributorMap.get(contributor);
        if (contributorData != null) {
            return (String)contributorData.get(key);
        }
        return null;
    }

    public void setContributorData(IContributorHandle contributor, String key, String value) {
        this.initialize();
        String oldValue = value == null ? this.removeContributorData(contributor, key) : this.internalSetContributorData(contributor, key, value);
        this.updateTeamDataRecords(contributor, key, oldValue, value);
    }

    public void clear() {
        this.initialize();
        this.uninstallChangeListener();
        try {
            if (this.fContributorMap != null) {
                this.fContributorMap.clear();
            }
            if (this.fProjectAreaImpl != null) {
                this.fProjectAreaImpl.getTeamDataRecords().clear();
            } else {
                this.fTeamAreaImpl.getTeamDataRecords().clear();
            }
        }
        finally {
            this.installChangeListener();
        }
    }

    public void flush() {
        if (this.fContributorMap != null) {
            this.uninstallChangeListener();
            this.fContributorMap = null;
        }
    }

    private String removeContributorData(IContributorHandle contributor, String key) {
        Map contributorData = (Map)this.fContributorMap.get(contributor);
        if (contributorData != null) {
            return (String)contributorData.remove(key);
        }
        return null;
    }

    private void initialize() {
        if (this.fContributorMap == null) {
            this.fContributorMap = new ItemHandleAwareHashMap();
            if (this.fProjectAreaImpl != null) {
                List teamDataRecords = this.fProjectAreaImpl.getTeamDataRecords();
                for (TeamDataRecord record : teamDataRecords) {
                    this.internalSetContributorData(record.getContributor(), record.getKey(), record.getValue());
                }
            } else {
                List teamDataRecords = this.fTeamAreaImpl.getTeamDataRecords();
                for (TeamDataRecord2 record : teamDataRecords) {
                    this.internalSetContributorData(record.getContributor(), record.getKey(), record.getValue());
                }
            }
            this.installChangeListener();
        }
    }

    private void installChangeListener() {
        if (this.fListener == null) {
            this.fListener = new TeamDataRecordsListener(this);
        }
        AuditableImpl eObject = this.fProjectAreaImpl != null ? this.fProjectAreaImpl : this.fTeamAreaImpl;
        eObject.eAdapters().add((Object)this.fListener);
    }

    private void uninstallChangeListener() {
        if (this.fListener != null) {
            AuditableImpl eObject = this.fProjectAreaImpl != null ? this.fProjectAreaImpl : this.fTeamAreaImpl;
            eObject.eAdapters().remove((Object)this.fListener);
        }
    }

    private String internalSetContributorData(IContributorHandle contributor, String key, String value) {
        HashMap<String, String> contributorData = (HashMap<String, String>)this.fContributorMap.get(contributor);
        if (contributorData == null) {
            contributorData = new HashMap<String, String>();
            this.fContributorMap.put(contributor, contributorData);
        }
        return contributorData.put(key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateTeamDataRecords(IContributorHandle contributor, String key, String oldValue, String value) {
        this.uninstallChangeListener();
        try {
            List records;
            if (oldValue == null) {
                if (value == null) {
                    return;
                }
                if (this.fProjectAreaImpl != null) {
                    TeamDataRecord record = ProcessFactory.eINSTANCE.createTeamDataRecord();
                    record.setContributor(contributor);
                    record.setKey(key);
                    record.setValue(value);
                    this.fProjectAreaImpl.getTeamDataRecords().add(record);
                    return;
                } else {
                    TeamDataRecord2 record = ProcessFactory.eINSTANCE.createTeamDataRecord2();
                    record.setContributor(contributor);
                    record.setKey(key);
                    record.setValue(value);
                    this.fTeamAreaImpl.getTeamDataRecords().add(record);
                }
                return;
            }
            if (this.fProjectAreaImpl != null) {
                records = this.fProjectAreaImpl.getTeamDataRecords();
                Iterator e = records.iterator();
                while (e.hasNext()) {
                    TeamDataRecord record = (TeamDataRecord)e.next();
                    if (!contributor.sameItemId((IItemHandle)record.getContributor()) || !key.equals(record.getKey()) || !oldValue.equals(record.getValue())) continue;
                    if (value != null) {
                        record.setValue(value);
                        return;
                    }
                    e.remove();
                    return;
                }
            } else {
                records = this.fTeamAreaImpl.getTeamDataRecords();
                Iterator e = records.iterator();
                while (e.hasNext()) {
                    TeamDataRecord2 record = (TeamDataRecord2)e.next();
                    if (!contributor.sameItemId((IItemHandle)record.getContributor()) || !key.equals(record.getKey()) || !oldValue.equals(record.getValue())) continue;
                    if (value != null) {
                        record.setValue(value);
                        return;
                    }
                    e.remove();
                    return;
                }
            }
            RuntimeException x = new RuntimeException(Messages.getCommonString("TeamData.0"));
            InternalProcessCommon.log(x);
            throw x;
        }
        finally {
            this.installChangeListener();
        }
    }
}

