/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProcessDefinitionImportUtil {
    public static final String NAME_TXT = "name.txt";
    public static final String PROCESS_ID_TXT = "processId.txt";
    public static final int VERSION_1 = 1;

    public static String getProcessId(File baseDir) throws TeamRepositoryException, IOException {
        return ProcessDefinitionImportUtil.getAttribute(baseDir, PROCESS_ID_TXT);
    }

    public static String getName(File baseDir) throws TeamRepositoryException, IOException {
        return ProcessDefinitionImportUtil.getAttribute(baseDir, NAME_TXT);
    }

    private static String getAttribute(File baseDir, String attributeFileName) throws TeamRepositoryException, IOException {
        if (!baseDir.exists()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.0"), baseDir));
        }
        if (!baseDir.isDirectory()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.1"), baseDir));
        }
        String versionFile = "version.txt";
        int version = -1;
        String versionString = ProcessDefinitionImportUtil.createStringFromFile(baseDir, versionFile);
        if (versionString != null) {
            try {
                version = Integer.parseInt(versionString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (version == -1) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.2"), versionFile));
        }
        if (version != 1) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.3"), version));
        }
        return ProcessDefinitionImportUtil.createStringFromFile(baseDir, attributeFileName);
    }

    public static IProcessDefinition createDefinition(File baseDir, String name, String processId, IProcessDefinition definitionToOverwrite, IDefinitionImportContext importContext, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        String specificationFile;
        IContent specification;
        IProcessDefinition definition;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 1000);
        if (!baseDir.exists()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.4"), baseDir));
        }
        if (!baseDir.isDirectory()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.5"), baseDir));
        }
        String versionFile = "version.txt";
        int version = -1;
        String versionString = ProcessDefinitionImportUtil.createStringFromFile(baseDir, versionFile);
        if (versionString != null) {
            try {
                version = Integer.parseInt(versionString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (version == -1) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.6"), versionFile));
        }
        if (version != 1) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.7"), version));
        }
        if (name == null) {
            name = ProcessDefinitionImportUtil.createStringFromFile(baseDir, NAME_TXT);
        }
        if (name == null || name.length() == 0) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.8"), NAME_TXT));
        }
        if (processId == null) {
            processId = ProcessDefinitionImportUtil.createStringFromFile(baseDir, PROCESS_ID_TXT);
        }
        if (processId == null || processId.length() == 0) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.9"), PROCESS_ID_TXT));
        }
        String contentURL = ProcessDefinitionImportUtil.createStringFromFile(baseDir, "contentURL.txt");
        String summary = ProcessDefinitionImportUtil.createStringFromFile(baseDir, "summary.txt");
        if (definitionToOverwrite != null) {
            definition = (IProcessDefinition)definitionToOverwrite.getWorkingCopy();
        } else {
            definition = (IProcessDefinition)IProcessDefinition.ITEM_TYPE.createItem();
            definition.setProcessId(processId);
        }
        definition.setName(name);
        definition.setProcessContentURL(contentURL);
        definition.getDescription().setSummary(summary);
        IContent description = importContext.createTextContentFromFile(baseDir, "description.txt", (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        if (description != null) {
            definition.getDescription().setDetails(description);
        }
        if ((specification = importContext.createTextContentFromFile(baseDir, specificationFile = "specification.txt", (IProgressMonitor)new SubProgressMonitor(monitor, 100))) == null) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.10"), specificationFile));
        }
        definition.getProcessData().put("com.ibm.team.internal.process.compiled.xml", specification);
        String stateFile = "state.txt";
        IContent state = importContext.createTextContentFromFile(baseDir, stateFile, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        if (state == null) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.11"), stateFile));
        }
        definition.getProcessData().put("com.ibm.team.internal.process.state.xml", state);
        ArrayList<IProcessDefinition> itemsToSave = new ArrayList<IProcessDefinition>();
        itemsToSave.add(definition);
        ProcessDefinitionImportUtil.addAttachments(definition, baseDir, importContext, itemsToSave, (IProgressMonitor)new SubProgressMonitor(monitor, 750));
        IProcessItem[] saved = importContext.saveProcessItems(itemsToSave.toArray(new IProcessItem[itemsToSave.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        return (IProcessDefinition)saved[0];
    }

    private static void addAttachments(IProcessDefinition definition, File baseDir, IDefinitionImportContext importContext, List attachments, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        definition.setAttachments(new IProcessAttachment[0]);
        File attachmentDir = new File(baseDir, "attachments");
        if (attachmentDir.exists() && attachmentDir.isDirectory()) {
            String attachmentsFile = "attachments.txt";
            String attachmentsDescriptor = ProcessDefinitionImportUtil.createStringFromFile(baseDir, attachmentsFile);
            if (attachmentsDescriptor == null) {
                throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.12"), attachmentsFile));
            }
            ArrayList<String> attachmentPaths = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new StringReader(attachmentsDescriptor));
            String path = reader.readLine();
            while (path != null) {
                attachmentPaths.add(path);
                path = reader.readLine();
            }
            ArrayList attachmentFiles = new ArrayList();
            ProcessDefinitionImportUtil.findFiles(attachmentDir, attachmentFiles);
            monitor.beginTask("", attachmentFiles.size() * 1000);
            for (File file : attachmentFiles) {
                int index;
                IProcessAttachment attachment = (IProcessAttachment)IProcessAttachment.ITEM_TYPE.createItem();
                Path fileName = new Path(file.getName());
                try {
                    index = Integer.parseInt(fileName.removeFileExtension().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (index >= attachmentPaths.size()) {
                    throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.13"), attachmentsFile, file.getName()));
                }
                String attachmentPath = (String)attachmentPaths.get(index);
                if (attachmentPath == null || attachmentPath.length() == 0) {
                    throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.14"), attachmentsFile, file.getName()));
                }
                attachment.setPath(attachmentPath);
                IContent content = importContext.createBinaryContentFromFile(file, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                attachment.setContent(content);
                definition.addAttachment(attachment);
                attachment.setProcessContainer(definition);
                attachments.add(attachment);
            }
        }
    }

    private static void findFiles(File baseDir, List foundFiles) {
        File[] files = baseDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                foundFiles.add(file);
            } else if (file.isDirectory()) {
                ProcessDefinitionImportUtil.findFiles(file, foundFiles);
            }
            ++i;
        }
    }

    public static final String createStringFromFile(File baseDir, String fileName) throws IOException {
        File file = new File(baseDir, fileName);
        if (!file.exists()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        try {
            char[] chars = new char[512];
            int read = reader.read(chars);
            while (read > 0) {
                buffer.append(chars, 0, read);
                read = reader.read(chars);
            }
        }
        finally {
            reader.close();
        }
        return buffer.toString();
    }

    public static void unzip(File zipFileLocation, File destination) throws IOException {
        destination.mkdirs();
        ZipFile zip = new ZipFile(zipFileLocation);
        try {
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry current = e.nextElement();
                File entryFile = new File(destination, current.getName());
                if (current.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                if (entryFile.exists()) continue;
                entryFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(entryFile);
                InputStream input = zip.getInputStream(current);
                ProcessDefinitionImportUtil.transferStreams(input, output);
            }
        }
        finally {
            zip.close();
        }
    }

    private static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        block27: {
            byte[] buffer = new byte[8192];
            try {
                while (true) {
                    int bytesRead = -1;
                    bytesRead = source.read(buffer);
                    if (bytesRead != -1) {
                        destination.write(buffer, 0, bytesRead);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                block25: {
                    try {
                        try {
                            source.close();
                        }
                        catch (IOException iOException) {
                            try {
                                destination.close();
                            }
                            catch (IOException iOException2) {}
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            destination.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable2;
                    }
                    try {
                        destination.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                try {
                    source.close();
                }
                catch (IOException iOException) {
                    try {
                        destination.close();
                    }
                    catch (IOException iOException3) {}
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static interface IDefinitionImportContext {
        public IContent createTextContentFromFile(File var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

        public IContent createBinaryContentFromFile(File var1, IProgressMonitor var2) throws TeamRepositoryException, IOException;

        public IProcessItem[] saveProcessItems(IProcessItem[] var1, IProgressMonitor var2) throws TeamRepositoryException;
    }
}

