/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.advice.runtime;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ISimpleMap;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.IReportInfoCollector;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.common.advice.runtime.IOperationAdviceListener;
import com.ibm.team.process.common.advice.runtime.IOperationAdviceManager;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.process.common.advice.runtime.IOperationParticipant;
import com.ibm.team.process.internal.common.InternalProcessCommon;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.AdvisorReport;
import com.ibm.team.process.internal.common.advice.ConfigurationSource;
import com.ibm.team.process.internal.common.advice.OperationAreaInfo;
import com.ibm.team.process.internal.common.advice.OperationConfigurationInfo;
import com.ibm.team.process.internal.common.advice.OperationReport;
import com.ibm.team.process.internal.common.advice.ParticipantReport;
import com.ibm.team.process.internal.common.advice.PermissionSource;
import com.ibm.team.process.internal.common.advice.ProcessReport;
import com.ibm.team.process.internal.common.advice.ReportInfo;
import com.ibm.team.process.internal.common.advice.RunnableReport;
import com.ibm.team.process.internal.common.advice.impl.AdvisorReportImpl;
import com.ibm.team.process.internal.common.advice.impl.ParticipantReportImpl;
import com.ibm.team.process.internal.common.advice.impl.ReportInfoImpl;
import com.ibm.team.process.internal.common.advice.runtime.AdvisorDeclaration;
import com.ibm.team.process.internal.common.advice.runtime.AdvisorInfoCollector;
import com.ibm.team.process.internal.common.advice.runtime.IOperationAdviceNotifier;
import com.ibm.team.process.internal.common.advice.runtime.Messages;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdvisorRegistry;
import com.ibm.team.process.internal.common.advice.runtime.OperationParticipantRegistry;
import com.ibm.team.process.internal.common.advice.runtime.OperationRegistry;
import com.ibm.team.process.internal.common.advice.runtime.ParticipantInfoCollector;
import com.ibm.team.process.internal.common.advice.runtime.RunnableInfoCollector;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionActionElement;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OperationAdviceManager
implements IOperationAdviceManager {
    public static final String ACTION_ID_ANY = "any";
    public static final String TAG_PERMISSION_DATA = "data";
    public static final String TAG_PERMISSIONS_DESCRIPTION = "role-description";
    public static final String ATTR_PERMISSIONS_MESSAGE = "message";
    public static final String TAG_PERMISSION_ACTION = "action";
    public static final String ATTR_PERMISSION_ACTION_ID = "id";
    public static final String ATTR_PERMISSION_ACTION_DESCRIPTION = "description";
    private static final String ATTR_OPERATION_NAME = "name";
    private static final String ATTR_VALID_OPERATION_ID = "operationId";
    private static final String TAG_ACTION = "action";
    private static final String ATTR_ACTION_LABEL = "label";
    private static final String ATTR_ACTION_ID = "id";
    public static final String ID_PERMISSION_DENIED_PROBLEM = "com.ibm.team.process.internal.permissionDenied";
    public static final String ID_LICENSE_NOT_GRANTED_PROBLEM = "com.ibm.team.process.internal.licenseNotGranted";
    public static final String ID_OPERATION_EXCEPTION = "com.ibm.team.process.internal.operationException";
    public static final String ID_OPERATION_CANCELED = "com.ibm.team.process.internal.operationCanceled";
    private List fOperationReports = new ArrayList();
    private ListenerList fAdviceListeners = new ListenerList();
    private Map fThreadStacks = new HashMap();
    private final OperationRegistry fOperationRegistry;
    private final OperationParticipantRegistry fOperationParticipantRegistry;
    private final OperationAdvisorRegistry fOperationAdvisorRegistry;
    private int fNumCompletedToKeep;

    public OperationAdviceManager(OperationRegistry operationRegistry, OperationParticipantRegistry operationParticipantRegistry, OperationAdvisorRegistry operationAdvisorRegistry, int numCompletedToKeep) {
        this.fOperationRegistry = operationRegistry;
        this.fOperationParticipantRegistry = operationParticipantRegistry;
        this.fOperationAdvisorRegistry = operationAdvisorRegistry;
        this.setNumCompletedToKeep(numCompletedToKeep);
    }

    public IOperationReport execute(ProcessRunnable runnable, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        Thread currentThread = Thread.currentThread();
        Stack<RunnableReport> stack = (Stack<RunnableReport>)this.fThreadStacks.get(currentThread);
        if (stack == null) {
            stack = new Stack<RunnableReport>();
            this.fThreadStacks.put(currentThread, stack);
        }
        RunnableReport runnableReport = this.createRunnableReport(runnable, name, stack);
        if (runnable == null) {
            this.appendError(runnableReport, Messages.getCommonString("OperationAdviceManager.0"), Messages.getCommonString("OperationAdviceManager.1"), null, ID_OPERATION_EXCEPTION, null);
            return runnableReport;
        }
        stack.push(runnableReport);
        try {
            try {
                monitor.beginTask(name, 1000);
                this.runRunnable(runnable, name, runnableReport, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            }
            catch (OperationCanceledException e) {
                this.appendError(runnableReport, Messages.getCommonString("OperationAdviceManager.2"), NLS.bind(Messages.getCommonString("OperationAdviceManager.3"), runnableReport.getName()), null, ID_OPERATION_EXCEPTION, (Object)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            runnableReport.setComplete(true);
            this.pruneCompletedReports();
            this.runAdviceNotifier(new IOperationAdviceNotifier(runnableReport){
                private final /* synthetic */ RunnableReport val$runnableReport;
                {
                    this.val$runnableReport = runnableReport;
                }

                public void notifyListener(IOperationAdviceListener listener) {
                    listener.handleOperationReportsCompleted(new IOperationReport[]{this.val$runnableReport});
                }
            });
            stack.pop();
            if (stack.isEmpty()) {
                this.fThreadStacks.remove(currentThread);
            }
            monitor.done();
            throw throwable;
        }
        runnableReport.setComplete(true);
        this.pruneCompletedReports();
        this.runAdviceNotifier(new /* invalid duplicate definition of identical inner class */);
        stack.pop();
        if (stack.isEmpty()) {
            this.fThreadStacks.remove(currentThread);
        }
        monitor.done();
        return runnableReport;
    }

    public IOperationReport advise(AdvisableOperation operation, int mode, ISimpleMap permissionConfigurations, OperationBehaviorConfiguration behavior, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        Throwable exception;
        OperationReport operationReport;
        String operationName;
        Stack<OperationReport> stack;
        Thread currentThread;
        block51: {
            IConfigurationElement operationExtension;
            block50: {
                String name;
                if (operation == null) {
                    throw new IllegalArgumentException();
                }
                monitor = this.getProgressMonitor(monitor);
                currentThread = Thread.currentThread();
                stack = (Stack<OperationReport>)this.fThreadStacks.get(currentThread);
                if (stack == null) {
                    stack = new Stack<OperationReport>();
                    this.fThreadStacks.put(currentThread, stack);
                }
                operationName = operation.getOperationIdentifier();
                operationExtension = this.fOperationRegistry.getConfigurationPointElement(operation.getOperationIdentifier());
                if (operationExtension != null && (name = operationExtension.getAttribute(ATTR_OPERATION_NAME)) != null) {
                    operationName = name;
                }
                IProcessArea processArea = operation.getProcessArea();
                OperationPermissionsConfiguration[] permissions = (OperationPermissionsConfiguration[])permissionConfigurations.get(processArea);
                operationReport = this.createOperationReport(operation, operationName, permissions, behavior, mode, stack);
                if (!this.isValidMode(mode)) {
                    this.appendError(operationReport, Messages.getCommonString("OperationAdviceManager.4"), NLS.bind(Messages.getCommonString("OperationAdviceManager.5"), mode), null, ID_OPERATION_EXCEPTION, null);
                    return operationReport;
                }
                stack.push(operationReport);
                exception = null;
                monitor.beginTask(operationName, 1000);
                if (mode != 2 || operation.canReRun()) break block50;
                this.appendError(operationReport, Messages.getCommonString("OperationAdviceManager.6"), Messages.getCommonString("OperationAdviceManager.7"), null, "com.ibm.team.process.exceptionProblem", null);
                OperationReport operationReport2 = operationReport;
                operationReport.setComplete(true);
                this.pruneCompletedReports();
                this.runAdviceNotifier(new IOperationAdviceNotifier(operationReport){
                    private final /* synthetic */ OperationReport val$operationReport;
                    {
                        this.val$operationReport = operationReport;
                    }

                    public void notifyListener(IOperationAdviceListener listener) {
                        listener.handleOperationReportsCompleted(new IOperationReport[]{this.val$operationReport});
                    }
                });
                stack.pop();
                if (stack.isEmpty()) {
                    this.fThreadStacks.remove(currentThread);
                }
                monitor.done();
                int advice = operationReport.getSeverity();
                if (exception == null && advice == 4 && mode != 0) {
                    String message;
                    IReportInfo firstError;
                    String name2 = operationReport.getName();
                    if (name2 == null) {
                        name2 = Messages.getCommonString("OperationAdviceManager.10");
                    }
                    if ((firstError = this.findFirstError(operationReport)) == null || firstError.getIdentifier().equals("com.ibm.team.process.exceptionProblem") || firstError.getIdentifier().equals(ID_OPERATION_EXCEPTION)) {
                        message = NLS.bind(Messages.getCommonString("OperationAdviceManager.11"), name2);
                    } else if (firstError.getIdentifier().equals(ID_PERMISSION_DENIED_PROBLEM)) {
                        message = NLS.bind(Messages.getCommonString("OperationAdviceManager.12"), name2);
                        if (operation.shouldThrowPermissionDeniedException()) {
                            PermissionDeniedException permissionDenied = new PermissionDeniedException(message);
                            permissionDenied.setProcessReportData((Object)operationReport);
                            throw permissionDenied;
                        }
                    } else {
                        message = firstError instanceof IAdvisorInfo ? NLS.bind(Messages.getCommonString("OperationAdviceManager.13"), name2, firstError.getDescription()) : NLS.bind(Messages.getCommonString("OperationAdviceManager.14"), name2, firstError.getDescription());
                    }
                    throw new TeamOperationCanceledException(operationReport, message);
                }
                return operationReport2;
            }
            if (behavior != null) {
                this.runAdvisors(operation, behavior, (IProgressMonitor)new SubProgressMonitor(monitor, 300), operationReport, oldReport, stack);
            } else {
                monitor.worked(300);
            }
            if (this.hasPermissions(operation, permissionConfigurations, operationExtension, operationReport)) break block51;
            OperationReport operationReport3 = operationReport;
            operationReport.setComplete(true);
            this.pruneCompletedReports();
            this.runAdviceNotifier(new /* invalid duplicate definition of identical inner class */);
            stack.pop();
            if (stack.isEmpty()) {
                this.fThreadStacks.remove(currentThread);
            }
            monitor.done();
            int advice = operationReport.getSeverity();
            if (exception == null && advice == 4 && mode != 0) {
                String message;
                IReportInfo firstError;
                String name = operationReport.getName();
                if (name == null) {
                    name = Messages.getCommonString("OperationAdviceManager.10");
                }
                if ((firstError = this.findFirstError(operationReport)) == null || firstError.getIdentifier().equals("com.ibm.team.process.exceptionProblem") || firstError.getIdentifier().equals(ID_OPERATION_EXCEPTION)) {
                    message = NLS.bind(Messages.getCommonString("OperationAdviceManager.11"), name);
                } else if (firstError.getIdentifier().equals(ID_PERMISSION_DENIED_PROBLEM)) {
                    message = NLS.bind(Messages.getCommonString("OperationAdviceManager.12"), name);
                    if (operation.shouldThrowPermissionDeniedException()) {
                        PermissionDeniedException permissionDenied = new PermissionDeniedException(message);
                        permissionDenied.setProcessReportData((Object)operationReport);
                        throw permissionDenied;
                    }
                } else {
                    message = firstError instanceof IAdvisorInfo ? NLS.bind(Messages.getCommonString("OperationAdviceManager.13"), name, firstError.getDescription()) : NLS.bind(Messages.getCommonString("OperationAdviceManager.14"), name, firstError.getDescription());
                }
                throw new TeamOperationCanceledException(operationReport, message);
            }
            return operationReport3;
        }
        try {
            try {
                int advice = operationReport.getSeverity();
                if (advice != 4 || mode == 0) {
                    this.runOperation(operation, operationName, mode, behavior, operationReport, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
                } else {
                    monitor.worked(400);
                }
                if (operationReport.wasRun() && operationReport.getSeverity() != 4) {
                    this.runParticipants(operation, behavior, (IProgressMonitor)new SubProgressMonitor(monitor, 300), operationReport, oldReport, stack);
                } else {
                    monitor.worked(300);
                }
            }
            catch (OperationCanceledException e) {
                this.appendError(operationReport, Messages.getCommonString("OperationAdviceManager.8"), NLS.bind(Messages.getCommonString("OperationAdviceManager.9"), operationReport.getName()), null, ID_OPERATION_CANCELED, (Object)e);
                exception = e;
                throw e;
            }
            catch (TeamRepositoryException e) {
                exception = e;
                throw e;
            }
            catch (RuntimeException e) {
                exception = e;
                throw e;
            }
        }
        catch (Throwable throwable) {
            operationReport.setComplete(true);
            this.pruneCompletedReports();
            this.runAdviceNotifier(new /* invalid duplicate definition of identical inner class */);
            stack.pop();
            if (stack.isEmpty()) {
                this.fThreadStacks.remove(currentThread);
            }
            monitor.done();
            int advice = operationReport.getSeverity();
            if (exception == null && advice == 4 && mode != 0) {
                String message;
                IReportInfo firstError;
                String name = operationReport.getName();
                if (name == null) {
                    name = Messages.getCommonString("OperationAdviceManager.10");
                }
                if ((firstError = this.findFirstError(operationReport)) == null || firstError.getIdentifier().equals("com.ibm.team.process.exceptionProblem") || firstError.getIdentifier().equals(ID_OPERATION_EXCEPTION)) {
                    message = NLS.bind(Messages.getCommonString("OperationAdviceManager.11"), name);
                } else if (firstError.getIdentifier().equals(ID_PERMISSION_DENIED_PROBLEM)) {
                    message = NLS.bind(Messages.getCommonString("OperationAdviceManager.12"), name);
                    if (operation.shouldThrowPermissionDeniedException()) {
                        PermissionDeniedException permissionDenied = new PermissionDeniedException(message);
                        permissionDenied.setProcessReportData((Object)operationReport);
                        throw permissionDenied;
                    }
                } else {
                    message = firstError instanceof IAdvisorInfo ? NLS.bind(Messages.getCommonString("OperationAdviceManager.13"), name, firstError.getDescription()) : NLS.bind(Messages.getCommonString("OperationAdviceManager.14"), name, firstError.getDescription());
                }
                throw new TeamOperationCanceledException(operationReport, message);
            }
            throw throwable;
        }
        operationReport.setComplete(true);
        this.pruneCompletedReports();
        this.runAdviceNotifier(new /* invalid duplicate definition of identical inner class */);
        stack.pop();
        if (stack.isEmpty()) {
            this.fThreadStacks.remove(currentThread);
        }
        monitor.done();
        int advice = operationReport.getSeverity();
        if (exception == null && advice == 4 && mode != 0) {
            String message;
            IReportInfo firstError;
            String name = operationReport.getName();
            if (name == null) {
                name = Messages.getCommonString("OperationAdviceManager.10");
            }
            if ((firstError = this.findFirstError(operationReport)) == null || firstError.getIdentifier().equals("com.ibm.team.process.exceptionProblem") || firstError.getIdentifier().equals(ID_OPERATION_EXCEPTION)) {
                message = NLS.bind(Messages.getCommonString("OperationAdviceManager.11"), name);
            } else if (firstError.getIdentifier().equals(ID_PERMISSION_DENIED_PROBLEM)) {
                message = NLS.bind(Messages.getCommonString("OperationAdviceManager.12"), name);
                if (operation.shouldThrowPermissionDeniedException()) {
                    PermissionDeniedException permissionDenied = new PermissionDeniedException(message);
                    permissionDenied.setProcessReportData((Object)operationReport);
                    throw permissionDenied;
                }
            } else {
                message = firstError instanceof IAdvisorInfo ? NLS.bind(Messages.getCommonString("OperationAdviceManager.13"), name, firstError.getDescription()) : NLS.bind(Messages.getCommonString("OperationAdviceManager.14"), name, firstError.getDescription());
            }
            throw new TeamOperationCanceledException(operationReport, message);
        }
        return operationReport;
    }

    public TeamOperationCanceledException createLicenseNotGrantedException(LicenseNotGrantedException exception, AdvisableOperation operation, int mode) {
        Thread currentThread;
        Stack<OperationReport> stack;
        String name;
        String operationId;
        String operationName = operationId = operation.getOperationIdentifier();
        IConfigurationElement operationExtension = this.fOperationRegistry.getConfigurationPointElement(operationId);
        if (operationExtension != null && (name = operationExtension.getAttribute(ATTR_OPERATION_NAME)) != null) {
            operationName = name;
        }
        if ((stack = (Stack<OperationReport>)this.fThreadStacks.get(currentThread = Thread.currentThread())) == null) {
            stack = new Stack<OperationReport>();
            this.fThreadStacks.put(currentThread, stack);
        }
        final OperationReport report = this.createOperationReport(operation, operationName, new OperationPermissionsConfiguration[0], null, mode, stack);
        stack.push(report);
        this.appendError(report, Messages.getCommonString("OperationAdviceManager.82"), this.transformLicenseNotGrantedException(exception, operationId, operationName), null, ID_LICENSE_NOT_GRANTED_PROBLEM, null);
        report.setComplete(true);
        this.pruneCompletedReports();
        this.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleOperationReportsCompleted(new IOperationReport[]{report});
            }
        });
        stack.pop();
        if (stack.isEmpty()) {
            this.fThreadStacks.remove(currentThread);
        }
        return new TeamOperationCanceledException(report, NLS.bind(Messages.getCommonString("OperationAdviceManager.84"), operationName));
    }

    private String transformLicenseNotGrantedException(LicenseNotGrantedException e, String operationId, String operationName) {
        String message = this.getExceptionMessage(e);
        int index = message.indexOf(operationId);
        if (index != -1) {
            return new StringBuffer(message).replace(index, index + operationId.length(), operationName).toString();
        }
        return message;
    }

    public void setNumCompletedToKeep(int numCompletedToKeep) {
        this.fNumCompletedToKeep = Math.max(1, numCompletedToKeep);
        this.pruneCompletedReports();
    }

    private void pruneCompletedReports() {
        IOperationReport[] reports = this.getReports();
        if (reports.length > this.fNumCompletedToKeep) {
            ArrayList<IOperationReport> reportsToRemove = new ArrayList<IOperationReport>();
            int completedFound = 0;
            int i = reports.length - 1;
            while (i >= 0) {
                IOperationReport report = reports[i];
                if (report.isComplete() && ++completedFound > this.fNumCompletedToKeep) {
                    reportsToRemove.add(report);
                }
                --i;
            }
            this.removeReports(reportsToRemove.toArray(new IOperationReport[reportsToRemove.size()]));
        }
    }

    private IReportInfo findFirstError(IProcessReport report) {
        IReportInfo[] infos = report.getInfos();
        int i = 0;
        while (i < infos.length) {
            IReportInfo info = infos[i];
            if (info.getSeverity() == 4) {
                return info;
            }
            ++i;
        }
        IProcessReport[] nestedReports = report.getNestedReports();
        int i2 = 0;
        while (i2 < nestedReports.length) {
            IReportInfo error = this.findFirstError(nestedReports[i2]);
            if (error != null) {
                return error;
            }
            ++i2;
        }
        return null;
    }

    private boolean hasPermissions(AdvisableOperation operation, ISimpleMap configurationsMap, IConfigurationElement operationExtension, OperationReport report) throws TeamRepositoryException {
        String[] actions = operation.getActions();
        List unpermitted = this.getUnpermittedActions(operation, actions, configurationsMap, report);
        if (unpermitted.size() > 0) {
            String description;
            Document doc = null;
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {}
            Element root = null;
            if (doc != null) {
                root = doc.createElement(TAG_PERMISSION_DATA);
                doc.appendChild(root);
            }
            StringBuffer buffer = new StringBuffer();
            OperationPermissionsConfiguration[] configurations = (OperationPermissionsConfiguration[])configurationsMap.get(operation.getProcessArea());
            if (configurations != null) {
                StringBuffer descriptionBuffer = new StringBuffer();
                if (configurations.length == 1) {
                    OperationPermissionsConfiguration config = configurations[0];
                    String description2 = config.getAttribute(ATTR_PERMISSION_ACTION_DESCRIPTION);
                    if (description2 != null && description2.trim().length() > 0) {
                        if (root != null) {
                            Element descriptionElement = doc.createElement(TAG_PERMISSIONS_DESCRIPTION);
                            descriptionElement.setAttribute(ATTR_PERMISSIONS_MESSAGE, description2);
                            root.appendChild(descriptionElement);
                        }
                        descriptionBuffer.append(description2);
                    }
                } else {
                    int i = 0;
                    while (i < configurations.length) {
                        OperationPermissionsConfiguration config = configurations[i];
                        description = config.getAttribute(ATTR_PERMISSION_ACTION_DESCRIPTION);
                        if (description != null && description.trim().length() > 0) {
                            ConfigurationSource source = config.getSource();
                            String message = source != null ? NLS.bind(Messages.getCommonString("OperationAdviceManager.15"), source.getRoleId(), description) : NLS.bind(Messages.getCommonString("OperationAdviceManager.89"), description);
                            if (root != null) {
                                Element descriptionElement = doc.createElement(TAG_PERMISSIONS_DESCRIPTION);
                                descriptionElement.setAttribute(ATTR_PERMISSIONS_MESSAGE, message);
                                root.appendChild(descriptionElement);
                            }
                            if (descriptionBuffer.length() > 0) {
                                descriptionBuffer.append('\n');
                            }
                            descriptionBuffer.append(message);
                        }
                        ++i;
                    }
                }
                if (descriptionBuffer.length() > 0) {
                    buffer.append(descriptionBuffer).append("\n\n");
                }
            }
            buffer.append(Messages.getCommonString("OperationAdviceManager.17"));
            Iterator iter = unpermitted.iterator();
            while (iter.hasNext()) {
                Path action = new Path((String)iter.next());
                Element element = null;
                if (root != null && doc != null) {
                    element = doc.createElement("action");
                    root.appendChild(element);
                    element.setAttribute("id", action.toString());
                }
                buffer.append("\n  ");
                description = this.findActionDescription((IPath)action, operationExtension);
                if (description != null) {
                    if (element != null) {
                        element.setAttribute(ATTR_PERMISSION_ACTION_DESCRIPTION, description);
                    }
                    buffer.append(NLS.bind(Messages.getCommonString("OperationAdviceManager.19"), description, action));
                    continue;
                }
                buffer.append(action.toString());
            }
            String data = null;
            if (root != null) {
                try {
                    data = AbstractModel.serializeDocument(doc);
                }
                catch (TransformerException transformerException) {
                }
                catch (IOException iOException) {}
            }
            this.appendError(report, Messages.getCommonString("OperationAdviceManager.20"), buffer.toString(), data, ID_PERMISSION_DENIED_PROBLEM, null);
            return false;
        }
        return true;
    }

    private String findActionDescription(IPath action, IConfigurationElement parent) {
        if (parent != null) {
            IConfigurationElement[] children = parent.getChildren("action");
            int i = 0;
            while (i < children.length) {
                IConfigurationElement child = children[i];
                String operationActionId = child.getAttribute("id");
                String actionId = action.segment(0);
                if (operationActionId != null && operationActionId.equals(actionId)) {
                    if (action.segmentCount() == 1) {
                        return child.getAttribute(ATTR_ACTION_LABEL);
                    }
                    IPath remainder = action.removeFirstSegments(1);
                    String description = this.findActionDescription(remainder, child);
                    if (description != null) {
                        return description;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private List getUnpermittedActions(AdvisableOperation operation, String[] primaryActions, ISimpleMap configurations, OperationReport report) throws TeamRepositoryException {
        ArrayList unpermitted = new ArrayList();
        IProcessArea primaryArea = operation.getProcessArea();
        this.appendUnpermittedActions(primaryActions, (OperationPermissionsConfiguration[])configurations.get(primaryArea), unpermitted);
        OperationConfigurationInfo operationInfo = (OperationConfigurationInfo)report.getOperationConfigurationInfo();
        OperationAreaInfo primaryInfo = operationInfo.getPrimaryAreaInfo();
        primaryInfo.setCheckedActions(primaryActions);
        IProcessArea[] permissionAreas = operation.getSecondaryProcessAreas();
        int i = 0;
        while (i < permissionAreas.length) {
            IProcessArea area = permissionAreas[i];
            String[] secondaryActions = operation.getSecondaryActions(area);
            OperationPermissionsConfiguration[] permissionConfigurations = (OperationPermissionsConfiguration[])configurations.get(area);
            this.appendUnpermittedActions(secondaryActions, permissionConfigurations, unpermitted);
            OperationAreaInfo secondaryInfo = AdvicePackage.eINSTANCE.getAdviceFactory().createOperationAreaInfo();
            secondaryInfo.setStartingArea(area);
            secondaryInfo.setAreaItemUuid(area.getItemId().getUuidValue());
            secondaryInfo.setAreaIsTeamArea(area instanceof ITeamArea);
            secondaryInfo.setCheckedActions(secondaryActions);
            ArrayList<ConfigurationSource> sources = new ArrayList<ConfigurationSource>();
            int j = 0;
            while (j < permissionConfigurations.length) {
                ConfigurationSource source = permissionConfigurations[j].getSource();
                if (source != null) {
                    sources.add(source);
                }
                ++j;
            }
            secondaryInfo.setPermissionSources(sources.toArray(new PermissionSource[sources.size()]));
            operationInfo.addSecondaryAreaInfo(secondaryInfo);
            ++i;
        }
        return unpermitted;
    }

    private void appendUnpermittedActions(String[] actions, OperationPermissionsConfiguration[] configurations, List unpermitted) {
        ArrayList<String> remainingActions = new ArrayList<String>();
        int i = 0;
        while (i < actions.length) {
            remainingActions.add(actions[i]);
            ++i;
        }
        if (configurations != null) {
            i = 0;
            while (i < configurations.length && remainingActions.size() > 0) {
                OperationPermissionsConfiguration permissions = configurations[i];
                List permittedActions = OperationAdviceManager.getPermittedActions(remainingActions, permissions);
                remainingActions.removeAll(permittedActions);
                ++i;
            }
        }
        Iterator iter = remainingActions.iterator();
        while (iter.hasNext()) {
            unpermitted.add(iter.next());
        }
    }

    public static List getPermittedActions(List actions, OperationPermissionsConfiguration configuration) {
        ArrayList<String> permittedActions = new ArrayList<String>();
        if (actions.size() > 0) {
            IPath[] configActions = OperationAdviceManager.getPermittedActions(configuration);
            Iterator iter = actions.iterator();
            block0: while (iter.hasNext()) {
                Path action = new Path((String)iter.next());
                int j = 0;
                while (j < configActions.length) {
                    IPath permitted = configActions[j];
                    if (OperationAdviceManager.findMatching((IPath)action, permitted, 0)) {
                        permittedActions.add(action.toString());
                        continue block0;
                    }
                    ++j;
                }
            }
        }
        return permittedActions;
    }

    public static boolean hasPermissions(String[] actions, OperationPermissionsConfiguration configuration) {
        if (actions != null && actions.length > 0) {
            IPath[] permittedActions = OperationAdviceManager.getPermittedActions(configuration);
            int i = 0;
            while (i < actions.length) {
                Path action = new Path(actions[i]);
                boolean hasPermission = false;
                int j = 0;
                while (j < permittedActions.length) {
                    IPath permitted = permittedActions[j];
                    if (OperationAdviceManager.findMatching((IPath)action, permitted, 0)) {
                        hasPermission = true;
                        break;
                    }
                    ++j;
                }
                if (!hasPermission) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean findMatching(IPath action, IPath permitted, int segmentIndex) {
        String permittedSegment = permitted.segment(segmentIndex);
        String actionSegment = action.segment(segmentIndex);
        if (actionSegment == null) {
            return true;
        }
        if (permittedSegment != null) {
            if (permittedSegment.equals(ACTION_ID_ANY)) {
                return true;
            }
            if (permittedSegment.equals(actionSegment)) {
                if (segmentIndex == action.segmentCount() - 1) {
                    return true;
                }
                return OperationAdviceManager.findMatching(action, permitted, segmentIndex + 1);
            }
        }
        return false;
    }

    private static IPath[] getPermittedActions(OperationPermissionsConfiguration operation) {
        ArrayList permitted = new ArrayList();
        if (operation != null) {
            PermissionActionElement[] actions = operation.getActions();
            int j = 0;
            while (j < actions.length) {
                PermissionActionElement action = actions[j];
                OperationAdviceManager.computeActions(action, (IPath)new Path(""), permitted);
                ++j;
            }
        }
        return permitted.toArray(new IPath[permitted.size()]);
    }

    private static void computeActions(PermissionActionElement action, IPath currentPath, List allActions) {
        IPath newPath = currentPath.append(action.getId());
        PermissionActionElement[] children = action.getChildren();
        if (children.length == 0) {
            allActions.add(newPath);
        }
        int j = 0;
        while (j < children.length) {
            PermissionActionElement child = children[j];
            OperationAdviceManager.computeActions(child, newPath, allActions);
            ++j;
        }
    }

    private void runAdvisors(AdvisableOperation operation, OperationBehaviorConfiguration behavior, IProgressMonitor monitor, OperationReport operationReport, IOperationReport oldReport, Stack stack) {
        block22: {
            int i;
            IProcessConfigurationElement[] advisorElements = null;
            IProcessConfigurationElement[] elements = behavior.getElements();
            if (elements != null) {
                i = 0;
                while (i < elements.length) {
                    IProcessConfigurationElement element = elements[i];
                    if ("preconditions".equals(element.getName())) {
                        advisorElements = element.getChildren();
                        break;
                    }
                    ++i;
                }
            }
            try {
                if (advisorElements == null) break block22;
                monitor.beginTask(Messages.getCommonString("OperationAdviceManager.22"), advisorElements.length * 1000);
                i = 0;
                while (i < advisorElements.length) {
                    SubProgressMonitor advisorMonitor = new SubProgressMonitor(monitor, 1000);
                    try {
                        IProcessConfigurationElement advisorConfig = advisorElements[i];
                        String advisorId = advisorConfig.getAttribute("id");
                        if (advisorId != null) {
                            IOperationAdvisor advisor = null;
                            IConfigurationElement configurationElement = this.fOperationAdvisorRegistry.getAdvisorExtension(advisorId);
                            if (configurationElement != null) {
                                String validOperationId;
                                String operationId = operation.getOperationIdentifier();
                                if (operationId.equals(validOperationId = configurationElement.getAttribute(ATTR_VALID_OPERATION_ID))) {
                                    try {
                                        advisor = this.fOperationAdvisorRegistry.createAdvisor(configurationElement);
                                        if (monitor.isCanceled()) {
                                            throw new OperationCanceledException();
                                        }
                                        this.runAdvisor(advisor, advisorConfig, operation, operationReport, oldReport, stack, (IProgressMonitor)advisorMonitor);
                                    }
                                    catch (CoreException e) {
                                        this.appendException(operationReport, Messages.getCommonString("OperationAdviceManager.23"), NLS.bind(Messages.getCommonString("OperationAdviceManager.24"), advisorId, this.getExceptionMessage(e)), e);
                                        InternalProcessCommon.log(e.getStatus());
                                    }
                                } else {
                                    this.appendError(operationReport, Messages.getCommonString("OperationAdviceManager.25"), NLS.bind(Messages.getCommonString("OperationAdviceManager.26"), advisorId, operationId), null, "com.ibm.team.process.exceptionProblem", null);
                                }
                            } else {
                                boolean optional = true;
                                String attr = advisorConfig.getAttribute("optional");
                                if (attr != null) {
                                    optional = Boolean.parseBoolean(attr);
                                }
                                if (optional) {
                                    final AdvisorReport advisorReport = this.createAdvisorReport(operationReport, advisorConfig);
                                    advisorReport.setName(String.valueOf(advisorReport.getName()) + Messages.getCommonString("OperationAdviceManager.27"));
                                    advisorReport.setComplete(true);
                                    operationReport.addReport(advisorReport);
                                    this.runAdviceNotifier(new IOperationAdviceNotifier(){

                                        public void notifyListener(IOperationAdviceListener listener) {
                                            listener.handleParticipantReportsCreated(new IParticipantReport[]{advisorReport});
                                        }
                                    });
                                } else {
                                    this.appendError(operationReport, Messages.getCommonString("OperationAdviceManager.28"), NLS.bind(Messages.getCommonString("OperationAdviceManager.29"), advisorId, "optional"), null, "com.ibm.team.process.exceptionProblem", null);
                                }
                            }
                        }
                    }
                    finally {
                        advisorMonitor.done();
                    }
                    ++i;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void runParticipants(AdvisableOperation operation, OperationBehaviorConfiguration behavior, IProgressMonitor monitor, OperationReport operationReport, IOperationReport oldReport, Stack stack) {
        block21: {
            try {
                int i;
                if (behavior == null) {
                    return;
                }
                IProcessConfigurationElement[] participantElements = null;
                IProcessConfigurationElement[] elements = behavior.getElements();
                if (elements != null) {
                    i = 0;
                    while (i < elements.length) {
                        IProcessConfigurationElement element = elements[i];
                        if ("followup-actions".equals(element.getName())) {
                            participantElements = element.getChildren();
                            break;
                        }
                        ++i;
                    }
                }
                if (participantElements == null) break block21;
                monitor.beginTask(Messages.getCommonString("OperationAdviceManager.30"), participantElements.length * 1000);
                i = 0;
                while (i < participantElements.length) {
                    block22: {
                        boolean optional;
                        String participantId;
                        IProcessConfigurationElement participantConfig;
                        SubProgressMonitor participantMonitor;
                        block23: {
                            participantMonitor = new SubProgressMonitor(monitor, 1000);
                            participantConfig = participantElements[i];
                            participantId = participantConfig.getAttribute("id");
                            if (participantId == null) break block22;
                            IConfigurationElement configurationElement = this.fOperationParticipantRegistry.getParticipantExtension(participantId);
                            if (configurationElement != null) {
                                String validOperationId;
                                String operationId = operation.getOperationIdentifier();
                                if (operationId.equals(validOperationId = configurationElement.getAttribute(ATTR_VALID_OPERATION_ID))) {
                                    try {
                                        IOperationParticipant participant = this.fOperationParticipantRegistry.createParticipant(configurationElement);
                                        if (monitor.isCanceled()) {
                                            throw new OperationCanceledException();
                                        }
                                        this.runParticipant(participant, participantConfig, operation, operationReport, stack, (IProgressMonitor)participantMonitor);
                                        int advice = operationReport.getSeverity();
                                        if (advice != 4) break block22;
                                        break;
                                    }
                                    catch (CoreException e) {
                                        this.appendException(operationReport, Messages.getCommonString("OperationAdviceManager.31"), NLS.bind(Messages.getCommonString("OperationAdviceManager.32"), participantId, this.getExceptionMessage(e)), e);
                                        InternalProcessCommon.log(e.getStatus());
                                        break block22;
                                    }
                                }
                                this.appendError(operationReport, Messages.getCommonString("OperationAdviceManager.33"), NLS.bind(Messages.getCommonString("OperationAdviceManager.34"), participantId, operationId), null, "com.ibm.team.process.exceptionProblem", null);
                                break block22;
                            }
                            optional = true;
                            String attr = participantConfig.getAttribute("optional");
                            if (attr == null) break block23;
                            optional = Boolean.parseBoolean(attr);
                        }
                        if (optional) {
                            final ParticipantReport participantReport = this.createParticipantReport(operationReport, participantConfig);
                            participantReport.setName(String.valueOf(participantReport.getName()) + Messages.getCommonString("OperationAdviceManager.35"));
                            participantReport.setComplete(true);
                            operationReport.addReport(participantReport);
                            this.runAdviceNotifier(new IOperationAdviceNotifier(){

                                public void notifyListener(IOperationAdviceListener listener) {
                                    listener.handleParticipantReportsCreated(new IParticipantReport[]{participantReport});
                                }
                            });
                        } else {
                            this.appendError(operationReport, Messages.getCommonString("OperationAdviceManager.36"), NLS.bind(Messages.getCommonString("OperationAdviceManager.37"), participantId, "optional"), null, "com.ibm.team.process.exceptionProblem", null);
                        }
                        break block22;
                        finally {
                            participantMonitor.done();
                        }
                    }
                    ++i;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private ParticipantReport createParticipantReport(IOperationReport operationReport, IProcessConfigurationElement participantConfig) {
        ParticipantReport participantReport = AdvicePackage.eINSTANCE.getAdviceFactory().createParticipantReport();
        String name = participantConfig.getAttribute(ATTR_OPERATION_NAME);
        if (name == null) {
            name = Messages.getCommonString("OperationAdviceManager.38");
        }
        String id = participantConfig.getAttribute("id");
        String description = participantConfig.getAttribute(ATTR_PERMISSION_ACTION_DESCRIPTION);
        participantReport.setName(name);
        participantReport.setIdentifier(id);
        participantReport.setDescription(description);
        return participantReport;
    }

    private AdvisorReport createAdvisorReport(IOperationReport operationReport, IProcessConfigurationElement advisorConfig) {
        AdvisorReportImpl advisorReport = (AdvisorReportImpl)AdvicePackage.eINSTANCE.getAdviceFactory().createAdvisorReport();
        String name = advisorConfig.getAttribute(ATTR_OPERATION_NAME);
        if (name == null) {
            name = Messages.getCommonString("OperationAdviceManager.39");
        }
        String id = advisorConfig.getAttribute("id");
        String description = advisorConfig.getAttribute(ATTR_PERMISSION_ACTION_DESCRIPTION);
        boolean overrulable = false;
        String overrulableString = advisorConfig.getAttribute("overrulable");
        if (overrulableString != null) {
            overrulable = Boolean.parseBoolean(overrulableString);
        }
        advisorReport.setName(name);
        advisorReport.setIdentifier(id);
        advisorReport.setDescription(description);
        advisorReport.setOverrulable(overrulable);
        return advisorReport;
    }

    public IAdvisorDeclaration[] getAdvisorDeclarations(OperationBehaviorConfiguration behavior) {
        ArrayList<AdvisorDeclaration> advisorDeclarations = new ArrayList<AdvisorDeclaration>();
        IProcessConfigurationElement[] elements = behavior.getElements();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                IProcessConfigurationElement element = elements[i];
                if ("preconditions".equals(element.getName())) {
                    IProcessConfigurationElement[] advisors = element.getChildren();
                    int j = 0;
                    while (j < advisors.length) {
                        AdvisorDeclaration declaration = AdvisorDeclaration.newAdvisorDeclaration(advisors[j]);
                        if (declaration != null) {
                            advisorDeclarations.add(declaration);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return advisorDeclarations.toArray(new IAdvisorDeclaration[advisorDeclarations.size()]);
    }

    /*
     * Loose catch block
     */
    private void runParticipant(IOperationParticipant participant, IProcessConfigurationElement participantConfig, AdvisableOperation operation, OperationReport operationReport, Stack stack, IProgressMonitor monitor) {
        block10: {
            final ParticipantReport participantReport = this.createParticipantReport(operationReport, participantConfig);
            operationReport.addReport(participantReport);
            this.runAdviceNotifier(new IOperationAdviceNotifier(){

                public void notifyListener(IOperationAdviceListener listener) {
                    listener.handleParticipantReportsCreated(new IParticipantReport[]{participantReport});
                }
            });
            ParticipantInfoCollector problemCollector = new ParticipantInfoCollector(this, participantReport);
            stack.push(participantReport);
            long startTime = System.currentTimeMillis();
            try {
                monitor.subTask(NLS.bind(Messages.getCommonString("OperationAdviceManager.40"), participantReport.getName()));
                participant.run(operation, participantConfig, problemCollector, monitor);
            }
            catch (PermissionDeniedException e) {
                this.appendError(participantReport, Messages.getCommonString("OperationAdviceManager.41"), NLS.bind(Messages.getCommonString("OperationAdviceManager.42"), participantReport.getName(), this.getExceptionMessage(e)), null, "com.ibm.team.process.exceptionProblem", (Object)e);
                participantReport.setTimeTaken(System.currentTimeMillis() - startTime);
                stack.pop();
                participantReport.setComplete(true);
                this.runAdviceNotifier(new IOperationAdviceNotifier(participantReport){
                    private final /* synthetic */ ParticipantReport val$participantReport;
                    {
                        this.val$participantReport = participantReport;
                    }

                    public void notifyListener(IOperationAdviceListener listener) {
                        listener.handleParticipantReportsCompleted(new IParticipantReport[]{this.val$participantReport});
                    }
                });
                monitor.done();
                break block10;
            }
            catch (TeamRepositoryException e) {
                String description = NLS.bind(Messages.getCommonString("OperationAdviceManager.43"), participantReport.getName(), this.getExceptionMessage(e));
                this.appendException(participantReport, Messages.getCommonString("OperationAdviceManager.44"), description, e);
                InternalProcessCommon.log(e);
                participantReport.setTimeTaken(System.currentTimeMillis() - startTime);
                stack.pop();
                participantReport.setComplete(true);
                this.runAdviceNotifier(new /* invalid duplicate definition of identical inner class */);
                monitor.done();
                break block10;
            }
            catch (RuntimeException e) {
                block11: {
                    if (e.getClass().getName().equals("com.ibm.team.repository.service.internal.UncheckedRepositoryException")) {
                        throw e;
                    }
                    if (e instanceof OperationCanceledException) {
                        String description = NLS.bind(Messages.getCommonString("OperationAdviceManager.46"), operationReport.getName());
                        String summary = Messages.getCommonString("OperationAdviceManager.47");
                        this.appendError(participantReport, summary, description, null, ID_OPERATION_CANCELED, e);
                        break block11;
                    }
                    String description = NLS.bind(Messages.getCommonString("OperationAdviceManager.48"), participantReport.getName(), this.getExceptionMessage(e));
                    String summary = Messages.getCommonString("OperationAdviceManager.49");
                    InternalProcessCommon.log(e);
                    this.appendException(participantReport, summary, description, e);
                    {
                        catch (Throwable throwable) {
                            participantReport.setTimeTaken(System.currentTimeMillis() - startTime);
                            stack.pop();
                            participantReport.setComplete(true);
                            this.runAdviceNotifier(new /* invalid duplicate definition of identical inner class */);
                            monitor.done();
                            throw throwable;
                        }
                    }
                }
                participantReport.setTimeTaken(System.currentTimeMillis() - startTime);
                stack.pop();
                participantReport.setComplete(true);
                this.runAdviceNotifier(new /* invalid duplicate definition of identical inner class */);
                monitor.done();
                break block10;
            }
            participantReport.setTimeTaken(System.currentTimeMillis() - startTime);
            stack.pop();
            participantReport.setComplete(true);
            this.runAdviceNotifier(new /* invalid duplicate definition of identical inner class */);
            monitor.done();
        }
    }

    private void runAdvisor(IOperationAdvisor advisor, IProcessConfigurationElement advisorConfig, AdvisableOperation operation, OperationReport operationReport, IOperationReport oldReport, Stack stack, IProgressMonitor monitor) {
        final AdvisorReport advisorReport = this.createAdvisorReport(operationReport, advisorConfig);
        operationReport.addReport(advisorReport);
        this.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleParticipantReportsCreated(new IParticipantReport[]{advisorReport});
            }
        });
        AdvisorInfoCollector problemCollector = new AdvisorInfoCollector(this, advisorReport);
        if (oldReport != null) {
            this.setOverruleState((ParticipantReportImpl)((Object)advisorReport), oldReport, advisor, problemCollector);
        }
        stack.push(advisorReport);
        long startTime = System.currentTimeMillis();
        try {
            monitor.subTask(NLS.bind(Messages.getCommonString("OperationAdviceManager.50"), advisorReport.getName()));
            advisor.run(operation, advisorConfig, problemCollector, monitor);
        }
        catch (PermissionDeniedException e) {
            this.appendError(advisorReport, Messages.getCommonString("OperationAdviceManager.51"), NLS.bind(Messages.getCommonString("OperationAdviceManager.52"), advisorReport.getName(), this.getExceptionMessage(e)), null, "com.ibm.team.process.exceptionProblem", (Object)e);
        }
        catch (TeamRepositoryException e) {
            String description = NLS.bind(Messages.getCommonString("OperationAdviceManager.53"), advisorReport.getName(), this.getExceptionMessage(e));
            this.appendException(advisorReport, Messages.getCommonString("OperationAdviceManager.54"), description, e);
            InternalProcessCommon.log(e);
        }
        catch (RuntimeException e) {
            String summary;
            String description;
            if (e.getClass().getName().equals("com.ibm.team.repository.service.internal.UncheckedRepositoryException")) {
                throw e;
            }
            if (e instanceof OperationCanceledException) {
                description = NLS.bind(Messages.getCommonString("OperationAdviceManager.56"), operationReport.getName());
                summary = Messages.getCommonString("OperationAdviceManager.57");
            } else {
                description = NLS.bind(Messages.getCommonString("OperationAdviceManager.58"), advisorReport.getName(), this.getExceptionMessage(e));
                summary = Messages.getCommonString("OperationAdviceManager.59");
                InternalProcessCommon.log(e);
            }
            this.appendException(advisorReport, summary, description, e);
        }
        advisorReport.setTimeTaken(System.currentTimeMillis() - startTime);
        stack.pop();
        advisorReport.setComplete(true);
        this.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleParticipantReportsCompleted(new IParticipantReport[]{advisorReport});
            }
        });
        monitor.done();
    }

    private void setOverruleState(ParticipantReportImpl advisorReport, IOperationReport oldReport, IOperationAdvisor advisor, IReportInfoCollector problemCollector) {
        IParticipantReport[] participantReports = oldReport.getParticipantReports();
        int j = 0;
        while (j < participantReports.length) {
            IParticipantReport report = participantReports[j];
            if (report.getParticipantIdentifier().equals(advisorReport.getParticipantIdentifier())) {
                if (!report.isRequestOverrule()) break;
                if (!advisorReport.isOverrulable()) {
                    ReportInfo problem = AdvicePackage.eINSTANCE.getAdviceFactory().createReportInfo();
                    problem.setDescription(Messages.getCommonString("OperationAdviceManager.60"));
                    problem.setSeverity(2);
                    problem.setSummary(Messages.getCommonString("OperationAdviceManager.61"));
                    problemCollector.addInfo(problem);
                    break;
                }
                advisorReport.setRequestOverrule(true);
                advisorReport.setWasOverruled(true);
                break;
            }
            ++j;
        }
    }

    public void setRequestOverrule(final IParticipantReport report, boolean requestOverrule) {
        if (report.isRequestOverrule() != requestOverrule) {
            ((ParticipantReportImpl)report).setRequestOverrule(requestOverrule);
            this.runAdviceNotifier(new IOperationAdviceNotifier(){

                public void notifyListener(IOperationAdviceListener listener) {
                    listener.handleParticipantReportsCreated(new IParticipantReport[]{report});
                }
            });
        }
    }

    public void setResolutionApplied(final IReportInfo info, boolean applied) {
        ((ReportInfoImpl)info).setResolutionApplied(applied);
        this.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleInfosAdded(new IReportInfo[]{info});
            }
        });
    }

    /*
     * Exception decompiling
     */
    private void runOperation(AdvisableOperation operation, String operationName, int mode, OperationBehaviorConfiguration behavior, OperationReport operationReport, IProgressMonitor monitor) throws TeamRepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runRunnable(ProcessRunnable runnable, String name, RunnableReport runnableReport, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(NLS.bind(Messages.getCommonString("OperationAdviceManager.71"), name), 1000);
        SubProgressMonitor runnableMonitor = new SubProgressMonitor(monitor, 1000);
        IOperationReport runReport = null;
        long startTime = System.currentTimeMillis();
        RunnableInfoCollector problemCollector = new RunnableInfoCollector(this, runnableReport);
        try {
            try {
                runReport = runnable.internalRun(problemCollector, (IProgressMonitor)runnableMonitor);
            }
            catch (TeamOperationCanceledException e) {
                IReportInfo info;
                runReport = e.getReport();
                if (runReport != null && ((info = this.findFirstError(runReport)) == null || ID_OPERATION_EXCEPTION.equals(info.getIdentifier()))) {
                    InternalProcessCommon.log((Throwable)((Object)e));
                }
                throw e;
            }
            catch (PermissionDeniedException e) {
                Object exceptionData = e.getProcessReportData();
                if (exceptionData instanceof IOperationReport) {
                    this.appendReports(runnableReport, new IOperationReport[]{(IOperationReport)exceptionData});
                } else {
                    this.appendError(runnableReport, Messages.getCommonString("OperationAdviceManager.72"), NLS.bind(Messages.getCommonString("OperationAdviceManager.73"), runnableReport.getName(), this.getExceptionMessage(e)), null, "com.ibm.team.process.exceptionProblem", (Object)e);
                }
                throw e;
            }
            catch (StaleDataException e) {
                this.appendException(runnableReport, Messages.getCommonString("OperationAdviceManager.74"), Messages.getCommonString("OperationAdviceManager.75"), e);
                throw e;
            }
            catch (LicenseNotGrantedException e) {
                String operationId = runnable.getOperationIdentifier();
                String message = operationId != null && name != null ? this.transformLicenseNotGrantedException(e, operationId, name) : this.getExceptionMessage(e);
                this.appendException(runnableReport, Messages.getCommonString("OperationAdviceManager.87"), message, e);
                throw e;
            }
            catch (TeamRepositoryException e) {
                this.appendException(runnableReport, Messages.getCommonString("OperationAdviceManager.76"), NLS.bind(Messages.getCommonString("OperationAdviceManager.77"), runnableReport.getName(), this.getExceptionMessage(e)), e);
                throw e;
            }
            catch (RuntimeException e) {
                this.appendException(runnableReport, Messages.getCommonString("OperationAdviceManager.78"), NLS.bind(Messages.getCommonString("OperationAdviceManager.79"), runnableReport.getName(), this.getExceptionMessage(e)), e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            runnableReport.setTimeTaken(System.currentTimeMillis() - startTime);
            runnableReport.setWasRun(runReport == null || runReport.wasRun());
            runnableMonitor.done();
            if (runReport != null) {
                this.appendReports(runnableReport, new IOperationReport[]{runReport});
            }
            monitor.done();
            throw throwable;
        }
        runnableReport.setTimeTaken(System.currentTimeMillis() - startTime);
        runnableReport.setWasRun(runReport == null || runReport.wasRun());
        runnableMonitor.done();
        if (runReport != null) {
            this.appendReports(runnableReport, new IOperationReport[]{runReport});
        }
        monitor.done();
    }

    private String getExceptionMessage(Throwable e) {
        String message = e.getMessage();
        if (message != null && message.trim().length() > 0) {
            return message;
        }
        return e.getClass().getSimpleName();
    }

    public void appendReports(Object report, final IOperationReport[] reports) {
        if (report instanceof ParticipantReport) {
            final ParticipantReport participantReport = (ParticipantReport)report;
            int i = 0;
            while (i < reports.length) {
                participantReport.appendReport(reports[i]);
                ++i;
            }
            this.runAdviceNotifier(new IOperationAdviceNotifier(){

                public void notifyListener(IOperationAdviceListener listener) {
                    listener.handleOperationReportsAppended(participantReport, reports);
                }
            });
        } else if (report instanceof OperationReport) {
            final OperationReport operationReport = (OperationReport)report;
            int i = 0;
            while (i < reports.length) {
                operationReport.append(reports[i]);
                ++i;
            }
            this.runAdviceNotifier(new IOperationAdviceNotifier(){

                public void notifyListener(IOperationAdviceListener listener) {
                    listener.handleOperationReportsAppended(operationReport, reports);
                }
            });
        }
    }

    private void appendException(ProcessReport report, String summary, String description, Throwable exception) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        exception.printStackTrace(new PrintStream(stream));
        this.appendError(report, summary, description, stream.toString(), ID_OPERATION_EXCEPTION, exception);
    }

    private void appendError(ProcessReport report, String errorSummary, String errorDetail, String problemData, String errorId, Object problemObject) {
        final ReportInfo errorReport = AdvicePackage.eINSTANCE.getAdviceFactory().createReportInfo();
        errorReport.setSummary(errorSummary);
        errorReport.setIdentifier(errorId);
        errorReport.setDescription(errorDetail);
        errorReport.setSeverity(4);
        if (problemData != null) {
            errorReport.setData(problemData);
        }
        if (problemObject != null) {
            errorReport.setProblemObject(problemObject);
        }
        report.addInfos(new IReportInfo[]{errorReport});
        this.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleInfosAdded(new IReportInfo[]{errorReport});
            }
        });
    }

    private OperationReport createOperationReport(AdvisableOperation operation, String operationName, OperationPermissionsConfiguration[] permissionConfigurations, OperationBehaviorConfiguration behavior, int mode, Stack stack) {
        String operationId = operation.getOperationIdentifier();
        ArrayList<IOperationReport> sameOperationReports = new ArrayList<IOperationReport>();
        IOperationReport[] reports = this.getReports();
        int i = 0;
        while (i < reports.length) {
            IOperationReport oldReport = reports[i];
            AdvisableOperation oldOperation = oldReport.getOperation();
            if (oldOperation != null && oldReport.isComplete() && operationId.equals(oldOperation.getOperationIdentifier()) && oldOperation.equals(operation)) {
                sameOperationReports.add(oldReport);
            }
            ++i;
        }
        if (sameOperationReports.size() > 0) {
            this.removeReports(sameOperationReports.toArray(new IOperationReport[sameOperationReports.size()]));
        }
        OperationReport operationReport = AdvicePackage.eINSTANCE.getAdviceFactory().createOperationReport();
        operationReport.setOperation(operation);
        this.initializeOperationReport(operationId, operationName, operation.getProcessArea(), operation.getDevelopmentLine(), permissionConfigurations, behavior, mode, stack, operationReport);
        operation.setOperationConfigurationInfo(operationReport.getOperationConfigurationInfo());
        operationReport.setData(operation.getReportData());
        return operationReport;
    }

    private RunnableReport createRunnableReport(ProcessRunnable runnable, String name, Stack stack) {
        String operationId = Messages.getCommonString("OperationAdviceManager.81");
        if (runnable != null) {
            operationId = runnable.getOperationIdentifier();
            ArrayList<IOperationReport> sameRunnableReports = new ArrayList<IOperationReport>();
            IOperationReport[] reports = this.getReports();
            int i = 0;
            while (i < reports.length) {
                IOperationReport oldReport = reports[i];
                ProcessRunnable oldRunnable = oldReport.getRunnable();
                if (oldRunnable != null && oldReport.isComplete() && oldRunnable.equals(runnable)) {
                    sameRunnableReports.add(oldReport);
                }
                ++i;
            }
            if (sameRunnableReports.size() > 0) {
                this.removeReports(sameRunnableReports.toArray(new IOperationReport[sameRunnableReports.size()]));
            }
        }
        RunnableReport runnableReport = AdvicePackage.eINSTANCE.getAdviceFactory().createRunnableReport();
        runnableReport.setRunnable(runnable);
        this.initializeOperationReport(operationId, name, null, null, null, null, 3, stack, runnableReport);
        return runnableReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeOperationReport(String operationId, String operationName, IProcessArea startingArea, IDevelopmentLine line, OperationPermissionsConfiguration[] permissions, OperationBehaviorConfiguration behavior, int mode, Stack stack, final OperationReport operationReport) {
        operationReport.setIdentifier(operationId);
        operationReport.setName(operationName);
        operationReport.setMode(mode);
        operationReport.setStartTime(System.currentTimeMillis());
        OperationConfigurationInfo configurationInfo = AdvicePackage.eINSTANCE.getAdviceFactory().createOperationConfigurationInfo();
        configurationInfo.setOperationId(operationId);
        operationReport.setOperationConfigurationInfo(configurationInfo);
        OperationAreaInfo primaryAreaInfo = null;
        if (startingArea != null) {
            primaryAreaInfo = AdvicePackage.eINSTANCE.getAdviceFactory().createOperationAreaInfo();
            primaryAreaInfo.setStartingArea(startingArea);
            primaryAreaInfo.setAreaItemUuid(startingArea.getItemId().getUuidValue());
            primaryAreaInfo.setAreaIsTeamArea(startingArea instanceof ITeamArea);
            configurationInfo.setPrimaryAreaInfo(primaryAreaInfo);
            if (line != null) {
                configurationInfo.setDevelopmentLineItemUuid(line.getItemId().getUuidValue());
            }
        }
        if (permissions != null && primaryAreaInfo != null) {
            operationReport.setPermissionConfigurations(permissions);
            ArrayList<ConfigurationSource> sources = new ArrayList<ConfigurationSource>();
            int i = 0;
            while (i < permissions.length) {
                ConfigurationSource source = permissions[i].getSource();
                if (source instanceof PermissionSource) {
                    sources.add(source);
                }
                ++i;
            }
            primaryAreaInfo.setPermissionSources(sources.toArray(new PermissionSource[sources.size()]));
        }
        if (behavior != null) {
            operationReport.setBehaviorConfiguration(behavior);
            configurationInfo.setBehaviorSource(behavior.getSource());
        }
        Object previousReport = null;
        if (!stack.empty()) {
            previousReport = stack.peek();
        }
        if (previousReport != null) {
            this.appendReports(previousReport, new IOperationReport[]{operationReport});
        } else {
            List list = this.fOperationReports;
            synchronized (list) {
                this.fOperationReports.add(operationReport);
            }
            this.runAdviceNotifier(new IOperationAdviceNotifier(){

                public void notifyListener(IOperationAdviceListener listener) {
                    listener.handleOperationReportsCreated(new IOperationReport[]{operationReport});
                }
            });
        }
    }

    private boolean isValidMode(int mode) {
        return mode == 0 || mode == 1 || mode == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOperationReport[] getReports() {
        List list = this.fOperationReports;
        synchronized (list) {
            return this.fOperationReports.toArray(new IOperationReport[0]);
        }
    }

    public void removeReports(IOperationReport[] reports) {
        this.removeReports(reports, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReports(IOperationReport[] reports, boolean keepNotRun) {
        ArrayList<IOperationReport> removed = new ArrayList<IOperationReport>();
        int i = 0;
        while (i < reports.length) {
            IOperationReport report = reports[i];
            if (report.isComplete() && (report.wasRun() || !keepNotRun)) {
                List list = this.fOperationReports;
                synchronized (list) {
                    if (this.fOperationReports.remove(report)) {
                        removed.add(report);
                    }
                }
            }
            ++i;
        }
        final IOperationReport[] removedReports = removed.toArray(new IOperationReport[0]);
        this.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleOperationReportsRemoved(removedReports);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReport(final IOperationReport report) {
        List list = this.fOperationReports;
        synchronized (list) {
            this.fOperationReports.add(report);
        }
        this.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleOperationReportsCreated(new IOperationReport[]{report});
                if (report.isComplete()) {
                    listener.handleOperationReportsCompleted(new IOperationReport[]{report});
                }
            }
        });
    }

    public void addAdviceListener(IOperationAdviceListener listener) {
        this.fAdviceListeners.add((Object)listener);
    }

    public void removeAdviceListener(IOperationAdviceListener listener) {
        this.fAdviceListeners.remove((Object)listener);
    }

    public void runAdviceNotifier(final IOperationAdviceNotifier notifier) {
        Object[] listeners = this.fAdviceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IOperationAdviceListener listener = (IOperationAdviceListener)listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    notifier.notifyListener(listener);
                }

                public void handleException(Throwable exception) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
            ++i;
        }
    }

    private IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }
}

