/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;

public class InvitationUtils {
    public static final String TEAM_REPOSITORY_URL = "teamRepository";
    public static final String USER_ID = "userId";
    public static final String USER_NAME = "userName";
    public static final String PROJECT_AREA_NAME = "projectAreaName";
    public static final String TEAM_AREA_PATH = "teamAreaPath";

    public static String generateInvitationContent(IContributor newTeamMember, List teamAreas, IProjectArea projectArea, String repositoryURL) throws TeamRepositoryException {
        StringBuffer textMessage = new StringBuffer();
        textMessage.append(NLS.bind("{0}={1}\n", TEAM_REPOSITORY_URL, repositoryURL));
        textMessage.append(NLS.bind("{0}={1}\n", USER_ID, newTeamMember.getUserId()));
        textMessage.append(NLS.bind("{0}={1}\n", USER_NAME, newTeamMember.getName()));
        textMessage.append(NLS.bind("{0}={1}\n", PROJECT_AREA_NAME, projectArea.getName()));
        if (teamAreas != null) {
            StringBuffer path = new StringBuffer();
            InvitationUtils.appendTeamAreaPath(teamAreas, projectArea, path);
            textMessage.append(NLS.bind("{0}={1}\n", TEAM_AREA_PATH, path.toString()));
        }
        return textMessage.toString();
    }

    private static void appendTeamAreaPath(List teamAreas, IProjectArea projectArea, StringBuffer buffer) throws TeamRepositoryException {
        for (ITeamArea teamArea : teamAreas) {
            buffer.insert(0, teamArea.getName());
            buffer.insert(0, '/');
        }
    }
}

