/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.metronome.internal;

import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.metronome.internal.Messages;
import com.ibm.team.metronome.internal.MetronomeModel;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.admin.common.ISCMAdminService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.themes.ITheme;

public class MetronomeWindow
extends ApplicationWindow
implements IListener {
    private MetronomeModel model;
    private IStatistics statistics;
    private String repoName;
    private Runnable runnable;
    private volatile Job job;
    private volatile boolean servicesStatsChanged;
    private volatile boolean itemsStatsChanged;
    private volatile long lastUpdate;
    private Image windowImage;
    private Clipboard cb;
    private static final int SVC_METHOD_COL_NUM = 0;
    private static final int SVC_CALL_COUNT_COL_NUM = 1;
    private static final int SVC_ELAPSED_TIME_COL_NUM = 2;
    private static final int SVC_TIME_RATIO_COL_NUM = 3;
    private static final int SVC_AVERAGE_TIME_COL_NUM = 4;
    private static final int SVC_WORST_TIME_COL_NUM = 5;
    private static final int SVC_TOOLTIP_COL_NUM = 6;
    private static final int ITEM_TYPE_COL_NUM = 0;
    private static final int ITEM_COUNT_COL_NUM = 1;
    private static final int ITEM_SIZE_COL_NUM = 2;
    private static final int ITEM_SIZE_RATIO_COL_NUM = 3;
    private static final int ITEM_HITS_COL_NUM = 4;
    private static final int ITEM_MISSES_COL_NUM = 5;
    private static final int ITEM_REFRESHES_COL_NUM = 6;
    private static final int STRING = 0;
    private static final int LONG = 1;
    private static final int DOUBLE = 2;
    private TabFolder tabFolder;
    private Tree servicesTree;
    private TreeColumn serviceMethodTreeColumn;
    private TreeColumn svcCallCountTreeColumn;
    private TreeColumn svcTimeTreeColumn;
    private TreeColumn svcTimeRatioTreeColumn;
    private TreeColumn srcAvgTimeTreeColumn;
    private TreeColumn srcWorstTimeTreeColumn;
    private Table itemsTable;
    private TableColumn itemTypeTableColumn;
    private TableColumn itemCountTableColumn;
    private TableColumn itemSizeTableColumn;
    private TableColumn itemSizeRatioTableColumn;
    private TableColumn itemHitsTableColumn;
    private TableColumn itemMissesTableColumn;
    private TableColumn itemRefreshesTableColumn;
    private int selectedTabIndex;
    private IAction copyAction;
    private IAction closeAction;
    private IAction expandAllAction;
    private IAction collapseAllAction;
    private IAction resetAction;
    private Button copyServicesButton;
    private Button expandAllButton;
    private Button collapseAllButton;
    private Button resetServicesButton;
    private Button copyItemsButton;
    private Button resetItemsButton;
    private IHandlerActivation copyHandler;
    private Button runTestButton;
    private Label pingTimeValue;
    private Label upBandwidthValue;
    private Label downBandwidthValue;
    static final double[] statisticalDivisors = new double[]{1024.0, 1048576.0, 1.073741824E9, 1.099511627776E12, 1.125899906842624E15};
    static final String[] statisticalSuffixes = new String[]{"KB", "MB", "GB", "TB", "PB"};
    private Color[] rangeColors = new Color[6];

    public static String bytesAsHumanReadable(long amt) {
        int i = statisticalDivisors.length - 1;
        while (i >= 0) {
            if ((double)amt > statisticalDivisors[i]) {
                return String.format("%,.1f %s", (double)amt / statisticalDivisors[i], statisticalSuffixes[i]);
            }
            --i;
        }
        return NLS.bind((String)"{0} B", (Object)amt);
    }

    public MetronomeWindow(MetronomeModel model, IStatistics statistics, String repoName) {
        super(null);
        this.addStatusLine();
        this.addMenuBar();
        this.model = model;
        this.statistics = statistics;
        this.repoName = repoName;
    }

    void setActive() {
        this.getShell().setActive();
    }

    protected Control createContents(Composite parent) {
        if (this.model != null) {
            this.model.addGenericListener("com.ibm.team.repository.statistics.serviceMethod", this);
            this.model.addGenericListener("com.ibm.team.repository.statistics.itemType", this);
        }
        this.rangeColors[0] = new Color((Device)parent.getDisplay(), 51, 255, 51);
        this.rangeColors[1] = new Color((Device)parent.getDisplay(), 170, 255, 170);
        this.rangeColors[2] = new Color((Device)parent.getDisplay(), 204, 204, 255);
        this.rangeColors[3] = new Color((Device)parent.getDisplay(), 255, 255, 153);
        this.rangeColors[4] = new Color((Device)parent.getDisplay(), 255, 153, 153);
        this.rangeColors[5] = new Color((Device)parent.getDisplay(), 255, 0, 0);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder(container, 0);
        this.createServicesTab(this.tabFolder);
        this.createItemManagerTab(this.tabFolder);
        this.createNetworkConnectionTab(this.tabFolder);
        this.tabFolder.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                MetronomeWindow.this.selectedTabIndex = MetronomeWindow.this.tabFolder.getSelectionIndex();
                MetronomeWindow.this.setEnabledForSelectedTab();
            }
        });
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MetronomeWindow.this.selectedTabIndex = MetronomeWindow.this.tabFolder.getSelectionIndex();
                MetronomeWindow.this.setEnabledForSelectedTab();
            }
        });
        this.makeActions();
        this.servicesStatsChanged = true;
        this.itemsStatsChanged = true;
        this.runnable = new Runnable(){

            public void run() {
                MetronomeWindow.this.updateView();
            }
        };
        this.job = new Job(""){
            Display d;
            {
                this.d = MetronomeWindow.this.getShell().getDisplay();
            }

            protected IStatus run(IProgressMonitor monitor) {
                this.d.asyncExec(MetronomeWindow.this.runnable);
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(false);
        this.updateView();
        return container;
    }

    private void createNetworkConnectionTab(TabFolder tabFolder) {
        TabItem networkConnectionTab = new TabItem(tabFolder, 0);
        networkConnectionTab.setText(Messages.MetronomeWindow_networkConnectionTab);
        GridLayout gridLayout = new GridLayout();
        Composite networkConnectionComposite = new Composite((Composite)tabFolder, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        networkConnectionComposite.setLayout((Layout)gridLayout);
        networkConnectionTab.setControl((Control)networkConnectionComposite);
        this.runTestButton = new Button(networkConnectionComposite, 8);
        this.runTestButton.setText(Messages.MetronomeWindow_testSpeedButton);
        this.runTestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetronomeWindow.this.runConnectionTest();
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.runTestButton);
        Label pingTimeLabel = new Label(networkConnectionComposite, 64);
        pingTimeLabel.setText(Messages.MetronomeWindow_pingTime);
        this.pingTimeValue = new Label(networkConnectionComposite, 64);
        this.pingTimeValue.setText(Messages.MetronomeWindow_pingTimeDefault);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pingTimeValue);
        Label upBandwidthLabel = new Label(networkConnectionComposite, 64);
        upBandwidthLabel.setText(Messages.MetronomeWindow_uploadSpeed);
        this.upBandwidthValue = new Label(networkConnectionComposite, 64);
        this.upBandwidthValue.setText(Messages.MetronomeWindow_uploadSpeedDefault);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.upBandwidthValue);
        Label downBandwidthLabel = new Label(networkConnectionComposite, 64);
        downBandwidthLabel.setText(Messages.MetronomeWindow_downloadSpeed);
        this.downBandwidthValue = new Label(networkConnectionComposite, 64);
        this.downBandwidthValue.setText(Messages.MetronomeWindow_downloadSpeedDefault);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.downBandwidthValue);
        Color backgroundColor = this.downBandwidthValue.getDisplay().getSystemColor(22);
        Browser browser = new Browser(networkConnectionComposite, 0);
        String text = NLS.bind((String)Messages.MetronomeWindow_explanationHtml, (Object[])new String[]{this.getCssIntro(), String.valueOf(Integer.toHexString(backgroundColor.getRGB().red)) + Integer.toHexString(backgroundColor.getRGB().green) + Integer.toHexString(backgroundColor.getRGB().blue), this.statistics.teamRepository().getRepositoryURI()});
        browser.setText(text);
        browser.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    private String getCssIntro() {
        FontData font = JFaceResources.getDefaultFont().getFontData()[0];
        StringBuffer css = new StringBuffer();
        css.append("<style type=\"text/css\">\n");
        css.append("body { overflow: auto; ").append(MarkupUtil.getFont((String)font.getName(), (int)font.getHeight())).append(" }\n");
        css.append("th { ").append(MarkupUtil.getFont((String)font.getName(), (int)font.getHeight())).append(" }\n");
        css.append("tr {  ").append(MarkupUtil.getFont((String)font.getName(), (int)font.getHeight())).append(" }\n");
        css.append("span.photo { padding: 3 10 0 3; float: left; }\n");
        css.append("span.name { padding: 5 0 0 0; float: left; ");
        css.append(MarkupUtil.getFont((String)font.getName(), (int)(font.getHeight() + 2), (int)1));
        css.append("}\n");
        css.append("a:link { text-decoration: none; }\n");
        css.append("a:visited { color:#0000FF; text-decoration: none; }\n");
        css.append("a:hover { text-decoration: underline; }\n");
        css.append("</style>\n");
        return css.toString();
    }

    private void createServicesTab(TabFolder tabFolder) {
        TabItem servicesTabItem = new TabItem(tabFolder, 0);
        servicesTabItem.setText(Messages.MetronomeWindow_servicesTab);
        final Composite servicesComposite = new Composite((Composite)tabFolder, 0);
        servicesComposite.setLayout((Layout)new GridLayout());
        servicesTabItem.setControl((Control)servicesComposite);
        this.servicesTree = new Tree(servicesComposite, 67586);
        this.servicesTree.setLinesVisible(true);
        this.servicesTree.setHeaderVisible(true);
        this.servicesTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.serviceMethodTreeColumn = new TreeColumn(this.servicesTree, 0);
        this.serviceMethodTreeColumn.setText(Messages.MetronomeWindow_serviceMethodColumnHeading);
        this.svcCallCountTreeColumn = new TreeColumn(this.servicesTree, 0);
        this.svcCallCountTreeColumn.setText(Messages.MetronomeWindow_countColumnHeading);
        this.svcCallCountTreeColumn.setAlignment(131072);
        this.svcTimeTreeColumn = new TreeColumn(this.servicesTree, 0);
        this.svcTimeTreeColumn.setText(Messages.MetronomeWindow_timeColumnHeading);
        this.svcTimeTreeColumn.setAlignment(131072);
        this.svcTimeRatioTreeColumn = new TreeColumn(this.servicesTree, 0);
        this.svcTimeRatioTreeColumn.setText(Messages.MetronomeWindow_timePercentColumnHeading);
        this.svcTimeRatioTreeColumn.setAlignment(131072);
        this.srcAvgTimeTreeColumn = new TreeColumn(this.servicesTree, 0);
        this.srcAvgTimeTreeColumn.setText(Messages.MetronomeWindow_averageSecondsColumnHeading);
        this.srcAvgTimeTreeColumn.setAlignment(131072);
        this.srcWorstTimeTreeColumn = new TreeColumn(this.servicesTree, 0);
        this.srcWorstTimeTreeColumn.setText(Messages.MetronomeWindow_worstSecondsColumnHeading);
        this.srcWorstTimeTreeColumn.setAlignment(131072);
        TreeColumn tooltipTreeColumn = new TreeColumn(this.servicesTree, 0);
        tooltipTreeColumn.setWidth(0);
        tooltipTreeColumn.setResizable(false);
        this.createFullNameTooltip();
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                MetronomeWindow.this.sortServicesTable(e);
            }
        };
        this.serviceMethodTreeColumn.addListener(13, sortListener);
        this.svcCallCountTreeColumn.addListener(13, sortListener);
        this.svcTimeTreeColumn.addListener(13, sortListener);
        this.svcTimeRatioTreeColumn.addListener(13, sortListener);
        this.srcAvgTimeTreeColumn.addListener(13, sortListener);
        this.srcWorstTimeTreeColumn.addListener(13, sortListener);
        Composite buttonsComposite = new Composite(servicesComposite, 0);
        GridLayout layout = new GridLayout(5, false);
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label label = new Label(buttonsComposite, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        label.setVisible(false);
        this.copyServicesButton = new Button(buttonsComposite, 0);
        this.copyServicesButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.copyServicesButton.setText(Messages.MetronomeWindow_copyButton);
        this.copyServicesButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MetronomeWindow.this.copyToClipboard();
            }
        });
        this.servicesTree.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MetronomeWindow.this.setEnabledForCopyServices();
            }
        });
        this.expandAllButton = new Button(buttonsComposite, 0);
        this.expandAllButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.expandAllButton.setText(Messages.MetronomeWindow_expandAllButton);
        this.expandAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetronomeWindow.this.expandServicesTree();
            }
        });
        this.collapseAllButton = new Button(buttonsComposite, 0);
        this.collapseAllButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.collapseAllButton.setText(Messages.MetronomeWindow_collapseAllButton);
        this.collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetronomeWindow.this.collapseServicesTree();
            }
        });
        this.resetServicesButton = new Button(buttonsComposite, 0);
        this.resetServicesButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.resetServicesButton.setText(Messages.MetronomeWindow_resetButton);
        this.resetServicesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetronomeWindow.this.resetServicesStats();
            }
        });
        servicesComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MetronomeWindow.this.resizeServicesTree(servicesComposite);
            }
        });
        this.updateServiceCountTab();
    }

    private void createFullNameTooltip() {
        this.servicesTree.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TABLEITEM");
                        MetronomeWindow.this.servicesTree.setSelection(new TreeItem[]{(TreeItem)e.item});
                        MetronomeWindow.this.servicesTree.notifyListeners(13, e);
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        Rectangle rect;
                        Point ptOfMouseHover = new Point(event.x, event.y);
                        TreeItem item = MetronomeWindow.this.servicesTree.getItem(ptOfMouseHover);
                        if (item == null || !(rect = item.getBounds(0)).contains(ptOfMouseHover)) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(MetronomeWindow.this.getShell(), 16388);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(MetronomeWindow.this.getShell().getDisplay().getSystemColor(28));
                        this.label.setBackground(MetronomeWindow.this.getShell().getDisplay().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(item.getText(6));
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Point ptToDisplay = MetronomeWindow.this.servicesTree.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(ptToDisplay.x, ptToDisplay.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        this.servicesTree.addListener(12, tableListener);
        this.servicesTree.addListener(1, tableListener);
        this.servicesTree.addListener(5, tableListener);
        this.servicesTree.addListener(32, tableListener);
    }

    private void createItemManagerTab(TabFolder tabFolder) {
        TabItem itemsTabItem = new TabItem(tabFolder, 0);
        itemsTabItem.setText(Messages.MetronomeWindow_itemManagerTab);
        final Composite itemsComposite = new Composite((Composite)tabFolder, 0);
        itemsComposite.setLayout((Layout)new GridLayout());
        itemsTabItem.setControl((Control)itemsComposite);
        this.itemsTable = new Table(itemsComposite, 67586);
        this.itemsTable.setLinesVisible(true);
        this.itemsTable.setHeaderVisible(true);
        this.itemsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.itemTypeTableColumn = new TableColumn(this.itemsTable, 0);
        this.itemTypeTableColumn.setText(Messages.MetronomeWindow_itemTypeColumnHeading);
        this.itemCountTableColumn = new TableColumn(this.itemsTable, 0);
        this.itemCountTableColumn.setText(Messages.MetronomeWindow_itemCountColumnHeading);
        this.itemCountTableColumn.setAlignment(131072);
        this.itemSizeTableColumn = new TableColumn(this.itemsTable, 0);
        this.itemSizeTableColumn.setText(Messages.MetronomeWindow_sizeBytesColumnHeading);
        this.itemSizeTableColumn.setAlignment(131072);
        this.itemSizeRatioTableColumn = new TableColumn(this.itemsTable, 0);
        this.itemSizeRatioTableColumn.setText(Messages.MetronomeWindow_sizePercentColumnHeading);
        this.itemSizeRatioTableColumn.setAlignment(131072);
        this.itemHitsTableColumn = new TableColumn(this.itemsTable, 0);
        this.itemHitsTableColumn.setText(Messages.MetronomeWindow_hitCountColumnHeading);
        this.itemHitsTableColumn.setAlignment(131072);
        this.itemMissesTableColumn = new TableColumn(this.itemsTable, 0);
        this.itemMissesTableColumn.setText(Messages.MetronomeWindow_missCountColumnHeading);
        this.itemMissesTableColumn.setAlignment(131072);
        this.itemRefreshesTableColumn = new TableColumn(this.itemsTable, 0);
        this.itemRefreshesTableColumn.setText(Messages.MetronomeWindow_refreshCountColumnHeading);
        this.itemRefreshesTableColumn.setAlignment(131072);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                MetronomeWindow.this.sortItemsTable(e);
            }
        };
        this.itemTypeTableColumn.addListener(13, sortListener);
        this.itemCountTableColumn.addListener(13, sortListener);
        this.itemSizeTableColumn.addListener(13, sortListener);
        this.itemSizeRatioTableColumn.addListener(13, sortListener);
        this.itemHitsTableColumn.addListener(13, sortListener);
        this.itemMissesTableColumn.addListener(13, sortListener);
        this.itemRefreshesTableColumn.addListener(13, sortListener);
        Composite buttonsComposite = new Composite(itemsComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label label = new Label(buttonsComposite, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        label.setVisible(false);
        this.copyItemsButton = new Button(buttonsComposite, 0);
        this.copyItemsButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.copyItemsButton.setText(Messages.MetronomeWindow_copyButton);
        this.copyItemsButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MetronomeWindow.this.copyToClipboard();
            }
        });
        this.itemsTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MetronomeWindow.this.setEnabledForCopyItems();
            }
        });
        this.resetItemsButton = new Button(buttonsComposite, 0);
        this.resetItemsButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.resetItemsButton.setText(Messages.MetronomeWindow_resetButton);
        this.resetItemsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetronomeWindow.this.resetItemsStats();
            }
        });
        itemsComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MetronomeWindow.this.resizeItemsTable(itemsComposite);
            }
        });
        this.updateItemManagerTab();
    }

    private boolean isLessThan(String value1, String value2, int type) {
        boolean result = false;
        if (type == 0) {
            result = value1.compareTo(value2) < 0;
        } else if (type == 1) {
            Long l2;
            Long l1 = Long.valueOf(value1);
            result = l1.compareTo(l2 = Long.valueOf(value2)) < 0;
        } else if (type == 2) {
            Double d2;
            Double d1 = Double.valueOf(value1);
            result = d1.compareTo(d2 = Double.valueOf(value2)) < 0;
        }
        return result;
    }

    private boolean isGreaterThan(String value1, String value2, int type) {
        boolean result = false;
        if (type == 0) {
            result = value1.compareTo(value2) > 0;
        } else if (type == 1) {
            Long l2;
            Long l1 = Long.valueOf(value1);
            result = l1.compareTo(l2 = Long.valueOf(value2)) > 0;
        } else if (type == 2) {
            Double d2;
            Double d1 = Double.valueOf(value1);
            result = d1.compareTo(d2 = Double.valueOf(value2)) > 0;
        }
        return result;
    }

    private void runConnectionTest() {
        final TeamRepository teamRepository = (TeamRepository)this.statistics.teamRepository();
        final ISCMAdminService adminService = (ISCMAdminService)teamRepository.getServiceInterface(ISCMAdminService.class);
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.tabFolder.getShell());
        final NetworkConnectionResults results = new NetworkConnectionResults();
        try {
            pmd.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IClientLibraryContext.IServiceRunnable<Object> serviceRunnable = new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                monitor.setTaskName(Messages.MetronomeWindow_testingConnectionProgress);
                                monitor.beginTask(Messages.MetronomeWindow_testingConnectionProgress, 100);
                                int NUM_PING_TRIES = 20;
                                int FILE_SIZE = 2048000;
                                int FILE_TRIES = 1;
                                ArrayList<Long> times = new ArrayList<Long>();
                                long time = System.currentTimeMillis();
                                monitor.subTask(Messages.MetronomeWindow_pingTestsProgress);
                                int i = 0;
                                while (i < NUM_PING_TRIES) {
                                    long singleTime = System.currentTimeMillis();
                                    adminService.echo(null);
                                    times.add(System.currentTimeMillis() - singleTime);
                                    ++i;
                                }
                                monitor.worked(30);
                                int count = 0;
                                double sum = 0.0;
                                double sumSquare = 0.0;
                                for (Long n : times) {
                                    ++count;
                                    sum += n.doubleValue();
                                    sumSquare += n.doubleValue() * n.doubleValue();
                                }
                                double average = sum / (double)count;
                                results.pingTime = (long)average;
                                results.pingStddev = (long)Math.sqrt(sumSquare / (double)count - average * average);
                                results.pingMax = (Long)Collections.max(times);
                                results.pingMin = (Long)Collections.min(times);
                                results.pingTries = count;
                                monitor.subTask(NLS.bind((String)Messages.MetronomeWindow_sendingFileProgress, (Object)MetronomeWindow.bytesAsHumanReadable(FILE_SIZE)));
                                time = System.currentTimeMillis();
                                int i2 = 0;
                                while (i2 < FILE_TRIES) {
                                    adminService.echoUp(new Object[]{MetronomeWindow.this.makeBytesToSend(FILE_SIZE)});
                                    ++i2;
                                }
                                monitor.worked(35);
                                time = System.currentTimeMillis() - time;
                                results.upSpeed = (double)(FILE_TRIES * FILE_SIZE) / ((double)time / 1000.0);
                                monitor.subTask(NLS.bind((String)Messages.MetronomeWindow_downloadingFileProgress, (Object)MetronomeWindow.bytesAsHumanReadable(FILE_SIZE)));
                                time = System.currentTimeMillis();
                                i2 = 0;
                                while (i2 < FILE_TRIES) {
                                    adminService.echoDown(FILE_SIZE);
                                    ++i2;
                                }
                                monitor.worked(35);
                                time = System.currentTimeMillis() - time;
                                results.downSpeed = (double)(FILE_TRIES * FILE_SIZE) / ((double)time / 1000.0);
                                return null;
                            }
                        };
                        teamRepository.callCancelableService((IClientLibraryContext.IServiceRunnable)serviceRunnable, monitor);
                        MetronomeWindow.this.tabFolder.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (!MetronomeWindow.this.tabFolder.getShell().isDisposed()) {
                                    MetronomeWindow.this.pingTimeValue.setText(NLS.bind((String)Messages.MetronomeWindow_pingTimeFormat, (Object[])new String[]{"" + results.pingTries, "" + results.pingMin, "" + results.pingTime, "" + results.pingMax, "" + results.pingStddev}));
                                    MetronomeWindow.this.upBandwidthValue.setText(NLS.bind((String)Messages.MetronomeWindow_perSecond, (Object)MetronomeWindow.bytesAsHumanReadable((long)results.upSpeed)));
                                    MetronomeWindow.this.downBandwidthValue.setText(NLS.bind((String)Messages.MetronomeWindow_perSecond, (Object)MetronomeWindow.bytesAsHumanReadable((long)results.downSpeed)));
                                }
                            }
                        });
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e, Messages.MetronomeWindow_errorContactingServer);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ErrorDialog.openError((Shell)this.tabFolder.getShell(), (String)Messages.MetronomeWindow_connectionErrorDialogTitle, (String)Messages.MetronomeWindow_netConnectionErrorMessage, (IStatus)StatusUtil.newStatus((int)4, (String)Messages.MetronomeWindow_errorStatusMessage, (Throwable)e.getTargetException()));
        }
        catch (InterruptedException interruptedException) {}
    }

    private String makeBytesToSend(int size) {
        SecureRandom randon = new SecureRandom();
        randon.setSeed(System.currentTimeMillis());
        byte[] randomBytes = new byte[size];
        String string2 = "abcedfghijklmnopqrstuvwxyz";
        int i = 0;
        while (i < size) {
            randomBytes[i] = (byte)string2.charAt(randon.nextInt(string2.length()));
            ++i;
        }
        return new String(randomBytes);
    }

    public boolean close() {
        this.windowImage.dispose();
        if (this.cb != null) {
            this.cb.dispose();
        }
        if (this.model != null) {
            this.model.removeGenericListener("com.ibm.team.repository.statistics.serviceMethod", this);
            this.model.removeGenericListener("com.ibm.team.repository.statistics.itemType", this);
        }
        int i = 0;
        while (i < this.rangeColors.length) {
            this.rangeColors[i].dispose();
            ++i;
        }
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.unregisterShell(this.getShell());
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        handlerService.deactivateHandler(this.copyHandler);
        return super.close();
    }

    void updateView() {
        this.lastUpdate = System.currentTimeMillis();
        if (this.getShell().isDisposed()) {
            return;
        }
        if (this.servicesStatsChanged) {
            this.updateServiceCountTab();
        }
        if (this.itemsStatsChanged) {
            this.updateItemManagerTab();
        }
    }

    private String getStatus(IStatistics statistics) {
        String str = NLS.bind((String)Messages.MetronomeWindow_0, (Object[])new String[]{"" + this.model.getTotalMethodCount(statistics), "" + this.model.getTotalElapsedTime(statistics), "" + this.model.getTotalItemCount(statistics), "" + this.model.getTotalCacheSize(statistics)});
        return str;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager statusLineManager = new StatusLineManager();
        return statusLineManager;
    }

    private void makeActions() {
        this.copyAction = new Action(Messages.MetronomeWindow_copyAction){

            public void run() {
                MetronomeWindow.this.copyToClipboard();
            }
        };
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.closeAction = new Action(Messages.MetronomeWindow_closeAction){

            public void run() {
                MetronomeWindow.this.close();
            }
        };
        this.expandAllAction = new Action(Messages.MetronomeWindow_expandAllAction){

            public void run() {
                MetronomeWindow.this.expandServicesTree();
            }
        };
        this.collapseAllAction = new Action(Messages.MetronomeWindow_collapseAllAction){

            public void run() {
                MetronomeWindow.this.collapseServicesTree();
            }
        };
        this.resetAction = new Action(Messages.MetronomeWindow_resetAction){

            public void run() {
                if (MetronomeWindow.this.selectedTabIndex == 0) {
                    MetronomeWindow.this.resetServicesStats();
                } else {
                    MetronomeWindow.this.resetItemsStats();
                }
            }
        };
    }

    protected MenuManager createMenuManager() {
        MenuManager mgr = super.createMenuManager();
        MenuManager fileMenu = new MenuManager(Messages.MetronomeWindow_fileMenuAction);
        MenuManager viewMenu = new MenuManager(Messages.MetronomeWindow_viewMenuAction);
        mgr.add((IContributionItem)fileMenu);
        mgr.add((IContributionItem)viewMenu);
        this.makeActions();
        fileMenu.add(this.copyAction);
        fileMenu.add(this.closeAction);
        viewMenu.add(this.expandAllAction);
        viewMenu.add(this.collapseAllAction);
        viewMenu.add(this.resetAction);
        return mgr;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)Messages.MetronomeWindow_metronomeDialogTitle, (Object)this.repoName));
        newShell.setSize(580, 320);
        this.windowImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.metronome", (String)"icons/obj16/metronome.gif").createImage(true, (Device)newShell.getDisplay());
        newShell.setImage(this.windowImage);
    }

    public void handleEvents(List events) {
        boolean needUpdate = false;
        for (PropertyChangeEvent event : events) {
            if (event.getData().equals("com.ibm.team.repository.statistics.serviceMethod")) {
                this.servicesStatsChanged = true;
                needUpdate = true;
                continue;
            }
            this.itemsStatsChanged = true;
            needUpdate = true;
        }
        if (needUpdate) {
            long time = Math.max(0L, this.lastUpdate + 1000L - System.currentTimeMillis());
            Job j = this.job;
            if (j != null) {
                j.schedule(time);
            }
        }
    }

    private void sortServicesTable(Event e) {
        TreeColumn nextSortColumn;
        int nextSortDir = this.servicesTree.getSortDirection();
        if (e == null) {
            nextSortColumn = this.servicesTree.getSortColumn();
        } else {
            TreeColumn currentSortColumn = this.servicesTree.getSortColumn();
            nextSortColumn = (TreeColumn)e.widget;
            if (currentSortColumn == null || currentSortColumn != nextSortColumn) {
                this.servicesTree.setSortColumn(nextSortColumn);
                nextSortDir = 128;
            } else {
                nextSortDir = nextSortDir == 128 ? 1024 : 128;
            }
            this.servicesTree.setSortDirection(nextSortDir);
        }
        int index = 0;
        int type = 0;
        if (nextSortColumn == this.svcCallCountTreeColumn) {
            index = 1;
            type = 1;
        } else if (nextSortColumn == this.svcTimeTreeColumn) {
            index = 2;
            type = 2;
        } else if (nextSortColumn == this.svcTimeRatioTreeColumn) {
            index = 3;
            type = 1;
        } else if (nextSortColumn == this.srcAvgTimeTreeColumn) {
            index = 4;
            type = 2;
        } else if (nextSortColumn == this.srcWorstTimeTreeColumn) {
            index = 5;
            type = 2;
        }
        TreeItem[] items = this.servicesTree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            TreeItem[] subItems = item.getItems();
            int j = 1;
            while (j < subItems.length) {
                String value1 = subItems[j].getText(index);
                int k = 0;
                while (k < j) {
                    String value2 = subItems[k].getText(index);
                    if (nextSortDir == 128 ? this.isLessThan(value1, value2, type) : this.isGreaterThan(value1, value2, type)) {
                        String[] values = new String[]{subItems[j].getText(0), subItems[j].getText(1), subItems[j].getText(2), subItems[j].getText(3), subItems[j].getText(4), subItems[j].getText(5), subItems[j].getText(6)};
                        subItems[j].dispose();
                        TreeItem subItem = new TreeItem(item, 0, k);
                        subItem.setText(values);
                        subItems = item.getItems();
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void sortItemsTable(Event e) {
        TableColumn nextSortColumn;
        int nextSortDir = this.itemsTable.getSortDirection();
        if (e == null) {
            nextSortColumn = this.itemsTable.getSortColumn();
        } else {
            TableColumn currentSortColumn = this.itemsTable.getSortColumn();
            nextSortColumn = (TableColumn)e.widget;
            if (currentSortColumn == null || currentSortColumn != nextSortColumn) {
                this.itemsTable.setSortColumn(nextSortColumn);
                nextSortDir = 128;
            } else {
                nextSortDir = nextSortDir == 128 ? 1024 : 128;
            }
            this.itemsTable.setSortDirection(nextSortDir);
        }
        int index = 0;
        int type = 0;
        if (nextSortColumn == this.itemCountTableColumn) {
            index = 1;
            type = 1;
        } else if (nextSortColumn == this.itemSizeTableColumn) {
            index = 2;
            type = 1;
        } else if (nextSortColumn == this.itemSizeRatioTableColumn) {
            index = 3;
            type = 1;
        } else if (nextSortColumn == this.itemCountTableColumn) {
            index = 1;
            type = 1;
        } else if (nextSortColumn == this.itemHitsTableColumn) {
            index = 4;
            type = 1;
        } else if (nextSortColumn == this.itemMissesTableColumn) {
            index = 5;
            type = 1;
        } else if (nextSortColumn == this.itemRefreshesTableColumn) {
            index = 6;
            type = 1;
        }
        TableItem[] items = this.itemsTable.getItems();
        int i = 1;
        while (i < items.length) {
            String value1 = items[i].getText(index);
            int j = 0;
            while (j < i) {
                String value2 = items[j].getText(index);
                if (nextSortDir == 128 ? this.isLessThan(value1, value2, type) : this.isGreaterThan(value1, value2, type)) {
                    String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4), items[i].getText(5), items[i].getText(6)};
                    items[i].dispose();
                    TableItem item = new TableItem(this.itemsTable, 0, j);
                    item.setText(values);
                    items = this.itemsTable.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void updateServiceCountTab() {
        if (this.servicesTree.isDisposed()) {
            return;
        }
        if (this.servicesStatsChanged) {
            this.servicesStatsChanged = false;
            Class<?>[] service = this.model.getServices(this.statistics);
            TreeItem[] items = this.servicesTree.getItems();
            int itemsCount = this.servicesTree.getItemCount();
            boolean allExpanded = itemsCount > 0;
            int i = 0;
            while (i < itemsCount) {
                allExpanded = this.servicesTree.getItems()[i].getExpanded();
                if (!allExpanded) break;
                ++i;
            }
            i = 0;
            while (i < service.length) {
                Class<?> s = service[i];
                if (this.model.getServiceCallCount(this.statistics, s) > 0L) {
                    int itemIndex = -1;
                    boolean itemFound = false;
                    String item1 = s.getName();
                    int j = 0;
                    while (j < items.length) {
                        String item2 = items[j].getText(6);
                        if (item1.equals(item2)) {
                            itemFound = true;
                            itemIndex = j;
                            break;
                        }
                        ++j;
                    }
                    TreeItem item = itemFound ? items[itemIndex] : new TreeItem(this.servicesTree, 0);
                    item.setText(this.model.getServiceData(this.statistics, s));
                    ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                    FontRegistry fontRegistry = theme.getFontRegistry();
                    Font font = fontRegistry.getBold("org.eclipse.jface.defaultfont");
                    item.setFont(font);
                    Method[] method = this.model.getMethods(this.statistics, s);
                    TreeItem[] subItems = item.getItems();
                    int k = 0;
                    while (k < method.length) {
                        Method m = method[k];
                        if (this.model.getMethodCallCount(this.statistics, s, m) > 0L || this.model.getMethodElapsedTime(this.statistics, s, m) > 0.0) {
                            int subItemIndex = -1;
                            String subItem1 = this.model.getMethodName(m);
                            int l = 0;
                            while (l < subItems.length) {
                                String subItem2 = subItems[l].getText(0);
                                if (subItem1.compareTo(subItem2) == 0) {
                                    subItemIndex = l;
                                    break;
                                }
                                ++l;
                            }
                            TreeItem subItem = subItemIndex > -1 ? subItems[subItemIndex] : new TreeItem(item, 0);
                            subItem.setText(this.model.getMethodData(this.statistics, s, m));
                        }
                        ++k;
                    }
                    if (!itemFound && allExpanded) {
                        item.setExpanded(true);
                    }
                }
                ++i;
            }
            this.servicesTree.layout();
            if (this.servicesTree.getSortColumn() != null) {
                this.sortServicesTable(null);
            }
            this.getStatusLineManager().setMessage(null, this.getStatus(this.statistics));
        } else {
            this.servicesTree.removeAll();
            this.getStatusLineManager().setMessage(null, this.getStatus(this.statistics));
        }
        this.setEnabledForSelectedTab();
    }

    private void updateItemManagerTab() {
        if (this.itemsTable.isDisposed()) {
            return;
        }
        this.itemsStatsChanged = false;
        IItemType[] itemTypes = this.model.getItemTypes(this.statistics);
        TableItem[] items = this.itemsTable.getItems();
        int i = 0;
        while (i < itemTypes.length) {
            IItemType itemType = itemTypes[i];
            if (this.model.getItemCount(this.statistics, itemType) > 0L || this.model.getItemHits(this.statistics, itemType) > 0L || this.model.getItemMisses(this.statistics, itemType) > 0L || this.model.getItemRefreshes(this.statistics, itemType) > 0L || this.model.getItemSize(this.statistics, itemType) > 0.0) {
                int index = -1;
                boolean found = false;
                String item1 = this.model.getItemTypeName(itemType);
                int j = 0;
                while (j < items.length) {
                    String item2 = items[j].getText(0);
                    if (item1.compareTo(item2) == 0) {
                        found = true;
                        index = j;
                        break;
                    }
                    ++j;
                }
                TableItem ti = found ? items[index] : new TableItem(this.itemsTable, 0);
                ti.setText(this.model.getItemTypeData(this.statistics, itemType));
            }
            ++i;
        }
        this.itemsTable.layout();
        if (this.itemsTable.getSortColumn() != null) {
            this.sortItemsTable(null);
        }
        this.getStatusLineManager().setMessage(null, this.getStatus(this.statistics));
        this.setEnabledForSelectedTab();
    }

    private void resizeServicesTree(Composite composite) {
        Rectangle area = composite.getClientArea();
        Point preferredSize = this.servicesTree.computeSize(-1, -1);
        int width = area.width - 2 * this.servicesTree.getBorderWidth();
        if (preferredSize.y > area.height + this.servicesTree.getHeaderHeight()) {
            Point vBarSize = this.servicesTree.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = this.servicesTree.getSize();
        if (oldSize.x > area.width) {
            this.serviceMethodTreeColumn.setWidth(5 * width / 10);
            this.svcCallCountTreeColumn.setWidth(1 * width / 10);
            this.svcTimeTreeColumn.setWidth(1 * width / 10);
            this.svcTimeRatioTreeColumn.setWidth(1 * width / 10);
            this.srcAvgTimeTreeColumn.setWidth(1 * width / 10);
            this.srcWorstTimeTreeColumn.setWidth(1 * width / 10);
            this.servicesTree.setSize(area.width, area.height);
        } else {
            this.servicesTree.setSize(area.width, area.height);
            this.serviceMethodTreeColumn.setWidth(5 * width / 10);
            this.svcCallCountTreeColumn.setWidth(1 * width / 10);
            this.svcTimeTreeColumn.setWidth(1 * width / 10);
            this.svcTimeRatioTreeColumn.setWidth(1 * width / 10);
            this.srcAvgTimeTreeColumn.setWidth(1 * width / 10);
            this.srcWorstTimeTreeColumn.setWidth(1 * width / 10);
        }
    }

    private void resizeItemsTable(Composite composite) {
        Rectangle area = composite.getClientArea();
        Point preferredSize = this.itemsTable.computeSize(-1, -1);
        int width = area.width - 2 * this.itemsTable.getBorderWidth();
        if (preferredSize.y > area.height + this.itemsTable.getHeaderHeight()) {
            Point vBarSize = this.itemsTable.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = this.itemsTable.getSize();
        if (oldSize.x > area.width) {
            this.itemTypeTableColumn.setWidth(3 * width / 10);
            this.itemCountTableColumn.setWidth(1 * width / 10);
            this.itemSizeTableColumn.setWidth(1 * width / 10);
            this.itemSizeRatioTableColumn.setWidth(1 * width / 10);
            this.itemHitsTableColumn.setWidth(1 * width / 10);
            this.itemMissesTableColumn.setWidth(1 * width / 10);
            this.itemRefreshesTableColumn.setWidth(1 * width / 10);
            this.itemsTable.setSize(area.width, area.height);
        } else {
            this.itemsTable.setSize(area.width, area.height);
            this.itemTypeTableColumn.setWidth(3 * width / 10);
            this.itemCountTableColumn.setWidth(1 * width / 10);
            this.itemSizeTableColumn.setWidth(1 * width / 10);
            this.itemSizeRatioTableColumn.setWidth(1 * width / 10);
            this.itemHitsTableColumn.setWidth(1 * width / 10);
            this.itemMissesTableColumn.setWidth(1 * width / 10);
            this.itemRefreshesTableColumn.setWidth(1 * width / 10);
        }
    }

    private void copyToClipboard() {
        String formatString;
        StringBuffer sb = new StringBuffer();
        if (this.cb == null) {
            this.cb = new Clipboard(this.getShell().getDisplay());
        }
        int index = this.tabFolder.getSelectionIndex();
        String lineSeparator = System.getProperty("line.separator");
        if (index == 0) {
            formatString = Messages.MetronomeWindow_serviceMethodCopyTextFormat;
            sb.append(String.valueOf(NLS.bind((String)formatString, (Object[])new String[]{Messages.MetronomeWindow_serviceMethodColumnHeading, Messages.MetronomeWindow_countColumnHeading, Messages.MetronomeWindow_timeSecondsColumnHeading, Messages.MetronomeWindow_timePercentColumnHeading, Messages.MetronomeWindow_timeAverageColumnHeading, Messages.MetronomeWindow_timeWorstColumnHeading})) + lineSeparator);
            TreeItem[] items = this.servicesTree.getSelection();
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (item.getItemCount() > 0) {
                    sb.append(item.getText(0));
                } else {
                    sb.append(String.valueOf(NLS.bind((String)("  " + formatString), (Object[])new String[]{item.getText(0), item.getText(1), item.getText(2), item.getText(3), item.getText(4), item.getText(5)})) + lineSeparator);
                }
                sb.append(lineSeparator);
                ++i;
            }
        } else if (index == 1) {
            formatString = Messages.MetronomeWindow_itemTypeFormat;
            sb.append(String.valueOf(NLS.bind((String)formatString, (Object[])new String[]{Messages.MetronomeWindow_itemTypeColumnHeading, Messages.MetronomeWindow_countColumnHeading, Messages.MetronomeWindow_sizeBytesColumnHeading, Messages.MetronomeWindow_sizePercentColumnHeading, Messages.MetronomeWindow_hitColumnHeading, Messages.MetronomeWindow_missColumnHeading, Messages.MetronomeWindow_refreshColumnHeading})) + lineSeparator);
            TableItem[] items = this.itemsTable.getSelection();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                sb.append(NLS.bind((String)(String.valueOf(formatString) + lineSeparator), (Object[])new String[]{item.getText(0), item.getText(1), item.getText(2), item.getText(3), item.getText(4), item.getText(5), item.getText(6)}));
                ++i;
            }
        } else if (index == 2) {
            sb.append(NLS.bind((String)(String.valueOf(Messages.MetronomeWindow_pingTimePasteMessage) + lineSeparator), (Object)this.pingTimeValue.getText()));
            sb.append(NLS.bind((String)(String.valueOf(Messages.MetronomeWindow_uploadSpeedPasteMessage) + lineSeparator), (Object)this.upBandwidthValue.getText()));
            sb.append(NLS.bind((String)(String.valueOf(Messages.MetronomeWindow_downloadSpeedPasteMessage) + lineSeparator), (Object)this.downBandwidthValue.getText()));
        }
        if (sb.length() > 0) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            this.cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
        }
    }

    private void expandServicesTree() {
        TreeItem[] items = this.servicesTree.getItems();
        int i = 0;
        while (i < this.servicesTree.getItemCount()) {
            items[i].setExpanded(true);
            ++i;
        }
    }

    private void collapseServicesTree() {
        TreeItem[] items = this.servicesTree.getItems();
        int i = 0;
        while (i < this.servicesTree.getItemCount()) {
            items[i].setExpanded(false);
            ++i;
        }
    }

    private void resetServicesStats() {
        this.model.resetServiceMethodStats(this.statistics);
        this.updateServiceCountTab();
        this.setEnabledForSelectedTab();
    }

    private void resetItemsStats() {
        this.model.resetItemTypeStats(this.statistics);
        this.updateItemManagerTab();
        this.setEnabledForSelectedTab();
    }

    private void setEnabledForServicesButtons() {
        if (this.servicesTree.getItemCount() > 0) {
            this.expandAllButton.setEnabled(true);
            this.collapseAllButton.setEnabled(true);
            this.resetServicesButton.setEnabled(true);
        } else {
            this.expandAllButton.setEnabled(false);
            this.collapseAllButton.setEnabled(false);
            this.resetServicesButton.setEnabled(false);
        }
    }

    private void setEnabledForItemsButtons() {
        if (this.itemsTable.getItemCount() > 0) {
            this.resetItemsButton.setEnabled(true);
        } else {
            this.resetItemsButton.setEnabled(false);
        }
    }

    private void setEnabledForServicesActions() {
        if (this.servicesTree.getItemCount() > 0) {
            this.expandAllAction.setEnabled(true);
            this.collapseAllAction.setEnabled(true);
            this.resetAction.setEnabled(true);
        } else {
            this.expandAllAction.setEnabled(false);
            this.collapseAllAction.setEnabled(false);
            this.resetAction.setEnabled(false);
        }
    }

    private void setEnabledForItemsActions() {
        if (this.itemsTable.getItemCount() > 0) {
            this.resetAction.setEnabled(true);
        } else {
            this.resetAction.setEnabled(false);
        }
        this.expandAllAction.setEnabled(false);
        this.collapseAllAction.setEnabled(false);
    }

    private void setEnabledForCopyServices() {
        if (this.servicesTree.getSelectionCount() > 0) {
            this.copyServicesButton.setEnabled(true);
            this.copyAction.setEnabled(true);
        } else {
            this.copyServicesButton.setEnabled(false);
            this.copyAction.setEnabled(false);
        }
    }

    private void setEnabledForCopyItems() {
        if (this.itemsTable.getSelectionCount() > 0) {
            this.copyItemsButton.setEnabled(true);
            this.copyAction.setEnabled(true);
        } else {
            this.copyItemsButton.setEnabled(false);
            this.copyAction.setEnabled(false);
        }
    }

    private void setEnabledForSelectedTab() {
        if (this.selectedTabIndex == 0) {
            this.setEnabledForServicesButtons();
            this.setEnabledForServicesActions();
            this.setEnabledForCopyServices();
        } else {
            this.setEnabledForItemsButtons();
            this.setEnabledForItemsActions();
            this.setEnabledForCopyItems();
        }
    }

    public int open() {
        int rc = super.open();
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.registerShell(this.getShell(), 2);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.copyHandler = handlerService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new ActionHandler(this.copyAction), (Expression)new ActiveShellExpression(this.getShell()));
        return rc;
    }

    private static final class ActiveShellExpression
    extends Expression {
        private static final int HASH_INITIAL = ActiveShellExpression.class.getName().hashCode();
        public static final int SOURCES = 17408;
        private final Shell activeShell;

        public ActiveShellExpression(Shell activeShell) {
            this.activeShell = activeShell;
        }

        public final void collectExpressionInfo(ExpressionInfo info) {
            info.addVariableNameAccess("activeShell");
            info.addVariableNameAccess("activeWorkbenchWindow");
            info.addVariableNameAccess("selection");
        }

        protected final int computeHashCode() {
            return HASH_INITIAL * 89 + ActiveShellExpression.hashCode((Object)this.activeShell);
        }

        public final boolean equals(Object object) {
            if (object instanceof ActiveShellExpression) {
                ActiveShellExpression that = (ActiveShellExpression)((Object)object);
                return ActiveShellExpression.equals((Object)this.activeShell, (Object)that.activeShell);
            }
            return false;
        }

        public final EvaluationResult evaluate(IEvaluationContext context) {
            Object value;
            if (this.activeShell != null && !this.activeShell.equals(value = context.getVariable("activeShell")) && !this.activeShell.equals(value = context.getVariable("activeWorkbenchWindowShell"))) {
                return EvaluationResult.FALSE;
            }
            return EvaluationResult.TRUE;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ActiveShellExpression(");
            buffer.append(this.activeShell);
            buffer.append(')');
            return buffer.toString();
        }
    }

    static class NetworkConnectionResults {
        public long pingTime = 0L;
        public long pingTries = 0L;
        public long pingMin = 0L;
        public long pingMax = 0L;
        public double upSpeed = 0.0;
        public double downSpeed = 0.0;
        public long pingStddev = 0L;

        NetworkConnectionResults() {
        }
    }
}

