/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.rcp.ui.internal.gef.model;

import com.ibm.team.links.rcp.ui.internal.gef.model.NodeElement;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramElement
extends NodeElement {
    private ArrayList<IItemHandle> fUniqueItemHandles = new ArrayList();
    private HashMap<UUID, ArrayList<NodeElement>> fItemUuidToNodeElementsMap = new HashMap();

    @Override
    public void addChild(NodeElement child, int index) {
        super.addChild(child, index);
        IItemHandle itemHandle = child.getItemHandle();
        UUID key = itemHandle.getItemId();
        ArrayList<NodeElement> nodeElements = this.fItemUuidToNodeElementsMap.get(key);
        if (nodeElements == null) {
            nodeElements = new ArrayList();
            this.fItemUuidToNodeElementsMap.put(key, nodeElements);
            this.fUniqueItemHandles.add(itemHandle);
        }
        nodeElements.add(child);
    }

    public ArrayList<NodeElement> getNodeElements(UUID itemId) {
        return this.fItemUuidToNodeElementsMap.get(itemId);
    }

    public NodeElement getNewestNodeElement(UUID itemId) {
        NodeElement newestNodeElement = null;
        ArrayList<NodeElement> nodeElements = this.fItemUuidToNodeElementsMap.get(itemId);
        if (nodeElements != null && nodeElements.size() > 0) {
            newestNodeElement = nodeElements.get(nodeElements.size() - 1);
        }
        return newestNodeElement;
    }

    public IItemHandle[] getAllUniqueNodeElementItemHandles() {
        return this.fUniqueItemHandles.toArray(new IItemHandle[this.fUniqueItemHandles.size()]);
    }
}

