/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.rcp.ui.internal.gef.controller;

import com.ibm.team.links.rcp.ui.ILinksViewerActionProvider;
import com.ibm.team.links.rcp.ui.ILinksViewerLabelProvider;
import com.ibm.team.links.rcp.ui.LinksViewer;
import com.ibm.team.links.rcp.ui.internal.Activator;
import com.ibm.team.links.rcp.ui.internal.gef.controller.ConnectionPart;
import com.ibm.team.links.rcp.ui.internal.gef.controller.LeftAnchor;
import com.ibm.team.links.rcp.ui.internal.gef.controller.NodeSelectionEditPolicy;
import com.ibm.team.links.rcp.ui.internal.gef.controller.RightAnchor;
import com.ibm.team.links.rcp.ui.internal.gef.model.NodeElement;
import com.ibm.team.links.rcp.ui.internal.gef.view.NodeFigure;
import com.ibm.team.repository.common.IItemHandle;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class NodePart
extends AbstractGraphicalEditPart
implements NodeEditPart {
    private LinksViewer fLinksViewer;
    private boolean fIsOpened;
    private boolean fIsActive;
    private static final int HORIZONTAL_ANCHOR_OFFSET = -1;
    private static final int VERTICAL_ANCHOR_OFFSET = -1;
    private static int NODE_PADDING_LEFT = 8;
    private static int NODE_PADDING_RIGHT = 18;
    private static int NODE_PADDING_TOP = 5;
    private static int NODE_PADDING_BOTTOM = 5;

    public NodePart(LinksViewer linksViewer) {
        this.fLinksViewer = linksViewer;
    }

    public NodePart() {
    }

    private NodeElement getNodeElement() {
        return (NodeElement)this.getModel();
    }

    private ConnectionAnchor getSourceConnectionAnchor() {
        RightAnchor anchor = null;
        anchor = new RightAnchor(this.getFigure(), -1);
        return anchor;
    }

    private ConnectionAnchor getTargetConnectionAnchor() {
        LeftAnchor anchor = null;
        anchor = new LeftAnchor(this.getFigure(), -1);
        return anchor;
    }

    public void contributeNodesToGraph(DirectedGraph graph, Subgraph s, Map map) {
        Node node = new Node((Object)this, s);
        node.incomingOffset = -1;
        node.outgoingOffset = -1;
        node.width = this.getFigure().getPreferredSize().width;
        node.height = this.getFigure().getPreferredSize().height;
        node.setPadding(new Insets(NODE_PADDING_TOP, NODE_PADDING_LEFT, NODE_PADDING_BOTTOM, NODE_PADDING_RIGHT));
        map.put(this, node);
        graph.nodes.add((Object)node);
        int index = 0;
        while (index < this.getChildren().size()) {
            NodePart nodePart = (NodePart)((Object)this.getChildren().get(index));
            nodePart.contributeNodesToGraph(graph, s, map);
            ++index;
        }
    }

    public void contributeEdgesToGraph(DirectedGraph graph, Map map) {
        List outgoing = this.getSourceConnections();
        int index = 0;
        while (index < outgoing.size()) {
            ConnectionPart connection = (ConnectionPart)((Object)this.getSourceConnections().get(index));
            connection.contributeToGraph(graph, map);
            ++index;
        }
        index = 0;
        while (index < this.getChildren().size()) {
            NodePart child = (NodePart)((Object)this.children.get(index));
            child.contributeEdgesToGraph(graph, map);
            ++index;
        }
    }

    protected void applyChildrenResults(DirectedGraph graph, Map map) {
        int index = 0;
        while (index < this.getChildren().size()) {
            NodePart part = (NodePart)((Object)this.getChildren().get(index));
            part.applyGraphResults(graph, map);
            ++index;
        }
    }

    protected void applyOwnResults(DirectedGraph graph, Map map) {
        Node node = (Node)map.get((Object)this);
        this.getFigure().setBounds(new Rectangle(node.x, node.y, node.width, node.height));
        int index = 0;
        while (index < this.getSourceConnections().size()) {
            ConnectionPart connection = (ConnectionPart)((Object)this.getSourceConnections().get(index));
            connection.applyGraphResults(graph, map);
            ++index;
        }
    }

    protected void applyGraphResults(DirectedGraph graph, Map map) {
        this.applyOwnResults(graph, map);
        this.applyChildrenResults(graph, map);
    }

    private void initFigureData(NodeFigure nodeFigure, Image icon, String label, Font font, boolean isOpened, boolean isActive) {
        nodeFigure.setIcon(icon);
        nodeFigure.setText(label);
        nodeFigure.setFont(font);
        nodeFigure.setOpened(isOpened);
        nodeFigure.setActive(isActive);
    }

    protected IFigure createFigure() {
        NodeFigure nodeFigure = new NodeFigure();
        NodeElement nodeElement = this.getNodeElement();
        IItemHandle itemHandle = nodeElement.getItemHandle();
        ILinksViewerLabelProvider labelProvider = (ILinksViewerLabelProvider)this.fLinksViewer.getLabelProvider();
        if (itemHandle != null) {
            this.initFigureData(nodeFigure, labelProvider.getImage(itemHandle), labelProvider.getText(itemHandle), labelProvider.getFont(itemHandle), this.fIsOpened, this.fIsActive);
        } else {
            this.initFigureData(nodeFigure, Activator.getImage("icons/obj16/Requirement.gif"), this.getNodeElement().getLabel(), labelProvider.getFont(itemHandle), false, false);
        }
        return nodeFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new NodeSelectionEditPolicy());
    }

    protected List getModelChildren() {
        return ((NodeElement)this.getModel()).getChildren();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getSourceConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getSourceConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getTargetConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getTargetConnectionAnchor();
    }

    protected List getModelSourceConnections() {
        return this.getNodeElement().getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return this.getNodeElement().getTargetConnections();
    }

    protected void refreshVisuals() {
    }

    public void performRequest(Request request) {
        ILinksViewerActionProvider actionProvider;
        if (request.getType() == "open" && (actionProvider = this.fLinksViewer.getLinksViewerActionProvider()) != null) {
            actionProvider.openItem(this.getNodeElement().getItemHandle());
        }
    }

    public void setOpened(boolean value) {
        this.fIsOpened = value;
        NodeFigure nodeFigure = (NodeFigure)this.getFigure();
        if (nodeFigure != null) {
            nodeFigure.setOpened(value);
        }
    }

    public boolean isOpened() {
        return this.fIsOpened;
    }

    public void setActive(boolean value) {
        this.fIsActive = value;
        NodeFigure nodeFigure = (NodeFigure)this.getFigure();
        if (nodeFigure != null) {
            nodeFigure.setActive(value);
        }
    }

    public boolean isActive() {
        return this.fIsActive;
    }
}

