/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.rcp.ui.internal.gef.controller;

import com.ibm.team.links.rcp.ui.ILinksViewerContentProvider;
import com.ibm.team.links.rcp.ui.internal.gef.controller.ConnectionSelectionEditPolicy;
import com.ibm.team.links.rcp.ui.internal.gef.view.ConnectionFigure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;

class ConnectionPart
extends AbstractConnectionEditPart {
    private ILinksViewerContentProvider.LinkType fLinkType;

    public ConnectionPart(ILinksViewerContentProvider.LinkType linkType) {
        this.fLinkType = linkType;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        ConnectionFigure connectionFigure = this.fLinkType != null ? new ConnectionFigure(this.fLinkType.getColor()) : new ConnectionFigure();
        return connectionFigure;
    }

    public void contributeToGraph(DirectedGraph graph, Map map) {
        Node source = (Node)map.get(this.getSource());
        Node target = (Node)map.get(this.getTarget());
        Edge edge = new Edge((Object)this, source, target);
        edge.weight = 2;
        graph.edges.add((Object)edge);
        map.put(this, edge);
    }

    protected void applyGraphResults(DirectedGraph graph, Map map) {
        Edge edge = (Edge)map.get((Object)this);
        NodeList nodes = edge.vNodes;
        ConnectionFigure conn = (ConnectionFigure)this.getConnectionFigure();
        conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int index = 0;
            while (index < nodes.size()) {
                Node vn = nodes.getNode(index);
                int x = vn.x;
                int y = vn.y;
                if (edge.isFeedback()) {
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    bends.add(new AbsoluteBendpoint(x, y));
                } else {
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                }
                ++index;
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint(Collections.EMPTY_LIST);
        }
    }
}

