/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.editor;

import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormColors;
import com.ibm.team.ui.editor.TeamFormLayouts;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TeamFormToolkit
extends FormToolkit {
    public TeamFormToolkit(Display display) {
        this(new TeamFormColors(display));
    }

    public TeamFormToolkit(FormColors colors) {
        super(colors);
    }

    public Label createLabel(Composite parent, String text, int style) {
        Label label = super.createLabel(parent, text, style);
        Color labelForeground = this.getColors().getColor("com.ibm.team.workitem.ide.ui.internal.editor.LABEL_FOREGROUND");
        if (labelForeground != null) {
            label.setForeground(labelForeground);
        }
        return label;
    }

    public Text createText(Composite parent, String value, int style) {
        Text text = super.createText(parent, value, style);
        text.setFont(parent.getFont());
        return text;
    }

    public void adapt(Control control, boolean trackFocus, boolean trackKeyboard) {
        super.adapt(control, trackFocus, trackKeyboard);
        if (control instanceof Combo) {
            ((Combo)control).setVisibleItemCount(15);
        }
        if (TeamFormLayouts.getLayoutData(control) == null) {
            if (control instanceof Label) {
                Label label = (Label)control;
                TeamFormLayouts.setLayoutData((Control)label, ITeamFormData.LABEL);
            } else if (control instanceof Button) {
                Button button = (Button)control;
                int style = button.getStyle();
                if ((style & 8) != 0) {
                    TeamFormLayouts.setLayoutData((Control)button, ITeamFormData.BUTTON);
                } else if ((style & 0x10) != 0) {
                    TeamFormLayouts.setLayoutData((Control)button, ITeamFormData.RADIO);
                } else if ((style & 0x20) != 0) {
                    TeamFormLayouts.setLayoutData((Control)button, ITeamFormData.CHECKBOX);
                }
            } else if (control instanceof Combo) {
                Combo combo = (Combo)control;
                int style = combo.getStyle();
                if ((style & 8) != 0) {
                    TeamFormLayouts.setLayoutData((Control)combo, ITeamFormData.READ_ONLY_COMBO);
                } else {
                    TeamFormLayouts.setLayoutData((Control)combo, ITeamFormData.COMBO);
                }
            }
        }
    }
}

