/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TeamFormSelectionProvider
implements IPostSelectionProvider {
    private ListenerList fListeners = new ListenerList();
    private ListenerList fPostListeners = new ListenerList();
    private Map fProvidersToControls = new HashMap();
    private ISelectionProvider fActiveProvider = null;
    private InternalControlListener fControlListener = new InternalControlListener();
    private ISelectionChangedListener fSelectionListener = new InternalSelectionListener();
    private ISelectionChangedListener fPostSelectionListener = new InternalPostSelectionListener();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        block3: {
            ISelectionProvider provider = this.fActiveProvider;
            if (provider != null) {
                try {
                    return provider.getSelection();
                }
                catch (SWTException x) {
                    if (x.code == 24) break block3;
                    throw x;
                }
            }
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider provider = this.fActiveProvider;
        if (provider != null) {
            provider.setSelection(selection);
        }
    }

    public void registerSelectionProvider(ISelectionProvider provider, Control control) {
        this.fProvidersToControls.put(control, provider);
        this.fControlListener.install(control);
    }

    public void unregisterSelectionProvider(ISelectionProvider provider) {
        Control control = this.findControl(provider);
        if (control != null) {
            this.removeSelectionProvider(control);
        }
    }

    private void removeSelectionProvider(Control control) {
        this.fControlListener.uninstall(control);
        if (this.fActiveProvider != null) {
            this.uninstall(this.fActiveProvider);
        }
        this.fProvidersToControls.remove(control);
    }

    private Control findControl(ISelectionProvider provider) {
        for (Map.Entry entry : this.fProvidersToControls.entrySet()) {
            if (entry.getValue() != provider) continue;
            return (Control)entry.getKey();
        }
        return null;
    }

    private void handleActivated(Control control) {
        if (this.fActiveProvider != null) {
            this.uninstall(this.fActiveProvider);
        }
        this.fActiveProvider = (ISelectionProvider)this.fProvidersToControls.get(control);
        if (this.fActiveProvider != null) {
            this.install(this.fActiveProvider);
            SelectionChangedEvent event = new SelectionChangedEvent(this.fActiveProvider, this.fActiveProvider.getSelection());
            this.fireSelectionChanged(this.fListeners, event);
            this.fireSelectionChanged(this.fPostListeners, event);
        }
    }

    private void uninstall(ISelectionProvider selectionProvider) {
        selectionProvider.removeSelectionChangedListener(this.fSelectionListener);
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.fPostSelectionListener);
        }
    }

    private void install(ISelectionProvider selectionProvider) {
        selectionProvider.addSelectionChangedListener(this.fSelectionListener);
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.fPostSelectionListener);
        }
    }

    private void fireSelectionChanged(ListenerList listenerList, SelectionChangedEvent event) {
        Object[] listeners = listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    private class InternalControlListener
    implements DisposeListener,
    Listener {
        private InternalControlListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 26) {
                TeamFormSelectionProvider.this.handleActivated((Control)event.widget);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            TeamFormSelectionProvider.this.removeSelectionProvider((Control)e.widget);
        }

        public void install(Control control) {
            control.addDisposeListener((DisposeListener)this);
            control.addListener(26, (Listener)this);
        }

        public void uninstall(Control control) {
            if (control.isDisposed()) {
                return;
            }
            control.removeListener(26, (Listener)this);
            control.removeDisposeListener((DisposeListener)this);
        }
    }

    private class InternalPostSelectionListener
    implements ISelectionChangedListener {
        private InternalPostSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == TeamFormSelectionProvider.this.fActiveProvider) {
                TeamFormSelectionProvider.this.fireSelectionChanged(TeamFormSelectionProvider.this.fPostListeners, event);
            }
        }
    }

    private class InternalSelectionListener
    implements ISelectionChangedListener {
        private InternalSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == TeamFormSelectionProvider.this.fActiveProvider) {
                TeamFormSelectionProvider.this.fireSelectionChanged(TeamFormSelectionProvider.this.fListeners, event);
                if (!(TeamFormSelectionProvider.this.fActiveProvider instanceof IPostSelectionProvider)) {
                    TeamFormSelectionProvider.this.fireSelectionChanged(TeamFormSelectionProvider.this.fPostListeners, event);
                }
            }
        }
    }
}

