/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import java.text.Collator;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ItemViewerFilter
implements Comparable {
    public static final int GROUP_DISPLAY = 0;
    public static final int GROUP_HIDE = 1;
    public static final int GROUP_SCOPE = 2;
    public static final String FILTER_PROPERTY = "filter";
    private String fId;
    private String fName;
    private ViewerFilter fViewerFilter;
    private int fGroup;
    private int fSortOrder;
    private boolean fIsEnabledByDefault = false;
    private final Collator fCollator = Collator.getInstance();

    public ItemViewerFilter(ViewerFilter filter, String id, String name, int type) {
        this(filter, id, name, type, -1);
    }

    public ItemViewerFilter(ViewerFilter filter, String id, String name, int type, int sortOrder) {
        this.fViewerFilter = filter != null ? new WrappingFilter(filter) : null;
        this.fId = id;
        this.fName = name;
        this.fGroup = type;
        this.fSortOrder = sortOrder;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public ViewerFilter getViewerFilter() {
        return this.fViewerFilter;
    }

    public int getGroup() {
        return this.fGroup;
    }

    public boolean isEnabledByDefault() {
        return this.fIsEnabledByDefault;
    }

    public void setEnabledByDefault(boolean isEnabledByDefault) {
        this.fIsEnabledByDefault = isEnabledByDefault;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof ItemViewerFilter) {
            ItemViewerFilter other = (ItemViewerFilter)arg0;
            if (this.fSortOrder != -1 && other.fSortOrder != -1) {
                return this.fSortOrder < other.fSortOrder ? -1 : 1;
            }
            int res = this.fCollator.compare(this.fName, other.fName);
            if (res != 0) {
                return res;
            }
            return this.fCollator.compare(this.fId, other.fId);
        }
        return -1;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemViewerFilter other = (ItemViewerFilter)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }

    private static class WrappingFilter
    extends ViewerFilter {
        private ViewerFilter fWrapped;

        public WrappingFilter(ViewerFilter wrapped) {
            this.fWrapped = wrapped;
        }

        public boolean isFilterProperty(Object element, String property) {
            return ItemViewerFilter.FILTER_PROPERTY.equals(property);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.fWrapped.select(viewer, parentElement, element);
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            return this.fWrapped.filter(viewer, parent, elements);
        }

        public Object[] filter(Viewer viewer, TreePath parentPath, Object[] elements) {
            return this.fWrapped.filter(viewer, parentPath, elements);
        }

        public boolean equals(Object obj) {
            if (obj instanceof WrappingFilter) {
                return this.fWrapped.equals(((WrappingFilter)((Object)obj)).fWrapped);
            }
            return this.fWrapped.equals(obj);
        }

        public int hashCode() {
            return this.fWrapped.hashCode();
        }
    }
}

