/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.dashboard.ISection;
import com.ibm.team.jface.internal.dashboard.views.Messages;
import com.ibm.team.jface.internal.dashboard.views.MultiTrackingSelectionProvider;
import com.ibm.team.jface.internal.dashboard.views.Perspective;
import com.ibm.team.jface.internal.dashboard.views.PerspectiveSectionSlot;
import com.ibm.team.jface.internal.dashboard.views.PerspectivesManager;
import com.ibm.team.jface.internal.dashboard.views.SectionDescriptor;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralLayout;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionsManager {
    private static final String PREF_LAST_SELECTED_SECTION = "lastSelectedSection";
    private SectionPart fLastSelectedSection;
    private IMemento fMemento;
    private MultiTrackingSelectionProvider fMultiTracker;
    private Composite fParent;
    private PerspectivesManager fPerspectivesManager;
    private ArrayList<SectionPart> fRememberExpandedSections = new ArrayList();
    private HashSet<SectionDescriptor> fSectionDescriptors;
    private TeamCentralView fTeamCentralView;
    private SectionPart fMaximizedForSection;
    private IContextActivation fLastContextActivation;

    public SectionsManager(TeamCentralView teamCentralView, PerspectivesManager perspectivesManager, MultiTrackingSelectionProvider multiTracker, IMemento memento, Composite parent, String viewId) {
        this.fTeamCentralView = teamCentralView;
        this.fPerspectivesManager = perspectivesManager;
        this.fMultiTracker = multiTracker;
        this.fMemento = memento;
        this.fParent = parent;
        this.fSectionDescriptors = new HashSet();
        this.loadSectionsFromRegistry(viewId);
        this.loadSectionsFromMemento();
    }

    SectionPart addSection(PerspectiveSectionSlot sectionContainer, SectionDescriptor sectionDescriptor, boolean order, boolean isFocus, boolean layout) {
        SectionPart expSection = this.getSection(sectionDescriptor.getId());
        if (expSection != null) {
            expSection.setSectionHeight(sectionContainer.getHeight());
            if (expSection.isExpanded() != sectionContainer.isExpanded()) {
                expSection.setSectionExpanded(sectionContainer.isExpanded(), false, false);
            }
            if (expSection.isGrabExcessVerticalSpace() != sectionContainer.isGrabExcessVerticalSpace()) {
                expSection.setGrabExcessVerticalSpace(sectionContainer.isGrabExcessVerticalSpace(), false);
            }
            expSection.setVisible(true);
        } else {
            expSection = new SectionPart(this.fTeamCentralView, this.fParent, this.fMultiTracker, sectionDescriptor, 0);
        }
        if (!expSection.isErrorLoading()) {
            sectionDescriptor.setSavedUserSettings(null);
        }
        if (isFocus) {
            expSection.setFocus();
        }
        if (order) {
            expSection.moveBelow(null);
            SectionPart moveAboveThisSection = null;
            SectionPart[] visibleSections = TeamCentralLayout.getVisibleSections(this.fParent);
            int a = visibleSections.length - 2;
            while (a >= 0) {
                SectionPart aboveSection = visibleSections[a];
                PerspectiveSectionSlot aboveContainer = this.fPerspectivesManager.getSectionSlot(aboveSection.getId());
                if (aboveContainer.getPriority() < sectionContainer.getPriority()) {
                    moveAboveThisSection = aboveSection;
                }
                --a;
            }
            if (moveAboveThisSection != null) {
                expSection.moveAbove((Control)moveAboveThisSection);
            }
        }
        if (layout) {
            this.fParent.layout();
        }
        return expSection;
    }

    void createSections() {
        if (this.fPerspectivesManager.getCurrentPerspective() == null) {
            this.fPerspectivesManager.setCurrentPerspective(this.fPerspectivesManager.getDefaultPerspective());
        }
        this.switchToPerspective(this.fPerspectivesManager.getCurrentPerspective(), false);
        if (this.fMemento != null && this.fMemento.getString(PREF_LAST_SELECTED_SECTION) != null) {
            String lastSelectedSectionId = this.fMemento.getString(PREF_LAST_SELECTED_SECTION);
            SectionPart[] visibleSections = TeamCentralLayout.getVisibleSections(this.fParent);
            int a = 0;
            while (a < visibleSections.length) {
                if (visibleSections[a].getId().equals(lastSelectedSectionId)) {
                    this.setLastSelectedSection(visibleSections[a]);
                    break;
                }
                ++a;
            }
        }
    }

    public SectionPart getLastSelectedSection() {
        return this.fLastSelectedSection;
    }

    public SectionPart getSection(String sectionId) {
        Control[] sections = this.fParent.getChildren();
        int i = 0;
        while (i < sections.length) {
            if (((SectionPart)sections[i]).getId().equals(sectionId)) {
                return (SectionPart)sections[i];
            }
            ++i;
        }
        return null;
    }

    Action[] getSectionActions(boolean templates) {
        int lowestPriority = -1;
        ArrayList allSlots = this.fPerspectivesManager.getCurrentPerspective().getAllContainedSectionSlots();
        for (PerspectiveSectionSlot slot : allSlots) {
            if (slot.getPriority() >= lowestPriority) continue;
            lowestPriority = slot.getPriority() - 1;
        }
        ArrayList<SortedSection> sortedSections = new ArrayList<SortedSection>();
        int i = 0;
        for (SectionDescriptor secDesc : this.fSectionDescriptors) {
            if (secDesc.isTemplate() == templates) {
                PerspectiveSectionSlot slot = this.fPerspectivesManager.getSectionSlot(secDesc.getId(), true);
                if (slot == null) {
                    sortedSections.add(new SortedSection(slot, secDesc, --lowestPriority));
                } else {
                    sortedSections.add(new SortedSection(slot, secDesc, slot.getPriority()));
                }
            }
            ++i;
        }
        TreeSet<SortedSection> sortSet = new TreeSet<SortedSection>(new Comparator<SortedSection>(){

            @Override
            public int compare(SortedSection o1, SortedSection o2) {
                int prio2;
                SortedSection s1 = o1;
                SortedSection s2 = o2;
                int prio1 = s1.getPriority();
                return prio1 > (prio2 = s2.getPriority()) ? -1 : 1;
            }
        });
        sortSet.addAll(sortedSections);
        int nTemplates = 0;
        for (SortedSection sortedSection : sortSet) {
            if (!sortedSection.getSectionDescriptor().isTemplate()) break;
            ++nTemplates;
            ++i;
        }
        Action[] actions = new Action[sortSet.size()];
        i = 0;
        for (final SortedSection sortedSection : sortSet) {
            final SectionDescriptor element = sortedSection.getSectionDescriptor();
            actions[i] = new Action(){

                public void run() {
                    if (sortedSection.getSectionDescriptor().isTemplate()) {
                        SectionsManager.this.cloneSection(sortedSection.getSectionDescriptor().getId(), sortedSection.getSectionDescriptor().getName());
                    } else if (this.isChecked()) {
                        PerspectiveSectionSlot sectionSlot = sortedSection.getSectionSlot() != null ? sortedSection.getSectionSlot() : new PerspectiveSectionSlot(element.getId());
                        sectionSlot.setPriority(sortedSection.getPriority());
                        SectionsManager.this.fPerspectivesManager.getCurrentPerspective().addSection(sectionSlot);
                        SectionsManager.this.addSection(sectionSlot, element, true, true, true);
                    } else if (TeamCentralLayout.getVisibleSections(SectionsManager.this.fParent).length > 1) {
                        SectionsManager.this.removeSection(element, true, false);
                    } else {
                        MessageDialog.openInformation((Shell)SectionsManager.this.fParent.getShell(), (String)Messages.SectionsManager_HIDE_SECTION, (String)Messages.SectionsManager_UNABLE_HIDE_LAST_SECTION);
                    }
                }
            };
            if (sortedSection.getSectionDescriptor().isTemplate()) {
                actions[i].setText(element.getName());
            } else {
                actions[i].setText(element.getName());
                actions[i].setChecked(this.isSectionVisible(element.getId()));
            }
            if (element.getSectionIconPath() != null && element.getNamespace() != null) {
                actions[i].setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespace(), (String)element.getSectionIconPath()));
            }
            ++i;
        }
        return actions;
    }

    SectionDescriptor getSectionDescriptor(String id) {
        for (SectionDescriptor section : this.fSectionDescriptors) {
            if (!section.getId().equals(id)) continue;
            return section;
        }
        return null;
    }

    Menu getSectionMenu(final Control parent, final SectionPart section) {
        Menu menu = new Menu(parent);
        if (section.isOpenable()) {
            MenuItem openView = new MenuItem(menu, 8);
            openView.setText(NLS.bind((String)Messages.SectionsManager_OPEN_SECTION, (Object)section.getSectionSite().getName()));
            openView.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    section.getSectionSite().fireOpen();
                }
            });
            new MenuItem(menu, 2);
        }
        MenuItem renameSection = new MenuItem(menu, 8);
        renameSection.setText(Messages.SectionsManager_RENAME_SECTION);
        renameSection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.SectionsManager_RENAME_SECTION, Messages.SectionsManager_ENTER_NAME_SECTION, section.getSectionSite().getName(), new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.trim().length() == 0) {
                            return Messages.SectionsManager_INVALID_NAME;
                        }
                        return null;
                    }
                });
                if (inputDialog.open() == 0) {
                    section.getSectionSite().setName(inputDialog.getValue());
                }
            }
        });
        if (section.isCloneable()) {
            MenuItem cloneSection = new MenuItem(menu, 8);
            cloneSection.setText(Messages.SectionsManager_DUPLICATE_SECTION);
            cloneSection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (section.isErrorLoading()) {
                        ErrorDialog.openError((Shell)parent.getShell(), (String)Messages.SectionsManager_ERROR_DUPLICATE_SECTION, (String)Messages.SectionsManager_UNABLE_DUPLICATE_SECTION, (IStatus)new Status(4, "com.ibm.team.jface", -1, Messages.SectionsManager_ERROR_LOADING_SECTION, null));
                        return;
                    }
                    InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.SectionsManager_DUPLICATE_SECTION, Messages.SectionsManager_ENTER_NAME_NEW_SECTION, NLS.bind((String)Messages.SectionsManager_COPY_OF_SECTION, (Object)section.getSectionSite().getName()), new IInputValidator(){

                        public String isValid(String newText) {
                            if (newText.trim().length() == 0) {
                                return Messages.SectionsManager_INVALID_NAME;
                            }
                            return null;
                        }
                    });
                    if (inputDialog.open() == 0) {
                        SectionsManager.this.cloneSection(section.getSectionDescriptor().getId(), inputDialog.getValue());
                    }
                }
            });
        }
        new MenuItem(menu, 2);
        if (section.isDeletable() || section.isErrorLoading()) {
            MenuItem deleteSection = new MenuItem(menu, 8);
            deleteSection.setText(Messages.SectionsManager_DELETE_SECTION);
            deleteSection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (TeamCentralLayout.getVisibleSections(SectionsManager.this.fParent).length == 1) {
                        MessageDialog.openInformation((Shell)SectionsManager.this.fParent.getShell(), (String)Messages.SectionsManager_DELETE_SECTION, (String)Messages.SectionsManager_UNABLE_DELETE_LAST_SECTION);
                        return;
                    }
                    boolean confirmed = MessageDialog.openQuestion((Shell)SectionsManager.this.fParent.getShell(), (String)Messages.SectionsManager_DELETE_SECTION, (String)NLS.bind((String)Messages.SectionsManager_CONFIRM_DELETE_SECTION, (Object)section.getSectionDescriptor().getName()));
                    if (confirmed) {
                        SectionsManager.this.removeSection(section.getSectionDescriptor(), true, true);
                    }
                }
            });
        }
        MenuItem hideSection = new MenuItem(menu, 8);
        hideSection.setText(Messages.SectionsManager_HIDE_SECTION);
        hideSection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TeamCentralLayout.getVisibleSections(SectionsManager.this.fParent).length > 1) {
                    SectionsManager.this.removeSection(section.getSectionDescriptor(), true, false);
                } else {
                    MessageDialog.openInformation((Shell)SectionsManager.this.fParent.getShell(), (String)Messages.SectionsManager_HIDE_SECTION, (String)Messages.SectionsManager_UNABLE_HIDE_LAST_SECTION);
                }
            }
        });
        return menu;
    }

    public ISection cloneSection(String sectionId, String name) {
        PerspectiveSectionSlot selectedSectionContainer = this.fPerspectivesManager.getSectionSlot(sectionId);
        String cloneId = this.createSectionId(sectionId);
        SectionDescriptor clonedSection = SectionDescriptor.cloneFrom(this.getSectionDescriptor(sectionId), cloneId, name);
        clonedSection.setDeletable(true);
        Perspective perspective = this.fPerspectivesManager.getCurrentPerspective();
        PerspectiveSectionSlot clonedContainer = PerspectiveSectionSlot.cloneFrom(selectedSectionContainer, this.getSectionDescriptor(sectionId), perspective, clonedSection.getId());
        this.fSectionDescriptors.add(clonedSection);
        perspective.addSection(clonedContainer);
        SectionPart part = this.addSection(clonedContainer, clonedSection, true, true, true);
        return part.getSectionImpl();
    }

    public String createSectionId(String sourceId) {
        int i = 1;
        String id;
        while (this.getSectionDescriptor(id = String.valueOf(sourceId) + "#" + i) != null) {
            ++i;
        }
        return id;
    }

    private boolean isSectionVisible(String id) {
        SectionPart section = this.getSection(id);
        return section != null && section.getVisible();
    }

    private void loadSectionsFromMemento() {
        SectionDescriptor[] sections = SectionDescriptor.createSections(this.fMemento);
        int i = 0;
        while (i < sections.length) {
            SectionDescriptor section = sections[i];
            if (this.fSectionDescriptors.contains(section)) {
                this.fSectionDescriptors.remove(section);
            }
            this.fSectionDescriptors.add(section);
            ++i;
        }
    }

    private void loadSectionsFromRegistry(String viewId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.jface.expandableSection");
        IExtension[] extensions = extensionPoint.getExtensions();
        int a = 0;
        while (a < extensions.length) {
            IConfigurationElement[] elements = extensions[a].getConfigurationElements();
            int b = 0;
            while (b < elements.length) {
                String requiredInstance = elements[b].getAttribute("requiredInstance");
                if (requiredInstance == null || requiredInstance.equals(viewId)) {
                    this.fSectionDescriptors.add(SectionDescriptor.createFrom(elements[b]));
                }
                ++b;
            }
            ++a;
        }
    }

    void maximizeSection(SectionPart section) {
        int oldSectionHeight = section.getSectionHeight();
        SectionPart[] visibleSections = TeamCentralLayout.getVisibleSections(this.fParent);
        int countExpandedSections = 0;
        int a = 0;
        while (a < visibleSections.length) {
            if (visibleSections[a].isExpanded()) {
                ++countExpandedSections;
            }
            ++a;
        }
        if (this.fMaximizedForSection == section && section.isExpanded() && countExpandedSections == 1) {
            int i = 0;
            while (i < this.fRememberExpandedSections.size()) {
                this.fRememberExpandedSections.get(i).setSectionExpanded(true, false, false);
                ++i;
            }
            this.fTeamCentralView.layoutAnimated();
            return;
        }
        this.fRememberExpandedSections.clear();
        this.fMaximizedForSection = section;
        if (!section.isExpanded()) {
            section.setSectionExpanded(true, false, false);
        }
        boolean fillCache = this.fRememberExpandedSections.size() == 0;
        int i = 0;
        while (i < visibleSections.length) {
            SectionPart sectionToCollapse = visibleSections[i];
            if (!sectionToCollapse.getId().equals(section.getId()) && sectionToCollapse.isExpanded()) {
                if (fillCache) {
                    this.fRememberExpandedSections.add(sectionToCollapse);
                }
                sectionToCollapse.setSectionExpanded(false, false, false);
            }
            ++i;
        }
        this.setLastSelectedSection(section);
        this.fTeamCentralView.layoutAnimated();
        section.setSectionHeight(oldSectionHeight);
    }

    void moveSection(SectionPart sectionFrom, SectionPart sectionTo) {
        if (sectionFrom == null || sectionTo == null) {
            return;
        }
        PerspectiveSectionSlot secContainerFrom = this.fPerspectivesManager.getSectionSlot(sectionFrom.getId());
        PerspectiveSectionSlot secContainerTo = this.fPerspectivesManager.getSectionSlot(sectionTo.getId());
        int sectionFromIndex = -1;
        int sectionToIndex = -1;
        SectionPart[] sections = TeamCentralLayout.getVisibleSections(this.fParent);
        int i = 0;
        while (i < sections.length) {
            SectionPart section = sections[i];
            if (section == sectionFrom) {
                sectionFromIndex = i;
            } else if (section == sectionTo) {
                sectionToIndex = i;
            }
            ++i;
        }
        if (sectionFromIndex == -1 || sectionToIndex == -1 || sectionFromIndex == sectionToIndex) {
            return;
        }
        int dif = Math.max(sectionToIndex, sectionFromIndex) - Math.min(sectionToIndex, sectionFromIndex);
        if (sectionFromIndex < sectionToIndex) {
            int a = 0;
            while (a < dif) {
                sectionFrom.moveBelow((Control)sections[sectionFromIndex + a + 1]);
                ++a;
            }
            secContainerFrom.setPriority(secContainerTo.getPriority() - 1);
        } else {
            int a = 0;
            while (a < dif) {
                sectionFrom.moveAbove((Control)sections[sectionFromIndex - a - 1]);
                ++a;
            }
            secContainerFrom.setPriority(secContainerTo.getPriority() + 1);
        }
        this.fTeamCentralView.layoutAnimated();
    }

    public void removeSection(SectionDescriptor section, boolean layout, boolean delete) {
        String id = section.getId();
        SectionPart sectionPartToRemove = null;
        SectionPart[] visibleSections = TeamCentralLayout.getVisibleSections(this.fParent);
        int a = 0;
        while (a < visibleSections.length) {
            if (id.equals(visibleSections[a].getId())) {
                sectionPartToRemove = visibleSections[a];
                break;
            }
            ++a;
        }
        if (sectionPartToRemove != null) {
            sectionPartToRemove.setVisible(false);
        }
        this.fPerspectivesManager.getCurrentPerspective().removeSection(section.getId(), delete);
        if (delete) {
            this.fSectionDescriptors.remove(section);
            if (sectionPartToRemove != null) {
                this.fRememberExpandedSections.remove((Object)sectionPartToRemove);
                if (this.fLastSelectedSection == sectionPartToRemove) {
                    this.fLastSelectedSection = null;
                }
                if (this.fMaximizedForSection == sectionPartToRemove) {
                    this.fMaximizedForSection = null;
                }
                sectionPartToRemove.dispose();
            }
            section.setDeleted();
        }
        this.fMultiTracker.clearActiveSelectionProvider();
        if (layout) {
            this.fTeamCentralView.layoutAnimated();
            this.fParent.redraw();
        }
    }

    void saveState(IMemento memento) {
        if (this.getLastSelectedSection() != null) {
            memento.putString(PREF_LAST_SELECTED_SECTION, this.getLastSelectedSection().getId());
        }
        Control[] sections = this.fParent.getChildren();
        int i = 0;
        while (i < sections.length) {
            SectionPart section = (SectionPart)sections[i];
            SectionDescriptor sectionDesc = section.getSectionDescriptor();
            sectionDesc.save(memento);
            ++i;
        }
        for (SectionDescriptor sectionDesc : this.fSectionDescriptors) {
            String id = sectionDesc.getId();
            if (this.getSection(id) != null || sectionDesc.isTemplate()) continue;
            sectionDesc.save(memento);
        }
    }

    public void setLastSelectedSection(SectionPart lastSelectedSection) {
        this.fLastSelectedSection = lastSelectedSection;
        if (lastSelectedSection != null) {
            this.updateContext(lastSelectedSection);
        }
    }

    public void updateContext(SectionPart section) {
        SectionPart.SectionSite sectionSite = section.getSectionSite();
        IViewSite viewSite = sectionSite.getViewSite();
        String newContext = sectionSite.getContext();
        IContextService contextService = (IContextService)viewSite.getService(IContextService.class);
        if (this.fLastContextActivation != null) {
            contextService.deactivateContext(this.fLastContextActivation);
            this.fLastContextActivation = null;
        }
        if (newContext != null) {
            this.fLastContextActivation = contextService.activateContext(newContext);
        }
    }

    void switchToPerspective(Perspective perspective, boolean layout) {
        this.fPerspectivesManager.setCurrentPerspective(perspective);
        SectionPart[] visibleSections = TeamCentralLayout.getVisibleSections(this.fParent);
        int i = 0;
        while (i < visibleSections.length) {
            SectionPart expSection = visibleSections[i];
            if (!perspective.containsSection(expSection.getId())) {
                this.removeSection(expSection.getSectionDescriptor(), false, false);
            }
            ++i;
        }
        ArrayList perspectiveSectionContainers = perspective.getSectionSlots();
        for (PerspectiveSectionSlot sectionContainer : perspectiveSectionContainers) {
            SectionDescriptor secDesc = this.getSectionDescriptor(sectionContainer.getSectionId());
            if (secDesc == null) continue;
            this.addSection(sectionContainer, secDesc, true, false, false);
        }
        if (layout) {
            this.fParent.layout();
        }
    }

    public Collection<SectionDescriptor> getSectionDescriptors() {
        return this.fSectionDescriptors;
    }

    public PerspectivesManager getPerspectivesManager() {
        return this.fPerspectivesManager;
    }

    private static class SortedSection {
        private int fPriority;
        private SectionDescriptor fSectionDescriptor;
        private PerspectiveSectionSlot fSlot;

        private SortedSection(PerspectiveSectionSlot slot, SectionDescriptor sectionDescriptor, int priority) {
            this.fSlot = slot;
            this.fSectionDescriptor = sectionDescriptor;
            this.fPriority = priority;
        }

        int getPriority() {
            return this.fPriority;
        }

        SectionDescriptor getSectionDescriptor() {
            return this.fSectionDescriptor;
        }

        PerspectiveSectionSlot getSectionSlot() {
            return this.fSlot;
        }
    }
}

