/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.Perspective;
import com.ibm.team.jface.internal.dashboard.views.PerspectiveSectionSlot;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMemento;

public class PerspectivesManager {
    static final String DEAULT_PERSPECTIVE_ID = "com.ibm.magnolia.dashboard.defaultPerspective";
    static final String EXTENSION_POINT_ID = "com.ibm.team.jface.sectionPerspective";
    static final String SECTION_REQUIRED_INSTANCE = "requiredInstance";
    private static final String PREF_LAST_SELECTED_PERSPECTIVE = "lastSelectedPerspective";
    private Perspective fCurrentPerspective;
    private Perspective fDefaultPerspective;
    private ArrayList<Perspective> fPerspectives = new ArrayList();

    PerspectivesManager(IMemento memento, String viewId) {
        this.init(memento, viewId);
        for (Perspective perspective : this.fPerspectives) {
            if (!perspective.isDefault()) continue;
            this.fDefaultPerspective = perspective;
            break;
        }
        if (memento != null) {
            this.fCurrentPerspective = this.getPerspective(memento.getString(PREF_LAST_SELECTED_PERSPECTIVE));
        }
    }

    void addPerspective(Perspective perspective) {
        this.fPerspectives.add(perspective);
    }

    public Perspective getCurrentPerspective() {
        return this.fCurrentPerspective;
    }

    int getCurrentVisibleSectionsCount() {
        return this.fCurrentPerspective.getSectionSlots().size();
    }

    Perspective getDefaultPerspective() {
        return this.fDefaultPerspective;
    }

    Perspective getPerspective(String id) {
        for (Perspective perspective : this.fPerspectives) {
            if (!perspective.getId().equals(id)) continue;
            return perspective;
        }
        return null;
    }

    ArrayList getPerspectives() {
        return this.fPerspectives;
    }

    PerspectiveSectionSlot getSectionSlot(String sectionId) {
        return this.getSectionSlot(sectionId, false);
    }

    PerspectiveSectionSlot getSectionSlot(String sectionId, boolean searchVisibleAndHidden) {
        if (this.fCurrentPerspective != null) {
            ArrayList slots = searchVisibleAndHidden ? this.fCurrentPerspective.getAllContainedSectionSlots() : this.fCurrentPerspective.getSectionSlots();
            for (PerspectiveSectionSlot sectionContainer : slots) {
                if (!sectionContainer.getSectionId().equals(sectionId)) continue;
                return sectionContainer;
            }
        }
        return null;
    }

    private void init(IMemento memento, String viewId) {
        this.loadPerspectivesFromRegistry(viewId);
        this.loadPerspectivesFromMemento(memento);
    }

    private void loadPerspectivesFromMemento(IMemento memento) {
        Perspective[] perspectives = Perspective.createPerspectives(memento);
        int i = 0;
        while (i < perspectives.length) {
            Perspective perspective = perspectives[i];
            if (this.fPerspectives.contains(perspective)) {
                this.fPerspectives.remove(perspective);
            }
            this.fPerspectives.add(perspective);
            ++i;
        }
    }

    private void loadPerspectivesFromRegistry(String viewId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int a = 0;
            while (a < extensions.length) {
                IConfigurationElement[] elements = extensions[a].getConfigurationElements();
                int b = 0;
                while (b < elements.length) {
                    String requiredViewId = elements[b].getAttribute(SECTION_REQUIRED_INSTANCE);
                    if (requiredViewId == null) {
                        requiredViewId = "com.ibm.magnolia.TeamCentral";
                    }
                    if (requiredViewId == null || requiredViewId.equals(viewId)) {
                        Perspective perspective = Perspective.createFrom(elements[b]);
                        if (this.fPerspectives.contains(perspective)) {
                            int existingIndex = this.fPerspectives.indexOf(perspective);
                            Perspective existingPerspective = this.fPerspectives.get(existingIndex);
                            ArrayList sectionSlots = perspective.getAllContainedSectionSlots();
                            for (PerspectiveSectionSlot slot : sectionSlots) {
                                existingPerspective.addSection(slot);
                            }
                        } else {
                            this.fPerspectives.add(perspective);
                        }
                    }
                    ++b;
                }
                ++a;
            }
        }
    }

    void saveState(IMemento memento) {
        memento.putString(PREF_LAST_SELECTED_PERSPECTIVE, this.fCurrentPerspective.getId());
        for (Perspective perspective : this.fPerspectives) {
            perspective.save(memento);
        }
    }

    void setCurrentPerspective(Perspective lastSelectedPerspective) {
        this.fCurrentPerspective = lastSelectedPerspective;
    }
}

