/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.dashboard;

import com.ibm.team.jface.DoubleBufferPainter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SectionLabel
extends Canvas {
    private static int DRAW_FLAGS = 7;
    private static final String ELLIPSIS = "...";
    private static final int GAP = 2;
    private static final int INDENT = 0;
    private int align = 16384;
    private String appToolTipText;
    private Image backgroundImage;
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;
    private int hIndent = 0;
    private Image image;
    private String text;
    private int vIndent = 0;

    public SectionLabel(Composite parent, int style) {
        super(parent, SectionLabel.checkStyle(style | 0x40000));
        if ((style & 0x1020000) == 0) {
            style |= 0x4000;
        }
        if ((style & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((style & 0x4000) != 0) {
            this.align = 16384;
        }
        new DoubleBufferPainter(this){

            public void doPaint(PaintEvent e) {
                SectionLabel.this.onPaint(e);
            }
        };
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SectionLabel.this.onDispose();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 128) {
                    SectionLabel.this.onMnemonic(event);
                }
            }
        });
        this.initAccessible();
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.image, this.text);
        e.x = wHint == -1 ? (e.x += 2 * this.hIndent) : wHint;
        e.y = hHint == -1 ? (e.y += 2 * this.vIndent) : hHint;
        return e;
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
    }

    public Image getImage() {
        return this.image;
    }

    public int getStyle() {
        int style = super.getStyle();
        switch (this.align) {
            case 131072: {
                style |= 0x20000;
                break;
            }
            case 0x1000000: {
                style |= 0x1000000;
                break;
            }
            case 16384: {
                style |= 0x4000;
            }
        }
        return style;
    }

    private String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    private Point getTotalSize(Image image, String text) {
        Point size = new Point(0, 0);
        if (image != null) {
            Rectangle r = image.getBounds();
            size.x += r.width;
            size.y += r.height;
        }
        GC gc = new GC((Drawable)this);
        if (text != null && text.length() > 0) {
            Point e = gc.textExtent(text, DRAW_FLAGS);
            size.x += e.x;
            size.y = Math.max(size.y, e.y);
            if (image != null) {
                size.x += 2;
            }
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        gc.dispose();
        return size;
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = SectionLabel.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic = SectionLabel.this._findMnemonic(SectionLabel.this.text);
                if (mnemonic != '\u0000') {
                    e.result = "Alt+" + mnemonic;
                }
            }

            public void getName(AccessibleEvent e) {
                e.result = SectionLabel.this.getText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = SectionLabel.this.toControl(new Point(e.x, e.y));
                e.childID = SectionLabel.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = SectionLabel.this.getBounds();
                Point pt = SectionLabel.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = SectionLabel.this.getText();
            }
        });
    }

    void onDispose() {
        this.gradientColors = null;
        this.gradientPercents = null;
        this.backgroundImage = null;
        this.text = null;
        this.image = null;
        this.appToolTipText = null;
    }

    void onMnemonic(TraverseEvent event) {
        char mnemonic = this._findMnemonic(this.text);
        if (mnemonic == '\u0000') {
            return;
        }
        if (Character.toUpperCase(event.character) != Character.toUpperCase(mnemonic)) {
            return;
        }
        Composite control = this.getParent();
        while (control != null) {
            Control[] children = control.getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                event.doit = true;
                event.detail = 0;
            }
            control = control.getParent();
        }
    }

    void onPaint(PaintEvent event) {
        int i;
        String[] lines;
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        boolean shortenText = false;
        String t = this.text;
        Image img = this.image;
        int availableWidth = Math.max(0, rect.width - 2 * this.hIndent);
        Point extent = this.getTotalSize(img, t);
        if (extent.x > availableWidth) {
            img = null;
            extent = this.getTotalSize(img, t);
            if (extent.x > availableWidth) {
                shortenText = true;
            }
        }
        GC gc = event.gc;
        String[] stringArray = lines = this.text == null ? null : this.splitString(this.text);
        if (shortenText) {
            extent.x = 0;
            int i2 = 0;
            while (i2 < lines.length) {
                Point e = gc.textExtent(lines[i2], DRAW_FLAGS);
                if (e.x > availableWidth) {
                    lines[i2] = this.shortenText(gc, lines[i2], availableWidth);
                    extent.x = Math.max(extent.x, this.getTotalSize(null, (String)lines[i2]).x);
                } else {
                    extent.x = Math.max(extent.x, e.x);
                }
                ++i2;
            }
            if (this.appToolTipText == null) {
                super.setToolTipText(this.text);
            }
        } else {
            super.setToolTipText(this.appToolTipText);
        }
        int x = rect.x + this.hIndent;
        if (this.align == 0x1000000) {
            x = (rect.width - extent.x) / 2;
        }
        if (this.align == 131072) {
            x = rect.width - this.hIndent - extent.x;
        }
        try {
            if (this.backgroundImage != null) {
                Rectangle imageRect = this.backgroundImage.getBounds();
                int xPos = 0;
                while (xPos < rect.width) {
                    int yPos = 0;
                    while (yPos < rect.height) {
                        gc.drawImage(this.backgroundImage, xPos, yPos);
                        yPos += imageRect.height;
                    }
                    xPos += imageRect.width;
                }
            } else if (this.gradientColors != null) {
                Color oldBackground = gc.getBackground();
                if (this.gradientColors.length != 1) {
                    Color oldForeground = gc.getForeground();
                    Color lastColor = this.gradientColors[0];
                    if (lastColor == null) {
                        lastColor = oldBackground;
                    }
                    int pos = 0;
                    i = 0;
                    while (i < this.gradientPercents.length) {
                        gc.setForeground(lastColor);
                        lastColor = this.gradientColors[i + 1];
                        if (lastColor == null) {
                            lastColor = oldBackground;
                        }
                        if (this.gradientVertical) {
                            int gradientHeight = this.gradientPercents[i] * rect.height / 100 - pos;
                            pos += gradientHeight;
                        } else {
                            int gradientWidth = this.gradientPercents[i] * rect.width / 100 - pos;
                            pos += gradientWidth;
                        }
                        ++i;
                    }
                    if (this.gradientVertical) {
                        int cfr_ignored_0 = rect.height;
                    }
                    if (!this.gradientVertical) {
                        int cfr_ignored_1 = rect.width;
                    }
                    gc.setForeground(oldForeground);
                }
            } else {
                this.getStyle();
            }
        }
        catch (SWTException sWTException) {
            this.getStyle();
        }
        int style = this.getStyle();
        if ((style & 4) != 0 || (style & 8) != 0) {
            this.paintBorder(gc, rect);
        }
        if (lines != null) {
            int lineHeight = gc.getFontMetrics().getHeight();
            int textHeight = lines.length * lineHeight;
            int lineY = Math.max(this.vIndent, rect.y + (rect.height - textHeight) / 2);
            gc.setForeground(this.getForeground());
            i = 0;
            while (i < lines.length) {
                int lineX = x;
                if (lines.length > 1) {
                    int lineWidth;
                    if (this.align == 0x1000000) {
                        lineWidth = gc.textExtent((String)lines[i], (int)SectionLabel.DRAW_FLAGS).x;
                        lineX = x + Math.max(0, (extent.x - lineWidth) / 2);
                    }
                    if (this.align == 131072) {
                        lineWidth = gc.textExtent((String)lines[i], (int)SectionLabel.DRAW_FLAGS).x;
                        lineX = Math.max(x, rect.x + rect.width - this.hIndent - lineWidth);
                    }
                }
                gc.drawText(lines[i], lineX, lineY, DRAW_FLAGS);
                lineY += lineHeight;
                ++i;
            }
        }
        if (img != null) {
            Rectangle imageRect = img.getBounds();
            gc.drawImage(img, 0, 0, imageRect.width, imageRect.height, x += extent.x - imageRect.width, (rect.height - imageRect.height) / 2, imageRect.width, imageRect.height);
        }
    }

    private void paintBorder(GC gc, Rectangle r) {
        Display disp = this.getDisplay();
        Color c1 = null;
        Color c2 = null;
        int style = this.getStyle();
        if ((style & 4) != 0) {
            c1 = disp.getSystemColor(18);
            c2 = disp.getSystemColor(20);
        }
        if ((style & 8) != 0) {
            c1 = disp.getSystemColor(19);
            c2 = disp.getSystemColor(18);
        }
        if (c1 != null && c2 != null) {
            gc.setLineWidth(1);
            this.drawBevelRect(gc, r.x, r.y, r.width - 1, r.height - 1, c1, c2);
        }
    }

    public void setBackground(Color color) {
        Color background;
        super.setBackground(color);
        if (color != null && this.backgroundImage == null && this.gradientColors == null && this.gradientPercents == null && color.equals((Object)(background = this.getBackground()))) {
            return;
        }
        this.backgroundImage = null;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.redraw();
    }

    public void setBackground(Color[] colors, int[] percents) {
        this.setBackground(colors, percents, false);
    }

    public void setBackground(Color[] colors, int[] percents, boolean vertical) {
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error((int)5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
            int i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error((int)5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error((int)5);
                }
                ++i;
            }
        }
        Color background = this.getBackground();
        if (this.backgroundImage == null) {
            if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
                boolean same = false;
                int i = 0;
                while (i < this.gradientColors.length) {
                    boolean bl = same = this.gradientColors[i] == colors[i] || this.gradientColors[i] == null && colors[i] == background || this.gradientColors[i] == background && colors[i] == null;
                    if (!same) break;
                    ++i;
                }
                if (same) {
                    i = 0;
                    while (i < this.gradientPercents.length) {
                        boolean bl = same = this.gradientPercents[i] == percents[i];
                        if (!same) break;
                        ++i;
                    }
                }
                if (same && this.gradientVertical == vertical) {
                    return;
                }
            }
        } else {
            this.backgroundImage = null;
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colors.length];
            int i = 0;
            while (i < colors.length) {
                this.gradientColors[i] = colors[i] != null ? colors[i] : background;
                ++i;
            }
            this.gradientPercents = new int[percents.length];
            i = 0;
            while (i < percents.length) {
                this.gradientPercents[i] = percents[i];
                ++i;
            }
            this.gradientVertical = vertical;
        }
        this.redraw();
    }

    public void setBackground(Image image) {
        this.checkWidget();
        if (image == this.backgroundImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.backgroundImage = image;
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.image) {
            this.image = image;
            this.redraw();
        }
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.text)) {
            this.text = text;
            this.redraw();
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    protected String shortenText(GC gc, String t, int width) {
        int pivot;
        if (t == null) {
            return null;
        }
        int w = gc.textExtent((String)ELLIPSIS, (int)SectionLabel.DRAW_FLAGS).x;
        int l = t.length();
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = t.substring(0, s);
            String s2 = t.substring(e, l);
            int l1 = gc.textExtent((String)s1, (int)SectionLabel.DRAW_FLAGS).x;
            int l2 = gc.textExtent((String)s2, (int)SectionLabel.DRAW_FLAGS).x;
            if (l1 + w + l2 < width) {
                t = String.valueOf(s1) + ELLIPSIS + s2;
                break;
            }
            --s;
            ++e;
        }
        return t;
    }

    private String[] splitString(String text) {
        int pos;
        String[] lines = new String[1];
        int start = 0;
        do {
            if ((pos = text.indexOf(10, start)) == -1) {
                lines[lines.length - 1] = text.substring(start);
                continue;
            }
            boolean crlf = pos > 0 && text.charAt(pos - 1) == '\r';
            lines[lines.length - 1] = text.substring(start, pos - (crlf ? 1 : 0));
            start = pos + 1;
            String[] newLines = new String[lines.length + 1];
            System.arraycopy(lines, 0, newLines, 0, lines.length);
            lines = newLines;
        } while (pos != -1);
        return lines;
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            style |= 4;
        }
        int mask = 100663340;
        style &= mask;
        style |= 0x80000;
        String platform = SWT.getPlatform();
        if ("carbon".equals(platform) || "gtk".equals(platform)) {
            return style;
        }
        return style | 0x40000;
    }
}

