/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.IValueMapping;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.WidgetUtil;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMappingDialog
extends TitleAreaDialog {
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ValueMappingDialog.this.updateButtons();
        }
    };
    private static final int ADD_BUTTON_ID = 1024;
    private final ResourceManager fResourceManager;
    private final WidgetUtil.ComboChoices<String> fItemValueChoices;
    private final WidgetUtil.ComboChoices<String> fExternalValueChoices;
    private final boolean fEditMode;
    private List<IValueMapping> fValueMappings = new ArrayList<IValueMapping>();
    private Combo fItemValueCombo;
    private Combo fExternalValueCombo;
    private Button fItemDefaultButton;
    private Button fExternalDefaultButton;

    public ValueMappingDialog(Shell parentShell, WidgetUtil.ComboChoices<String> itemValueChoices, WidgetUtil.ComboChoices<String> externalValueChoices, IValueMapping editMapping, ResourceManager resourceManager) {
        super(parentShell);
        this.fResourceManager = resourceManager;
        this.fItemValueChoices = itemValueChoices;
        this.fExternalValueChoices = externalValueChoices;
        boolean bl = this.fEditMode = editMapping != null;
        if (this.fEditMode) {
            this.fValueMappings.add(editMapping);
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public IValueMapping[] getValueMappings() {
        return this.fValueMappings.toArray(new IValueMapping[this.fValueMappings.size()]);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.fEditMode) {
            this.setTitle(Messages.ValueMappingDialog_EDIT_MODE_TITLE);
            this.setMessage(Messages.ValueMappingDialog_EDIT_MODE_DESCRIPTION);
        } else {
            this.setTitle(Messages.ValueMappingDialog_DIALOG_TITLE);
            this.setMessage(Messages.ValueMappingDialog_DIALOG_DESCRIPTION);
        }
        this.setTitleImage(this.fResourceManager.createImage(InteropIdeUIPlugin.VALUE_MAPPINGS_WIZBAN_IMAGE_DESCRIPTOR));
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite nameComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(nameComposite);
        Label label = new Label(nameComposite, 0);
        label.setText(Messages.ValueMappingDialog_ITEM_VALUE_LABEL);
        this.fItemValueCombo = new Combo(nameComposite, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fItemValueCombo);
        WidgetUtil.setComboChoices(this.fItemValueCombo, this.fItemValueChoices, false);
        this.fItemValueCombo.addModifyListener(this.fModifyListener);
        this.fItemValueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueMappingDialog.this.updateButtons();
            }
        });
        label = new Label(nameComposite, 0);
        label.setText(Messages.ValueMappingDialog_EXTERNAL_VALUE_LABEL);
        this.fExternalValueCombo = new Combo(nameComposite, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fExternalValueCombo);
        WidgetUtil.setComboChoices(this.fExternalValueCombo, this.fExternalValueChoices, false);
        this.fExternalValueCombo.addModifyListener(this.fModifyListener);
        this.fExternalValueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueMappingDialog.this.updateButtons();
            }
        });
        Group optionsGroup = new Group(composite, 0);
        optionsGroup.setText(Messages.ValueMappingDialog_OPTIONS_GROUP_TITLE);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo((Composite)optionsGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)optionsGroup);
        this.fItemDefaultButton = new Button((Composite)optionsGroup, 32);
        this.fItemDefaultButton.setText(Messages.ValueMappingDialog_DEFAULT_ITEM_VALUE_BUTTON_LABEL);
        this.fItemDefaultButton.setToolTipText(Messages.ValueMappingDialog_DEFAULT_ITEM_VALUE_BUTTON_TOOLTIP);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fItemDefaultButton);
        this.fExternalDefaultButton = new Button((Composite)optionsGroup, 32);
        this.fExternalDefaultButton.setText(Messages.ValueMappingDialog_DEFAULT_EXTERNAL_VALUE_BUTTON_LABEL);
        this.fExternalDefaultButton.setToolTipText(Messages.ValueMappingDialog_DEFAULT_EXTERNAL_VALUE_BUTTON_TOOLTIP);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fExternalDefaultButton);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
        if (this.fEditMode) {
            this.refresh(this.fValueMappings.get(0));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.interop.ide.ui.valueMappingsDialog");
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button;
        if (!this.fEditMode) {
            button = this.createButton(parent, 1024, Messages.ValueMappingDialog_ADD_MAPPING_BUTTON_LABEL, false);
            button.setEnabled(false);
        }
        button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        button.setEnabled(this.fEditMode);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ValueMappingDialog_SHELL_TITLE);
    }

    protected void okPressed() {
        if (this.fEditMode) {
            this.commit(this.fValueMappings.get(0));
        } else {
            this.addButtonPressed();
        }
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.addButtonPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void addButtonPressed() {
        IValueMapping mapping = InteropFactory.INSTANCE.createValueMapping();
        this.commit(mapping);
        String itemValue = mapping.getItemValue();
        String externalValue = mapping.getExternalValue();
        if (!(itemValue != null && itemValue.length() != 0 || externalValue != null && externalValue.length() != 0)) {
            return;
        }
        this.fValueMappings.add(mapping);
        this.clear();
        this.updateButtons();
    }

    private void refresh(IValueMapping mapping) {
        WidgetUtil.setComboChoices(this.fItemValueCombo, this.fItemValueChoices, false);
        WidgetUtil.setComboSelection(this.fItemValueCombo, mapping.getItemValue(), this.fItemValueChoices);
        WidgetUtil.setComboChoices(this.fExternalValueCombo, this.fExternalValueChoices, false);
        WidgetUtil.setComboSelection(this.fExternalValueCombo, mapping.getExternalValue(), this.fExternalValueChoices);
        this.fItemDefaultButton.setSelection(mapping.isDefaultItemValue());
        this.fExternalDefaultButton.setSelection(mapping.isDefaultExternalValue());
    }

    private void commit(IValueMapping mapping) {
        mapping.setItemValue(this.fItemValueCombo.getText());
        mapping.setExternalValue(this.fExternalValueCombo.getText());
        mapping.setDefaultItemValue(this.fItemDefaultButton.getSelection());
        mapping.setDefaultExternalValue(this.fExternalDefaultButton.getSelection());
    }

    private void clear() {
        WidgetUtil.setComboSelection(this.fItemValueCombo, null, this.fItemValueChoices);
        WidgetUtil.setComboSelection(this.fExternalValueCombo, null, this.fExternalValueChoices);
        this.fItemDefaultButton.setSelection(false);
        this.fExternalDefaultButton.setSelection(false);
    }

    private void updateButtons() {
        Button button;
        boolean valueSpecified;
        String itemValue = this.fItemValueCombo.getText();
        String externalValue = this.fExternalValueCombo.getText();
        boolean bl = valueSpecified = itemValue != null && itemValue.length() != 0 || externalValue != null && externalValue.length() != 0;
        if (!this.fEditMode && (button = this.getButton(1024)) != null) {
            button.setEnabled(valueSpecified);
        }
        if ((button = this.getButton(0)) != null) {
            button.setEnabled(valueSpecified || !this.fEditMode && !this.fValueMappings.isEmpty());
        }
    }
}

