/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.ExportSyncRulesDialog;
import com.ibm.team.interop.ide.ui.internal.ImportSyncRulesDialog;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleEditor;
import com.ibm.team.interop.rcp.ui.InteropRcpUiPlugin;
import com.ibm.team.interop.rcp.ui.internal.SyncRuleWorkingCopy;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SyncRuleEditorHeader
extends AbstractFormPart {
    private final IManagedForm fHeaderForm;
    private final Form fForm;
    private final SyncRuleEditor fEditor;
    private final NamePart fNamePart;
    private final SyncRuleWorkingCopy fWorkingCopy;
    private final ResourceManager fResourceManager;
    private boolean fInitialized;
    private IStatus fStatus;
    private Button fSaveButton;
    private Action fRefreshAction;

    public SyncRuleEditorHeader(SyncRuleEditor editor, IManagedForm headerForm, SyncRuleWorkingCopy workingCopy, ResourceManager resourceManager) {
        this.fHeaderForm = headerForm;
        this.fForm = headerForm.getForm().getForm();
        this.fEditor = editor;
        this.fWorkingCopy = workingCopy;
        this.fResourceManager = resourceManager;
        FormToolkit toolkit = this.fHeaderForm.getToolkit();
        toolkit.decorateFormHeading(this.fForm);
        this.fNamePart = new NamePart(this.fHeaderForm);
        this.fHeaderForm.addPart((IFormPart)this.fNamePart);
        this.createToolBar();
        this.fForm.setText(Messages.SyncRuleEditorHeader_EDITOR_TITLE);
        this.fForm.setImage(this.fResourceManager.createImage(InteropRcpUiPlugin.SYNC_RULE_IMAGE_DESCRIPTOR));
        this.fForm.addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (SyncRuleEditorHeader.this.fStatus != null) {
                    ErrorDialog.openError((Shell)SyncRuleEditorHeader.this.fEditor.getSite().getShell(), (String)e.getLabel(), null, (IStatus)SyncRuleEditorHeader.this.fStatus);
                } else {
                    MessageDialog.openInformation((Shell)SyncRuleEditorHeader.this.fEditor.getSite().getShell(), (String)e.getLabel(), (String)Messages.SyncRuleEditorHeader_NO_ERROR_DETAILS);
                }
            }
        });
    }

    public boolean isDirty() {
        return this.fNamePart.isDirty() || super.isDirty();
    }

    public void refresh() {
        this.fNamePart.refresh();
        this.updateButtons();
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fNamePart.commit(onSave);
    }

    public void prepareForReload() {
        this.refresh();
        this.fInitialized = false;
    }

    public void updateStatus(IStatus status) {
        if (status != null && !status.isOK()) {
            int type = 0;
            switch (status.getSeverity()) {
                case 4: 
                case 8: {
                    type = 3;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 1: {
                    type = 1;
                }
            }
            this.fForm.setMessage(status.getMessage(), type);
            this.fStatus = status;
        } else {
            this.fForm.setMessage(null, 0);
            this.fStatus = null;
        }
    }

    private void doRevert() {
        this.fEditor.prepareForReload();
        this.updateStatus(null);
        Job job = new Job(Messages.SyncRuleEditorHeader_RELOADING_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SyncRuleEditorHeader.this.fWorkingCopy.revert(monitor);
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)SyncRuleEditorHeader.this.fEditor.getSite().getShell(), (String)Messages.SyncRuleEditorHeader_ERROR_RELOADING_SYNCRULE, null, (IStatus)e.getStatus());
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void doImport() {
        ImportSyncRulesDialog dialog = new ImportSyncRulesDialog(this.fEditor.getSite().getShell(), false);
        List<File> files = dialog.open();
        if (files == null || files.size() == 0) {
            return;
        }
        IStatus status = this.fWorkingCopy.importFromFile(files.get(0));
        this.updateStatus(status);
        this.markDirty();
    }

    private void doExport() {
        String defaultFileName = String.valueOf(this.fWorkingCopy.getName()) + ".xml";
        ExportSyncRulesDialog dialog = new ExportSyncRulesDialog(this.fEditor.getSite().getShell(), defaultFileName);
        File file = dialog.open();
        if (file == null) {
            return;
        }
        IStatus status = this.fWorkingCopy.exportToFile(file);
        this.updateStatus(status);
    }

    private void createToolBar() {
        IToolBarManager toolbarManager = this.fForm.getToolBarManager();
        Action importAction = new Action(Messages.SyncRuleEditorHeader_IMPORT_ACTION_NAME, 1){

            public void run() {
                SyncRuleEditorHeader.this.doImport();
            }
        };
        importAction.setImageDescriptor(InteropIdeUIPlugin.IMPORT_ACTION_IMAGE_DESCRIPTOR);
        importAction.setToolTipText(Messages.SyncRuleEditorHeader_IMPORT_ACTION_TOOLTIP);
        importAction.setEnabled(this.fWorkingCopy.isLicensed());
        toolbarManager.add((IAction)importAction);
        Action exportAction = new Action(Messages.SyncRuleEditorHeader_EXPORT_ACTION_NAME, 1){

            public void run() {
                SyncRuleEditorHeader.this.doExport();
            }
        };
        exportAction.setImageDescriptor(InteropIdeUIPlugin.EXPORT_ACTION_IMAGE_DESCRIPTOR);
        exportAction.setToolTipText(Messages.SyncRuleEditorHeader_EXPORT_ACTION_TOOLTIP);
        exportAction.setEnabled(this.fWorkingCopy.isLicensed());
        toolbarManager.add((IAction)exportAction);
        this.fRefreshAction = new Action(Messages.SyncRuleEditorHeader_REFRESH_ACTION_NAME, 1){

            public void run() {
                SyncRuleEditorHeader.this.doRevert();
            }
        };
        this.fRefreshAction.setImageDescriptor(InteropIdeUIPlugin.REFRESH_ACTION_IMAGE_DESCRIPTOR);
        this.fRefreshAction.setToolTipText(Messages.SyncRuleEditorHeader_REFRESH_ACTION_TOOLTIP);
        this.fRefreshAction.setEnabled(this.fWorkingCopy.isLicensed() && !this.fWorkingCopy.getSyncRule().isNewItem());
        toolbarManager.add((IAction)this.fRefreshAction);
        ControlContribution save = new ControlContribution("save"){

            protected Control createControl(Composite parent) {
                SyncRuleEditorHeader.this.fSaveButton = SyncRuleEditorHeader.this.fHeaderForm.getToolkit().createButton(parent, Messages.SyncRuleEditorHeader_SAVE_BUTTON_LABEL, 8);
                SyncRuleEditorHeader.this.fSaveButton.setBackground(null);
                SyncRuleEditorHeader.this.fSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SyncRuleEditorHeader.this.fEditor.getSite().getPage().saveEditor((IEditorPart)SyncRuleEditorHeader.this.fEditor, false);
                    }
                });
                SyncRuleEditorHeader.this.fSaveButton.setEnabled(SyncRuleEditorHeader.this.fWorkingCopy.isLicensed() && SyncRuleEditorHeader.this.fEditor.isDirty());
                return SyncRuleEditorHeader.this.fSaveButton;
            }
        };
        this.fEditor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 257) {
                    SyncRuleEditorHeader.this.fSaveButton.setEnabled(SyncRuleEditorHeader.this.fWorkingCopy.isLicensed() && SyncRuleEditorHeader.this.fEditor.isDirty());
                }
            }
        });
        toolbarManager.add((IContributionItem)save);
        toolbarManager.update(false);
    }

    private void updateButtons() {
        this.fRefreshAction.setEnabled(this.fWorkingCopy.isLicensed() && !this.fWorkingCopy.getSyncRule().isNewItem());
    }

    private class NamePart
    extends AbstractFormPart {
        private IChangeListener fChangeListener = new IChangeListener(){

            public void changed(Object source, Object property) {
                if (property != IWorkingCopy.PROP_VALID) {
                    return;
                }
                if (!SyncRuleEditorHeader.this.fWorkingCopy.isValid()) {
                    return;
                }
                NamePart.this.refresh();
            }
        };
        private Text fNameText;

        NamePart(IManagedForm headerForm) {
            FormToolkit toolkit = headerForm.getToolkit();
            Form form = headerForm.getForm().getForm();
            Composite nameBar = toolkit.createComposite(form.getHead());
            GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(1, 1, 0, 4).spacing(LayoutConstants.getSpacing()).applyTo(nameBar);
            nameBar.setBackground(null);
            toolkit.paintBordersFor(nameBar);
            form.setHeadClient((Control)nameBar);
            Label label = toolkit.createLabel(nameBar, Messages.SyncRuleEditorHeader_NAME_LABEL);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
            label.setBackground(null);
            this.fNameText = toolkit.createText(nameBar, "");
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(1, -1).applyTo((Control)this.fNameText);
            this.fNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (SyncRuleEditorHeader.this.fInitialized) {
                        NamePart.this.markDirty();
                    }
                }
            });
            SyncRuleEditorHeader.this.fWorkingCopy.addListener(this.fChangeListener);
        }

        public void dispose() {
            SyncRuleEditorHeader.this.fWorkingCopy.removeListener(this.fChangeListener);
            super.dispose();
        }

        public void refresh() {
            ISyncRule syncRule = SyncRuleEditorHeader.this.fWorkingCopy.getSyncRule();
            if (syncRule.getName() == null) {
                this.fNameText.setText("");
            } else {
                this.fNameText.setText(syncRule.getName());
            }
            super.refresh();
            SyncRuleEditorHeader.this.fInitialized = true;
        }

        public void commit(boolean onSave) {
            if (this.isDirty()) {
                ISyncRule syncRule = SyncRuleEditorHeader.this.fWorkingCopy.getSyncRule();
                syncRule.setName(this.fNameText.getText());
            }
        }
    }
}

