/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleDocumentProvider;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleEditorHeader;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleEditorInput;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleOverviewPage;
import com.ibm.team.interop.rcp.ui.internal.SyncRuleWorkingCopy;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.ui.editor.TeamFormEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class SyncRuleEditor
extends TeamFormEditor {
    private IChangeListener fChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property != IWorkingCopy.PROP_VALID) {
                return;
            }
            SyncRuleWorkingCopy workingCopy = (SyncRuleWorkingCopy)source;
            if (!workingCopy.isValid()) {
                return;
            }
            if (workingCopy.getLastError() != null) {
                SyncRuleEditor.this.updateStatus(StatusUtil.newStatus((Object)this, (Throwable)workingCopy.getLastError()));
            }
            SyncRuleEditor.this.fTextEditor.doRevertToSaved();
        }
    };
    private static final int OVERVIEW_PAGE_INDEX = 0;
    private static final int SOURCE_PAGE_INDEX = 1;
    private SyncRuleEditorHeader fHeader;
    private SyncRuleOverviewPage fOverviewPage;
    private TextEditor fTextEditor;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static void openEditor(IWorkbenchPage page, ISyncRule syncRule, ITeamRepository repository, IProcessArea processArea) {
        SyncRuleEditorInput input = new SyncRuleEditorInput(syncRule, repository, processArea);
        try {
            page.openEditor((IEditorInput)input, "com.ibm.team.interop.syncRuleEditor");
        }
        catch (PartInitException e) {
            InteropIdeUIPlugin.getDefault().log(Messages.SyncRuleEditor_ERROR_OPENING_EDITOR, e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPage(this.getCurrentPage());
        CoreException error = null;
        SyncRuleEditorInput editorInput = (SyncRuleEditorInput)this.getEditorInput();
        try {
            editorInput.saveSyncRule(monitor);
            this.fTextEditor.getDocumentProvider().resetDocument((Object)this.getEditorInput());
        }
        catch (CoreException e) {
            error = e;
        }
        this.setPartName(editorInput.getName());
        if (error != null) {
            this.fHeader.updateStatus(StatusUtil.newStatus((Object)((Object)this), (Throwable)error));
        } else {
            this.fHeader.updateStatus(null);
            this.fHeader.refresh();
            this.fOverviewPage.setPageDirty(false);
            this.firePropertyChange(257);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        SyncRuleEditorInput editorInput = (SyncRuleEditorInput)this.getEditorInput();
        editorInput.getWorkingCopy().removeListener(this.fChangeListener);
        editorInput.getWorkingCopy().dispose();
        this.fResourceManager.dispose();
        super.dispose();
    }

    public void prepareForReload() {
        this.fHeader.prepareForReload();
        this.fOverviewPage.prepareForReload();
        this.firePropertyChange(257);
    }

    public void updateStatus(IStatus status) {
        if (this.fHeader != null) {
            this.fHeader.updateStatus(status);
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        SyncRuleEditorInput input = (SyncRuleEditorInput)this.getEditorInput();
        this.fHeader = new SyncRuleEditorHeader(this, headerForm, input.getWorkingCopy(), this.fResourceManager);
        headerForm.addPart((IFormPart)this.fHeader);
    }

    protected void addPages() {
        this.createOverviewPage();
        this.createSourcePage();
        this.setPartName(this.getEditorInput().getName());
        SyncRuleEditorInput editorInput = (SyncRuleEditorInput)this.getEditorInput();
        editorInput.getWorkingCopy().addListener(this.fChangeListener);
    }

    protected void pageChange(int newPageIndex) {
        this.commitPage(this.getCurrentPage());
        super.pageChange(newPageIndex);
    }

    private void commitPage(int pageIndex) {
        SyncRuleDocumentProvider docProvider = (SyncRuleDocumentProvider)this.fTextEditor.getDocumentProvider();
        IDocument document = docProvider.getDocument(this.getEditorInput());
        try {
            switch (pageIndex) {
                case 0: {
                    boolean update = false;
                    if (this.fHeader.isDirty()) {
                        this.fHeader.commit(false);
                        update = true;
                    }
                    if (this.fOverviewPage.isDirty()) {
                        this.fOverviewPage.commit();
                        update = true;
                    }
                    if (update) {
                        docProvider.updateDocument(this.getEditorInput(), document);
                    }
                    break;
                }
                case 1: {
                    if (!this.fTextEditor.isDirty()) break;
                    docProvider.commitDocument(this.getEditorInput(), document);
                    this.fHeader.refresh();
                    this.fOverviewPage.refresh();
                }
                default: {
                    break;
                }
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.SyncRuleEditor_ERROR_UPDATING_SYNCRULE, null, (IStatus)e.getStatus());
        }
    }

    private void createOverviewPage() {
        SyncRuleEditorInput input = (SyncRuleEditorInput)this.getEditorInput();
        try {
            this.fOverviewPage = new SyncRuleOverviewPage((FormEditor)this, input.getWorkingCopy(), this.fResourceManager);
            this.addPage((IFormPage)this.fOverviewPage);
            this.fOverviewPage.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    SyncRuleEditor.this.handlePropertyChange(propId);
                }
            });
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.SyncRuleEditor_ERROR_CREATING_OVERVIEW_PAGE, null, (IStatus)e.getStatus());
        }
    }

    private void createSourcePage() {
        this.fTextEditor = new TextEditor();
        try {
            this.addPage((IEditorPart)this.fTextEditor, this.getEditorInput());
            this.setPageText(1, Messages.SyncRuleEditor_SOURCE_PAGE_TITLE);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.SyncRuleEditor_ERROR_CREATING_SOURCE_PAGE, null, (IStatus)e.getStatus());
        }
    }
}

