/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.IPropertyMapping;
import com.ibm.team.interop.common.rcp.dto.IPropertyInfoDTO;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.WidgetUtil;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMappingLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final ResourceManager fResourceManager;
    private final WidgetUtil.ComboChoices<IPropertyInfoDTO> fItemPropertyChoices;
    private final WidgetUtil.ComboChoices<IPropertyInfoDTO> fExternalPropertyChoices;

    public PropertyMappingLabelProvider(WidgetUtil.ComboChoices<IPropertyInfoDTO> itemPropertyChoices, WidgetUtil.ComboChoices<IPropertyInfoDTO> externalPropertyChoices, ResourceManager resourceManager) {
        this.fItemPropertyChoices = itemPropertyChoices;
        this.fExternalPropertyChoices = externalPropertyChoices;
        this.fResourceManager = resourceManager;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        IPropertyMapping mapping = (IPropertyMapping)element;
        switch (columnIndex) {
            case 0: {
                if (!mapping.isItemIdentifier()) break;
                return this.fResourceManager.createImage(InteropIdeUIPlugin.IDENTIFIER_IMAGE_DESCRIPTOR);
            }
            case 3: {
                if (!mapping.isExternalIdentifier()) break;
                return this.fResourceManager.createImage(InteropIdeUIPlugin.IDENTIFIER_IMAGE_DESCRIPTOR);
            }
            case 2: {
                if (mapping.isIncoming() && mapping.isOutgoing()) {
                    return this.fResourceManager.createImage(InteropIdeUIPlugin.IN_OUT_IMAGE_DESCRIPTOR);
                }
                if (mapping.isIncoming()) {
                    return this.fResourceManager.createImage(InteropIdeUIPlugin.IN_IMAGE_DESCRIPTOR);
                }
                if (!mapping.isOutgoing()) break;
                return this.fResourceManager.createImage(InteropIdeUIPlugin.OUT_IMAGE_DESCRIPTOR);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IPropertyMapping mapping = (IPropertyMapping)element;
        switch (columnIndex) {
            case 1: {
                return this.fItemPropertyChoices.getDisplayNameByAlternateName(mapping.getItemPropertyName());
            }
            case 4: {
                return this.fExternalPropertyChoices.getDisplayNameByAlternateName(mapping.getExternalPropertyName());
            }
        }
        return null;
    }
}

