/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.widgets.Combo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetUtil {
    public static void setComboChoices(Combo combo, ComboChoices choices, boolean selectDefault) {
        if (choices.getChoices().size() == 0) {
            combo.removeAll();
            return;
        }
        String previousValue = combo.getText();
        String[] choiceNames = new String[choices.getDisplayNames().size()];
        choices.getDisplayNames().toArray(choiceNames);
        combo.setItems(choiceNames);
        if (selectDefault) {
            if (choices.getChoices().size() == 1) {
                combo.select(0);
            } else if (previousValue != null && previousValue.length() != 0) {
                int i = 0;
                while (i < choices.getChoices().size()) {
                    if (previousValue.equals(choiceNames[i]) || choices.getAlternateName(i) != null && previousValue.equals(choices.getAlternateName(i))) {
                        combo.select(i);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            combo.clearSelection();
            combo.deselectAll();
        }
    }

    public static void setComboSelection(Combo combo, String choiceName, ComboChoices choices) {
        if (choiceName == null || choiceName.length() == 0) {
            combo.clearSelection();
            combo.deselectAll();
            return;
        }
        int index = -1;
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (choiceName.equals(items[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            index = choices.add(choiceName, choiceName, null);
            combo.add(choiceName, index);
        }
        combo.select(index);
    }

    public static <T> T getComboSelection(Combo combo, ComboChoices<T> choices) {
        int index = combo.getSelectionIndex();
        if (index >= 0 && index < choices.getChoices().size()) {
            return choices.getChoices().get(index);
        }
        return null;
    }

    private WidgetUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComboChoices<T> {
        private static String EMPTY = new String();
        private List<String> fDisplayNames = new LinkedList<String>();
        private List<String> fAlternateNames = new LinkedList<String>();
        private List<T> fChoices = new LinkedList<T>();

        public int add(String displayName, String alternateName, T choice) {
            int index = 0;
            while (index < this.fDisplayNames.size()) {
                if (displayName.compareToIgnoreCase(this.fDisplayNames.get(index)) < 0) break;
                ++index;
            }
            this.fDisplayNames.add(index, displayName);
            this.fAlternateNames.add(index, alternateName);
            this.fChoices.add(index, choice);
            return index;
        }

        public void clear() {
            this.fDisplayNames.clear();
            this.fAlternateNames.clear();
            this.fChoices.clear();
        }

        public List<String> getDisplayNames() {
            return this.fDisplayNames;
        }

        public String getDisplayName(int i) {
            if (i < this.fDisplayNames.size()) {
                return this.fDisplayNames.get(i);
            }
            return null;
        }

        public List<String> getAlternateNames() {
            return this.fAlternateNames;
        }

        public String getAlternateName(int i) {
            if (i < this.fAlternateNames.size()) {
                return this.fAlternateNames.get(i);
            }
            return null;
        }

        public List<T> getChoices() {
            return this.fChoices;
        }

        public T getChoice(int i) {
            if (i < this.fChoices.size()) {
                return this.fChoices.get(i);
            }
            return null;
        }

        public T getChoiceByDisplayName(String name) {
            int index = this.fDisplayNames.indexOf(name);
            if (index == -1) {
                return null;
            }
            return this.fChoices.get(index);
        }

        public T getChoiceByAlternateName(String name) {
            int index = this.fAlternateNames.indexOf(name);
            if (index == -1) {
                if (name == null) {
                    index = this.fAlternateNames.indexOf(EMPTY);
                } else if (name.length() == 0) {
                    index = this.fAlternateNames.indexOf(null);
                }
                if (index == -1) {
                    return null;
                }
            }
            return this.fChoices.get(index);
        }

        public String getDisplayNameByAlternateName(String name) {
            int index = this.fAlternateNames.indexOf(name);
            if (index == -1) {
                if (name == null) {
                    index = this.fAlternateNames.indexOf(EMPTY);
                } else if (name.length() == 0) {
                    index = this.fAlternateNames.indexOf(null);
                }
                if (index == -1) {
                    return name;
                }
            }
            return this.fDisplayNames.get(index);
        }
    }
}

