/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.Messages;
import com.ibm.team.interop.rcp.ui.InteropRcpUiPlugin;
import com.ibm.team.interop.rcp.ui.internal.ExternalProxyWorkingCopy;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.util.NLS;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;

public class InteropLabelProvider
extends TypeLabelProvider {
    private static Map<UUID, String> fProxyInfoMap = Collections.synchronizedMap(new HashMap());

    public void updateLabel(ViewerLabel label, Object element) {
        if (element instanceof IExternalProxy) {
            IExternalProxy proxy = (IExternalProxy)element;
            label.setImage(this.getImage(InteropRcpUiPlugin.PROXY_IMAGE_DESCRIPTOR));
            label.setText(this.getProxyText(proxy));
        } else if (element instanceof IExternalRepositoryConnection) {
            IExternalRepositoryConnection externalConnection = (IExternalRepositoryConnection)element;
            if (externalConnection.isOutgoingSyncDisabled()) {
                label.setImage(this.getImage(InteropIdeUIPlugin.EXTERNAL_REPO_DISABLED_IMAGE_DESCRIPTOR));
            } else {
                label.setImage(this.getImage(InteropIdeUIPlugin.EXTERNAL_REPO_UNKNOWN_IMAGE_DESCRIPTOR));
            }
            if (externalConnection.getName() != null && externalConnection.getName().length() != 0) {
                ITeamRepository repository = (ITeamRepository)externalConnection.getOrigin();
                if (repository == null) {
                    label.setText(externalConnection.getName());
                } else {
                    label.setText(String.format("%s [%s]", externalConnection.getName(), repository.getName()));
                }
            } else {
                label.setText(Messages.InteropLabelProvider_NEW_EXTERNAL_REPOSITORY_CONNECTION);
            }
        } else if (element instanceof ISyncRule) {
            label.setImage(this.getImage(InteropRcpUiPlugin.SYNC_RULE_IMAGE_DESCRIPTOR));
            ISyncRule syncRule = (ISyncRule)element;
            if (syncRule.getName() != null && syncRule.getName().length() != 0) {
                label.setText(syncRule.getName());
            } else {
                label.setText(NLS.bind((String)Messages.InteropLabelProvider_SYNC_RULE_LABEL, (Object[])new Object[]{syncRule.getItemId().getUuidValue()}));
            }
        }
    }

    private String getProxyText(IExternalProxy proxy) {
        String externalId = proxy.getExternalIdHint();
        if (externalId != null && externalId.length() != 0) {
            fProxyInfoMap.remove(proxy.getItemId());
            return NLS.bind((String)Messages.InteropLabelProvider_SYNC_STATUS_FORMAT, (Object[])new Object[]{externalId, ExternalProxyWorkingCopy.getSyncStatusText((IExternalProxy)proxy)});
        }
        String statusFormat = fProxyInfoMap.get(proxy.getItemId());
        if (statusFormat == null || statusFormat.length() == 0) {
            FetchProxyInfoJob job = new FetchProxyInfoJob(proxy);
            job.schedule();
            return Messages.InteropLabelProvider_FETCHING_SYNC_STATUS;
        }
        return NLS.bind((String)statusFormat, (Object[])new Object[]{ExternalProxyWorkingCopy.getSyncStatusText((IExternalProxy)proxy)});
    }

    private class FetchProxyInfoJob
    extends UIUpdaterJob {
        private final IExternalProxy fProxy;

        FetchProxyInfoJob(IExternalProxy proxy) {
            super(Messages.InteropLabelProvider_FETCHING_SYNC_STATUS);
            this.fProxy = proxy;
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            ITeamRepository repository = (ITeamRepository)this.fProxy.getOrigin();
            IInteropManager interopClient = (IInteropManager)repository.getClientLibrary(IInteropManager.class);
            IItemHandle itemHandle = null;
            String info = this.fProxy.getExternalIdHint();
            if (info == null || info.length() == 0) {
                try {
                    URI uri = interopClient.getUri((IExternalProxyHandle)this.fProxy, monitor);
                    if (uri != null) {
                        try {
                            info = URLDecoder.decode(uri.toString(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            info = uri.toString();
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
            if (info == null || info.length() == 0) {
                try {
                    IItem item;
                    Object value;
                    String itemNameProperty;
                    itemHandle = interopClient.getTargetItem((IExternalProxyHandle)this.fProxy, monitor);
                    if (itemHandle != null && (itemNameProperty = ((ItemType)itemHandle.getItemType()).idPropertyName()) != null && itemNameProperty.length() != 0 && (value = ((Item)(item = repository.itemManager().fetchPartialItem(itemHandle, 0, (Collection)Collections.singletonList(itemNameProperty), monitor))).getPropertyValue(itemNameProperty)) != null) {
                        info = value.toString();
                    }
                }
                catch (Throwable throwable) {}
            }
            String statusText = ExternalProxyWorkingCopy.getSyncStatusText((IExternalProxy)this.fProxy);
            if (info != null && info.length() != 0) {
                fProxyInfoMap.put(this.fProxy.getItemId(), NLS.bind((String)Messages.InteropLabelProvider_SYNC_STATUS_FORMAT, (Object[])new Object[]{info, statusText}));
            } else if (itemHandle != null) {
                fProxyInfoMap.put(this.fProxy.getItemId(), NLS.bind((String)Messages.InteropLabelProvider_SYNC_STATUS_ITEM_TYPE_FORMAT, (Object[])new Object[]{itemHandle.getItemType().getName(), statusText}));
            } else {
                fProxyInfoMap.put(this.fProxy.getItemId(), NLS.bind((String)Messages.InteropLabelProvider_SYNC_STATUS_UNKNOWN_EXTERNAL_OBJECT_FORMAT, (Object[])new Object[]{statusText}));
            }
            return Status.OK_STATUS;
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            InteropLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)InteropLabelProvider.this, (Object)this.fProxy));
            return Status.OK_STATUS;
        }
    }
}

