/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.interop.common.service.IInteropService;
import com.ibm.team.interop.ide.ui.internal.Messages;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.itemview.IItemViewUIAdvisor;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class InteropItemViewUIAdvisor
implements IItemViewUIAdvisor {
    private static final Set<String> CATEGORIES = new HashSet<String>((Collection)Arrays.asList(IInteropService.CHANGE_EVENT_CATEGORIES));
    private static final String FILTER_ID = "com.ibm.team.interop.filter";

    public void configure(ItemViewUIConfigurer configurer) {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof GenericAggregationBin) {
                    element = ((GenericAggregationBin)element).getMostRecent();
                }
                if (element instanceof NewsItem) {
                    NewsItem item = (NewsItem)element;
                    String newsCategory = item.getCategory();
                    return !CATEGORIES.contains(newsCategory);
                }
                return true;
            }
        };
        ItemViewerFilter viewFilter = new ItemViewerFilter(filter, FILTER_ID, Messages.InteropItemViewUIAdvisor_EXTERNAL_CONNECTOR_FILTER_NAME, 0);
        viewFilter.setEnabledByDefault(true);
        configurer.addFilter(viewFilter);
    }
}

