/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.ide.ui.internal.Messages;
import com.ibm.team.interop.ide.ui.internal.WidgetUtil;
import com.ibm.team.interop.rcp.ui.internal.ExternalRepositoryConnectionWorkingCopy;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ExternalRepositoryConnectionProperties {
    private Text fNameText;
    private ControlDecoration fNameDecoration;
    private Text fConnectionInfoText;
    private Text fUserIdText;
    private Text fPasswordText;
    private Combo fProjectAreaCombo;
    private WidgetUtil.ComboChoices<IProjectArea> fProjectAreaChoices = new WidgetUtil.ComboChoices();
    private Button fOutgoingSyncDisabled;

    public ExternalRepositoryConnectionProperties(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.ExternalRepositoryConnectionDialog_NAME_LABEL);
        this.fNameText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fNameText);
        this.fNameDecoration = new ControlDecoration((Control)this.fNameText, 16512);
        this.fNameDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        this.fNameDecoration.show();
        label = new Label(composite, 0);
        label.setText(Messages.ExternalRepositoryConnectionDialog_CONNECTION_INFO_LABEL);
        this.fConnectionInfoText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fConnectionInfoText);
        label = new Label(composite, 0);
        label.setText(Messages.ExternalRepositoryConnectionDialog_USER_ID_LABEL);
        this.fUserIdText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fUserIdText);
        label = new Label(composite, 0);
        label.setText(Messages.ExternalRepositoryConnectionDialog_PASSWORD_LABEL);
        this.fPasswordText = new Text(composite, 0x400804);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fPasswordText);
        label = new Label(composite, 0);
        label.setText(Messages.ExternalRepositoryConnectionProperties_PROJECT_AREA_LABEL);
        label.setToolTipText(Messages.ExternalRepositoryConnectionProperties_PROJECT_AREA_TOOLTIP);
        this.fProjectAreaCombo = new Combo(composite, 12);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fProjectAreaCombo);
        this.fOutgoingSyncDisabled = new Button(composite, 32);
        this.fOutgoingSyncDisabled.setText(Messages.ExternalRepositoryConnectionDialog_DISABLE_OUTGOING_BUTTON_LABEL);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fOutgoingSyncDisabled);
    }

    public void addRequiredPropertiesModifyListener(ModifyListener modifyListener) {
        if (modifyListener != null) {
            this.fNameText.addModifyListener(modifyListener);
        }
    }

    public boolean requiredPropertiesSet() {
        return this.fNameText.getText() != null && this.fNameText.getText().length() != 0;
    }

    public void commit(ExternalRepositoryConnectionWorkingCopy workingCopy) {
        IExternalRepositoryConnection externalConnection = workingCopy.getExternalRepositoryConnection();
        externalConnection.setName(this.fNameText.getText());
        externalConnection.setConnectionInfo(this.fConnectionInfoText.getText());
        externalConnection.setUserId(this.fUserIdText.getText());
        externalConnection.setPassword(this.fPasswordText.getText());
        externalConnection.setOutgoingSyncDisabled(this.fOutgoingSyncDisabled.getSelection());
        IProjectArea projectArea = WidgetUtil.getComboSelection(this.fProjectAreaCombo, this.fProjectAreaChoices);
        externalConnection.setProjectArea((IProjectAreaHandle)projectArea);
        workingCopy.updateProjectArea(projectArea);
    }

    public void refresh(ExternalRepositoryConnectionWorkingCopy workingCopy) {
        IExternalRepositoryConnection externalConnection = workingCopy.getExternalRepositoryConnection();
        this.fNameText.setText(this.safeGetText(externalConnection.getName()));
        this.fConnectionInfoText.setText(this.safeGetText(externalConnection.getConnectionInfo()));
        this.fUserIdText.setText(this.safeGetText(externalConnection.getUserId()));
        this.fPasswordText.setText(this.safeGetText(externalConnection.getPassword()));
        this.fOutgoingSyncDisabled.setSelection(externalConnection.isOutgoingSyncDisabled());
        IProjectArea projectArea = workingCopy.getProjectArea();
        String projectAreaName = projectArea == null ? Messages.ExternalRepositoryConnectionProperties_CHOICE_NONE : projectArea.getName();
        this.fProjectAreaChoices.clear();
        this.fProjectAreaChoices.add(Messages.ExternalRepositoryConnectionProperties_CHOICE_NONE, null, null);
        for (IProjectArea area : workingCopy.getConnectedProjectAreas()) {
            this.fProjectAreaChoices.add(area.getName(), null, area);
        }
        WidgetUtil.setComboChoices(this.fProjectAreaCombo, this.fProjectAreaChoices, false);
        WidgetUtil.setComboSelection(this.fProjectAreaCombo, projectAreaName, this.fProjectAreaChoices);
        if (projectArea != null && !externalConnection.isNewItem()) {
            this.fProjectAreaCombo.setEnabled(false);
        }
    }

    private String safeGetText(String text) {
        return text == null ? new String() : text;
    }
}

