/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportSyncRulesDialog {
    private static final String EXPORT_DIALOG_SETTINGS = "exportSyncRules";
    private static final String SETTINGS_DIRECTORY_KEY = "directoryPath";
    private final Shell fShell;
    private final String fDefaultFileName;

    public ExportSyncRulesDialog(Shell shell, String defaultFileName) {
        this.fShell = shell;
        this.fDefaultFileName = defaultFileName;
    }

    public File open() {
        String defaultDirectoryPath = null;
        IDialogSettings allSettings = InteropIdeUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = allSettings.getSection(EXPORT_DIALOG_SETTINGS);
        if (settings == null) {
            settings = allSettings.addNewSection(EXPORT_DIALOG_SETTINGS);
        } else {
            defaultDirectoryPath = settings.get(SETTINGS_DIRECTORY_KEY);
        }
        if (this.fDefaultFileName != null) {
            FileDialog fileDialog = new FileDialog(this.fShell, 8192);
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            fileDialog.setFilterPath(defaultDirectoryPath);
            fileDialog.setFileName(this.fDefaultFileName);
            fileDialog.setText(Messages.ExportSyncRulesDialog_FILE_DIALOG_TITLE);
            String filePath = fileDialog.open();
            if (filePath == null) {
                return null;
            }
            settings.put(SETTINGS_DIRECTORY_KEY, fileDialog.getFilterPath());
            File file = new File(filePath);
            if (file.exists() && !MessageDialog.openConfirm((Shell)this.fShell, (String)Messages.ExportSyncRulesDialog_CONFIRM_OVERWRITE_TITLE, (String)NLS.bind((String)Messages.ExportSyncRulesDialog_CONFIRM_OVERWRITE_MESSAGE, (Object[])new Object[]{file.getName(), file.getParent()}))) {
                return null;
            }
            return file;
        }
        DirectoryDialog dirDialog = new DirectoryDialog(this.fShell);
        dirDialog.setText(Messages.ExportSyncRulesDialog_DIRECTORY_DIALOG_TITLE);
        dirDialog.setMessage(Messages.ExportSyncRulesDialog_DIRECTORY_DIALOG_DESCRIPTION);
        dirDialog.setFilterPath(defaultDirectoryPath);
        String dirPath = dirDialog.open();
        if (dirPath == null) {
            return null;
        }
        settings.put(SETTINGS_DIRECTORY_KEY, dirPath);
        return new File(dirPath);
    }
}

