/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.search;

import com.ibm.icu.text.NumberFormat;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.fulltext.ide.ui.internal.ArtifactType;
import com.ibm.team.fulltext.ide.ui.internal.FulltextUIPlugin;
import com.ibm.team.fulltext.ide.ui.internal.ResultItem;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;

public class ResultLabelProvider
extends OwnerDrawLabelProvider {
    private static final String PREF_SHOW_SCORE = "com.ibm.team.fulltext.ide.ui.internal.search.PrefShowScore";
    private LocalResourceManager fResources;
    private Color fScoreColorFill;
    private Color fColorWhite;
    private Color fScoreEmptyColorFill;
    private Color fTextColorFg;
    private Color fBorderColorFg;
    private final NumberFormat fCachedFormat = NumberFormat.getPercentInstance();
    private boolean fShowScore;
    private Point fMaxTextExtent;

    public ResultLabelProvider() {
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.createResources();
    }

    private void createResources() {
        this.fScoreColorFill = this.fResources.createColor(new RGB(200, 200, 200));
        this.fScoreEmptyColorFill = this.fResources.createColor(new RGB(245, 245, 245));
        this.fColorWhite = this.fResources.createColor(new RGB(255, 255, 255));
        this.fTextColorFg = this.fResources.createColor(new RGB(140, 140, 140));
        this.fBorderColorFg = this.fResources.createColor(new RGB(170, 170, 170));
    }

    public boolean isScoreShown() {
        return this.fShowScore;
    }

    public void setShowScore(boolean showScore) {
        this.fShowScore = showScore;
    }

    public void loadFrom(IMemento memento) {
        if (memento == null) {
            return;
        }
        String showScoreStr = memento.getString(PREF_SHOW_SCORE);
        this.fShowScore = showScoreStr != null ? Boolean.parseBoolean(showScoreStr) : false;
    }

    public void saveTo(IMemento memento) {
        memento.putString(PREF_SHOW_SCORE, String.valueOf(this.fShowScore));
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }

    public void update(ViewerCell cell) {
        IScoredResult result = ((ResultItem)cell.getElement()).getResult();
        if (result == null) {
            return;
        }
        URIReference ref = result.getResult();
        ArtifactType artifactType = FulltextUIPlugin.getDefault().getArtifactType(ref.getType());
        switch (cell.getColumnIndex()) {
            case 0: {
                cell.setText(ref.getName());
                if (artifactType != null) {
                    cell.setImage(this.fResources.createImage(artifactType.getIcon()));
                    break;
                }
                cell.setImage(this.fResources.createImage(FulltextUIPlugin.getDefault().createDescriptor("icons/obj16/generic.gif")));
                break;
            }
            case 2: {
                if (ref.getDetails() != null && ref.getDetails().length() > 0) {
                    cell.setText(ref.getDetails());
                    break;
                }
                cell.setText("-");
                break;
            }
            case 3: {
                if (artifactType != null) {
                    cell.setText(artifactType.getName());
                    break;
                }
                cell.setText(ref.getType());
            }
        }
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        int index = event.index;
        if (element == null) {
            return;
        }
        if (index == 1) {
            boolean selected;
            Tree tree = (Tree)event.widget;
            GC gc = event.gc;
            gc.setAdvanced(true);
            ResultItem result = (ResultItem)element;
            int percentage = (int)((float)result.getResult().getScore() / 1000.0f);
            int left = event.x + 5;
            int colWidth = tree.getColumn(index).getWidth();
            int width = colWidth - 10;
            if (this.fMaxTextExtent == null) {
                String maxText = this.fCachedFormat.format(1.0).intern();
                this.fMaxTextExtent = gc.textExtent(maxText);
                this.fMaxTextExtent.x += 5;
            }
            if (this.fShowScore) {
                width -= this.fMaxTextExtent.x;
            }
            Color background = gc.getBackground();
            boolean bl = selected = (event.detail & 2) != 0;
            if (!selected) {
                gc.setBackground(this.fColorWhite);
                gc.fillRectangle(event.x, event.y, colWidth, event.height);
            }
            int percentageNorm = Math.max(percentage, this.fShowScore ? 0 : 8);
            int y = event.y + 5;
            int height = event.height - 10;
            int offset = width * percentageNorm / 100;
            gc.setBackground(this.fScoreEmptyColorFill);
            gc.fillRectangle(left, y, width - 2, height);
            gc.setBackground(this.fScoreColorFill);
            gc.fillRectangle(left, y, offset - 2, height);
            gc.setForeground(this.fBorderColorFg);
            gc.drawRectangle(left, y, width - 2, height);
            if (this.fShowScore) {
                boolean focused = (event.detail & 4) != 0;
                String text = this.fCachedFormat.format((double)Math.max(percentage, 1) / 100.0).intern();
                Point extent = gc.textExtent(text);
                gc.setBackground(background);
                gc.setForeground(selected && focused ? this.fColorWhite : this.fTextColorFg);
                gc.drawString(text, left + width + 5, event.y + (event.height - extent.y) / 2, true);
                gc.setBackground(background);
            }
        }
    }

    protected void erase(Event event, Object element) {
        if (event.index == 1) {
            event.detail &= 0xFFFFFFEF;
        }
    }
}

