/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryItem {
    private static final String PREF_HISTORY_ITEM_MEMENTO = "com.ibm.team.fulltext.ide.ui.internal.search.PrefHistoryItemMemento";
    private static final String PREF_HISTORY_ITEM_QUERY = "com.ibm.team.fulltext.ide.ui.internal.search.PrefHistoryItemQuery";
    private static final String PREF_HISTORY_ITEM_SCOPE_MEMENTO = "com.ibm.team.fulltext.ide.ui.internal.search.PrefHistoryItemScopeMemento";
    private static final String PREF_HISTORY_ITEM_SCOPE = "com.ibm.team.fulltext.ide.ui.internal.search.PrefHistoryItemScope";
    private String fQuery;
    private List<String> fSearchScope;

    public static void saveTo(IMemento memento, List<HistoryItem> items) {
        for (HistoryItem item : items) {
            IMemento child = memento.createChild(PREF_HISTORY_ITEM_MEMENTO);
            child.putString(PREF_HISTORY_ITEM_QUERY, item.getQuery());
            List<String> searchScope = item.getSearchScope();
            for (String scope : searchScope) {
                IMemento child2 = child.createChild(PREF_HISTORY_ITEM_SCOPE_MEMENTO);
                child2.putString(PREF_HISTORY_ITEM_SCOPE, scope);
            }
        }
    }

    public static List<HistoryItem> loadFrom(IMemento memento) {
        IMemento[] children;
        ArrayList<HistoryItem> items = new ArrayList<HistoryItem>();
        IMemento[] iMementoArray = children = memento.getChildren(PREF_HISTORY_ITEM_MEMENTO);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String query = child.getString(PREF_HISTORY_ITEM_QUERY);
            IMemento[] children2 = child.getChildren(PREF_HISTORY_ITEM_SCOPE_MEMENTO);
            ArrayList<String> scope = new ArrayList<String>();
            IMemento[] iMementoArray2 = children2;
            int n3 = children2.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento child2 = iMementoArray2[n4];
                scope.add(child2.getString(PREF_HISTORY_ITEM_SCOPE));
                ++n4;
            }
            items.add(new HistoryItem(query, scope));
            ++n2;
        }
        return items;
    }

    public HistoryItem(String query, List<String> searchScope) {
        this.fQuery = query;
        this.fSearchScope = searchScope;
    }

    public String getQuery() {
        return this.fQuery;
    }

    public List<String> getSearchScope() {
        return this.fSearchScope;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fQuery == null ? 0 : this.fQuery.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistoryItem other = (HistoryItem)obj;
        return !(this.fQuery == null ? other.fQuery != null : !this.fQuery.equals(other.fQuery));
    }
}

