/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.client.internal;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.client.IFullTextClientLibrary;
import com.ibm.team.fulltext.client.internal.Messages;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.fulltext.common.service.IFullTextService;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextClientLibraryImpl
implements IFullTextClientLibrary {
    private final IClientLibraryContext fContext;

    public FullTextClientLibraryImpl(IClientLibraryContext context) {
        this.fContext = context;
    }

    private IFullTextService getService() throws TeamRepositoryException {
        IFullTextService service = (IFullTextService)this.fContext.getServiceInterface(IFullTextService.class);
        if (service == null) {
            throw new TeamRepositoryException("Unable to get IFullTextService");
        }
        return service;
    }

    @Override
    public IScoredResult[] find(String text, String[] searchScope, String constrainType, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)text, (String)"The Text to search for must not be null!");
        if (monitor != null) {
            monitor.beginTask(NLS.bind((String)Messages.FullTextClientLibraryImpl_TEXT_SEARCH_PROGRESS, (Object[])new Object[]{text}), 100);
        }
        try {
            IFullTextService service = this.getService();
            if (monitor != null) {
                monitor.worked(20);
            }
            IScoredResult[] iScoredResultArray = service.find(text, searchScope, constrainType);
            return iScoredResultArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IScoredResult[] findDuplicate(URIReference like, String[] searchScope, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)like, (String)"The URIReference of the artifact to search duplicates for must not be null!");
        Assert.isNotNull((Object)like.getType(), (String)"The fulltext service can only work with references that provide a type that is not null!");
        if (monitor != null) {
            monitor.beginTask(NLS.bind((String)Messages.FullTextClientLibraryImpl_DUPLICATE_SEARCH_PROGRESS, (Object[])new Object[]{like.getName()}), 100);
        }
        try {
            IFullTextService service = this.getService();
            if (monitor != null) {
                monitor.worked(20);
            }
            IScoredResult[] iScoredResultArray = service.findDuplicateByReference(like.getURI().toString(), like.getType(), searchScope);
            return iScoredResultArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IScoredResult[] findDuplicate(String name, String content, String type, String[] searchScope, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)type, (String)"The type of the artifact to find duplicates for must not be null!");
        if (monitor != null) {
            monitor.beginTask(NLS.bind((String)Messages.FullTextClientLibraryImpl_DUPLICATE_SEARCH_PROGRESS, (Object[])new Object[]{name}), 100);
        }
        try {
            IFullTextService service = this.getService();
            if (monitor != null) {
                monitor.worked(20);
            }
            IScoredResult[] iScoredResultArray = service.findDuplicate(name, content, type, searchScope);
            return iScoredResultArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IScoredResult[] findRelated(URIReference like, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)like, (String)"The URIReference of the artifact to find related artifacts for must not be null!");
        Assert.isNotNull((Object)like.getType(), (String)"The fulltext service can only work with references that provide a type that is not null!");
        if (monitor != null) {
            monitor.beginTask(NLS.bind((String)Messages.FullTextClientLibraryImpl_RELATED_SEARCH_PROGRESS, (Object[])new Object[]{like.getName()}), 100);
        }
        try {
            IFullTextService service = this.getService();
            if (monitor != null) {
                monitor.worked(20);
            }
            IScoredResult[] iScoredResultArray = service.findRelatedByReference(like.getURI().toString(), like.getType());
            return iScoredResultArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public IScoredResult[] findRelated(String name, String content, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((name != null || content != null ? 1 : 0) != 0, (String)"Either name or content must not be null!");
        if (monitor != null) {
            monitor.beginTask(NLS.bind((String)Messages.FullTextClientLibraryImpl_RELATED_SEARCH_PROGRESS, (Object[])new Object[]{name}), 100);
        }
        try {
            IFullTextService service = this.getService();
            if (monitor != null) {
                monitor.worked(20);
            }
            IScoredResult[] iScoredResultArray = service.findRelated(name, content);
            return iScoredResultArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public Map<String, Integer> getTagFrequencies(String type, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)type);
        if (monitor != null) {
            monitor.beginTask(Messages.FullTextClientLibraryImpl_LOAD_TAG_FREQUENCIES, 100);
        }
        try {
            IFullTextService service = this.getService();
            if (monitor != null) {
                monitor.worked(20);
            }
            Map map = service.getTagFrequencies(type);
            return map;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

