/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions;

import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.HandlerUpdater;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.Messages;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPaneAction;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;

public class ViewerUndoAction
extends ViewerPaneAction {
    public ViewerUndoAction(String text, String tooltip, String cmdId, ImageDescriptor image) {
        super(text, tooltip, cmdId, image);
        this.update();
    }

    public ViewerUndoAction(String text, String tooltip, String cmdId, ImageDescriptor image, ViewerPart part) {
        super(text, tooltip, cmdId, image, part);
        this.update();
    }

    public void update() {
        if (this.getViewerPart() == null) {
            this.setEnabled(false);
            return;
        }
        IUndoContext undoContext = (IUndoContext)this.getViewerPart().getAdapter(IUndoContext.class);
        this.setEnabled(undoContext != null && OperationHistoryFactory.getOperationHistory().canUndo(undoContext));
    }

    public void run() {
        this.update();
        if (!this.isEnabled()) {
            return;
        }
        IUndoContext undoContext = (IUndoContext)this.getViewerPart().getAdapter(IUndoContext.class);
        if (undoContext != null) {
            try {
                OperationHistoryFactory.getOperationHistory().undo(undoContext, null, null);
            }
            catch (ExecutionException x) {
                FoundationIDEUIPlugin.getDefault().log(Messages.ViewerUndoAction_ERROR_UNDO, x);
            }
        }
    }

    public static void install(SourceViewer sourceViewer, HandlerUpdater handlerUpdater) {
        ViewerUndoAction action = new ViewerUndoAction(Messages.ViewerUndoAction_M_UNDO, Messages.ViewerUndoAction_UNDO, "org.eclipse.ui.edit.undo", null, new ViewerPart((Viewer)sourceViewer));
        handlerUpdater.addAction((IAction)action);
        handlerUpdater.updateInputChanged(action);
        handlerUpdater.updateOperationHistoryChanged(action);
    }
}

