/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SourceViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.IUpdate;

public class StyledEditingAction
extends Action
implements IUpdate {
    public static final String STYLED_EDITING_SCOPE = "com.ibm.magnolia.styledEditingScope";
    private IWorkbenchPart fPart;
    private ISourceViewer fSourceViewer;

    public StyledEditingAction(String text, String cmdId, ImageDescriptor image) {
        this.setText(text);
        this.setActionDefinitionId(cmdId);
        this.setImageDescriptor(image);
    }

    public StyledEditingAction(String text, String cmdId, ImageDescriptor image, IWorkbenchPart part) {
        this(text, cmdId, image);
        this.setPart(part);
    }

    public StyledEditingAction(String text, String cmdId, ImageDescriptor image, ISourceViewer sourceViewer) {
        this(text, cmdId, image);
        this.fSourceViewer = sourceViewer;
    }

    protected ISourceViewer getSourceViewer() {
        if (this.fSourceViewer != null) {
            return this.fSourceViewer;
        }
        if (this.fPart == null) {
            return null;
        }
        SourceViewerPane sourceViewerPane = (SourceViewerPane)this.fPart.getAdapter(SourceViewerPane.class);
        ViewerPane viewerPane = (ViewerPane)this.fPart.getAdapter(ViewerPane.class);
        if (sourceViewerPane == null || viewerPane == null) {
            return null;
        }
        ViewerPart viewerPart = viewerPane.getActiveViewerPart();
        if (viewerPart == null) {
            return null;
        }
        return sourceViewerPane.getSourceViewer(viewerPart.getControl());
    }

    public IWorkbenchPart getPart() {
        return this.fPart;
    }

    public void setPart(IWorkbenchPart part) {
        this.fPart = part;
    }

    public final void setHelpContextId(String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, contextId);
    }

    public void update() {
        this.setEnabled(this.getSourceViewer() != null);
    }

    protected boolean canModifyViewer() {
        return this.canModifyPart() && this.getSourceViewer() != null && this.getSourceViewer().isEditable();
    }

    protected boolean canModifyPart() {
        IWorkbenchPart part = this.getPart();
        if (part instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)part).isEditorInputModifiable();
        }
        if (part instanceof ITextEditorExtension) {
            return !((ITextEditorExtension)part).isEditorInputReadOnly();
        }
        if (part instanceof ITextEditor) {
            return ((ITextEditor)part).isEditable();
        }
        return true;
    }

    protected boolean validatePartInputState() {
        IWorkbenchPart part = this.getPart();
        if (part instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)part).validateEditorInputState();
        }
        if (part instanceof ITextEditorExtension) {
            return !((ITextEditorExtension)part).isEditorInputReadOnly();
        }
        if (part instanceof ITextEditor) {
            return ((ITextEditor)part).isEditable();
        }
        return true;
    }
}

