/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ActiveControlTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerUpdater {
    private IServiceLocator fServiceLocator;
    private ActiveControlTracker fActiveControlTracker;
    private SourceViewer fSourceViewer;
    private ISelectionProvider fSelectionProvider;
    private Control fControl;
    private Map<String, IHandler> fHandlers = new HashMap<String, IHandler>();
    private List<IHandlerActivation> fActivations = new ArrayList<IHandlerActivation>();
    private InternalListener fInternalListener = new InternalListener();
    private List<IUpdate> fInputChangedHandlers = new ArrayList<IUpdate>();
    private List<IUpdate> fSelectionChangedHandlers = new ArrayList<IUpdate>();
    private List<IUpdate> fOperationHistoryChangedHandlers = new ArrayList<IUpdate>();

    public HandlerUpdater(IServiceLocator serviceLocator, ActiveControlTracker activeControlTracker) {
        this.fServiceLocator = serviceLocator;
        this.fActiveControlTracker = activeControlTracker;
    }

    public void addAction(IAction action) {
        this.addHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
    }

    public void addHandler(String commandId, IHandler handler) {
        this.fHandlers.put(commandId, handler);
    }

    public void updateInputChanged(IUpdate handler) {
        this.fInputChangedHandlers.add(handler);
    }

    public void updateSelectionChanged(IUpdate handler) {
        this.fSelectionChangedHandlers.add(handler);
    }

    public void updateOperationHistoryChanged(IUpdate handler) {
        this.fOperationHistoryChangedHandlers.add(handler);
    }

    public void install(SourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
        this.fSourceViewer.addTextInputListener((ITextInputListener)this.fInternalListener);
        this.install((ISelectionProvider)sourceViewer, (Control)sourceViewer.getTextWidget(), false);
    }

    public void install(ISelectionProvider selectionProvider, Control control, boolean disposeWithControl) {
        this.fSelectionProvider = selectionProvider;
        this.fControl = control;
        if (disposeWithControl) {
            this.fControl.addDisposeListener((DisposeListener)this.fInternalListener);
        }
        this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fInternalListener);
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this.fInternalListener);
        this.fActiveControlTracker.addListener(this.fInternalListener);
    }

    public void uninstall() {
        this.deactivateHandlers();
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fInternalListener);
            this.fSelectionProvider = null;
        }
        if (this.fSourceViewer != null) {
            this.fSourceViewer.removeTextInputListener((ITextInputListener)this.fInternalListener);
            this.fSourceViewer = null;
        }
        if (this.fControl != null) {
            if (!this.fControl.isDisposed()) {
                this.fControl.removeDisposeListener((DisposeListener)this.fInternalListener);
            }
            this.fControl = null;
        }
        OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this.fInternalListener);
        this.fActiveControlTracker.removeListener(this.fInternalListener);
    }

    public void dispose() {
        this.uninstall();
        if (this.fHandlers != null) {
            for (IHandler handler : this.fHandlers.values()) {
                handler.dispose();
            }
            this.fHandlers = null;
        }
        this.fServiceLocator = null;
        this.fActiveControlTracker = null;
        this.fActivations = null;
        this.fInternalListener = null;
    }

    private void activateHandlers() {
        IHandlerService handlerService = (IHandlerService)this.fServiceLocator.getService(IHandlerService.class);
        for (Map.Entry<String, IHandler> entry : this.fHandlers.entrySet()) {
            IHandlerActivation activation = handlerService.activateHandler(entry.getKey(), entry.getValue());
            this.fActivations.add(activation);
        }
    }

    private void deactivateHandlers() {
        IHandlerService handlerService = (IHandlerService)this.fServiceLocator.getService(IHandlerService.class);
        handlerService.deactivateHandlers(this.fActivations);
        this.fActivations.clear();
    }

    private void update(List<IUpdate> handlers) {
        for (IUpdate handler : handlers) {
            handler.update();
        }
    }

    private class InternalListener
    extends ActiveControlTracker.ActiveControlListener
    implements ITextInputListener,
    ISelectionChangedListener,
    IOperationHistoryListener,
    DisposeListener {
        private InternalListener() {
        }

        public void activate(Control control) {
            if (control == HandlerUpdater.this.fControl) {
                HandlerUpdater.this.activateHandlers();
            }
        }

        public void deactivate(Control control) {
            if (control == HandlerUpdater.this.fControl) {
                HandlerUpdater.this.deactivateHandlers();
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            HandlerUpdater.this.update(HandlerUpdater.this.fInputChangedHandlers);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            HandlerUpdater.this.update(HandlerUpdater.this.fSelectionChangedHandlers);
        }

        public void historyNotification(OperationHistoryEvent event) {
            HandlerUpdater.this.update(HandlerUpdater.this.fOperationHistoryChangedHandlers);
        }

        public void widgetDisposed(DisposeEvent e) {
            HandlerUpdater.this.dispose();
        }
    }
}

