/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ActiveControlTracker;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.AnnotationAccess;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.EditorLinkDetector;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.Messages;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.PatchedStyledText;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerMenuListener;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledViewerConfiguration;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.TeamJFaceURIUtils;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ClipboardOperationAction;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.HandlerUpdater;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SelectAllHandler;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.StyleAction;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerRedoAction;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerUndoAction;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import com.ibm.team.jface.internal.util.TextViewerDecorator;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledTextViewerSupport {
    public static final String STYLED_EDITING_CONTEXT = "com.ibm.magnolia.styledEditingScope";
    public static final String BOLD_COMMAND_ID = "com.ibm.magnolia.edit.text.bold";
    public static final String ITALIC_COMMAND_ID = "com.ibm.magnolia.edit.text.italic";
    private static final int RULER_WIDTH = 6;
    private static MarkerAnnotationPreferences fgAnnotationPreferences;
    private SourceViewer fSourceViewer;
    private IOverviewRuler fOverviewRuler;
    private ProjectionSupport fProjectionSupport;
    private SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    private List<TextViewerDecorator> fTextDecorators = new ArrayList<TextViewerDecorator>();
    private EditorLinkDetector fEditorLinkDetector;
    private ResourceManager fResourceManager;
    private HandlerUpdater fHandlerUpdater;
    private SelectionUpdater fSelectionUpdater;
    private StructuredTextSelectionProvider fStructuredSelectionProvider;
    private DropTarget fDropTarget;
    private DelegatingDropAdapter fDropAdapter;
    private IMenuListener fContextMenuListener;
    private boolean fUseOverviewRuler = false;
    private boolean fUseProjectionViewer = false;
    private int fStyle = 66114;
    private Point fMargin = new Point(0, 0);
    private ITeamFormPartSite fSite;
    private boolean fEnableSpellChecking = true;

    public void setUseOverviewRuler(boolean useOverviewRuler) {
        this.fUseOverviewRuler = useOverviewRuler;
    }

    public void setUseProjectionViewer(boolean useProjectionViewer) {
        this.fUseProjectionViewer = useProjectionViewer;
    }

    public void setStyle(int style) {
        this.fStyle = style;
    }

    public void setMargin(Point margin) {
        this.fMargin = margin;
    }

    public void init(ITeamFormPartSite site) {
        this.fSite = site;
    }

    public void setEnableSpellChecking(boolean enableSpellChecking) {
        this.fEnableSpellChecking = enableSpellChecking;
    }

    public void createContent(Composite container) {
        this.fSourceViewer = this.createSourceViewer(container);
    }

    public SourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    public StructuredTextSelectionProvider getStructuredSelectionProvider() {
        return this.fStructuredSelectionProvider;
    }

    private SourceViewer createSourceViewer(Composite container) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        AnnotationAccess annotationAccess = new AnnotationAccess();
        this.fOverviewRuler = null;
        if (this.fUseOverviewRuler) {
            this.fOverviewRuler = new OverviewRuler((IAnnotationAccess)annotationAccess, 6, (ISharedTextColors)new InternalSharedTextColors());
            for (AnnotationPreference preference : StyledTextViewerSupport.getAnnotationPreferences().getAnnotationPreferences()) {
                if (!preference.contributesToHeader()) continue;
                this.fOverviewRuler.addHeaderAnnotationType(preference.getAnnotationType());
            }
        }
        IEmbeddedViewer sourceViewer = this.fUseProjectionViewer ? new EmbeddedProjectionViewer(container, (IVerticalRuler)new CompositeRuler(2), this.fOverviewRuler, this.fUseOverviewRuler, this.fStyle, this.fMargin) : new EmbeddedSourceViewer(container, null, this.fOverviewRuler, this.fUseOverviewRuler, this.fStyle, this.fMargin);
        ContextProvider contextProvider = null;
        if (this.fSite != null) {
            contextProvider = (ContextProvider)this.fSite.getAdapter(ContextProvider.class);
        }
        if (contextProvider == null) {
            StandardContextProvider provider = new StandardContextProvider(null);
            provider.setUIContext((Object)container.getShell());
            contextProvider = provider;
        }
        StyledViewerConfiguration configuration = new StyledViewerConfiguration(this.fResourceManager, contextProvider, this.fEnableSpellChecking);
        sourceViewer.configure(configuration);
        if (this.fUseProjectionViewer) {
            this.fProjectionSupport = new ProjectionSupport((ProjectionViewer)sourceViewer, (IAnnotationAccess)annotationAccess, (ISharedTextColors)new InternalSharedTextColors());
            this.fProjectionSupport.setAnnotationPainterDrawingStrategy((AnnotationPainter.IDrawingStrategy)new AnnotationPainter.NullStrategy());
            this.fProjectionSupport.install();
        }
        this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)sourceViewer, this.fOverviewRuler, (IAnnotationAccess)annotationAccess, (ISharedTextColors)new InternalSharedTextColors());
        Iterator iter = StyledTextViewerSupport.getAnnotationPreferences().getAnnotationPreferences().iterator();
        while (iter.hasNext()) {
            this.fSourceViewerDecorationSupport.setAnnotationPreference((AnnotationPreference)iter.next());
        }
        this.fSourceViewerDecorationSupport.install(EditorsUI.getPreferenceStore());
        this.fEditorLinkDetector = new EditorLinkDetector(contextProvider);
        this.fTextDecorators.add(this.fEditorLinkDetector);
        sourceViewer.getTextWidget().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (StyledTextViewerSupport.this.fSourceViewer == null) {
                    return;
                }
                if (((StyledTextViewerSupport)StyledTextViewerSupport.this).fSourceViewer.getTextWidget().getClientArea().width > 0) {
                    StyledTextViewerSupport.this.fSourceViewer.getTextWidget().removeControlListener((ControlListener)this);
                    for (TextViewerDecorator element : StyledTextViewerSupport.this.getTextViewerDecorators()) {
                        element.install((TextViewer)StyledTextViewerSupport.this.fSourceViewer);
                    }
                    StyledTextViewerSupport.this.fSourceViewer.invalidateTextPresentation();
                }
            }
        });
        this.fStructuredSelectionProvider = new StructuredTextSelectionProvider((ITextViewer)sourceViewer);
        if (this.fSite != null) {
            IServiceLocator serviceLocator = (IServiceLocator)this.fSite.getAdapter(IServiceLocator.class);
            ActiveControlTracker activeControlTracker = (ActiveControlTracker)this.fSite.getAdapter(ActiveControlTracker.class);
            if (serviceLocator != null && activeControlTracker != null) {
                this.fHandlerUpdater = new HandlerUpdater(serviceLocator, activeControlTracker);
                this.addActions(this.fHandlerUpdater, (SourceViewer)sourceViewer);
                this.fHandlerUpdater.install((SourceViewer)sourceViewer);
            }
            this.fSite.registerSelectionProvider((ISelectionProvider)sourceViewer, (Control)sourceViewer.getTextWidget());
            this.hookContextMenu(this.fSite, (ISourceViewer)sourceViewer);
            IWorkbenchPart part = (IWorkbenchPart)this.fSite.getAdapter(IWorkbenchPart.class);
            if (part != null && part.getSite().getSelectionProvider() != null) {
                this.fSelectionUpdater = new SelectionUpdater((SourceViewer)sourceViewer, part.getSite().getSelectionProvider());
            }
        }
        this.createDragSource((ISourceViewer)sourceViewer);
        this.fDropTarget = this.createDropTarget((ISourceViewer)sourceViewer);
        return sourceViewer;
    }

    private void addActions(HandlerUpdater handlerUpdater, SourceViewer sourceViewer) {
        ClipboardOperationAction.installCut(sourceViewer, handlerUpdater);
        ClipboardOperationAction.installCopy(sourceViewer, handlerUpdater);
        ClipboardOperationAction.installPaste(sourceViewer, handlerUpdater);
        StyleAction.installBold(sourceViewer, handlerUpdater);
        StyleAction.installItalic(sourceViewer, handlerUpdater);
        ViewerUndoAction.install(sourceViewer, handlerUpdater);
        ViewerRedoAction.install(sourceViewer, handlerUpdater);
        SelectAllHandler.install(sourceViewer, handlerUpdater);
    }

    public List<TextViewerDecorator> getTextViewerDecorators() {
        return this.fTextDecorators;
    }

    public DropTarget getDropTarget() {
        return this.fDropTarget;
    }

    public DelegatingDropAdapter getDropAdapter() {
        return this.fDropAdapter;
    }

    public IOverviewRuler getOverviewRuler() {
        return this.fOverviewRuler;
    }

    public void updateBaseURI() {
        this.fEditorLinkDetector.updateBaseURI();
    }

    public void dispose() {
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        if (this.getTextViewerDecorators() != null) {
            for (TextViewerDecorator decorator : this.getTextViewerDecorators()) {
                decorator.uninstall();
            }
            this.fTextDecorators = null;
        }
        if (this.fHandlerUpdater != null) {
            this.fHandlerUpdater.dispose();
            this.fHandlerUpdater = null;
        }
        if (this.fSelectionUpdater != null) {
            this.fSelectionUpdater.dispose();
            this.fSelectionUpdater = null;
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        this.fEditorLinkDetector = null;
        this.fSourceViewer = null;
        this.fOverviewRuler = null;
        this.fStructuredSelectionProvider = null;
    }

    public void setContextMenuListener(IMenuListener contextMenuListener) {
        this.fContextMenuListener = contextMenuListener;
    }

    private void hookContextMenu(ITeamFormPartSite site, ISourceViewer textViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)(this.fContextMenuListener != null ? this.fContextMenuListener : new StyledTextViewerMenuListener(this)));
        Menu menu = menuMgr.createContextMenu((Control)textViewer.getTextWidget());
        textViewer.getTextWidget().setMenu(menu);
        site.registerContextMenu(site.getId(null), menuMgr, (ISelectionProvider)this.getStructuredSelectionProvider());
    }

    private DragSource createDragSource(final ISourceViewer sourceViewer) {
        DragSource source = new DragSource((Control)sourceViewer.getTextWidget(), 1);
        source.setTransfer(new Transfer[]{HTMLTransfer.getInstance(), TextTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                if (sourceViewer.isEditable() || ((ITextSelection)sourceViewer.getSelectionProvider().getSelection()).getLength() == 0) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (HTMLTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = Utils.escapeForHTMLTransfer((String)this.getSelectedHTML().getXMLText());
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.getSelectedText();
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }

            private XMLString getSelectedHTML() {
                if (!(sourceViewer.getDocument() instanceof IStyledDocument)) {
                    return XMLString.createFromPlainText((String)this.getSelectedText());
                }
                try {
                    ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
                    return ((IStyledDocument)sourceViewer.getDocument()).getHTML(selection.getOffset(), selection.getLength());
                }
                catch (BadLocationException x) {
                    throw new RuntimeException(x);
                }
            }

            private String getSelectedText() {
                try {
                    ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
                    return sourceViewer.getDocument().get(selection.getOffset(), selection.getLength());
                }
                catch (BadLocationException x) {
                    throw new RuntimeException(x);
                }
            }
        });
        return source;
    }

    private DropTarget createDropTarget(ISourceViewer sourceViewer) {
        DropTarget target = new DropTarget((Control)sourceViewer.getTextWidget(), 7);
        target.setTransfer(new Transfer[]{URIReferenceTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), HTMLTransfer.getInstance(), TextTransfer.getInstance()});
        this.fDropAdapter = new DelegatingDropAdapter();
        this.fDropAdapter.addDropTargetListener((TransferDropTargetListener)new HTMLDropTargetListener((ITextViewer)sourceViewer));
        this.fDropAdapter.addDropTargetListener((TransferDropTargetListener)new TextDropTargetListener((ITextViewer)sourceViewer));
        this.fDropAdapter.addDropTargetListener((TransferDropTargetListener)new SelectionDropTargetListener((ITextViewer)sourceViewer));
        this.fDropAdapter.addDropTargetListener((TransferDropTargetListener)new URIReferenceDropTargetListener((ITextViewer)sourceViewer));
        target.addDropListener((DropTargetListener)this.fDropAdapter);
        return target;
    }

    private static MarkerAnnotationPreferences getAnnotationPreferences() {
        if (fgAnnotationPreferences == null) {
            fgAnnotationPreferences = new MarkerAnnotationPreferences();
        }
        return fgAnnotationPreferences;
    }

    private static class EmbeddedProjectionViewer
    extends ProjectionViewer
    implements IEmbeddedViewer {
        private boolean fShowVerticalRuler;
        private boolean fShowOverviewRuler;
        private final IVerticalRuler fVerticalRulerCache;
        private final IOverviewRuler fOverviewRulerCache;
        private final Point fMargin;
        private Caret fPreviousCaret;

        public EmbeddedProjectionViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, Point margin) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
            this.fVerticalRulerCache = verticalRuler;
            this.fOverviewRulerCache = overviewRuler;
            this.fMargin = margin;
            this.fShowVerticalRuler = this.fVerticalRulerCache != null;
            this.fShowOverviewRuler = this.fOverviewRulerCache != null && showAnnotationsOverview;
        }

        public void showAnnotations(boolean show) {
            this.fShowVerticalRuler = this.fVerticalRulerCache != null && show;
            super.showAnnotations(show);
        }

        public void showAnnotationsOverview(boolean show) {
            this.fShowOverviewRuler = this.fOverviewRulerCache != null && show;
            super.showAnnotationsOverview(show);
        }

        public boolean showsOverviewRuler() {
            return this.fOverviewRulerCache != null && this.fShowOverviewRuler;
        }

        public boolean showsVerticalRuler() {
            return this.fVerticalRulerCache != null && this.fShowVerticalRuler;
        }

        public IVerticalRuler getVerticalRulerCache() {
            return this.fVerticalRulerCache;
        }

        public IOverviewRuler getOverviewRulerCache() {
            return this.fOverviewRulerCache;
        }

        public Point getMargin() {
            return this.fMargin;
        }

        protected Layout createLayout() {
            return new EmbeddedRulerLayout(1, this);
        }

        public void setEditable(boolean editable) {
            StyledText textWidget = this.getTextWidget();
            if (textWidget != null) {
                if (editable && this.fPreviousCaret != null) {
                    if (textWidget.getCaret() == null) {
                        textWidget.setCaret(this.fPreviousCaret);
                    }
                    this.fPreviousCaret = null;
                } else if (!editable && this.fPreviousCaret == null) {
                    this.fPreviousCaret = textWidget.getCaret();
                    if (textWidget.getCaret() != null) {
                        textWidget.setCaret(null);
                    }
                }
            }
            super.setEditable(editable);
        }

        protected void handleDispose() {
            if (this.fPreviousCaret != null) {
                this.fPreviousCaret.dispose();
                this.fPreviousCaret = null;
            }
            super.handleDispose();
        }

        public IReconciler getReconciler() {
            return this.fReconciler;
        }
    }

    private static class EmbeddedRulerLayout
    extends Layout {
        private int fGap;
        private final IEmbeddedViewer fViewer;

        public EmbeddedRulerLayout(int gap, IEmbeddedViewer viewer) {
            this.fGap = gap;
            this.fViewer = viewer;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point margin;
            Control[] children = composite.getChildren();
            Point s = children[children.length - 1].computeSize(-1, -1, flushCache);
            if (this.fViewer.showsVerticalRuler()) {
                s.x += this.fViewer.getVerticalRulerCache().getWidth() + this.fGap;
            }
            if ((margin = this.fViewer.getMargin()) != null) {
                s.x += 2 * margin.x;
                s.y += 2 * margin.y;
            }
            return s;
        }

        protected void layout(Composite composite, boolean flushCache) {
            IVerticalRuler verticalRuler;
            IOverviewRuler overviewRuler;
            StyledText textWidget = this.fViewer.getTextWidget();
            Rectangle clArea = composite.getClientArea();
            Rectangle trim = textWidget.computeTrim(0, 0, 0, 0);
            int topTrim = -trim.y;
            int scrollbarHeight = trim.height - topTrim;
            int x = clArea.x;
            int width = clArea.width;
            Point margin = this.fViewer.getMargin();
            if (margin == null) {
                margin = new Point(0, 0);
            }
            if ((overviewRuler = this.fViewer.getOverviewRulerCache()) != null && this.fViewer.showsOverviewRuler()) {
                int overviewRulerWidth = overviewRuler.getWidth();
                overviewRuler.getControl().setBounds(clArea.x + clArea.width - margin.x - overviewRulerWidth - 1, clArea.y + margin.y + scrollbarHeight, overviewRulerWidth, clArea.height - 3 * scrollbarHeight);
                overviewRuler.getHeaderControl().setBounds(clArea.x + clArea.width - margin.x - overviewRulerWidth - 1, clArea.y + margin.y, overviewRulerWidth, scrollbarHeight);
                width -= overviewRulerWidth + this.fGap;
            }
            if ((verticalRuler = this.fViewer.getVerticalRulerCache()) != null && this.fViewer.showsVerticalRuler()) {
                int verticalRulerWidth = verticalRuler.getWidth();
                int magicVerticalAdjustment = 0;
                verticalRuler.getControl().setBounds(clArea.x + margin.x, clArea.y + topTrim + margin.y + magicVerticalAdjustment, verticalRulerWidth, clArea.height - scrollbarHeight - topTrim - magicVerticalAdjustment);
                x += verticalRulerWidth + this.fGap;
                width -= verticalRulerWidth + this.fGap;
            }
            textWidget.setBounds(x + margin.x, clArea.y + margin.y, width - 2 * margin.x, clArea.height - 2 * margin.y);
        }
    }

    private static class EmbeddedSourceViewer
    extends SourceViewer
    implements IEmbeddedViewer {
        private boolean fShowVerticalRuler;
        private boolean fShowOverviewRuler;
        private final IVerticalRuler fVerticalRulerCache;
        private final IOverviewRuler fOverviewRulerCache;
        private final Point fMargin;
        private Caret fPreviousCaret;

        public EmbeddedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, Point margin) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
            this.fVerticalRulerCache = verticalRuler;
            this.fOverviewRulerCache = overviewRuler;
            this.fMargin = margin;
            this.fShowVerticalRuler = this.fVerticalRulerCache != null;
            this.fShowOverviewRuler = this.fOverviewRulerCache != null && showAnnotationsOverview;
        }

        public void showAnnotations(boolean show) {
            this.fShowVerticalRuler = this.fVerticalRulerCache != null && show;
            super.showAnnotations(show);
        }

        public void showAnnotationsOverview(boolean show) {
            this.fShowOverviewRuler = this.fOverviewRulerCache != null && show;
            super.showAnnotationsOverview(show);
        }

        public boolean showsOverviewRuler() {
            return this.fOverviewRulerCache != null && this.fShowOverviewRuler;
        }

        public boolean showsVerticalRuler() {
            return this.fVerticalRulerCache != null && this.fShowVerticalRuler;
        }

        public IVerticalRuler getVerticalRulerCache() {
            return this.fVerticalRulerCache;
        }

        public IOverviewRuler getOverviewRulerCache() {
            return this.fOverviewRulerCache;
        }

        public Point getMargin() {
            return this.fMargin;
        }

        protected Layout createLayout() {
            return new EmbeddedRulerLayout(2, this);
        }

        protected void internalRevealRange(int start, int end) {
            StyledText textWidget = this.getTextWidget();
            Point location = textWidget.getLocationAtOffset(start);
            textWidget.setTopPixel(textWidget.getTopPixel() + location.y);
            textWidget.setHorizontalPixel(textWidget.getHorizontalPixel() + location.x);
        }

        public void setEditable(boolean editable) {
            StyledText textWidget = this.getTextWidget();
            if (textWidget != null) {
                if (editable && this.fPreviousCaret != null) {
                    if (textWidget.getCaret() == null) {
                        textWidget.setCaret(this.fPreviousCaret);
                    }
                    this.fPreviousCaret = null;
                } else if (!editable && this.fPreviousCaret == null) {
                    this.fPreviousCaret = textWidget.getCaret();
                    if (textWidget.getCaret() != null) {
                        textWidget.setCaret(null);
                    }
                }
            }
            super.setEditable(editable);
        }

        protected void handleDispose() {
            if (this.fPreviousCaret != null) {
                this.fPreviousCaret.dispose();
                this.fPreviousCaret = null;
            }
            super.handleDispose();
        }

        protected StyledText createTextWidget(Composite parent, int styles) {
            return new PatchedStyledText(parent, styles);
        }

        public IReconciler getReconciler() {
            return this.fReconciler;
        }
    }

    private static class HTMLDropTargetListener
    extends TextViewerDropTargetListener {
        public HTMLDropTargetListener(ITextViewer textViewer) {
            super(textViewer);
        }

        public Transfer getTransfer() {
            return HTMLTransfer.getInstance();
        }

        public boolean isEnabled(DropTargetEvent event) {
            return super.isEnabled(event) && (event.operations & 0x13) != 0;
        }

        public void drop(DropTargetEvent event) {
            try {
                ITextSelection textSelection = (ITextSelection)this.getTextViewer().getSelectionProvider().getSelection();
                IStyledDocument document = (IStyledDocument)this.getTextViewer().getDocument();
                document.replaceHTML(textSelection.getOffset(), 0, XMLString.createFromXMLText((String)((String)event.data)));
            }
            catch (BadLocationException x) {
                throw new RuntimeException(x);
            }
        }

        protected void updateOperation(DropTargetEvent event) {
            event.detail = (event.operations & 0x11) != 0 ? 1 : ((event.operations & 2) != 0 ? 2 : 0);
        }
    }

    static interface IEmbeddedViewer {
        public IVerticalRuler getVerticalRulerCache();

        public boolean showsVerticalRuler();

        public IOverviewRuler getOverviewRulerCache();

        public boolean showsOverviewRuler();

        public Point getMargin();

        public StyledText getTextWidget();

        public IReconciler getReconciler();
    }

    private class InternalSharedTextColors
    implements ISharedTextColors {
        private InternalSharedTextColors() {
        }

        public Color getColor(RGB rgb) {
            return StyledTextViewerSupport.this.fResourceManager.createColor(rgb);
        }

        public void dispose() {
        }
    }

    private static class SelectionDropTargetListener
    extends TextViewerDropTargetListener {
        public SelectionDropTargetListener(ITextViewer textViewer) {
            super(textViewer);
        }

        public Transfer getTransfer() {
            return LocalSelectionTransfer.getTransfer();
        }

        public boolean isEnabled(DropTargetEvent event) {
            return super.isEnabled(event) && (event.operations & 5) != 0;
        }

        public void drop(DropTargetEvent event) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            if (selection instanceof IStructuredSelection) {
                final IStructuredSelection structured = (IStructuredSelection)selection;
                UIUpdaterJob job = new UIUpdaterJob(Messages.StyledTextViewerSupport_PASTING_REFERENCES){
                    URIReference[] fReferences;

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        this.fReferences = TeamJFaceURIUtils.createURIReferences(structured.toArray(), null);
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        URIReference[] uRIReferenceArray = this.fReferences;
                        int n = this.fReferences.length;
                        int n2 = 0;
                        while (n2 < n) {
                            URIReference reference = uRIReferenceArray[n2];
                            SelectionDropTargetListener.this.pasteReference(reference);
                            ++n2;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }

        protected void updateOperation(DropTargetEvent event) {
            event.detail = (event.operations & 0x14) != 0 ? 4 : ((event.operations & 1) != 0 ? 1 : 0);
        }
    }

    private static class SelectionUpdater
    implements ISelectionChangedListener,
    FocusListener {
        private SourceViewer fSourceViewer;
        private ISelectionProvider fSelectionProvider;
        private ResourceManager fResourceManager;
        private Color fActiveSelection;
        private Color fInactiveSelection;

        public SelectionUpdater(SourceViewer sourceViewer, ISelectionProvider selectionProvider) {
            this.fSourceViewer = sourceViewer;
            this.fSelectionProvider = selectionProvider;
            this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            StyledText text = this.fSourceViewer.getTextWidget();
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
            this.fActiveSelection = text.getSelectionBackground();
            this.fInactiveSelection = this.fResourceManager.createColor(FormColors.blend((RGB)this.fActiveSelection.getRGB(), (RGB)new RGB(255, 255, 255), (int)41));
            text.addFocusListener((FocusListener)this);
            text.setSelectionBackground(this.fInactiveSelection);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Point range = this.fSourceViewer.getSelectedRange();
            if (range.y > 0 && this.fSourceViewer != event.getSource() && event.getSelection() instanceof ITextSelection && ((ITextSelection)event.getSelection()).getLength() > 0) {
                StyledText text = this.fSourceViewer.getTextWidget();
                boolean left = text.getCaretOffset() == text.getSelection().x;
                int offset = left ? range.x : range.x + range.y;
                this.fSourceViewer.setSelectedRange(offset, 0);
            }
        }

        public void focusGained(FocusEvent e) {
            StyledText text = this.fSourceViewer.getTextWidget();
            text.setSelectionBackground(this.fActiveSelection);
        }

        public void focusLost(FocusEvent e) {
            StyledText text = this.fSourceViewer.getTextWidget();
            text.setSelectionBackground(this.fInactiveSelection);
        }

        public void dispose() {
            if (this.fSelectionProvider != null) {
                this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                this.fSelectionProvider = null;
            }
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            if (this.fSourceViewer != null && this.fSourceViewer.getTextWidget() != null) {
                this.fSourceViewer.getTextWidget().removeFocusListener((FocusListener)this);
                this.fSourceViewer = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StructuredTextSelectionProvider
    implements ISelectionProvider,
    ITextInputListener,
    IDocumentListener,
    DisposeListener,
    Runnable {
        private static final int JOB_DELAY = 500;
        private ITextViewer fTextViewer;
        private Map<URI, Object> fReferencedObjectCache = new HashMap<URI, Object>();

        public StructuredTextSelectionProvider(ITextViewer textViewer) {
            this.fTextViewer = textViewer;
            this.fTextViewer.addTextInputListener((ITextInputListener)this);
            if (this.fTextViewer.getDocument() != null) {
                this.inputDocumentChanged(null, this.fTextViewer.getDocument());
            }
            this.fTextViewer.getTextWidget().addDisposeListener((DisposeListener)this);
        }

        public void widgetDisposed(DisposeEvent e) {
            this.fTextViewer.removeTextInputListener((ITextInputListener)this);
            if (this.fTextViewer.getDocument() != null) {
                this.inputDocumentAboutToBeChanged(this.fTextViewer.getDocument(), null);
            }
            this.fTextViewer = null;
            this.fReferencedObjectCache.clear();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput instanceof IStyledDocument) {
                oldInput.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void inputDocumentChanged(IDocument oldInput, final IDocument newInput) {
            if (newInput instanceof IStyledDocument) {
                newInput.addDocumentListener((IDocumentListener)this);
                this.fTextViewer.getTextWidget().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (StructuredTextSelectionProvider.this.fTextViewer != null) {
                            StructuredTextSelectionProvider.this.update((IStyledDocument)newInput, 0, newInput.getLength());
                        }
                    }
                });
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.update((IStyledDocument)event.getDocument(), event.getOffset(), event.getText().length());
        }

        private void update(IStyledDocument styledDocument, int offset, int length) {
            if (this.fTextViewer != null && this.fTextViewer.getTextWidget() != null) {
                this.fTextViewer.getTextWidget().getDisplay().timerExec(500, (Runnable)this);
            }
        }

        @Override
        public void run() {
            if (this.fTextViewer == null || this.fTextViewer.getTextWidget() == null || !(this.fTextViewer.getDocument() instanceof IStyledDocument)) {
                return;
            }
            IStyledDocument styledDocument = (IStyledDocument)this.fTextViewer.getDocument();
            HashSet<URI> uris = new HashSet<URI>();
            this.addUnknown(uris, styledDocument.getReferencePositions(false));
            this.addUnknown(uris, styledDocument.getReferencePositions(true));
            if (!uris.isEmpty()) {
                this.resolveInBackground(uris);
            }
        }

        private void addUnknown(Set<URI> uris, ReferencePosition[] referencePositions) {
            ReferencePosition[] referencePositionArray = referencePositions;
            int n = referencePositions.length;
            int n2 = 0;
            while (n2 < n) {
                ReferencePosition referencePosition = referencePositionArray[n2];
                URI uri = referencePosition.getReference();
                if (!this.fReferencedObjectCache.containsKey(uri)) {
                    this.fReferencedObjectCache.put(uri, null);
                    uris.add(uri);
                }
                ++n2;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            Object element = this.objectUnderMouse(this.fTextViewer);
            if (element != null) {
                return new StructuredSelection(element);
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }

        private Object objectUnderMouse(ITextViewer textViewer) {
            int offsetAtLocation;
            if (!(textViewer.getDocument() instanceof IStyledDocument)) {
                return null;
            }
            StyledText textWidget = textViewer.getTextWidget();
            Display d = textWidget.getDisplay();
            Control cursorControl = d.getCursorControl();
            if (cursorControl != textWidget) {
                return null;
            }
            Point cursorLocation = d.getCursorLocation();
            Point point = textWidget.toControl(cursorLocation);
            try {
                offsetAtLocation = textWidget.getOffsetAtLocation(point);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            try {
                Object object;
                ReferencePosition[] positions = ((IStyledDocument)textViewer.getDocument()).getReferencePositions(offsetAtLocation, 1, true);
                if (positions.length > 0 && (object = this.getReferencedObject(positions[0].getReference())) != null) {
                    return object;
                }
                positions = ((IStyledDocument)textViewer.getDocument()).getReferencePositions(offsetAtLocation, 1, false);
                if (positions.length > 0 && (object = this.getReferencedObject(positions[0].getReference())) != null) {
                    return object;
                }
            }
            catch (BadLocationException x) {
                FoundationIDEUIPlugin.getDefault().log(x.getMessage(), x);
            }
            return null;
        }

        private Object getReferencedObject(URI uri) {
            if (!this.fReferencedObjectCache.containsKey(uri)) {
                this.resolveInBackground(Collections.singleton(uri));
                return null;
            }
            return this.fReferencedObjectCache.get(uri);
        }

        private void resolveInBackground(final Set<URI> uris) {
            FoundationJob job = new FoundationJob(Messages.StyledTextViewerSupport_RESOLVING_URIS){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    HashMap<ITeamRepository, ArrayList<URI>> resolve = new HashMap<ITeamRepository, ArrayList<URI>>();
                    for (URI uRI : uris) {
                        Location location;
                        ITeamRepository teamRepository = ClientURIUtils.findTeamRepository((URI)uRI);
                        if (teamRepository == null) continue;
                        try {
                            location = Location.location((URI)uRI);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            continue;
                        }
                        IItemHandle handle = location.getItemHandle();
                        if (handle == null) {
                            ArrayList<URI> list = (ArrayList<URI>)resolve.get(teamRepository);
                            if (list == null) {
                                list = new ArrayList<URI>();
                                resolve.put(teamRepository, list);
                            }
                            list.add(uRI);
                            continue;
                        }
                        if (handle.getOrigin() == null) {
                            ((ItemHandle)handle).setOrigin((Object)teamRepository);
                        }
                        StructuredTextSelectionProvider.this.fReferencedObjectCache.put(uRI, handle);
                    }
                    for (Map.Entry entry : resolve.entrySet()) {
                        try {
                            IItemManager itemManager = ((ITeamRepository)entry.getKey()).itemManager();
                            List uris2 = (List)entry.getValue();
                            ArrayList<Location> locations = new ArrayList<Location>();
                            for (URI uri : uris2) {
                                locations.add(Location.location((URI)uri));
                            }
                            List items = itemManager.fetchPartialItemsByLocation(locations, 0, (Collection)Collections.emptyList(), monitor);
                            int i = 0;
                            while (i < uris2.size()) {
                                IItem item = (IItem)items.get(i);
                                if (item != null) {
                                    StructuredTextSelectionProvider.this.fReferencedObjectCache.put((URI)uris2.get(i), item.getItemHandle());
                                }
                                ++i;
                            }
                        }
                        catch (TeamRepositoryException x) {
                            FoundationIDEUIPlugin.getDefault().log("Exception resolving URIs", x);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private static class TextDropTargetListener
    extends TextViewerDropTargetListener {
        public TextDropTargetListener(ITextViewer textViewer) {
            super(textViewer);
        }

        public Transfer getTransfer() {
            return TextTransfer.getInstance();
        }

        public boolean isEnabled(DropTargetEvent event) {
            return super.isEnabled(event) && (event.operations & 0x13) != 0;
        }

        public void drop(DropTargetEvent event) {
            try {
                ITextSelection textSelection = (ITextSelection)this.getTextViewer().getSelectionProvider().getSelection();
                IDocument document = this.getTextViewer().getDocument();
                document.replace(textSelection.getOffset(), 0, (String)event.data);
            }
            catch (BadLocationException x) {
                throw new RuntimeException(x);
            }
        }

        protected void updateOperation(DropTargetEvent event) {
            event.detail = (event.operations & 0x11) != 0 ? 1 : ((event.operations & 2) != 0 ? 2 : 0);
        }
    }

    private static abstract class TextViewerDropTargetListener
    implements TransferDropTargetListener {
        private ITextViewer fTextViewer;

        public TextViewerDropTargetListener(ITextViewer textViewer) {
            this.fTextViewer = textViewer;
        }

        protected abstract void updateOperation(DropTargetEvent var1);

        protected ITextViewer getTextViewer() {
            return this.fTextViewer;
        }

        public boolean isEnabled(DropTargetEvent event) {
            return this.fTextViewer.isEditable();
        }

        public void dragEnter(DropTargetEvent event) {
            this.updateOperation(event);
            if (!this.getTextViewer().getTextWidget().isFocusControl()) {
                this.getTextViewer().getTextWidget().setFocus();
            }
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.updateOperation(event);
        }

        public void dragOver(DropTargetEvent event) {
            try {
                StyledText text = this.getTextViewer().getTextWidget();
                int offset = text.getOffsetAtLocation(text.toControl(event.x, event.y));
                Point selectedRange = this.getTextViewer().getSelectedRange();
                if (selectedRange.x != offset || selectedRange.y != 0) {
                    this.getTextViewer().setSelectedRange(offset, 0);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        protected void pasteReference(final URIReference reference) {
            try {
                ITextViewer textViewer = this.getTextViewer();
                if (textViewer == null || textViewer.getTextWidget().isDisposed()) {
                    return;
                }
                ISelectionProvider selectionProvider = textViewer.getSelectionProvider();
                final String label = reference.getName();
                String newDocText = String.valueOf(label) + " ";
                ITextSelection textSelection = (ITextSelection)selectionProvider.getSelection();
                final int offset = textSelection.getOffset();
                final IDocument document = textViewer.getDocument();
                if (document == null) {
                    return;
                }
                if (document instanceof IStyledDocument) {
                    document.addPrenotifiedDocumentListener(new IDocumentListener(){

                        public void documentAboutToBeChanged(DocumentEvent event) {
                        }

                        public void documentChanged(DocumentEvent event) {
                            try {
                                document.removePrenotifiedDocumentListener((IDocumentListener)this);
                                ((IStyledDocument)document).setReferencePosition(new ReferencePosition(offset, label.length(), ClientURIUtils.toPublicRepositoryURI((URI)reference.getURI()), false));
                            }
                            catch (BadLocationException x) {
                                FoundationIDEUIPlugin.getDefault().log(x.getMessage(), x);
                            }
                        }
                    });
                }
                document.replace(offset, textSelection.getLength(), newDocText);
                selectionProvider.setSelection((ISelection)new TextSelection(offset + newDocText.length(), 0));
            }
            catch (BadLocationException x) {
                FoundationIDEUIPlugin.getDefault().log("Bad location", x);
            }
        }

        public void dropAccept(DropTargetEvent event) {
        }
    }

    private static class URIReferenceDropTargetListener
    extends TextViewerDropTargetListener {
        public URIReferenceDropTargetListener(ITextViewer textViewer) {
            super(textViewer);
        }

        public Transfer getTransfer() {
            return URIReferenceTransfer.getInstance();
        }

        public boolean isEnabled(DropTargetEvent event) {
            return super.isEnabled(event) && (event.operations & 5) != 0;
        }

        public void drop(DropTargetEvent event) {
            Object data = event.data;
            if (data instanceof URIReference[]) {
                URIReference[] references;
                URIReference[] uRIReferenceArray = references = (URIReference[])data;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    URIReference reference = uRIReferenceArray[n2];
                    this.pasteReference(reference);
                    ++n2;
                }
            }
        }

        protected void updateOperation(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = (event.operations & 4) != 0 ? 4 : 0;
            }
        }
    }
}

