/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.Messages;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiHyperlinkHandler
extends HyperlinkHandler {
    private static final String MULTI_SCHEME = "multi";

    public boolean handles(URI uri) {
        return MULTI_SCHEME.equals(uri.getScheme());
    }

    public void open(URI uri, ContextProvider context) {
        final ArrayList<URI> uris = new ArrayList<URI>();
        String encoded = uri.toString().substring(uri.toString().indexOf("://") + 3);
        String all = URLDecoder.decode(encoded);
        String[] stringArray = all.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            try {
                URI partUri = new URI(URLDecoder.decode(part));
                uris.add(partUri);
            }
            catch (URISyntaxException uRISyntaxException) {}
            ++n2;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell = Display.getCurrent().getActiveShell();
                MultiURIPopupDialog d = new MultiURIPopupDialog(shell, uris);
                d.open();
            }
        });
    }

    public static URI createMultiURI(List<URI> uris) {
        StringBuffer content = new StringBuffer();
        for (URI uri : uris) {
            content.append(URLEncoder.encode(uri.toString()));
            content.append("/");
        }
        String allEncoded = URLEncoder.encode(content.toString());
        URI result = null;
        try {
            result = new URI("multi://" + allEncoded);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiURIPopupDialog
    extends PopupDialog {
        private Composite fComposite;
        private List<URI> fUris;
        private Map<URI, String> names = new HashMap<URI, String>();

        public MultiURIPopupDialog(Shell shell, List<URI> uris) {
            super(shell, 0, true, false, false, false, Messages.MultiHyperlinkHandler_POSSIBLE_LINKS, null);
            this.fUris = uris;
        }

        protected Control createDialogArea(Composite parent) {
            this.fComposite = (Composite)super.createDialogArea(parent);
            this.fComposite.setLayout((Layout)new GridLayout(2, false));
            Label res = new Label(this.fComposite, 0);
            res.setText(Messages.MultiHyperlinkHandler_RESOLVING);
            UIUpdaterJob job = new UIUpdaterJob(Messages.MultiHyperlinkHandler_RESOLVING_ITEMS){

                public IStatus runInBackground(IProgressMonitor monitor) {
                    StandardLabelProvider p = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
                    for (URI uri : MultiURIPopupDialog.this.fUris) {
                        try {
                            Location location = Location.location((URI)uri);
                            ITeamRepository teamRepository = ClientURIUtils.findTeamRepository((URI)uri);
                            IItem item = teamRepository.itemManager().fetchCompleteItem(location, 0, monitor);
                            String name = p.getText((Object)item);
                            if (name != null && !name.equals("")) {
                                MultiURIPopupDialog.this.names.put(uri, name);
                                continue;
                            }
                            MultiURIPopupDialog.this.names.put(uri, uri.toString());
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            MultiURIPopupDialog.this.names.put(uri, uri.toString());
                        }
                    }
                    p.dispose();
                    return Status.OK_STATUS;
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (MultiURIPopupDialog.this.fComposite == null || MultiURIPopupDialog.this.fComposite.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    Control[] controlArray = MultiURIPopupDialog.this.fComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        c.dispose();
                        ++n2;
                    }
                    HyperlinkGroup group = new HyperlinkGroup(Display.getCurrent());
                    group.setForeground(Display.getCurrent().getSystemColor(9));
                    group.setActiveForeground(Display.getCurrent().getSystemColor(9));
                    group.setHyperlinkUnderlineMode(3);
                    for (URI u : MultiURIPopupDialog.this.names.keySet()) {
                        Label la = new Label(MultiURIPopupDialog.this.fComposite, 0);
                        la.setBackground(MultiURIPopupDialog.this.fComposite.getBackground());
                        la.setLayoutData((Object)new GridData());
                        ITeamRepository repo = ClientURIUtils.findTeamRepository((URI)u);
                        if (repo != null) {
                            la.setText(String.valueOf(repo.getName()) + ": ");
                        }
                        Hyperlink l = new Hyperlink(MultiURIPopupDialog.this.fComposite, 0);
                        group.add(l);
                        l.setText((String)MultiURIPopupDialog.this.names.get(u));
                        l.setHref((Object)u);
                        l.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent e) {
                                if (e.getHref() instanceof URI) {
                                    Hyperlinks.openHyperlink((URI)((URI)e.getHref()));
                                }
                            }
                        });
                    }
                    MultiURIPopupDialog.this.fComposite.layout();
                    Point size = MultiURIPopupDialog.this.getShell().computeSize(-1, -1, true);
                    Rectangle b = MultiURIPopupDialog.this.getShell().getBounds();
                    MultiURIPopupDialog.this.getShell().setBounds(b.x, b.y, size.x, size.y);
                    group.setBackground(MultiURIPopupDialog.this.fComposite.getBackground());
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            return this.fComposite;
        }

        protected void adjustBounds() {
            Point cursor = Display.getDefault().getCursorLocation();
            Rectangle b = this.getShell().getBounds();
            int w = Math.max(b.width, 120);
            this.getShell().setBounds(cursor.x, cursor.y + 10, w, b.height);
        }
    }
}

