/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.Messages;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;

public class HyperlinkPositionDetector
implements IHyperlinkDetector {
    private String[] fHyperlinkPositionCategories;
    private ContextProvider fContextProvider;

    public HyperlinkPositionDetector(String[] hyperlinkPositionCategories, ContextProvider contextProvider) {
        this.fHyperlinkPositionCategories = hyperlinkPositionCategories;
        this.fContextProvider = contextProvider;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<Hyperlink> hyperlinks;
        block9: {
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return null;
            }
            try {
                hyperlinks = new ArrayList<Hyperlink>();
                int i = 0;
                while (i < this.fHyperlinkPositionCategories.length) {
                    String category = this.fHyperlinkPositionCategories[i];
                    Position[] positions = document.getPositions(category);
                    int j = 0;
                    int n = positions.length;
                    while (j < n) {
                        ReferencePosition position;
                        if (positions[j] instanceof ReferencePosition && (position = (ReferencePosition)positions[j]).overlapsWith(region.getOffset(), region.getLength())) {
                            if (canShowMultipleHyperlinks) {
                                hyperlinks.add(new Hyperlink(position, document));
                            } else {
                                return new IHyperlink[]{new Hyperlink(position, document)};
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                if (hyperlinks.size() != 0) break block9;
                return null;
            }
            catch (BadPositionCategoryException x) {
                FoundationIDEUIPlugin.getDefault().log(x.getMessage(), x);
                return null;
            }
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    class Hyperlink
    implements IHyperlink {
        private ReferencePosition fReferencePosition;
        private IDocument fDocument;

        public Hyperlink(ReferencePosition position, IDocument document) {
            this.fReferencePosition = position;
            this.fDocument = document;
        }

        public URI getReference() {
            return this.fReferencePosition.getReference();
        }

        public IRegion getHyperlinkRegion() {
            return new Region(this.fReferencePosition.getOffset(), this.fReferencePosition.getLength());
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            String label;
            URI reference = this.fReferencePosition.getReference();
            try {
                label = this.fDocument.get(this.fReferencePosition.getOffset(), this.fReferencePosition.getLength());
            }
            catch (BadLocationException e) {
                FoundationIDEUIPlugin.getDefault().log(e.getMessage(), e);
                label = Messages.HyperlinkPositionDetector_HYPERLINK;
            }
            StandardContextProvider contextProvider = HyperlinkPositionDetector.this.fContextProvider != null ? new StandardContextProvider(null, HyperlinkPositionDetector.this.fContextProvider.getContext()) : null;
            Hyperlinks.openHyperlink((URI)reference, contextProvider, (String)label);
        }
    }
}

