/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.foundation.common.URILinkDetector;
import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.MultiHyperlinkHandler;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.TextDecorator;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.internal.text.DocumentUtils;
import com.ibm.team.foundation.rcp.core.internal.text.SyntheticDelimiterPosition;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;

public class EditorLinkDetector
extends TextDecorator {
    private static final String SYNTHETIC_DELIMITER_CATEGORY = SyntheticDelimiterPosition.SYNTHETIC_DELIMITER_CATEGORY;
    private List<ReferencePosition> fReferencePositions = new ArrayList<ReferencePosition>();
    private LinkDetector fDetector;
    private ContextProvider fContextProvider;
    private ITextViewer fTextViewer;
    private LinkDetector.ILinkDetectorListener fLinkDetectorListener;

    public EditorLinkDetector(ContextProvider contextProvider) {
        this.fContextProvider = contextProvider;
    }

    protected void update(IStyledDocument document, IRegion range) throws BadLocationException {
        if (this.fDetector == null) {
            return;
        }
        Position[] syntheticDelimiters = new Position[]{};
        if (document.containsPositionCategory(SYNTHETIC_DELIMITER_CATEGORY)) {
            try {
                syntheticDelimiters = document.getPositions(SYNTHETIC_DELIMITER_CATEGORY);
            }
            catch (BadPositionCategoryException x) {
                FoundationIDEUIPlugin.getDefault().log("Unexpected Exception", x);
            }
        }
        int begin = document.getLineOfOffset(range.getOffset());
        int end = document.getLineOfOffset(range.getOffset() + range.getLength());
        if (syntheticDelimiters.length > 0) {
            begin = this.findStartLine(document, begin, syntheticDelimiters);
            end = this.findEndLine(document, end, syntheticDelimiters);
        }
        try {
            int deletionOffset = document.getLineInformation(begin).getOffset();
            IRegion deletionRange = document.getLineInformation(end);
            int deletionLength = deletionRange.getOffset() + deletionRange.getLength() - deletionOffset;
            ReferencePosition[] deletionPositions = document.getReferencePositions(deletionOffset, deletionLength, true);
            int i = 0;
            while (i < deletionPositions.length) {
                ReferencePosition position = deletionPositions[i];
                if (this.fReferencePositions.contains(position)) {
                    document.removeReferencePosition(position);
                    this.fReferencePositions.remove(position);
                }
                ++i;
            }
            int line = begin;
            while (line <= end) {
                int endLine;
                IRegion lineInfo = document.getLineInformation(line);
                int offset = lineInfo.getOffset();
                int length = lineInfo.getLength();
                Position[] containedDelimiters = new Position[]{};
                if (syntheticDelimiters.length > 0 && (endLine = this.findEndLine(document, line, syntheticDelimiters)) > line) {
                    line = endLine;
                    lineInfo = document.getLineInformation(line);
                    length = lineInfo.getOffset() + lineInfo.getLength() - offset;
                    containedDelimiters = DocumentUtils.getPositions((Position[])syntheticDelimiters, (int)offset, (int)length);
                }
                String text = document.get(offset, length);
                if (containedDelimiters.length > 0) {
                    StringBuilder builder = new StringBuilder(text);
                    int i2 = containedDelimiters.length - 1;
                    while (i2 >= 0) {
                        Position delimiter = containedDelimiters[i2];
                        int tmp = delimiter.getOffset() - offset;
                        builder.replace(tmp, tmp + delimiter.getLength(), SyntheticDelimiterPosition.getOriginal((Position)delimiter));
                        --i2;
                    }
                    text = builder.toString();
                }
                List results = this.fDetector.match(text);
                for (DetectedTextLink result : results) {
                    List uris = result.createURIs();
                    if (uris.size() == 0) continue;
                    URI uri = uris.size() > 1 ? MultiHyperlinkHandler.createMultiURI(uris) : (URI)uris.get(0);
                    int positionOffset = offset + result.getOffset();
                    int positionLength = result.getLength();
                    if (containedDelimiters.length > 0) {
                        Position[] positionArray = containedDelimiters;
                        int n = containedDelimiters.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Position delimiter = positionArray[n2];
                            if (delimiter.getOffset() <= positionOffset) {
                                positionOffset += delimiter.getLength() - SyntheticDelimiterPosition.getOriginal((Position)delimiter).length();
                            } else {
                                if (delimiter.getOffset() >= positionOffset + positionLength) break;
                                positionLength += delimiter.getLength() - SyntheticDelimiterPosition.getOriginal((Position)delimiter).length();
                            }
                            ++n2;
                        }
                    }
                    ReferencePosition position = new ReferencePosition(positionOffset, positionLength, uri, true);
                    document.setReferencePosition(position);
                    this.fReferencePositions.add(position);
                }
                ++line;
            }
        }
        catch (BadLocationException x) {
            FoundationIDEUIPlugin.getDefault().log("Exception during document manipulation", x);
        }
    }

    private int findStartLine(IStyledDocument document, int line, Position[] syntheticDelimiters) throws BadLocationException {
        while (line > 0) {
            int offset = document.getLineOffset(line);
            int i = DocumentUtils.getLeftIndexAtOffset((Position[])syntheticDelimiters, (int)offset);
            if (i == -1 || syntheticDelimiters[i].getOffset() + syntheticDelimiters[i].getLength() != offset) {
                return line;
            }
            --line;
        }
        return line;
    }

    private int findEndLine(IStyledDocument document, int line, Position[] syntheticDelimiters) throws BadLocationException {
        while (line < document.getNumberOfLines() - 1) {
            IRegion info = document.getLineInformation(line);
            int offset = info.getOffset() + info.getLength();
            int i = DocumentUtils.getRightIndexAtOffset((Position[])syntheticDelimiters, (int)offset);
            if (i == syntheticDelimiters.length || syntheticDelimiters[i].getOffset() != offset) {
                return line;
            }
            ++line;
        }
        return line;
    }

    public void updateBaseURI() {
        this.createLinkDetector();
        if (this.fContextProvider != null && this.fContextProvider.findContext() != null) {
            URI uri = this.fContextProvider.findContext().getURI();
            this.fDetector.setBaseURI(uri);
        }
    }

    public void install(TextViewer textViewer) {
        this.createLinkDetector();
        this.fTextViewer = textViewer;
        this.fLinkDetectorListener = new LinkDetectorListener();
        this.fDetector.addListener(this.fLinkDetectorListener);
        super.install(textViewer);
    }

    public void uninstall() {
        if (this.fDetector != null) {
            if (this.fLinkDetectorListener != null) {
                this.fDetector.removeListener(this.fLinkDetectorListener);
                this.fLinkDetectorListener = null;
            }
            this.fDetector.dispose();
            this.fDetector = null;
        }
        if (this.fTextViewer != null) {
            this.fTextViewer = null;
        }
        super.uninstall();
    }

    protected void createLinkDetector() {
        if (this.fDetector == null) {
            this.fDetector = TextLinkDetectorManager.getDefault().createLinkDetector();
            this.fDetector.addTextLinkDetector((TextLinkDetector)new URILinkDetector());
        }
    }

    private class LinkDetectorListener
    implements LinkDetector.ILinkDetectorListener {
        private LinkDetectorListener() {
        }

        public void linkDetectorChanged() {
            if (EditorLinkDetector.this.fTextViewer != null && EditorLinkDetector.this.fTextViewer.getDocument() != null && !EditorLinkDetector.this.fTextViewer.getTextWidget().isDisposed()) {
                EditorLinkDetector.this.fTextViewer.getTextWidget().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (EditorLinkDetector.this.fTextViewer != null && EditorLinkDetector.this.fTextViewer.getDocument() != null && !EditorLinkDetector.this.fTextViewer.getTextWidget().isDisposed()) {
                            try {
                                EditorLinkDetector.this.update((IStyledDocument)EditorLinkDetector.this.fTextViewer.getDocument(), (IRegion)new Region(0, EditorLinkDetector.this.fTextViewer.getDocument().getLength()));
                                EditorLinkDetector.this.fTextViewer.invalidateTextPresentation();
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                });
            }
        }
    }
}

