/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2008. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  
 * Use, duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp. 
 *******************************************************************************/
package junit.swingui;

import javax.swing.ListModel;

import junit.framework.Test;

/**
 * The interface for accessing the Test run context. Test run views
 * should use this interface rather than accessing the TestRunner
 * directly.
 */
public interface TestRunContext {
	/**
	 * Handles the selection of a Test.
	 */
	public void handleTestSelected(Test test);
	/**
	 * Returns the failure model
	 */
	public ListModel getFailures();
}