/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2008. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  
 * Use, duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp. 
 *******************************************************************************/
package junit.runner;

import java.awt.Component; 

import junit.framework.*;

/**
 * A view to show a details about a failure
 */
public interface FailureDetailView {
	/**
	 * Returns the component used to present the TraceView
	 */
	public Component getComponent();
	/**
	 * one liner
	 * 
	 * Shows details of a TestFailure
	 */
	public void showFailure(TestFailure failure);
	/**
	 * Clears the view
	 */
	public void clear();
}