/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;

public final class ParmsMoveAcrossComponentRequest
implements IParameterWrapper {
    public ParmsWorkspace workspace;
    public String sourceComponentItemId;
    public String[] toMoveFolderItemIds;
    public String targetComponentItemId;
    public String[] parentFolderItemIds;
    public String sourceChangeSetComment;
    public String targetChangeSetComment;

    public IComponentHandle getSourceComponentHandle() {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.sourceComponentItemId), null);
    }

    public IComponentHandle getTargetComponentHandle() {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.targetComponentItemId), null);
    }

    public IFolderHandle[] getToMoveFolderHandles() {
        return this.getFolderHandles(this.toMoveFolderItemIds);
    }

    public IFolderHandle[] getParentFolderHandles() {
        return this.getFolderHandles(this.parentFolderItemIds);
    }

    private IFolderHandle[] getFolderHandles(String[] folderItemIds) {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        IFolderHandle[] folderHandles = new IFolderHandle[folderItemIds.length];
        int i = 0;
        while (i < folderItemIds.length) {
            folderHandles[i] = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)folderItemIds[i]), null);
            ++i;
        }
        return folderHandles;
    }

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        ParmValidation.requiredValue(this.toMoveFolderItemIds, requestName, parameterName, "toMoveFolderItemIds");
        ParmValidation.requiredValue(this.parentFolderItemIds, requestName, parameterName, "parentFolderItemIds");
        if (this.toMoveFolderItemIds.length != this.parentFolderItemIds.length) {
            throw new IllegalArgumentException(NLS.bind((String)"The {0} and {1} must be in 1-1 correspondence", (Object[])new Object[]{ParmValidation.getParameterName(parameterName, "toMoveFolderItemIds"), ParmValidation.getParameterName(parameterName, "parentFolderItemIds")}));
        }
        int i = 0;
        while (i < this.toMoveFolderItemIds.length) {
            ParmValidation.requiredValue(this.toMoveFolderItemIds[i], requestName, parameterName, "toMoveFolderItemIds", i);
            ParmValidation.requiredValue(this.parentFolderItemIds[i], requestName, parameterName, "parentFolderItemIds", i);
            ++i;
        }
        ParmValidation.requiredValue(this.sourceComponentItemId, requestName, parameterName, "sourceComponentItemId");
        ParmValidation.requiredValue(this.targetComponentItemId, requestName, parameterName, "targetComponentItemId");
    }
}

