/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.IPersistentFlag;
import com.ibm.team.filesystem.client.internal.utils.PersistentFlag;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.MultiStatus;

public class PersistentBusyFlag {
    private static final boolean BUSY = false;
    private static final boolean COMPLETE = true;
    private final IPersistentFlag wrapped;

    public PersistentBusyFlag(File file) {
        this.wrapped = new PersistentFlag(file);
    }

    public boolean isBusy() {
        return !this.wrapped.getState();
    }

    public void setBusy(MultiStatus multi) {
        try {
            this.wrapped.setState(false);
        }
        catch (IOException e) {
            multi.add(FileSystemStatus.getStatusFor(2, NLS.bind((String)Messages.PersistentBusyFlag_0, (Object[])new Object[]{this}), (Throwable)e));
        }
    }

    public void setComplete(MultiStatus multi) {
        try {
            this.wrapped.setState(true);
        }
        catch (IOException e) {
            if (multi == null) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(2, Messages.PersistentBusyFlag_1, (Throwable)e));
            }
            multi.add(FileSystemStatus.getStatusFor(2, NLS.bind((String)Messages.PersistentBusyFlag_2, (Object[])new Object[]{this}), e.getCause()));
        }
    }
}

