/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.era.EraSyncReportFragment;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReportFragment;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotSyncReport {
    private SnapshotSyncReportFragment incoming;
    private SnapshotSyncReportFragment outgoing;

    public SnapshotSyncReport(SnapshotSyncReportFragment incoming, SnapshotSyncReportFragment outgoing) {
        this.incoming = incoming;
        this.outgoing = outgoing;
    }

    public SnapshotSyncReportFragment getIncoming() {
        return this.incoming;
    }

    public SnapshotSyncReportFragment getOutgoing() {
        return this.outgoing;
    }

    public Set<ItemId<IComponent>> getModifiedComponents(FlowType flowType) {
        HashSet result = NewCollection.hashSet();
        if (flowType != FlowType.Outgoing) {
            for (Map.Entry<ItemId<IComponent>, ComponentSyncReportFragment> next : this.incoming.getComponentModifications().entrySet()) {
                if (next.getValue().isEmpty()) continue;
                result.add(next.getKey());
            }
        }
        if (flowType != FlowType.Incoming) {
            for (Map.Entry<ItemId<IComponent>, ComponentSyncReportFragment> next : this.outgoing.getComponentModifications().entrySet()) {
                if (next.getValue().isEmpty()) continue;
                result.add(next.getKey());
            }
        }
        return result;
    }

    public SetDiff<ItemId<IComponent>> getComponentChanges(FlowType flowType) {
        if (flowType == FlowType.Incoming) {
            return this.incoming.getComponentChanges();
        }
        if (flowType == FlowType.Outgoing) {
            return this.outgoing.getComponentChanges();
        }
        HashSet outgoingAdditions = new HashSet();
        HashSet outgoingRemovals = new HashSet();
        SetDiff<ItemId<IComponent>> incomingChanges = this.incoming.getComponentChanges();
        SetDiff<ItemId<IComponent>> outgoingChanges = this.outgoing.getComponentChanges();
        outgoingAdditions.addAll(incomingChanges.getRemovals());
        outgoingRemovals.addAll(incomingChanges.getAdditions());
        outgoingAdditions.addAll(outgoingChanges.getAdditions());
        outgoingRemovals.addAll(outgoingChanges.getRemovals());
        return SetDiff.create(outgoingRemovals, outgoingAdditions);
    }

    public SnapshotSyncReportFragment get(FlowType type) {
        if (type == FlowType.Incoming) {
            return this.getIncoming();
        }
        return this.getOutgoing();
    }

    public Set<ItemId<IComponent>> getAffectedComponents() {
        HashSet result = NewCollection.hashSet();
        result.addAll(this.incoming.getAffectedComponents());
        result.addAll(this.outgoing.getAffectedComponents());
        return result;
    }

    public static SnapshotSyncReport generateSyncReport(ITeamRepository repo, List<ItemId<IChangeSet>> incomingChangeSets, List<ItemId<IChangeSet>> outgoingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List incomingChangeSetIds = ItemLocator.idsToLocators(RepositoryNamespace.create(repo), incomingChangeSets);
        List outgoingChangeSetIds = ItemLocator.idsToLocators(RepositoryNamespace.create(repo), outgoingChangeSets);
        Set changeSetsToFetch = NewCollection.hashSet();
        changeSetsToFetch.addAll(incomingChangeSetIds);
        changeSetsToFetch.addAll(outgoingChangeSetIds);
        Map changeSets = ItemFetcher.fetchCurrents(changeSetsToFetch, false, (IProgressMonitor)progress.newChild(10));
        SnapshotSyncReportFragment incomingReport = SnapshotSyncReportFragment.createFromChangeSets(CollectionUtil.reorderValues(changeSets, incomingChangeSetIds));
        SnapshotSyncReportFragment outgoingReport = SnapshotSyncReportFragment.createFromChangeSets(CollectionUtil.reorderValues(changeSets, outgoingChangeSetIds));
        return new SnapshotSyncReport(incomingReport, outgoingReport);
    }

    public static SnapshotSyncReport createFrom(IChangeHistorySyncReport syncReport) {
        List localComponents = ItemLists.handlesToIds((Collection)syncReport.localComponents());
        List remoteComponents = ItemLists.handlesToIds((Collection)syncReport.remoteComponents());
        SetDiff componentDiff = SetDiff.computeDiff((Collection)localComponents, (Collection)remoteComponents);
        Map<ItemId<IComponent>, ItemId<IBaseline>> incomingBaselines = SnapshotSyncReport.getBasisMap(syncReport.remoteBases());
        Map<ItemId<IComponent>, ItemId<IBaseline>> outgoingBaselines = SnapshotSyncReport.getBasisMap(syncReport.localBases());
        Map incomingReports = NewCollection.hashMap();
        for (ItemId localComponent : localComponents) {
            if (componentDiff.getRemovals().contains(localComponent)) continue;
            IComponentHandle componentHandle = (IComponentHandle)localComponent.toHandle();
            ItemId<IBaseline> commonBaseline = SnapshotSyncReport.getBaselineHandle(syncReport.commonBaseline(componentHandle));
            List differentBaselines = ItemLists.handlesToIds((Collection)syncReport.incomingBaselines(componentHandle));
            List incomingAfterBasis = ItemLists.handlesToIds((Collection)syncReport.incomingChangeSetsAfterBasis(componentHandle));
            List allIncomingChangeSets = ItemLists.handlesToIds((Collection)syncReport.incomingChangeSets(componentHandle));
            incomingReports.put(localComponent, new ComponentSyncReportFragment(differentBaselines, commonBaseline, new EraSyncReportFragment(incomingAfterBasis), allIncomingChangeSets));
        }
        Map outgoingReports = NewCollection.hashMap();
        for (ItemId remoteComponent : remoteComponents) {
            if (componentDiff.getAdditions().contains(remoteComponent)) continue;
            IComponentHandle componentHandle = (IComponentHandle)remoteComponent.toHandle();
            ItemId<IBaseline> commonBaseline = SnapshotSyncReport.getBaselineHandle(syncReport.commonBaseline(componentHandle));
            List differentBaselines = ItemLists.handlesToIds((Collection)syncReport.outgoingBaselines(componentHandle));
            List outgoingChangeSets = ItemLists.handlesToIds((Collection)syncReport.outgoingChangeSetsAfterBasis(componentHandle));
            List allOutgoingChangeSets = ItemLists.handlesToIds((Collection)syncReport.outgoingChangeSets(componentHandle));
            outgoingReports.put(remoteComponent, new ComponentSyncReportFragment(differentBaselines, commonBaseline, new EraSyncReportFragment(outgoingChangeSets), allOutgoingChangeSets));
        }
        return new SnapshotSyncReport(new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)SetDiff.create((Collection)Collections.EMPTY_SET, (Collection)componentDiff.getAdditions()), incomingReports, incomingBaselines), new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)SetDiff.create((Collection)Collections.EMPTY_SET, (Collection)componentDiff.getRemovals()), outgoingReports, outgoingBaselines));
    }

    private static ItemId<IBaseline> getBaselineHandle(IBaselineHandle commonBaseline) {
        if (commonBaseline == null) {
            return ItemId.getNullItem((IItemType)IBaseline.ITEM_TYPE);
        }
        return ItemId.create((IItemHandle)commonBaseline);
    }

    private static Map<ItemId<IComponent>, ItemId<IBaseline>> getBasisMap(Map<IComponentHandle, IBaselineHandle> remoteBases) {
        Map result = NewCollection.hashMap();
        for (Map.Entry<IComponentHandle, IBaselineHandle> nextEntry : remoteBases.entrySet()) {
            result.put(new ItemId((IItemHandle)nextEntry.getKey()), new ItemId((IItemHandle)nextEntry.getValue()));
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.incoming == null ? 0 : this.incoming.hashCode());
        result = 31 * result + (this.outgoing == null ? 0 : this.outgoing.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotSyncReport other = (SnapshotSyncReport)obj;
        if (this.incoming == null ? other.incoming != null : !this.incoming.equals(other.incoming)) {
            return false;
        }
        return !(this.outgoing == null ? other.outgoing != null : !this.outgoing.equals(other.outgoing));
    }
}

