/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateRequest;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.AcceptSuspendedChangeSetException;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.ActiveChangeSetsOverlapException;
import com.ibm.team.scm.common.ChangeSetAlreadyInHistoryException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspaceUpdateOperation
extends ChangeHistoryChangeSetsOperation
implements IWorkspaceUpdateOperation {
    private static final int ACCEPT_CHANGE_SETS = 1;
    private static final int ACCEPT_COMBINED = 2;
    private static final int RESUME = 3;
    private int acceptFlags;
    protected HashMap<IWorkspaceConnection, List<WorkspaceUpdateRequest>> acceptRequests;
    private final WorkspaceUpdateDilemmaHandler problemHandler;
    private Set<ConfigurationDescriptor> componentsAdded;
    private Set<ConfigurationDescriptor> componentsRemoved;
    private boolean redundantChangeSets;
    private boolean resumedChangeSets;
    private boolean problemsEncountered;

    public WorkspaceUpdateOperation(WorkspaceUpdateDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? WorkspaceUpdateDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? WorkspaceUpdateDilemmaHandler.getDefault() : dilemmaHandler;
        this.acceptRequests = new HashMap();
        this.componentsAdded = new HashSet<ConfigurationDescriptor>();
        this.componentsRemoved = new HashSet<ConfigurationDescriptor>();
        this.redundantChangeSets = false;
        this.resumedChangeSets = false;
        this.acceptFlags = 0;
        this.problemsEncountered = false;
    }

    public void setPreflight(boolean preflight) {
        this.acceptFlags = preflight ? 1 : 0;
    }

    public boolean isPreflightOnly() {
        return (this.acceptFlags & 1) == 1;
    }

    @Override
    public void acceptChangeSets(IWorkspaceConnection workspace, List<? extends IChangeSetHandle> changeSets) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (changeSets == null) {
            throw new IllegalArgumentException("Change sets to accept must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (!request.isChangeSetContext()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest == null) {
            existingRequests.add(new WorkspaceUpdateRequest(workspace, changeSets));
        } else {
            existingRequest.addChangeSets(changeSets);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, List<? extends IBaselineHandle> baselines, List<? extends IChangeSetHandle> changeSets, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("Sync compare report must not be null");
        }
        if (baselines == null) {
            throw new IllegalArgumentException("Baselines to accept must not be null");
        }
        if (changeSets == null) {
            throw new IllegalArgumentException("Change sets to accept must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Components to accept must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addBaselines(baselines);
            existingRequest.addChangeSets(changeSets);
            existingRequest.addComponents(components, false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, baselines, changeSets, components);
            existingRequests.add(request);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("Sync compare report must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, false);
            existingRequests.add(request);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("Sync compare report must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Components must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, components, false);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IProgressMonitor progress) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        IFlowTable flowTable = workspace.getFlowTable();
        ITeamRepository repository = workspace.teamRepository();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)flowTable.acceptSources().size());
        for (IFlowEntry flowEntry : flowTable.acceptSources()) {
            IFlowNodeHandle source = flowEntry.getFlowNode();
            if (!(source instanceof IWorkspaceHandle)) continue;
            IWorkspaceConnection sourceWorkspace = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection((IWorkspaceHandle)source, (IProgressMonitor)monitor.newChild(1));
            ArrayList componentScopes = new ArrayList(flowTable.getComponentScopes(source));
            if (componentScopes.isEmpty()) {
                this.replace(workspace, sourceWorkspace);
                continue;
            }
            this.replace(workspace, sourceWorkspace, componentScopes);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IBaselineSetHandle sourceSnapshot, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceSnapshot == null) {
            throw new IllegalArgumentException("Source snapshot must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Components must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceSnapshot.sameItemId((IItemHandle)request.getSourceSnapshot())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceSnapshot, components);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || sourceWorkspace != request.getSourceWorkspace()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, null, true);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("Source workspace must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("Components must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, null, components, true);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IBaselineConnection sourceBaseline) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceBaseline == null) {
            throw new IllegalArgumentException("Source snapshot must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || request.getSourceBaseline() == null || !sourceBaseline.getBaseline().sameItemId((IItemHandle)request.getSourceBaseline().getBaseline())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceBaseline);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IBaselineSetHandle sourceSnapshot) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (sourceSnapshot == null) {
            throw new IllegalArgumentException("Source snapshot must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceSnapshot.sameItemId((IItemHandle)request.getSourceSnapshot())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceSnapshot);
            existingRequests.add(request);
        }
    }

    @Override
    public void addComponent(IWorkspaceConnection workspace, String newComponentName) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (newComponentName == null) {
            throw new IllegalArgumentException("New Component name must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addNewComponent(newComponentName);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, newComponentName);
            existingRequests.add(request);
        }
    }

    @Override
    public void addComponent(IWorkspaceConnection workspace, IComponentHandle component) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addNewComponent(component);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, component, true);
            existingRequests.add(request);
        }
    }

    @Override
    public void removeComponent(IWorkspaceConnection workspace, IComponentHandle component) {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.removeComponent(component);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, component, false);
            existingRequests.add(request);
        }
    }

    @Override
    protected void execute(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.WorkspaceUpdateOperation_5, (int)(10 + 30 * this.acceptRequests.size()));
        this.problemsEncountered = false;
        ArrayList determinants = new ArrayList();
        HashSet<IContextHandle> affectedContexts = new HashSet<IContextHandle>();
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        this.getAffectedConfigurations(affectedContexts, affectedConfigurations, (IProgressMonitor)monitor.newChild(2));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, affectedContexts, determinants);
        try {
            try {
                if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
                    IVerifyInSyncOperation verifyOp = this.getVerifyOperation(this.problemHandler);
                    for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                        verifyOp.addToVerify(configurationDescriptor.getConnection(null), configurationDescriptor.componentHandle);
                    }
                    verifyOp.run((IProgressMonitor)monitor.newChild(this.acceptRequests.size()));
                }
                final HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports = new HashMap<IWorkspaceConnection, List<IUpdateReport>>();
                this.runPreConditions(affectedConfigurations, (IProgressMonitor)monitor.newChild(8));
                for (Map.Entry entry : this.acceptRequests.entrySet()) {
                    IWorkspaceConnection workspace = (IWorkspaceConnection)entry.getKey();
                    List requests = (List)entry.getValue();
                    if (!this.isPreflightOnly()) {
                        this.performComponentOperations(workspace, requests, updateReports, (IProgressMonitor)monitor.newChild(5));
                    }
                    SubMonitor iterProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(14), (int)(10 * requests.size()));
                    for (WorkspaceUpdateRequest acceptRequest : requests) {
                        this.performAcceptRequest(acceptRequest, updateReports, (IProgressMonitor)iterProgress.newChild(10));
                        if (this.problemsEncountered) break;
                        this.checkCancelled((IProgressMonitor)monitor);
                    }
                    if (this.problemsEncountered) break;
                }
                if (!this.isPreflightOnly()) {
                    IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                        public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + updateReports.size() * 10));
                            if (!WorkspaceUpdateOperation.this.componentsRemoved.isEmpty()) {
                                try {
                                    IFileSystemOperation op = WorkspaceUpdateOperation.this.getUnshareProjectsOperation(WorkspaceUpdateOperation.this.componentsRemoved);
                                    op.run((IProgressMonitor)monitor.newChild(10));
                                }
                                catch (TeamRepositoryException e) {
                                    WorkspaceUpdateOperation.this.collectStatus(FileSystemStatus.getStatusFor(e));
                                }
                                catch (FileSystemClientException e) {
                                    WorkspaceUpdateOperation.this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                                }
                            }
                            for (Map.Entry entry : updateReports.entrySet()) {
                                IFileSystemOperation updateOperation = WorkspaceUpdateOperation.this.getUpdateOperation((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), 3, WorkspaceUpdateOperation.this.problemHandler);
                                WorkspaceUpdateOperation.this.disableVerifyInSync(updateOperation);
                                try {
                                    updateOperation.run((IProgressMonitor)monitor.newChild(10));
                                }
                                catch (FileSystemClientException e) {
                                    WorkspaceUpdateOperation.this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                                }
                                catch (TeamRepositoryException e) {
                                    WorkspaceUpdateOperation.this.collectStatus(FileSystemStatus.getStatusFor(e));
                                }
                            }
                        }
                    };
                    this.runWithinFileSystemLock(iRunnableWithProgress, (IProgressMonitor)monitor.newChild(10 * this.acceptRequests.size()));
                }
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof TeamRepositoryException) {
                    throw (TeamRepositoryException)throwable;
                }
                if (throwable instanceof FileSystemClientException) {
                    throw (FileSystemClientException)((Object)throwable);
                }
                throw new TeamRepositoryException(Messages.AcceptOperation_1, throwable);
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    @Override
    public void runPreConditionsOnly(IProgressMonitor progress) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.WorkspaceUpdateOperation_3, (int)(10 + 10 * this.acceptRequests.size()));
        ArrayList determinants = new ArrayList();
        HashSet<IContextHandle> affectedContexts = new HashSet<IContextHandle>();
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        this.getAffectedConfigurations(affectedContexts, affectedConfigurations, (IProgressMonitor)monitor.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, affectedContexts, determinants);
        try {
            try {
                if (this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
                    IVerifyInSyncOperation verifyOp = this.getVerifyOperation(this.problemHandler);
                    for (ConfigurationDescriptor configuration : affectedConfigurations) {
                        verifyOp.addToVerify(configuration.getConnection(null), configuration.componentHandle);
                    }
                    verifyOp.run((IProgressMonitor)monitor.newChild(this.acceptRequests.size()));
                }
                this.runPreConditions(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
            }
            catch (FileSystemClientException e) {
                throw new TeamRepositoryException((Throwable)((Object)e));
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    @Override
    public Collection<ConfigurationDescriptor> getComponentsAdded() {
        return this.componentsAdded;
    }

    private void performComponentOperations(IWorkspaceConnection workspace, List<WorkspaceUpdateRequest> requests, HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(5 + 10 * requests.size()));
        ArrayList<Object> componentOps = new ArrayList<Object>();
        for (WorkspaceUpdateRequest acceptRequest : requests) {
            acceptRequest.createNewComponents((IProgressMonitor)monitor.newChild(1));
            componentOps.addAll(acceptRequest.getComponentOperations((IProgressMonitor)monitor.newChild(1)));
            componentOps.addAll(acceptRequest.getReplaceCandidates((IProgressMonitor)monitor.newChild(1)));
        }
        this.checkCancelled((IProgressMonitor)monitor);
        if (!componentOps.isEmpty()) {
            IUpdateReport updateReport = workspace.applyComponentOperations(componentOps, true, (IProgressMonitor)monitor.newChild(5));
            this.holdUpdateReport(workspace, updateReport, updateReports);
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                Collection<IFlowNodeConnection.IComponentOp> componentOpsDone = acceptRequest.getComponentOperations((IProgressMonitor)monitor.newChild(1));
                SubMonitor iterProgress = monitor.newChild(6);
                iterProgress.setWorkRemaining(componentOpsDone.size());
                for (IFlowNodeConnection.IComponentOp componentOp : componentOpsDone) {
                    if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        if (acceptRequest.getSourceWorkspace() != null && acceptRequest.getWorkspace().getFlowTable().getDeliverFlow((IFlowNodeHandle)acceptRequest.getSourceWorkspace().getResolvedWorkspace()) != null) {
                            FlowUtils.addComponentSyncState((IWorkspaceConnection)workspace, (IConnection)acceptRequest.getSourceWorkspace(), (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)iterProgress.newChild(1));
                        }
                        this.componentsAdded.add(new ConfigurationDescriptor((IConnection)workspace, componentOp.getComponent()));
                        continue;
                    }
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    if (acceptRequest.getSourceWorkspace() != null && acceptRequest.getWorkspace().getFlowTable().getDeliverFlow((IFlowNodeHandle)acceptRequest.getSourceWorkspace().getResolvedWorkspace()) != null) {
                        FlowUtils.removeComponentSyncState((IWorkspaceConnection)acceptRequest.getWorkspace(), (IConnection)acceptRequest.getSourceWorkspace(), (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)iterProgress.newChild(1));
                    }
                    this.componentsRemoved.add(new ConfigurationDescriptor((IConnection)workspace, componentOp.getComponent()));
                }
            }
        }
    }

    private void runPreConditions(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)50);
        this.verifyComponentFlowing((IProgressMonitor)monitor.newChild(10));
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, (IProgressMonitor)monitor.newChild(10));
        this.verifyReplaceComponents((IProgressMonitor)monitor.newChild(10));
        this.disconnectedComponents(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
        this.validateRequests((IProgressMonitor)monitor.newChild(10));
    }

    private void verifyReplaceComponents(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + 10 * this.acceptRequests.size()));
        HashSet<ConfigurationDescriptor> replaceConfigurations = new HashSet<ConfigurationDescriptor>();
        HashMap replaces = new HashMap();
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(10), (int)(10 * requests.size()));
            for (WorkspaceUpdateRequest request : requests) {
                Collection<IFlowNodeConnection.IComponentReplacementOp> componentOps = request.getReplaceCandidates((IProgressMonitor)iterProgress.newChild(10));
                ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
                for (IFlowNodeConnection.IComponentReplacementOp op : componentOps) {
                    replaceConfigurations.add(new ConfigurationDescriptor((IConnection)request.getWorkspace(), op.getComponent()));
                    components.add(op.getComponent());
                }
                replaces.put(request, components);
            }
        }
        if (!replaceConfigurations.isEmpty()) {
            int direction = this.getAcceptDilemmaHandler().componentReplacementCandidates(replaceConfigurations);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction != 0) {
                if (direction == 3) {
                    SubMonitor iterProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(10), (int)replaces.size());
                    for (Map.Entry entry : replaces.entrySet()) {
                        WorkspaceUpdateRequest acceptRequest = (WorkspaceUpdateRequest)entry.getKey();
                        acceptRequest.excludeComponentOps((List)entry.getValue(), (IProgressMonitor)iterProgress.newChild(1));
                    }
                } else {
                    throw new TeamRepositoryException(Messages.WorkspaceUpdateOperation_1);
                }
            }
        }
    }

    private void getAffectedConfigurations(Set<IContextHandle> workspacesToLock, Set<ConfigurationDescriptor> configurationsAffected, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.acceptRequests.size());
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterMonitor = monitor.newChild(1).setWorkRemaining(requests.size() * 2);
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                configurationsAffected.addAll(acceptRequest.getAffectedConfigurations((IProgressMonitor)iterMonitor.newChild(1)));
                for (IFlowNodeConnection.IComponentOp componentOp : acceptRequest.getComponentOperations((IProgressMonitor)iterMonitor.newChild(1))) {
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) && !(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    workspacesToLock.add(acceptRequest.getWorkspace().getContextHandle());
                    break;
                }
                if (acceptRequest.getNewComponentNames().isEmpty()) continue;
                workspacesToLock.add(acceptRequest.getWorkspace().getContextHandle());
            }
        }
    }

    private void disconnectedComponents(Set<ConfigurationDescriptor> configurationsAffected, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.acceptRequests.size());
        HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>(configurationsAffected);
        CopyFileAreaStore cfa = this.getCopyFileArea();
        Collection<LoadedConfigurationDescriptor> configurationsLoaded = cfa.allLoadedComponents((IProgressMonitor)monitor.newChild(1));
        for (LoadedConfigurationDescriptor configuration : configurationsLoaded) {
            configurations.remove(new ConfigurationDescriptor(configuration.id, configuration.uri, configuration.connectionHandle, configuration.componentHandle));
        }
        if (!configurations.isEmpty()) {
            int reaction = this.problemHandler.disconnectedComponents(configurations);
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            if (reaction != 0) {
                throw new TeamRepositoryException(Messages.WorkspaceUpdateOperation_2);
            }
        }
    }

    private void validateRequests(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 * this.acceptRequests.size()));
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterProgress = monitor.newChild(10).setWorkRemaining(requests.size() * 10);
            HashSet<UUID> componentsAffected = new HashSet<UUID>();
            for (WorkspaceUpdateRequest request : requests) {
                HashSet<UUID> componentIds = new HashSet<UUID>();
                Collection<ConfigurationDescriptor> configurations = request.getAffectedConfigurations((IProgressMonitor)iterProgress.newChild(1));
                for (ConfigurationDescriptor configuration : configurations) {
                    componentIds.add(configuration.componentHandle.getItemId());
                }
                Collection<IFlowNodeConnection.IComponentOp> componentOps = request.getComponentOperations((IProgressMonitor)iterProgress.newChild(1));
                for (IFlowNodeConnection.IComponentOp op : componentOps) {
                    componentIds.add(op.getComponent().getItemId());
                }
                for (UUID id : componentIds) {
                    if (componentsAffected.add(id)) continue;
                    IComponent component = (IComponent)request.getWorkspace().teamRepository().itemManager().fetchCompleteItem(IComponent.ITEM_TYPE.createItemHandle(id, null), 0, (IProgressMonitor)iterProgress.newChild(1));
                    throw new TeamRepositoryException(NLS.bind((String)Messages.WorkspaceUpdateOperation_4, (Object[])new Object[]{component.getName(), request.getWorkspace().getResolvedWorkspace().getName()}));
                }
            }
        }
    }

    private void performAcceptRequest(WorkspaceUpdateRequest acceptRequest, HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports, IProgressMonitor progress) throws TeamRepositoryException {
        int paranoiaCheck = 10;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + 15 * paranoiaCheck));
        ArrayList<IChangeSetHandle> changeSetsToAccept = new ArrayList<IChangeSetHandle>(acceptRequest.getChangeSets((IProgressMonitor)monitor.newChild(1)));
        ArrayList<IBaselineHandle> baselinesToAccept = new ArrayList<IBaselineHandle>(acceptRequest.getBaselines((IProgressMonitor)monitor.newChild(1)));
        if (!changeSetsToAccept.isEmpty() || !baselinesToAccept.isEmpty()) {
            boolean retryAccept = true;
            int staleDataRetries = 0;
            ArrayList<IChangeSetHandle> toResume = new ArrayList<IChangeSetHandle>();
            while (retryAccept && !this.problemsEncountered && paranoiaCheck-- > 0) {
                this.checkCancelled((IProgressMonitor)monitor);
                retryAccept = false;
                int action = 0;
                try {
                    IUpdateReport updateReport;
                    if (acceptRequest.isChangeSetContext() && baselinesToAccept.isEmpty() && !changeSetsToAccept.isEmpty()) {
                        action = 1;
                        updateReport = acceptRequest.getWorkspace().accept(this.acceptFlags, changeSetsToAccept, (IProgressMonitor)monitor.newChild(8));
                        this.holdUpdateReport(acceptRequest.getWorkspace(), updateReport, updateReports);
                        changeSetsToAccept.clear();
                    } else if (!changeSetsToAccept.isEmpty() || !baselinesToAccept.isEmpty()) {
                        action = 2;
                        updateReport = acceptRequest.getWorkspace().accept(this.acceptFlags, acceptRequest.getSyncReport((IProgressMonitor)monitor.newChild(1)), baselinesToAccept, changeSetsToAccept, (IProgressMonitor)monitor.newChild(7));
                        this.holdUpdateReport(acceptRequest.getWorkspace(), updateReport, updateReports);
                        changeSetsToAccept.clear();
                        baselinesToAccept.clear();
                    }
                    if (toResume.isEmpty()) continue;
                    action = 3;
                    updateReport = acceptRequest.getWorkspace().resume(this.acceptFlags, toResume, (IProgressMonitor)monitor.newChild(4));
                    this.holdUpdateReport(acceptRequest.getWorkspace(), updateReport, updateReports);
                    this.resumedChangeSets = true;
                    toResume.clear();
                }
                catch (ActiveChangeSetsOverlapException e) {
                    retryAccept = this.handleActiveChangeSetsOverlap(acceptRequest, toResume, e, (IProgressMonitor)monitor.newChild(3));
                }
                catch (GapException e) {
                    retryAccept = this.handleGap(acceptRequest, action == 3 ? toResume : changeSetsToAccept, toResume, !toResume.isEmpty(), e, monitor.newChild(3));
                }
                catch (ChangeSetAlreadyInHistoryException e) {
                    retryAccept = this.handleChangeSetAlreadyInHistory(acceptRequest, action == 3 ? toResume : changeSetsToAccept, (TeamRepositoryException)((Object)e), (IProgressMonitor)monitor.newChild(3));
                    if (retryAccept) continue;
                    this.handleProblem((TeamRepositoryException)((Object)e));
                }
                catch (ActiveChangeSetsException e) {
                    retryAccept = this.handleActiveChangeSets(acceptRequest, changeSetsToAccept, (TeamRepositoryException)((Object)e), (IProgressMonitor)monitor.newChild(3));
                }
                catch (AcceptSuspendedChangeSetException e) {
                    retryAccept = this.handleSuspendedChangeSets(acceptRequest, changeSetsToAccept, toResume, (IProgressMonitor)monitor.newChild(3));
                    if (retryAccept) continue;
                    this.handleProblem((TeamRepositoryException)((Object)e));
                }
                catch (StaleDataException e) {
                    retryAccept = this.handleStaleData(acceptRequest, staleDataRetries, e, (IProgressMonitor)monitor.newChild(3));
                    ++staleDataRetries;
                }
                catch (TeamRepositoryException e) {
                    retryAccept = this.handleChangeSetAlreadyInHistory(acceptRequest, changeSetsToAccept, e, (IProgressMonitor)monitor.newChild(1));
                    if (!retryAccept) {
                        retryAccept = this.handleSuspendedChangeSets(acceptRequest, changeSetsToAccept, toResume, (IProgressMonitor)monitor.newChild(1));
                    }
                    if (!retryAccept) {
                        retryAccept = this.handleActiveChangeSets(acceptRequest, changeSetsToAccept, e, (IProgressMonitor)monitor.newChild(1));
                    }
                    if (retryAccept) continue;
                    this.handleProblem(e);
                }
            }
        }
    }

    private boolean handleStaleData(WorkspaceUpdateRequest acceptRequest, int staleDataRetries, StaleDataException exception, IProgressMonitor progress) {
        boolean retry = false;
        if (staleDataRetries > 0) {
            this.handleProblem((TeamRepositoryException)((Object)exception));
        } else {
            int reaction = this.problemHandler.staleData(acceptRequest.getWorkspace(), acceptRequest.getSourceWorkspace());
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            if (reaction == 0) {
                try {
                    acceptRequest.recomputeSyncReport(progress);
                    retry = true;
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus(FileSystemStatus.getStatusFor(e));
                    this.handleProblem(e);
                }
            } else {
                this.handleProblem((TeamRepositoryException)((Object)exception));
            }
        }
        return retry;
    }

    private void handleProblem(TeamRepositoryException e) {
        this.collectStatus(FileSystemStatus.getStatusFor(e));
        this.problemsEncountered = true;
    }

    private boolean handleChangeSetAlreadyInHistory(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSets, TeamRepositoryException exception, IProgressMonitor progress) {
        boolean retry = false;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        try {
            List changeSetsAlreadyInHistory = acceptRequest.getWorkspace().changeSetsInHistory(changeSets, (IProgressMonitor)monitor.newChild(2));
            if (!changeSetsAlreadyInHistory.isEmpty()) {
                HashSet<UUID> redundant = new HashSet<UUID>();
                for (IChangeSetHandle cs : changeSetsAlreadyInHistory) {
                    redundant.add(cs.getItemId());
                }
                Iterator<IChangeSetHandle> iChangeSets = changeSets.iterator();
                while (iChangeSets.hasNext()) {
                    IChangeSetHandle cs = iChangeSets.next();
                    if (!redundant.contains(cs.getItemId())) continue;
                    iChangeSets.remove();
                    this.redundantChangeSets = true;
                    retry = true;
                }
            }
        }
        catch (TeamRepositoryException failure) {
            this.collectStatus(FileSystemStatus.getStatusFor(exception));
            this.handleProblem(failure);
        }
        return retry;
    }

    private boolean handleSuspendedChangeSets(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSets, List<IChangeSetHandle> toResume, IProgressMonitor progress) {
        boolean retry = false;
        List suspendedCS = acceptRequest.getWorkspace().suspendedChangeSets();
        if (!suspendedCS.isEmpty()) {
            HashSet<UUID> suspended = new HashSet<UUID>();
            for (IChangeSetHandle cs : suspendedCS) {
                suspended.add(cs.getItemId());
            }
            Iterator<IChangeSetHandle> iChangeSets = changeSets.iterator();
            while (iChangeSets.hasNext()) {
                IChangeSetHandle cs = iChangeSets.next();
                if (!suspended.contains(cs.getItemId())) continue;
                iChangeSets.remove();
                toResume.add(cs);
                retry = true;
            }
        }
        return retry;
    }

    private boolean handleActiveChangeSets(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSetsToAccept, TeamRepositoryException exception, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean retry = false;
        HashSet<UUID> open = new HashSet<UUID>();
        ArrayList<IChangeSetHandle> activeChangeSets = new ArrayList<IChangeSetHandle>();
        try {
            if (acceptRequest.isChangeSetContext() || acceptRequest.getSourceWorkspace() == null) {
                List fullChangeSets = acceptRequest.getWorkspace().teamRepository().itemManager().fetchCompleteItems(changeSetsToAccept, 0, (IProgressMonitor)monitor);
                for (IChangeSetHandle changeSet : fullChangeSets) {
                    if (!changeSet.isActive()) continue;
                    open.add(changeSet.getItemId());
                }
            } else {
                List active = acceptRequest.getSourceWorkspace().activeChangeSets();
                for (IChangeSetHandle changeSet : active) {
                    open.add(changeSet.getItemId());
                }
            }
            if (!open.isEmpty()) {
                Iterator<IChangeSetHandle> iChangeSets = changeSetsToAccept.iterator();
                while (iChangeSets.hasNext()) {
                    IChangeSetHandle cs = iChangeSets.next();
                    if (!open.contains(cs.getItemId())) continue;
                    iChangeSets.remove();
                    activeChangeSets.add(cs);
                }
                if (!activeChangeSets.isEmpty()) {
                    int direction = this.problemHandler.activeChangeSets(acceptRequest.getWorkspace(), activeChangeSets);
                    if (direction == 0) {
                        retry = true;
                    } else if (direction != 3) {
                        if (direction == 1) {
                            throw new OperationCanceledException();
                        }
                        this.handleProblem(exception);
                    }
                }
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus(FileSystemStatus.getStatusFor(exception));
            this.handleProblem(e);
        }
        return retry;
    }

    private boolean handleActiveChangeSetsOverlap(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> toResume, ActiveChangeSetsOverlapException exception, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean retry = false;
        try {
            List fullChangeSets = acceptRequest.getWorkspace().teamRepository().itemManager().fetchCompleteItems(toResume, 0, (IProgressMonitor)monitor.newChild(50));
            ArrayList<IChangeSet> activeChangeSets = new ArrayList<IChangeSet>();
            for (IChangeSet changeSet : fullChangeSets) {
                if (!changeSet.isActive()) continue;
                activeChangeSets.add(changeSet);
            }
            int instructions = this.problemHandler.activeChangeSetsOverlap(acceptRequest.getWorkspace(), activeChangeSets);
            if (instructions == 0) {
                acceptRequest.getWorkspace().closeChangeSets(activeChangeSets, (IProgressMonitor)monitor.newChild(50));
                retry = true;
            } else if (instructions != 3) {
                if (instructions == 1) {
                    throw new OperationCanceledException();
                }
                this.handleProblem((TeamRepositoryException)((Object)exception));
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus(FileSystemStatus.getStatusFor(exception));
            this.handleProblem(e);
        }
        return retry;
    }

    private boolean handleGap(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSetsWithGap, List<IChangeSetHandle> toResume, boolean handlingSuspended, GapException exception, SubMonitor progress) {
        boolean retry = false;
        int instructions = this.problemHandler.gap(acceptRequest.getWorkspace(), changeSetsWithGap, handlingSuspended);
        if (instructions != 0) {
            if (instructions == 1) {
                throw new OperationCanceledException();
            }
            this.handleProblem((TeamRepositoryException)((Object)exception));
        }
        return retry;
    }

    private void holdUpdateReport(IWorkspaceConnection workspace, IUpdateReport updateReport, HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports) {
        List<IUpdateReport> reports = updateReports.get(workspace);
        if (reports == null) {
            reports = new ArrayList<IUpdateReport>();
            updateReports.put(workspace, reports);
        }
        reports.add(updateReport);
    }

    private void verifyComponentFlowing(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + this.acceptRequests.size() * 10));
        HashMap<WorkspaceUpdateRequest, ArrayList<IComponentHandle>> componentsFlowedForRequest = new HashMap<WorkspaceUpdateRequest, ArrayList<IComponentHandle>>();
        ArrayList<ConfigurationDescriptor> added = new ArrayList<ConfigurationDescriptor>();
        ArrayList<ConfigurationDescriptor> removed = new ArrayList<ConfigurationDescriptor>();
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterMonitor = monitor.newChild(10).setWorkRemaining(requests.size());
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                if (acceptRequest.isChangeSetContext()) continue;
                Collection<IFlowNodeConnection.IComponentOp> componentOps = acceptRequest.getComponentOperations((IProgressMonitor)iterMonitor.newChild(1));
                for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) && !(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        added.add(new ConfigurationDescriptor((IConnection)acceptRequest.getWorkspace(), componentOp.getComponent()));
                    } else {
                        removed.add(new ConfigurationDescriptor((IConnection)acceptRequest.getWorkspace(), componentOp.getComponent()));
                    }
                    ArrayList<IComponentHandle> flowsForRequest = (ArrayList<IComponentHandle>)componentsFlowedForRequest.get(acceptRequest);
                    if (flowsForRequest == null) {
                        flowsForRequest = new ArrayList<IComponentHandle>();
                        componentsFlowedForRequest.put(acceptRequest, flowsForRequest);
                    }
                    flowsForRequest.add(componentOp.getComponent());
                }
            }
        }
        if (added.size() > 0 || removed.size() > 0) {
            int result = this.getAcceptDilemmaHandler().componentsToBeAddedOrRemoved(added, removed);
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result == 3) {
                SubMonitor iterProgress = monitor.newChild(10);
                iterProgress.setWorkRemaining(componentsFlowedForRequest.entrySet().size());
                for (Map.Entry entry : componentsFlowedForRequest.entrySet()) {
                    WorkspaceUpdateRequest acceptRequest = (WorkspaceUpdateRequest)entry.getKey();
                    acceptRequest.excludeComponentOps((List)entry.getValue(), (IProgressMonitor)iterProgress.newChild(1));
                }
            } else if (result != 0) {
                throw new TeamRepositoryException(Messages.WorkspaceUpdateOperation_0);
            }
        }
    }

    protected final WorkspaceUpdateDilemmaHandler getAcceptDilemmaHandler() {
        return this.problemHandler;
    }

    @Override
    public boolean changeSetsAlreadyInHistory() {
        return this.redundantChangeSets;
    }

    @Override
    public boolean acceptedSuspendedChangeSets() {
        return this.resumedChangeSets;
    }

    protected void runWithinFileSystemLock(IRunnableWithProgress runnableWithProgress, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        runnableWithProgress.run(monitor);
    }

    protected abstract IFileSystemOperation getUpdateOperation(IWorkspaceConnection var1, List<IUpdateReport> var2, int var3, UpdateDilemmaHandler var4);

    protected abstract IVerifyInSyncOperation getVerifyOperation(OutOfSyncDilemmaHandler var1);

    protected abstract CopyFileAreaStore getCopyFileArea();

    protected abstract IFileSystemOperation getUnshareProjectsOperation(Set<ConfigurationDescriptor> var1) throws FileSystemClientException, TeamRepositoryException;
}

