/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.SharePoint;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdateOperation
extends FileSystemOperation {
    private final List<IUpdateReport> updateReports;
    private final HashSet<ConfigurationDescriptor> affectedComponents;
    private final IWorkspaceConnection connection;
    public static final int PROCESS_UPDATES = 1;
    public static final int PROCESS_INCIDENTAL_UPDATES = 2;
    public static final int PROCESS_ALL_UPDATES = 3;
    private final int updatesToProcess;
    private int updateCount;
    private HashMap<UUID, IComponentHandle> excludedComponents;
    private ISynchronizationInfo synchronizationInfo;
    protected final UpdateDilemmaHandler problemHandler;

    protected UpdateOperation(IWorkspaceConnection connection, List updateReports, Collection<IComponentHandle> componentsToExclude, int updatesToProcess, UpdateDilemmaHandler problemHandler) {
        super(problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler);
        UpdateDilemmaHandler updateDilemmaHandler = this.problemHandler = problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler;
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (updateReports == null || updateReports.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (componentsToExclude == null) {
            throw new IllegalArgumentException();
        }
        if ((updatesToProcess | 3) != 3 || updatesToProcess == 0) {
            throw new IllegalArgumentException();
        }
        this.excludedComponents = new HashMap();
        for (IComponentHandle component : componentsToExclude) {
            this.excludedComponents.put(component.getItemId(), component);
        }
        this.connection = connection;
        this.updateReports = updateReports;
        this.affectedComponents = new HashSet();
        for (Object next : updateReports) {
            if (!(next instanceof IUpdateReport)) {
                throw new IllegalArgumentException();
            }
            IUpdateReport report = (IUpdateReport)next;
            for (IComponentHandle component : report.getAffectedComponents()) {
                this.affectedComponents.add(new ConfigurationDescriptor((IConnection)connection, component));
            }
            for (IComponentStateSummary componentStateSummary : report.getComponentStatesBefore()) {
                this.affectedComponents.add(new ConfigurationDescriptor((IConnection)connection, componentStateSummary.getComponent()));
            }
            for (IComponentStateSummary componentStateSummary : report.getComponentStatesAfter()) {
                this.affectedComponents.add(new ConfigurationDescriptor((IConnection)connection, componentStateSummary.getComponent()));
            }
        }
        int flag = 0;
        if ((updatesToProcess & 1) == 1) {
            flag |= 1;
        }
        if ((updatesToProcess & 2) == 2) {
            flag |= 2;
        }
        this.updatesToProcess = flag;
    }

    public void setSynchronizationInfo(ISynchronizationInfo synchronizationInfo) {
        this.synchronizationInfo = synchronizationInfo;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        monitor.setTaskName(Messages.UpdateOperation_0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 + 100 * this.updateReports.size()));
        CopyFileAreaStore cfa = this.getCopyFileArea();
        ISchedulingRule cfaLock = CopyFileAreaLockUtil.getCopyFileAreaLock(cfa, this.getAffectedConfigurations(), (IProgressMonitor)progress.newChild(1));
        try {
            Collection<IComponentHandle> moreComponents = this.getAdditionalComponentsToExclude(this.connection, this.excludedComponents.values(), this.updateReports);
            for (IComponentHandle component : moreComponents) {
                this.excludedComponents.put(component.getItemId(), component);
            }
            FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
            this.verifyShares((IProgressMonitor)progress.newChild(8));
            int loadCompletedCount = 0;
            try {
                int numReports = this.updateReports.size();
                int currentReport = 1;
                monitor.setTaskName(Messages.UpdateOperation_1);
                SharingManager.getInstance().disableChangeMonitoring();
                for (IUpdateReport updateReport : this.updateReports) {
                    if (numReports > 1) {
                        monitor.setTaskName(NLS.bind((String)Messages.UpdateOperation_2, (Object)currentReport, (Object)numReports));
                    }
                    try {
                        Collection<SharePoint> sharePoints = this.getSharePoints(updateReport, (IProgressMonitor)progress.newChild(1));
                        FileAreaUpdateReport updates = fileSystemService.incrementalFileLoadStream(this.connection, updateReport, this.excludedComponents.values(), sharePoints, true, this.updatesToProcess, this.synchronizationInfo, (IProgressMonitor)progress.newChild(50));
                        this.loadFileArea(this.connection, updateReport.getComponentStatesBefore(), updateReport.getComponentStatesAfter(), updates, (IProgressMonitor)progress.newChild(49));
                        this.updateCount += updates.getAdds().size() + updates.getDeletes().size() + updates.getModifies().size() + updates.getMoves().size();
                        ++loadCompletedCount;
                    }
                    catch (FileSystemClientException e) {
                        this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                    }
                    catch (TeamRepositoryException e) {
                        this.collectStatus(FileSystemStatus.getStatusFor(4, Messages.UpdateOperation_3, (Throwable)e));
                    }
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
                cfa.sync();
            }
        }
        finally {
            cfa.release(cfaLock, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private Collection<SharePoint> getSharePoints(IUpdateReport updateReport, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)updateReport.getAffectedComponents().size());
        ArrayList<SharePoint> result = new ArrayList<SharePoint>();
        for (IComponentHandle componentHandle : updateReport.getAffectedComponents()) {
            if (this.excludedComponents.containsKey(componentHandle.getItemId())) continue;
            ISharingManager sharingManager = FileSystemCore.getSharingManager();
            try {
                Collection<ISharingDescriptor> shares = sharingManager.getShares(sharingManager.getDefaultCFARoot(), this.connection.getContextHandle(), componentHandle, (IProgressMonitor)monitor.newChild(1));
                for (ISharingDescriptor descriptor : shares) {
                    SharePoint sharePoint = FilesystemDTOFactory.eINSTANCE.createSharePoint();
                    sharePoint.setContext(this.connection.getContextHandle());
                    sharePoint.setComponent(componentHandle);
                    sharePoint.setVersionable((IVersionableHandle)descriptor.getRootFolder());
                    result.add(sharePoint);
                }
            }
            catch (FileSystemClientException e) {
                this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
            }
        }
        return result;
    }

    protected final Collection<ConfigurationDescriptor> getAffectedConfigurations() {
        return this.affectedComponents;
    }

    private void verifyShares(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (!this.verifyInSyncEnabled() || this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            monitor.done();
            return;
        }
        VerifySharesOperation verifyOp = new VerifySharesOperation(this.getCopyFileArea().getRoot(), this.problemHandler);
        HashMap<UUID, IComponentStateSummary> componentStates = new HashMap<UUID, IComponentStateSummary>();
        for (IUpdateReport updateReport : this.updateReports) {
            if (this.excludedComponents.isEmpty()) {
                for (IComponentHandle componentHandle : updateReport.getAffectedComponents()) {
                    verifyOp.addToVerify((IConnection)this.connection, componentHandle);
                }
            } else {
                for (IComponentHandle component : updateReport.getAffectedComponents()) {
                    if (this.excludedComponents.containsKey(component.getItemId())) continue;
                    verifyOp.addToVerify((IConnection)this.connection, component);
                }
            }
            for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
                if (componentStates.get(summary.getComponent().getItemId()) != null) continue;
                componentStates.put(summary.getComponent().getItemId(), summary);
            }
        }
        verifyOp.addToVerifyAgainst((IConnection)this.connection, componentStates.values());
        verifyOp.run(monitor);
    }

    protected abstract CopyFileAreaStore getCopyFileArea();

    protected abstract void loadFileArea(IWorkspaceConnection var1, Collection var2, Collection var3, FileAreaUpdateReport var4, IProgressMonitor var5) throws FileSystemClientException, TeamRepositoryException;

    private Collection<IComponentHandle> getAdditionalComponentsToExclude(IWorkspaceConnection connection, Collection<IComponentHandle> excludedComponents, List<IUpdateReport> updateReports) {
        HashMap<UUID, IComponentHandle> result = new HashMap<UUID, IComponentHandle>();
        HashSet<UUID> componentsExamined = new HashSet<UUID>();
        for (IComponentHandle component : excludedComponents) {
            componentsExamined.add(component.getItemId());
        }
        IWorkspace context = connection.getResolvedWorkspace();
        for (IUpdateReport report : updateReports) {
            for (IComponentHandle component : report.getAffectedComponents()) {
                if (componentsExamined.contains(component.getItemId())) continue;
                try {
                    if (!this.getCopyFileArea().isLoaded(component, (IContextHandle)context, null)) {
                        result.put(component.getItemId(), component);
                    }
                }
                catch (FileSystemClientException fileSystemClientException) {}
                componentsExamined.add(component.getItemId());
            }
        }
        return result.values();
    }

    @Override
    protected String getTraceMessage() {
        return String.valueOf(super.getTraceMessage()) + " : " + this.connection.getName() + " " + this.updateCount + " updates";
    }
}

