/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationRequest {
    private final IWorkspaceConnection workspace;
    private IChangeHistorySyncReport syncReport;
    private List<IBaselineHandle> baselines;
    private List<IChangeSetHandle> changeSets;
    private final List<IComponentHandle> components;

    public OperationRequest(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSets) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
        this.changeSets = changeSets;
        this.components = Collections.EMPTY_LIST;
        this.baselines = Collections.EMPTY_LIST;
        this.syncReport = null;
    }

    public OperationRequest(IWorkspaceConnection workspace, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets) {
        this(workspace, syncReport, baselines, changeSets, Collections.EMPTY_LIST);
    }

    public OperationRequest(IWorkspaceConnection workspace, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, List<IComponentHandle> components) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        if (baselines == null) {
            throw new IllegalArgumentException();
        }
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        if (components == null) {
            throw new IllegalArgumentException();
        }
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        this.syncReport = syncReport;
        this.baselines = baselines;
        this.workspace = workspace;
        this.changeSets = changeSets;
        this.components = components;
    }

    public void clearChanges(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (this.changeSets.size() > 0) {
            List fullChangeSets = this.workspace.teamRepository().itemManager().fetchPartialItems(this.changeSets, 0, (Collection)Collections.singletonList(IChangeSet.COMPONENT_PROPERTY), (IProgressMonitor)progress.newChild(5));
            ArrayList<IChangeSetHandle> newChangeSets = new ArrayList<IChangeSetHandle>();
            for (IChangeSet changeSet : fullChangeSets) {
                if (changeSet.getComponent().sameItemId((IItemHandle)component)) continue;
                newChangeSets.add((IChangeSetHandle)changeSet);
            }
            this.changeSets = newChangeSets;
        }
        if (this.baselines.size() > 0) {
            List fullBaselines = this.workspace.teamRepository().itemManager().fetchPartialItems(this.baselines, 0, (Collection)Collections.singletonList(IBaseline.COMPONENT_PROPERTY), (IProgressMonitor)progress.newChild(5));
            ArrayList<IBaselineHandle> newBaselines = new ArrayList<IBaselineHandle>();
            for (IBaseline baseline : fullBaselines) {
                if (baseline.getComponent().sameItemId((IItemHandle)component)) continue;
                newBaselines.add((IBaselineHandle)baseline);
            }
            this.baselines = newBaselines;
        }
    }

    public Collection<ConfigurationDescriptor> getAffectedConfigurations(List<IAuditable> determinants, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
        if (!this.changeSets.isEmpty()) {
            List fullChangeSets = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.changeSets, 0, (IProgressMonitor)monitor.newChild(50));
            determinants.addAll(fullChangeSets);
            for (IChangeSet changeSet : fullChangeSets) {
                configurations.add(new ConfigurationDescriptor((IConnection)this.workspace, changeSet.getComponent()));
            }
        }
        if (!this.baselines.isEmpty()) {
            List fullBaselines = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.baselines, 0, (IProgressMonitor)monitor.newChild(50));
            determinants.addAll(fullBaselines);
            for (IBaseline baseline : fullBaselines) {
                configurations.add(new ConfigurationDescriptor((IConnection)this.workspace, baseline.getComponent()));
            }
        }
        if (!this.components.isEmpty()) {
            List fullComponents = this.workspace.teamRepository().itemManager().fetchCompleteItems(this.components, 0, (IProgressMonitor)monitor.newChild(50));
            determinants.addAll(fullComponents);
            for (IComponentHandle componentHandle : this.components) {
                configurations.add(new ConfigurationDescriptor((IConnection)this.workspace, componentHandle));
            }
        }
        return configurations;
    }

    public List<IComponentHandle> getAffectedComponents(IProgressMonitor monitor) throws TeamRepositoryException {
        Collection<ConfigurationDescriptor> affected = this.getAffectedConfigurations(new ArrayList<IAuditable>(), monitor);
        ArrayList<IComponentHandle> affectedComponents = new ArrayList<IComponentHandle>(affected.size());
        for (ConfigurationDescriptor configurationDescriptor : affected) {
            affectedComponents.add(configurationDescriptor.componentHandle);
        }
        return affectedComponents;
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    public IChangeHistorySyncReport getSyncReport() {
        return this.syncReport;
    }

    public List<IBaselineHandle> getBaselines() {
        return this.baselines;
    }

    public List<IChangeSetHandle> getChangeSets() {
        return this.changeSets;
    }

    public List<IComponentHandle> getComponents() {
        return this.components;
    }

    public void setReport(IChangeHistorySyncReport report) {
        this.syncReport = report;
    }
}

