/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemLoadMutator;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemMergeLoadMutator;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemVerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileSystemLoadOperation
extends LoadOperation {
    public static final int NONE = 0;
    public static final int MAINTAIN_SHARE_INFO = 1;
    public static final int MERGE_LOAD = 2;
    private final IPath fileAreaRoot;
    private final int loadFlags;
    private CopyFileAreaStore cfa;

    public LocalFileSystemLoadOperation(IPath fileAreaRoot, int mutatorFlags, LoadDilemmaHandler loadProblemHandler) {
        super(loadProblemHandler);
        this.fileAreaRoot = fileAreaRoot;
        this.loadFlags = mutatorFlags;
        this.cfa = CopyFileAreaStore.getCopyFileArea(fileAreaRoot);
    }

    @Override
    public void requestReLoad(Collection<IShare> sharesToReload, IProgressMonitor progress) throws TeamRepositoryException {
        for (IShare share : sharesToReload) {
            if (share.getAnchor().equals((Object)this.fileAreaRoot)) continue;
            throw new IllegalArgumentException();
        }
        super.requestReLoad(sharesToReload, progress);
    }

    @Override
    protected void execute(IProgressMonitor reporter) throws FileSystemClientException, TeamRepositoryException {
        Collection<ConfigurationDescriptor> configurationsToLock = this.getAffectedConfigurations();
        FlowNodeLock jazzWorkspaceLock = WorkspaceLockUtil.acquireRead(configurationsToLock);
        try {
            super.doLoad(reporter);
        }
        finally {
            WorkspaceLockUtil.release(jazzWorkspaceLock);
        }
    }

    @Override
    protected FileSystemOperation getLoadMutator(IConnection connection, IComponentHandle component, Collection<IVersionableHandle> shareRoots, Collection<String[]> subtreeRoots, LoadTree loadTree, LoadDilemmaHandler loadProblemHandler) throws TeamRepositoryException {
        if ((this.loadFlags & 2) == 2) {
            Map<ConfigurationDescriptor, Collection<IVersionableHandle>> roots = Collections.singletonMap(new ConfigurationDescriptor(connection, component), shareRoots);
            return new LocalFileSystemMergeLoadMutator(connection, roots, loadTree, this.fileAreaRoot, subtreeRoots, loadProblemHandler);
        }
        int mutatorFlags = 0;
        if ((this.loadFlags & 1) == 1) {
            mutatorFlags = 1;
        }
        return new LocalFileSystemLoadMutator(connection, component, shareRoots, loadTree, this.fileAreaRoot, subtreeRoots, mutatorFlags, loadProblemHandler);
    }

    @Override
    protected boolean maintainShareInfo() {
        return (this.loadFlags & 2) == 2 || (this.loadFlags & 1) == 1;
    }

    @Override
    protected IShareable getShareable(String child) {
        return new ShareableFile(this.fileAreaRoot, this.fileAreaRoot.append(child).toFile());
    }

    @Override
    protected boolean existsOnMirror(String child) {
        return this.fileAreaRoot.append(child).toFile().exists();
    }

    @Override
    protected CopyFileAreaStore getCopyFileArea() {
        return this.cfa;
    }

    private void deleteSubtree(File file) throws FileSystemClientException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.deleteSubtree(children[i]);
                ++i;
            }
        }
        file.delete();
    }

    @Override
    protected IShare[] getAllShares() throws FileSystemClientException {
        return SharingManager.getInstance().allShares(this.cfa);
    }

    @Override
    protected void deleteShare(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        if (shareable.getLocalFullPath().segmentCount() > 0) {
            File toDeleteFile = ((ShareableFile)shareable).getFile();
            this.deleteSubtree(toDeleteFile);
        }
        ((Shareable)shareable).unshare(monitor);
    }

    @Override
    protected IVerifyInSyncOperation getVerifyInSyncOperation(OutOfSyncDilemmaHandler outOfSyncDilemmaHandler) {
        return new LocalFileSystemVerifySharesOperation(this.fileAreaRoot, outOfSyncDilemmaHandler);
    }
}

