/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Collision;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadOverlap;
import com.ibm.team.filesystem.client.internal.load.RemovedShare;
import com.ibm.team.filesystem.client.internal.load.ShareableToLoad;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.InvalidLoadRequest;
import com.ibm.team.filesystem.client.internal.operations.LoadRequest;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoadOperation
extends FileSystemOperation
implements ILoadOperation {
    private HashMap<IConnection, HashMap<ConfigurationDescriptor, Set<LoadRequest>>> requestsByConnection;
    private ISynchronizationInfo synchronizationInfo;
    private final LoadDilemmaHandler dilemmaHandler;
    private HashMap<String, IRemovedShare> sharesToRemove = new HashMap();
    private HashMap<String, ILoadLocation> treesToLoad;
    HashMap<String, ICollision> collisions;
    HashMap<String, IShareableToLoad> newItems;
    ArrayList<ILoadOverlap> loadOverLaps;
    ArrayList<IShareOutOfSync> sharesOutOfSync;
    ArrayList<IInvalidLoadRequest> invalidLoadRequests;
    HashMap<IConnection, HashSet<ConfigurationDescriptor>> configurationsToTrack;

    public LoadOperation(LoadDilemmaHandler problemHandler) {
        super(problemHandler == null ? LoadDilemmaHandler.getDefault() : problemHandler);
        this.dilemmaHandler = problemHandler == null ? LoadDilemmaHandler.getDefault() : problemHandler;
        this.requestsByConnection = new HashMap();
        this.treesToLoad = new HashMap();
        this.sharesToRemove = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.configurationsToTrack = new HashMap();
    }

    @Override
    public void requestLoad(IWorkspaceConnection workspaceConnection, IComponentHandle component, Collection<IFolderHandle> foldersToLoad) {
        this.validateRequestToLoad((IConnection)workspaceConnection, component, foldersToLoad);
        this.recordRequestToLoad((IConnection)workspaceConnection, component, foldersToLoad);
    }

    @Override
    public void requestLoad(IBaselineConnection baselineConnection, Collection<IFolderHandle> foldersToLoad) {
        this.validateRequestToLoad((IConnection)baselineConnection, baselineConnection.getComponent(), foldersToLoad);
        this.recordRequestToLoad((IConnection)baselineConnection, baselineConnection.getComponent(), foldersToLoad);
    }

    @Override
    public void requestLoad(Collection<ILoadRule> loadRules, IProgressMonitor progress) throws TeamRepositoryException {
        if (loadRules == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)loadRules.size());
        for (ILoadRule loadRule : loadRules) {
            this.recordRequestToLoad((IConnection)loadRule.getWorkspaceConnection(), loadRule.getComponent(), loadRule.getFoldersToLoad((IProgressMonitor)monitor.newChild(1)));
        }
    }

    private void validateRequestToLoad(IConnection connection, IComponentHandle component, Collection<IFolderHandle> foldersToLoad) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (foldersToLoad == null) {
            throw new IllegalArgumentException();
        }
        for (IFolderHandle handle : foldersToLoad) {
            if (handle != null) continue;
            throw new IllegalArgumentException();
        }
    }

    private void recordRequestToLoad(IConnection connection, IComponentHandle component, Collection<IFolderHandle> foldersToLoad) {
        ConfigurationDescriptor descriptor = new ConfigurationDescriptor(connection, component);
        if (foldersToLoad.isEmpty()) {
            HashSet<ConfigurationDescriptor> configurationsByConnection = this.configurationsToTrack.get(connection);
            if (configurationsByConnection == null) {
                configurationsByConnection = new HashSet();
                this.configurationsToTrack.put(connection, configurationsByConnection);
            }
            configurationsByConnection.add(descriptor);
        } else {
            Set<LoadRequest> requests;
            HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig = this.requestsByConnection.get(connection);
            if (requestsByConfig == null) {
                requestsByConfig = new HashMap();
                this.requestsByConnection.put(connection, requestsByConfig);
            }
            if ((requests = requestsByConfig.get(descriptor)) == null) {
                requests = new HashSet<LoadRequest>();
                requestsByConfig.put(descriptor, requests);
            }
            for (IFolderHandle handle : foldersToLoad) {
                LoadRequest request = new LoadRequest(connection, component, handle, false);
                requests.add(request);
            }
        }
    }

    @Override
    public void requestReLoad(Collection<IShare> sharesToReload, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)sharesToReload.size());
        if (sharesToReload == null || sharesToReload.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (IShare share : sharesToReload) {
            if (share != null) continue;
            throw new IllegalArgumentException();
        }
        for (IShare share : sharesToReload) {
            Set<LoadRequest> requests;
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
            IConnection connection = configurationDescriptor.getConnection((IProgressMonitor)monitor.newChild(1));
            HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig = this.requestsByConnection.get(connection);
            if (requestsByConfig == null) {
                requestsByConfig = new HashMap();
                this.requestsByConnection.put(connection, requestsByConfig);
            }
            if ((requests = requestsByConfig.get(configurationDescriptor)) == null) {
                requests = new HashSet<LoadRequest>();
                requestsByConfig.put(configurationDescriptor, requests);
            }
            requests.add(new LoadRequest(connection, sharingDescriptor.getComponent(), sharingDescriptor.getRootFolder(), true));
        }
    }

    @Override
    public Collection<ILoadRequest> getLoadRequests() {
        ArrayList<LoadRequest> allRequests = new ArrayList<LoadRequest>();
        for (HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig : this.requestsByConnection.values()) {
            for (Set<LoadRequest> requests : requestsByConfig.values()) {
                allRequests.addAll(requests);
            }
        }
        return Collections.unmodifiableCollection(allRequests);
    }

    @Override
    public Collection<ILoadOverlap> getLoadOverlaps() {
        return Collections.unmodifiableCollection(this.loadOverLaps);
    }

    @Override
    public Collection<IInvalidLoadRequest> getInvalidLoadRequests() {
        return Collections.unmodifiableCollection(this.invalidLoadRequests);
    }

    @Override
    public void evaluateLoadRequests(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        this.treesToLoad = new HashMap();
        this.sharesToRemove = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        HashMap<IShare, IConnection> sharesToVerifyInSync = new HashMap<IShare, IConnection>();
        this.getElementsToLoad(sharesToVerifyInSync, (IProgressMonitor)monitor.newChild(90));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!sharesToVerifyInSync.isEmpty()) {
            OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = new OutOfSyncDilemmaHandler(){

                @Override
                public int outOfSync(Collection<IShareOutOfSync> shares) {
                    LoadOperation.this.sharesOutOfSync.addAll(shares);
                    return 0;
                }
            };
            IVerifyInSyncOperation verifyInSyncOp = this.getVerifyInSyncOperation(outOfSyncDilemmaHandler);
            for (Map.Entry<IShare, IConnection> entry : sharesToVerifyInSync.entrySet()) {
                verifyInSyncOp.addToVerify(entry.getValue(), entry.getKey());
            }
            verifyInSyncOp.run((IProgressMonitor)monitor.newChild(10));
        }
        monitor.done();
    }

    @Override
    public void removeLoadRequests(Collection<ILoadRequest> requestsToRemove) {
        if (requestsToRemove == null) {
            throw new IllegalArgumentException();
        }
        for (ILoadRequest request : requestsToRemove) {
            Set<LoadRequest> requests;
            ConfigurationDescriptor descriptor = new ConfigurationDescriptor(request.getConnection(), request.getComponent());
            HashMap<ConfigurationDescriptor, Set<LoadRequest>> requestsByConfig = this.requestsByConnection.get(request.getConnection());
            if (requestsByConfig == null || (requests = requestsByConfig.get(descriptor)) == null) continue;
            requests.remove(request);
            if (!requests.isEmpty()) continue;
            requestsByConfig.remove(descriptor);
            if (!requestsByConfig.isEmpty()) continue;
            this.requestsByConnection.remove(request.getConnection());
        }
    }

    @Override
    public Collection<IRemovedShare> getSharesToBeRemoved() {
        return this.sharesToRemove.values();
    }

    @Override
    public Collection<ICollision> getCollisions() {
        return Collections.unmodifiableCollection(this.collisions.values());
    }

    @Override
    public Collection<IShareableToLoad> getNewSharesToLoad() {
        return Collections.unmodifiableCollection(this.newItems.values());
    }

    @Override
    public Collection<IShareOutOfSync> getSharesOutOfSync() {
        return Collections.unmodifiableCollection(this.sharesOutOfSync);
    }

    @Override
    public Collection<ConfigurationDescriptor> getConfigurationsToTrack() {
        HashSet<ConfigurationDescriptor> allConfigurationsToTrack = new HashSet<ConfigurationDescriptor>();
        for (HashSet<ConfigurationDescriptor> configurationsByConnection : this.configurationsToTrack.values()) {
            allConfigurationsToTrack.addAll(configurationsByConnection);
        }
        return Collections.unmodifiableCollection(allConfigurationsToTrack);
    }

    @Override
    public void removeConfigurationTrackingRequests(Collection<ConfigurationDescriptor> configurations) {
        if (configurations == null) {
            throw new IllegalArgumentException();
        }
        block0: for (ConfigurationDescriptor configuration : configurations) {
            HashSet<ConfigurationDescriptor> configurationByConnection = this.configurationsToTrack.get(configuration.connectionHandle.getItemId());
            if (configurationByConnection == null) continue;
            Iterator<ConfigurationDescriptor> i = configurationByConnection.iterator();
            while (i.hasNext()) {
                ConfigurationDescriptor descriptor = i.next();
                if (!descriptor.sameConfiguration(configuration)) continue;
                i.remove();
                continue block0;
            }
        }
    }

    public void setSychronizationInfo(ISynchronizationInfo synchronizationInfo) {
        this.synchronizationInfo = synchronizationInfo;
    }

    protected final void doLoad(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileAreaStore cfa = this.getCopyFileArea();
        ISchedulingRule copyFileAreaLock = CopyFileAreaLockUtil.getCopyFileAreaLock(cfa, this.getAffectedConfigurations(), (IProgressMonitor)progress.newChild(1));
        try {
            try {
                this.evaluateLoadRequests((IProgressMonitor)progress.newChild(3));
                this.notifyDilemmaHandler((IProgressMonitor)progress.newChild(1));
                this.trackComponents((IProgressMonitor)progress.newChild(1));
                this.removeShares((IProgressMonitor)progress.newChild(10));
                this.load((IProgressMonitor)progress.newChild(83));
            }
            finally {
                cfa.sync();
            }
        }
        finally {
            cfa.release(copyFileAreaLock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    protected final Collection<ConfigurationDescriptor> getAffectedConfigurations() {
        HashSet<ConfigurationDescriptor> configurationsAffected = new HashSet<ConfigurationDescriptor>();
        for (HashMap<ConfigurationDescriptor, Set<LoadRequest>> hashMap : this.requestsByConnection.values()) {
            configurationsAffected.addAll((Collection)hashMap.keySet());
        }
        for (HashSet hashSet : this.configurationsToTrack.values()) {
            configurationsAffected.addAll(hashSet);
        }
        return configurationsAffected;
    }

    protected void notifyDilemmaHandler(IProgressMonitor reporter) throws TeamRepositoryException, FileSystemClientException {
        int reaction;
        MultiStatus status;
        int i;
        int result;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)(100 + this.requestsByConnection.size()));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.loadOverLaps.isEmpty()) {
            result = this.dilemmaHandler.overlappingLoadRequests(Collections.unmodifiableCollection(this.loadOverLaps));
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result != 0) {
                IStatus[] reportedOverlaps = new IStatus[this.loadOverLaps.size()];
                i = 0;
                for (ILoadOverlap overlap : this.loadOverLaps) {
                    String msg = "";
                    if (!overlap.getOverlappingShares().isEmpty()) {
                        msg = NLS.bind((String)Messages.LoadOperation_1, (Object)PathUtils.getString(overlap.getFolderPath()), (Object)overlap.getOverlappingShares().size());
                    }
                    if (!overlap.getOverlappingFolders().isEmpty()) {
                        msg = NLS.bind((String)Messages.LoadOperation_2, (Object)PathUtils.getString(overlap.getFolderPath()), (Object)overlap.getOverlappingFolders().size());
                    }
                    reportedOverlaps[i] = new FileSystemStatus(4, msg);
                    ++i;
                }
                status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedOverlaps, Messages.LoadOperation_3, null);
                this.handleErrors(new IStatus[]{status});
            }
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.newItems.isEmpty()) {
            result = this.dilemmaHandler.newItemsToLoad(Collections.unmodifiableCollection(this.newItems.values()));
            if (result == 0) {
                for (IShareableToLoad newItem : this.newItems.values()) {
                    if (newItem.willLoad()) continue;
                    this.treesToLoad.remove(newItem.getLoadLocation().getShareName());
                }
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                IStatus[] reportedNewItems = new IStatus[this.newItems.size()];
                i = 0;
                for (IShareableToLoad shareableToLoad : this.newItems.values()) {
                    reportedNewItems[i] = new FileSystemStatus(2, shareableToLoad.getShareable().getLocalFullPath() + Messages.LoadOperation_4);
                    ++i;
                }
                status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedNewItems, Messages.LoadOperation_5, null);
                this.handleErrors(new IStatus[]{status});
            }
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.collisions.size() > 0 || this.sharesToRemove.size() > 0) {
            result = this.dilemmaHandler.collision(Collections.unmodifiableCollection(this.collisions.values()), Collections.unmodifiableCollection(this.sharesToRemove.values()), Collections.unmodifiableCollection(this.sharesOutOfSync));
            if (result == 0) {
                ICollision[] collisionDecisions = this.collisions.values().toArray(new ICollision[this.collisions.size()]);
                int i2 = 0;
                while (i2 < collisionDecisions.length) {
                    LoadLocation loadLocation = (LoadLocation)collisionDecisions[i2].getLoadLocation();
                    if (loadLocation != null) {
                        this.treesToLoad.put(loadLocation.getShareName(), loadLocation);
                    }
                    ++i2;
                }
            } else if (result != 1) {
                IStatus[] reportedCollisions = new IStatus[this.collisions.size() + this.sharesToRemove.size()];
                int i3 = 0;
                Iterator<ICollision> iCollisions = this.collisions.values().iterator();
                while (iCollisions.hasNext()) {
                    reportedCollisions[i3] = iCollisions.next().getStatus();
                    ++i3;
                }
                for (IRemovedShare removedShare : this.sharesToRemove.values()) {
                    reportedCollisions[i3] = new FileSystemStatus(2, NLS.bind((String)Messages.LoadOperation_0, (Object)removedShare.getShareableLocalPath()));
                    ++i3;
                }
                status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedCollisions, Messages.LoadOperation_7, null);
                this.handleErrors(new IStatus[]{status});
            } else {
                throw new OperationCanceledException();
            }
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.invalidLoadRequests.size() > 0 && (reaction = this.dilemmaHandler.invalidLoadRequest(Collections.unmodifiableCollection(this.invalidLoadRequests))) != 0) {
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            IStatus[] reasons = new IStatus[this.invalidLoadRequests.size()];
            int i4 = 0;
            for (IInvalidLoadRequest request : this.invalidLoadRequests) {
                reasons[i4] = ((InvalidLoadRequest)request).getStatus();
                ++i4;
            }
            status = new MultiStatus("com.ibm.team.filesystem.client", 4, reasons, NLS.bind((String)Messages.LoadOperation_15, (Object)this.invalidLoadRequests.size()), null);
            this.handleErrors(new IStatus[]{status});
        }
        progress.done();
    }

    protected abstract IVerifyInSyncOperation getVerifyInSyncOperation(OutOfSyncDilemmaHandler var1);

    protected boolean maintainShareInfo() {
        return true;
    }

    private void removeShares(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)this.sharesToRemove.size());
        for (IRemovedShare share : this.sharesToRemove.values()) {
            Shareable shareable = (Shareable)share.getShareable();
            mon.setTaskName(NLS.bind((String)Messages.LoadOperation_8, (Object)shareable.getLocalFullPath().toString()));
            if (share.isToBeDeleted()) {
                this.deleteShare(shareable, (IProgressMonitor)mon.newChild(1));
            } else {
                shareable.unshare(null);
                mon.worked(1);
            }
            if (!mon.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        mon.done();
    }

    private void trackComponents(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.configurationsToTrack.size() * 1));
        CopyFileAreaStore cfa = this.getCopyFileArea();
        for (HashSet<ConfigurationDescriptor> configurationsForConnection : this.configurationsToTrack.values()) {
            SubMonitor iterProgess = mon.newChild(1);
            iterProgess.setWorkRemaining(configurationsForConnection.size() + 2);
            ArrayList<IComponentHandle> componentsToRetrieve = new ArrayList<IComponentHandle>(configurationsForConnection.size());
            IConnection connection = null;
            for (ConfigurationDescriptor descriptor : configurationsForConnection) {
                if (connection == null) {
                    connection = descriptor.getConnection((IProgressMonitor)iterProgess.newChild(1));
                }
                if (descriptor.componentHandle.hasFullState()) {
                    LoadedConfigurationDescriptor loadedConfigurationDescriptor = new LoadedConfigurationDescriptor(connection, (IComponent)descriptor.componentHandle);
                    cfa.componentLoaded(loadedConfigurationDescriptor, (IProgressMonitor)iterProgess.newChild(1));
                    continue;
                }
                componentsToRetrieve.add(descriptor.componentHandle);
            }
            if (!componentsToRetrieve.isEmpty() && connection != null) {
                List fullComponents = connection.teamRepository().itemManager().fetchCompleteItems(componentsToRetrieve, 0, (IProgressMonitor)iterProgess.newChild(1));
                for (IComponent component : fullComponents) {
                    LoadedConfigurationDescriptor loadedConfigurationDescriptor = new LoadedConfigurationDescriptor(connection, component);
                    cfa.componentLoaded(loadedConfigurationDescriptor, (IProgressMonitor)iterProgess.newChild(1));
                }
            }
            iterProgess.done();
        }
        mon.done();
    }

    protected void load(IProgressMonitor reporter) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)reporter, (int)(this.treesToLoad.size() * 3));
        subProgress.setTaskName(Messages.LoadOperation_9);
        subProgress.beginTask(Messages.LoadOperation_10, this.treesToLoad.size() * 3);
        HashMap<ConfigurationDescriptor, ArrayList<LoadLocation>> componentsToLoad = new HashMap<ConfigurationDescriptor, ArrayList<LoadLocation>>();
        for (LoadLocation loadLocation : this.treesToLoad.values()) {
            ArrayList<LoadLocation> itemsToLoad = (ArrayList<LoadLocation>)componentsToLoad.get(loadLocation.getDescriptor());
            if (itemsToLoad == null) {
                itemsToLoad = new ArrayList<LoadLocation>();
                componentsToLoad.put(loadLocation.getDescriptor(), itemsToLoad);
            }
            itemsToLoad.add(loadLocation);
        }
        int i = 1;
        for (ArrayList arrayList : componentsToLoad.values()) {
            LoadLocation location = (LoadLocation)arrayList.get(0);
            SubProgressMonitor dlMonitor = new SubProgressMonitor((IProgressMonitor)subProgress, arrayList.size() * 2);
            IFileSystemManager fsm = (IFileSystemManager)location.getDescriptor().getTeamRepository().getClientLibrary(IFileSystemManager.class);
            IConnection connection = location.getDescriptor().getConnection(null);
            FileSystemServiceProxy fss = ((FileSystemManager)fsm).getFileSystemService();
            dlMonitor.setTaskName(NLS.bind((String)Messages.LoadOperation_11, (Object[])new Object[]{connection.getName(), location.getComponent().getName(), i, componentsToLoad.size()}));
            subProgress.subTask(NLS.bind((String)Messages.LoadOperation_12, (Object)location.getComponent().getName()));
            IVersionableHandle[] versionableHandles = new IVersionableHandle[arrayList.size()];
            ArrayList<String[]> paths = new ArrayList<String[]>(arrayList.size());
            int j = 0;
            for (ILoadLocation loadLocation : arrayList) {
                versionableHandles[j] = ((LoadLocation)loadLocation).getFolder();
                paths.add(new String[]{loadLocation.getShareName()});
                ++j;
            }
            LoadTree loadTree = fss.getFileTreeByVersionable(connection, (IComponentHandle)location.getComponent(), versionableHandles, -1, true, this.synchronizationInfo, (IProgressMonitor)subProgress.newChild(arrayList.size()));
            FileSystemOperation mutator = this.getLoadMutator(connection, (IComponentHandle)location.getComponent(), (Collection<IVersionableHandle>)Arrays.asList(versionableHandles), paths, loadTree, this.dilemmaHandler);
            try {
                mutator.run((IProgressMonitor)dlMonitor);
            }
            finally {
                dlMonitor.done();
            }
            if (subProgress.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        subProgress.setTaskName(Messages.LoadOperation_13);
        subProgress.done();
    }

    private void getElementsToLoad(HashMap<IShare, IConnection> sharesToVerifyInSync, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * (this.requestsByConnection.size() + this.configurationsToTrack.size())));
        monitor.setTaskName(Messages.LoadOperation_14);
        HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> existingShares = this.organizeShares();
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        for (Map.Entry<IConnection, HashSet<ConfigurationDescriptor>> entry : this.configurationsToTrack.entrySet()) {
            IConnection connection = entry.getKey();
            HashSet<ConfigurationDescriptor> configurationsToTrackByConnection = entry.getValue();
            ArrayList<IComponentHandle> interestingComponents = new ArrayList<IComponentHandle>(configurationsToTrackByConnection.size());
            ArrayList<List<? extends IVersionableHandle>> interestingVersionables = new ArrayList<List<? extends IVersionableHandle>>(configurationsToTrackByConnection.size());
            for (ConfigurationDescriptor descriptor : configurationsToTrackByConnection) {
                HashMap<UUID, IShare> shares = existingShares.get(descriptor);
                if (shares == null) continue;
                ArrayList<IFolderHandle> versionables = new ArrayList<IFolderHandle>();
                for (IShare share : shares.values()) {
                    versionables.add(share.getSharingDescriptor().getRootFolder());
                }
                interestingComponents.add(descriptor.componentHandle);
                interestingVersionables.add(versionables);
            }
            Map<UUID, Map<UUID, ? extends IVersionable>> fullFolders = this.fetchCompleteItems(connection, interestingComponents, interestingVersionables, monitor.newChild(100));
            for (ConfigurationDescriptor descriptor : configurationsToTrackByConnection) {
                HashMap<UUID, IShare> shares = existingShares.get(descriptor);
                if (shares == null) continue;
                Map versionablesFound = fullFolders.get(descriptor.componentHandle.getItemId());
                if (versionablesFound == null) {
                    versionablesFound = Collections.EMPTY_MAP;
                }
                for (Map.Entry<UUID, IShare> entry2 : shares.entrySet()) {
                    if (versionablesFound.get(entry2.getKey()) != null) continue;
                    IShare share = entry2.getValue();
                    this.sharesToRemove.put(share.getPath().toString(), new RemovedShare(share));
                }
            }
        }
        for (Map.Entry<IConnection, Cloneable> entry : this.requestsByConnection.entrySet()) {
            Object descriptor;
            HashMap<UUID, IShare> shares;
            HashMap uuidsToLoad;
            SubMonitor iterProgress = monitor.newChild(100);
            IConnection connection = entry.getKey();
            ArrayList<OverlapRequest> overlapRequests = new ArrayList<OverlapRequest>(((HashMap)entry.getValue()).size());
            HashMap<Object, HashMap> toLoad = new HashMap<Object, HashMap>();
            HashMap configurationFolders = new HashMap();
            ArrayList<IComponentHandle> componentsToRetrieve = new ArrayList<IComponentHandle>();
            ArrayList<IComponentHandle> interestingComponents = new ArrayList<IComponentHandle>();
            ArrayList<List<? extends IVersionableHandle>> interestingVersionables = new ArrayList<List<? extends IVersionableHandle>>();
            for (Map.Entry entryByConfig : ((HashMap)entry.getValue()).entrySet()) {
                ConfigurationDescriptor descriptor2 = (ConfigurationDescriptor)entryByConfig.getKey();
                interestingComponents.add(descriptor2.componentHandle);
                ArrayList<IFolderHandle> versionables = new ArrayList<IFolderHandle>();
                interestingVersionables.add(versionables);
                uuidsToLoad = new HashMap();
                toLoad.put(descriptor2, uuidsToLoad);
                for (LoadRequest request : (Set)entryByConfig.getValue()) {
                    if (!components.containsKey(request.getComponent().getItemId())) {
                        componentsToRetrieve.add(request.getComponent());
                    }
                    versionables.add(request.getFolderToLoad());
                    uuidsToLoad.put(request.getFolderToLoad().getItemId(), request);
                }
                shares = existingShares.get(descriptor2);
                if (shares == null) continue;
                for (IShare share : shares.values()) {
                    ISharingDescriptor iSharingDescriptor = share.getSharingDescriptor();
                    LoadRequest request = (LoadRequest)uuidsToLoad.get(iSharingDescriptor.getRootFolder().getItemId());
                    if (request != null) {
                        request.setReloadRequest(true);
                        continue;
                    }
                    versionables.add(iSharingDescriptor.getRootFolder());
                }
            }
            Map<UUID, Map<UUID, ? extends IVersionable>> fullFolders = this.fetchCompleteItems(connection, interestingComponents, interestingVersionables, iterProgress.newChild(40));
            for (Map.Entry entry3 : ((HashMap)entry.getValue()).entrySet()) {
                descriptor = (ConfigurationDescriptor)entry3.getKey();
                uuidsToLoad = (HashMap)toLoad.get(descriptor);
                shares = existingShares.get(descriptor);
                Map<UUID, ? extends IVersionable> fullFoldersForComponent = fullFolders.get(((ConfigurationDescriptor)descriptor).componentHandle.getItemId());
                if (fullFoldersForComponent == null) continue;
                HashMap<UUID, IFolder> foldersRetrieved = new HashMap<UUID, IFolder>();
                for (IFolder iFolder : fullFoldersForComponent.values()) {
                    if (iFolder == null) continue;
                    foldersRetrieved.put(iFolder.getItemId(), iFolder);
                }
                configurationFolders.put(descriptor, foldersRetrieved);
                OverlapRequest overlapRequest = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
                overlapRequest.setContext(connection.getContextHandle());
                overlapRequest.setComponent(((ConfigurationDescriptor)descriptor).componentHandle);
                int i = 0;
                for (Map.Entry<UUID, ? extends IVersionable> entry4 : fullFoldersForComponent.entrySet()) {
                    UUID folderItemId = entry4.getKey();
                    if (entry4.getValue() == null) {
                        IShare share;
                        LoadRequest request = (LoadRequest)uuidsToLoad.get(folderItemId);
                        if (request != null) {
                            uuidsToLoad.remove(folderItemId);
                            if (request.isReloadRequest()) {
                                share = shares.get(folderItemId);
                                this.sharesToRemove.put(share.getPath().toString(), new RemovedShare(share));
                            } else {
                                FileSystemStatus msg = new FileSystemStatus(2, Messages.LoadOperation_16);
                                InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.NonExistantFolder, msg);
                                this.invalidLoadRequests.add(invalidLoadRequest);
                            }
                        } else {
                            share = shares.get(folderItemId);
                            this.sharesToRemove.put(share.getPath().toString(), new RemovedShare(share));
                        }
                    } else {
                        IFolder folder = (IFolder)entry4.getValue();
                        Path path = new Path(folder.getName());
                        if (path.segmentCount() != 1) {
                            LoadRequest request = (LoadRequest)uuidsToLoad.get(folderItemId);
                            uuidsToLoad.remove(folderItemId);
                            FileSystemStatus msg = new FileSystemStatus(4, NLS.bind((String)Messages.LoadOperation_17, (Object)folder.getName()));
                            InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.InvalidProjectName, msg);
                            this.invalidLoadRequests.add(invalidLoadRequest);
                        } else {
                            overlapRequest.getGroup().add(folder);
                        }
                    }
                    ++i;
                }
                if (overlapRequest.getGroup().size() <= 1) continue;
                overlapRequests.add(overlapRequest);
            }
            if (!componentsToRetrieve.isEmpty()) {
                List list = connection.teamRepository().itemManager().fetchCompleteItems(componentsToRetrieve, 0, (IProgressMonitor)iterProgress.newChild(10));
                for (IComponent component : list) {
                    components.put(component.getItemId(), component);
                }
            }
            if (!overlapRequests.isEmpty()) {
                FileSystemManager fileSystemManager = (FileSystemManager)FileSystemCore.getFileSystemManager(connection.teamRepository());
                FileSystemServiceProxy fileSystemService = fileSystemManager.getFileSystemService();
                List<OverlapResponse> overlapResult = fileSystemService.detectOverlap(overlapRequests, null, (IProgressMonitor)iterProgress.newChild(40));
                for (OverlapResponse response : overlapResult) {
                    ConfigurationDescriptor descriptor3 = new ConfigurationDescriptor(connection, response.getComponent());
                    HashMap uuidsToLoad2 = (HashMap)toLoad.get(descriptor3);
                    if (uuidsToLoad2 == null) continue;
                    HashMap<UUID, IAncestorReport> hashMap = new HashMap<UUID, IAncestorReport>();
                    for (IAncestorReport ancestorReport : response.getAncestorReports()) {
                        List pairs = ancestorReport.getNameItemPairs();
                        hashMap.put(((INameItemPair)pairs.get(pairs.size() - 1)).getItem().getItemId(), ancestorReport);
                    }
                    HashMap<UUID, Collection<IVersionableHandle>> overlapSituations = new HashMap<UUID, Collection<IVersionableHandle>>();
                    for (OverlapDescription overlapDescription : response.getOverlapDescriptions()) {
                        IVersionableHandle element = overlapDescription.getElement();
                        for (IVersionableHandle itemOverlapped : overlapDescription.getOverlappedChildren()) {
                            this.recordOverlap(overlapSituations, element, itemOverlapped);
                            this.recordOverlap(overlapSituations, itemOverlapped, element);
                        }
                    }
                    for (Map.Entry<Object, Object> entry5 : overlapSituations.entrySet()) {
                        LoadRequest request = (LoadRequest)uuidsToLoad2.get(entry5.getKey());
                        if (request == null) continue;
                        uuidsToLoad2.remove(entry5.getKey());
                        LoadOverlap loadOverlap = new LoadOverlap(connection, response.getComponent(), (IAncestorReport)hashMap.get(entry5.getKey()));
                        this.loadOverLaps.add(loadOverlap);
                        for (IVersionableHandle versionable : (Collection)entry5.getValue()) {
                            HashMap<UUID, IShare> shares2 = existingShares.get(descriptor3);
                            if (shares2 != null && shares2.get(versionable.getItemId()) != null) {
                                loadOverlap.addOverlappingShare(shares2.get(versionable.getItemId()));
                            }
                            loadOverlap.addOverlappingFolder((IAncestorReport)hashMap.get(versionable.getItemId()));
                        }
                    }
                }
            }
            iterProgress.setWorkRemaining(toLoad.size());
            for (Map.Entry<Object, IShare> entry6 : toLoad.entrySet()) {
                descriptor = (ConfigurationDescriptor)entry6.getKey();
                SubMonitor subIterProgress = iterProgress.newChild(1);
                subIterProgress.setWorkRemaining(((HashMap)((Object)entry6.getValue())).size());
                for (LoadRequest request : ((HashMap)((Object)entry6.getValue())).values()) {
                    IFolder folder = (IFolder)((HashMap)configurationFolders.get(descriptor)).get(request.getFolderToLoad().getItemId());
                    if (folder == null) {
                        throw new IllegalStateException();
                    }
                    LoadLocation loadLocation = new LoadLocation((ConfigurationDescriptor)descriptor, (IComponent)components.get(request.getComponent().getItemId()), folder.getName(), request.getFolderToLoad());
                    this.checkForCollision(loadLocation, folder.getName(), sharesToVerifyInSync, (IProgressMonitor)subIterProgress.newChild(1));
                }
            }
        }
    }

    private Map<UUID, Map<UUID, ? extends IVersionable>> fetchCompleteItems(IConnection connection, ArrayList<IComponentHandle> interestingComponents, ArrayList<List<? extends IVersionableHandle>> interestingVersionables, SubMonitor progress) throws TeamRepositoryException {
        HashMap<UUID, HashMap<UUID, IFolder>> fullFolders;
        if (connection instanceof IWorkspaceConnection) {
            fullFolders = ((IWorkspaceConnection)connection).configuration().fetchCompleteItems(interestingComponents, interestingVersionables, (IProgressMonitor)progress.newChild(10));
        } else {
            IConfiguration configuration = ((IBaselineConnection)connection).configuration();
            if (interestingComponents.size() != 1) {
                throw new IllegalStateException("There should be just 1 component in a baseline connection");
            }
            List<? extends IVersionableHandle> versionablesToGet = interestingVersionables.get(0);
            List fullFoldersRetrieved = configuration.fetchCompleteItems(versionablesToGet, (IProgressMonitor)progress.newChild(10));
            Iterator iFullFoldersRetrieved = fullFoldersRetrieved.iterator();
            HashMap<UUID, IFolder> fullFoldersForComponent = new HashMap<UUID, IFolder>();
            fullFolders = new HashMap<UUID, HashMap<UUID, IFolder>>(1);
            fullFolders.put(configuration.component().getItemId(), fullFoldersForComponent);
            for (IVersionableHandle iVersionableHandle : versionablesToGet) {
                IFolder folder = (IFolder)iFullFoldersRetrieved.next();
                fullFoldersForComponent.put(iVersionableHandle.getItemId(), folder);
            }
        }
        return fullFolders;
    }

    private void recordOverlap(HashMap<UUID, Collection<IVersionableHandle>> overlapSituations, IVersionableHandle element, IVersionableHandle itemOverlapped) {
        Collection<IVersionableHandle> overlap = overlapSituations.get(element.getItemId());
        if (overlap == null) {
            overlap = new ArrayList<IVersionableHandle>();
            overlapSituations.put(element.getItemId(), overlap);
        }
        overlap.add(itemOverlapped);
    }

    private HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> organizeShares() throws FileSystemClientException {
        HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>> result = new HashMap<ConfigurationDescriptor, HashMap<UUID, IShare>>();
        IShare[] iShareArray = this.getAllShares();
        int n = iShareArray.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            if (share.getSharingDescriptor() != null) {
                ISharingDescriptor shareDesc = share.getSharingDescriptor();
                ConfigurationDescriptor descriptor = new ConfigurationDescriptor(shareDesc.getRepositoryId(), shareDesc.getRepositoryUri(), shareDesc.getConnectionHandle(), shareDesc.getComponent());
                HashMap<Object, IShare> shares = result.get(descriptor);
                if (shares == null) {
                    shares = new HashMap();
                    result.put(descriptor, shares);
                }
                shares.put(shareDesc.getRootFolder().getItemId(), share);
            }
            ++n2;
        }
        return result;
    }

    private void checkForCollision(LoadLocation location, String name, HashMap<IShare, IConnection> sharesToVerifyInSync, IProgressMonitor progress) throws TeamRepositoryException {
        ICollision collision;
        ISharingDescriptor descriptor;
        IShare share;
        ICollision overWriteCollision = this.checkForOverwrite(location, name);
        if (overWriteCollision != null && overWriteCollision.collidedWithExistingContent() && (share = overWriteCollision.getShareable().getShare()) != null && (descriptor = share.getSharingDescriptor()).getConnectionHandle().sameItemId((IItemHandle)location.getDescriptor().connectionHandle) && descriptor.getComponent().sameItemId((IItemHandle)location.getDescriptor().componentHandle)) {
            sharesToVerifyInSync.put(share, location.getDescriptor().getConnection(progress));
        }
        if (this.collisions.containsKey(name)) {
            collision = this.collisions.get(name);
            collision.getLocations().add(location);
        } else if (this.treesToLoad.containsKey(name)) {
            collision = new Collision(this.getShareable(name), location, false);
            ILoadLocation otherLocation = this.treesToLoad.remove(name);
            this.newItems.remove(name);
            ((Collision)collision).getLocations().add(otherLocation);
            this.collisions.put(name, collision);
        } else {
            collision = this.checkForOverwrite(location, name);
            if (collision != null) {
                this.collisions.put(name, collision);
            } else {
                this.treesToLoad.put(name, location);
                this.newItems.put(name, new ShareableToLoad(this.getShareable(name), location));
            }
        }
    }

    protected abstract FileSystemOperation getLoadMutator(IConnection var1, IComponentHandle var2, Collection<IVersionableHandle> var3, Collection<String[]> var4, LoadTree var5, LoadDilemmaHandler var6) throws TeamRepositoryException;

    protected abstract IShareable getShareable(String var1);

    protected abstract boolean existsOnMirror(String var1);

    protected abstract void deleteShare(IShareable var1, IProgressMonitor var2) throws FileSystemClientException;

    protected abstract IShare[] getAllShares() throws FileSystemClientException;

    private ICollision checkForOverwrite(LoadLocation location, String name) throws TeamRepositoryException {
        if (this.existsOnMirror(name)) {
            IShareable shareable = this.getShareable(name);
            return new Collision(shareable, location, true);
        }
        return null;
    }

    protected abstract CopyFileAreaStore getCopyFileArea();
}

