/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.repository.common.internal.content.util.CachedDiskBackedHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreFileAgeDBHM
extends CachedDiskBackedHashMap<IPath, AgeRecord> {
    public void put(IPath path, long age, long size) {
        this.put(path, new AgeRecord(age, size));
    }

    public boolean shouldReload(IPath path, long age, long size) {
        AgeRecord rec = (AgeRecord)this.get(path);
        return rec == null || rec.age != age || rec.size != size;
    }

    protected long persistStream(ByteArrayOutputStream out) throws IOException {
        long offset = this.heap.allocate((long)out.size());
        out.writeTo(this.heap.getOutputStream(offset));
        return offset;
    }

    protected long writeObject(Object o, int flags) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        if ((1 & flags) != 0) {
            IPath path = (IPath)o;
            oos.writeUTF(path.toString());
        } else {
            oos.writeObject(o);
        }
        oos.flush();
        return this.persistStream(out);
    }

    protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(in);
        if ((1 & flags) != 0) {
            return new Path(ois.readUTF());
        }
        return ois.readObject();
    }

    public static class AgeRecord
    implements Serializable {
        private static final long serialVersionUID = 1920333109154851884L;
        long age;
        long size;

        public AgeRecord(long age, long size) {
            this.age = age;
            this.size = size;
        }
    }
}

