/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.OperationRequest;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.client.internal.isv.IWorkspaceOperationRunner;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeliverOperation
extends FileSystemOperation
implements IDeliverOperation {
    private DeliverDilemmaHandler problemHandler;
    public Map<DeliverDescriptor, DeliverOperationRequest> deliverRequests = new HashMap<DeliverDescriptor, DeliverOperationRequest>();
    private boolean flowComponents = true;

    protected DeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : dilemmaHandler;
        this.deliverRequests = new HashMap<DeliverDescriptor, DeliverOperationRequest>();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeliverOperation_0, (int)100);
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        ArrayList<IContextHandle> targets = new ArrayList<IContextHandle>();
        Collection<ConfigurationDescriptor> affectedConfigurations = this.getAffectedDeliverConfigurations(this.deliverRequests.values(), determinants, targets, (IProgressMonitor)progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, targets, determinants);
        try {
            IChangeHistorySyncReport report;
            SubMonitor loopProgress;
            this.runPreConditionsOnly((IProgressMonitor)progress.newChild(1));
            if (this.flowComponents) {
                progress.subTask(Messages.DeliverOperation_1);
                loopProgress = progress.newChild(10).setWorkRemaining(this.deliverRequests.size() * 4);
                for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
                    report = deliverRequest.getSyncReport();
                    List componentOps = FlowUtils.getComponentSynchronizationOps((boolean)deliverRequest.isWorkspaceContext(), deliverRequest.getAffectedComponents((IProgressMonitor)loopProgress.newChild(1)), (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace(), (IChangeHistorySyncReport)report);
                    if (componentOps.size() <= 0) continue;
                    ArrayList csToClose = new ArrayList();
                    for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                        if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp)) continue;
                        csToClose.addAll(deliverRequest.getWorkspace().activeChangeSets(componentOp.getComponent()));
                    }
                    deliverRequest.getWorkspace().closeChangeSets(csToClose, (IProgressMonitor)loopProgress.newChild(1));
                    deliverRequest.getTargetWorkspace().applyComponentOperations(componentOps, (IProgressMonitor)loopProgress.newChild(1));
                    SubMonitor loopProgress2 = loopProgress.newChild(1).setWorkRemaining(componentOps.size() * 2);
                    for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                        if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                            FlowUtils.addComponentSyncState((IWorkspaceConnection)deliverRequest.getWorkspace(), (IConnection)deliverRequest.getTargetWorkspace(), (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)loopProgress2.newChild(1));
                        } else if (componentOp instanceof IFlowNodeConnection.IComponentDeletionOp) {
                            FlowUtils.removeComponentSyncState((IWorkspaceConnection)deliverRequest.getWorkspace(), (IConnection)deliverRequest.getTargetWorkspace(), (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)loopProgress2.newChild(1));
                        }
                        deliverRequest.clearChanges(componentOp.getComponent(), (IProgressMonitor)loopProgress2.newChild(1));
                    }
                }
            }
            loopProgress = progress.newChild(88).setWorkRemaining(this.deliverRequests.size());
            progress.subTask(Messages.DeliverOperation_0);
            for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
                report = deliverRequest.getSyncReport();
                if (deliverRequest.getChangeSets().size() <= 0 && deliverRequest.getBaselines().size() <= 0) continue;
                ((IWorkspaceOperationRunner)deliverRequest.getWorkspace()).runDeliverWithPrecondition(new IWorkspaceOperationRunner.IWorkspaceOperationRunnable(){

                    public void run(IProgressMonitor monitor) throws TeamRepositoryException {
                        try {
                            DeliverOperation.this.verifyUncheckedInChanges(monitor);
                        }
                        catch (FileSystemClientException e) {
                            throw new TeamRepositoryException(e.getMessage(), (Throwable)((Object)e));
                        }
                    }
                }, report, deliverRequest.getBaselines(), deliverRequest.getChangeSets(), (IProgressMonitor)loopProgress.newChild(1));
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
            progress.done();
        }
    }

    private void verifyNonDefaultTargets() throws FileSystemClientException {
        int result;
        ArrayList<IWorkspaceConnection> nonDefaultTargets = new ArrayList<IWorkspaceConnection>(1);
        for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
            IWorkspaceConnection source = deliverRequest.getWorkspace();
            IWorkspaceConnection target = deliverRequest.getTargetWorkspace();
            IWorkspaceHandle defaultTarget = FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)source);
            if (defaultTarget != null && defaultTarget.sameItemId((IItemHandle)target.getResolvedWorkspace())) continue;
            nonDefaultTargets.add(target);
        }
        if (nonDefaultTargets.size() > 0 && (result = this.getProblemHandler().notDefaultTarget(nonDefaultTargets)) != 0) {
            if (result == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemClientException(new FileSystemStatus(4, Messages.DeliverOperation_2));
        }
    }

    private void verifyComponentFlowing(SubMonitor newChild) throws FileSystemClientException, TeamRepositoryException {
        ArrayList<IComponentHandle> added = new ArrayList<IComponentHandle>();
        ArrayList<IComponentHandle> removed = new ArrayList<IComponentHandle>();
        ArrayList<UUID> affectedComponents = new ArrayList<UUID>();
        for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
            if (deliverRequest.isComponentContext()) continue;
            List componentOps = FlowUtils.getComponentSynchronizationOps((boolean)deliverRequest.isWorkspaceContext(), deliverRequest.getAffectedComponents((IProgressMonitor)newChild), (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace(), (IChangeHistorySyncReport)deliverRequest.getSyncReport());
            for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                IComponentHandle component = componentOp.getComponent();
                affectedComponents.add(component.getItemId());
                if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                    added.add(component);
                    continue;
                }
                if (!(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                removed.add(component);
            }
        }
        if (added.size() > 0 || removed.size() > 0) {
            int result = this.getProblemHandler().componentsToBeAddedOrRemoved(added, removed);
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result == 2) {
                throw new FileSystemClientException(new FileSystemStatus(4, Messages.DeliverOperation_3));
            }
            if (result == 3) {
                this.setFlowComponents(false);
                for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
                    List<IComponentHandle> impactedComponents = deliverRequest.getAffectedComponents((IProgressMonitor)newChild);
                    for (IComponentHandle componentHandle : impactedComponents) {
                        if (!affectedComponents.contains(componentHandle.getItemId())) continue;
                        deliverRequest.clearChanges(componentHandle, (IProgressMonitor)newChild);
                    }
                }
            }
        }
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report) {
        DeliverOperationRequest request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        ArrayList components = new ArrayList();
        try {
            components.addAll(sourceWorkspace.getComponents());
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        this.deliverRequests.put(new DeliverDescriptor(sourceWorkspace, targetWorkspace), request);
        for (IComponentHandle componentHandle : components) {
            this.deliver(sourceWorkspace, targetWorkspace, report, componentHandle);
        }
        request.setWorkspaceContext(true);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, IComponentHandle component, boolean flowAll) {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && request.isWorkspaceContext()) {
            return;
        }
        if (request == null) {
            ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), components);
            request.setComponentContext(!flowAll);
            this.deliverRequests.put(deliverKey, request);
        }
        if (!request.getComponents().contains(component)) {
            request.setReport(report);
            request.getComponents().add(component);
            this.selectWhatToDeliver(sourceWorkspace, targetWorkspace, component, report, request.getChangeSets(), request.getBaselines());
        }
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, IComponentHandle component) {
        this.deliver(sourceWorkspace, targetWorkspace, report, component, false);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, List<? extends IChangeSetHandle> changeSets) {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && (request.isWorkspaceContext() || request.isComponentContext())) {
            return;
        }
        if (request == null) {
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
            this.deliverRequests.put(deliverKey, request);
        }
        request.getChangeSets().addAll(changeSets);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, List<IComponentHandle> components) throws TeamRepositoryException {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && request.isWorkspaceContext()) {
            return;
        }
        if (request == null) {
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
            this.deliverRequests.put(deliverKey, request);
        }
        request.getChangeSets().addAll(changeSets);
        request.getBaselines().addAll(baselines);
        request.getComponents().addAll(components);
    }

    protected void setFlowComponents(boolean flowComponents) {
        this.flowComponents = flowComponents;
    }

    protected Collection<DeliverOperationRequest> getDeliverRequests() {
        return this.deliverRequests.values();
    }

    protected DeliverDilemmaHandler getProblemHandler() {
        return this.problemHandler;
    }

    protected Collection<ConfigurationDescriptor> getAffectedDeliverConfigurations(Collection<DeliverOperationRequest> requests, List<IAuditable> determinants, List<IContextHandle> targets, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection<ConfigurationDescriptor> descriptors = this.getAffectedConfigurations(requests, determinants, monitor);
        for (DeliverOperationRequest deliverOperationRequest : requests) {
            targets.add((IContextHandle)deliverOperationRequest.getTargetWorkspace().getResolvedWorkspace());
            targets.add((IContextHandle)deliverOperationRequest.getWorkspace().getResolvedWorkspace());
        }
        return descriptors;
    }

    protected abstract void verifyUncheckedInChanges(IProgressMonitor var1) throws TeamRepositoryException, FileSystemClientException;

    private void selectWhatToDeliver(IWorkspaceConnection source, IWorkspaceConnection target, IComponentHandle component, IChangeHistorySyncReport report, List<IChangeSetHandle> changeSets, List<IBaselineHandle> baselines) {
        try {
            List outgoingBaselines;
            IBaselineHandle sourceBasis = source.getComponentInfo(component).basis();
            IBaselineHandle targetBasis = target.getComponentInfo(component).basis();
            if (!sourceBasis.sameItemId((IItemHandle)targetBasis) && (outgoingBaselines = ItemLists.handlesToIds((Collection)report.outgoingBaselines(component))).contains(ItemId.create((IItemHandle)sourceBasis))) {
                baselines.add(sourceBasis);
                changeSets.addAll(report.outgoingChangeSetsAfterBasis(component));
                return;
            }
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
        changeSets.addAll(report.outgoingChangeSets(component));
    }

    @Override
    public void runPreConditionsOnly(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        this.verifyNonDefaultTargets();
        this.verifyComponentFlowing(progress.newChild(5));
        this.verifyUncheckedInChanges((IProgressMonitor)progress.newChild(5));
    }

    public static class DeliverDescriptor {
        public IWorkspaceConnection source;
        public IWorkspaceConnection target;

        public DeliverDescriptor(IWorkspaceConnection source, IWorkspaceConnection target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof DeliverDescriptor)) {
                return false;
            }
            return ((DeliverDescriptor)other).source.equals((Object)this.source) && ((DeliverDescriptor)other).target.equals((Object)this.target);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.source.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeliverOperationRequest
    extends OperationRequest {
        private IWorkspaceConnection targetWorkspace;
        private boolean workspaceContext = false;
        private boolean componentContext = false;

        public DeliverOperationRequest(IWorkspaceConnection workspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, List<IComponentHandle> components) {
            super(workspace, syncReport, baselines, changeSets, components);
            this.targetWorkspace = targetWorkspace;
        }

        public IWorkspaceConnection getTargetWorkspace() {
            return this.targetWorkspace;
        }

        public boolean isWorkspaceContext() {
            return this.workspaceContext;
        }

        public void setWorkspaceContext(boolean workspaceContext) {
            this.workspaceContext = workspaceContext;
        }

        public boolean isComponentContext() {
            return this.componentContext;
        }

        public void setComponentContext(boolean componentContext) {
            this.componentContext = componentContext;
        }
    }
}

