/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.FileSystemView;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommitOperation
extends FileSystemOperation {
    protected final IWorkspaceConnection workspace;
    protected final IComponentHandle component;
    protected IChangeSetHandle changeSet;
    protected final Map<UUID, IChangeSetHandle> changeSetsCommitted;
    protected final ITeamRepository repository;
    protected final FileSystemView fsv;
    protected final CommitDilemmaHandler commitProblemHandler;

    public AbstractCommitOperation(IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle changeSet, CommitDilemmaHandler commitProblemHandler) {
        super(commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler);
        this.workspace = workspace;
        this.component = component;
        this.repository = workspace.teamRepository();
        this.fsv = (FileSystemView)FileSystemCore.getFileSystemManager(workspace.teamRepository()).getFileSystemView((IConnection)workspace);
        this.commitProblemHandler = commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler;
        this.changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
        if (changeSet == null) {
            throw new IllegalArgumentException();
        }
        this.changeSet = changeSet;
    }

    public AbstractCommitOperation(IWorkspaceConnection workspace, IComponentHandle component, CommitDilemmaHandler commitProblemHandler) {
        super(commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler);
        this.workspace = workspace;
        this.component = component;
        this.repository = workspace.teamRepository();
        this.fsv = (FileSystemView)FileSystemCore.getFileSystemManager(workspace.teamRepository()).getFileSystemView((IConnection)workspace);
        this.commitProblemHandler = commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler;
        this.changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
        this.changeSet = null;
    }

    public Collection<IChangeSetHandle> getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }
}

