/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.IVersionableTree;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFolderAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFolderDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class LocalChangeTracker {
    public static final Object CHANGES_COMPUTER_JOB_FAMILY = Messages.LocalChangeTracker_0;
    private static final long DELAY = 200000000L;
    private static final long DELAY_MS = 200L;
    private LocalChangeNotifier notifier;
    private LocalChangeContext context;
    private LocalChangeNode changeTree = new LocalChangeNode(null, null);
    private IVersionableTree versionableTree;
    private LocalChangesComputer computeChangesjob;
    private Map<UUID, LocalChange> localChanges = new HashMap<UUID, LocalChange>();
    private HashMap<DateRecord, Long> needDates = new HashMap();
    private final IPath copyFileAreaRoot;

    private static void setCounterpart(LocalMoveFrom moveFrom, LocalMoveTo moveTo) {
        moveFrom.setCounterpart(moveTo);
        moveTo.setCounterpart(moveFrom);
    }

    private static void setNode(LocalChangeNode node, LocalChange change) {
        change.setNode(node);
        node.addChange(change);
    }

    public LocalChangeTracker(IPath copyFileAreaRoot, IVersionableTree versionableTree, LocalChangeNotifier notifier, LocalChangeContext context, ISchedulingRule schedulingRule) {
        this.notifier = notifier;
        this.context = context;
        this.versionableTree = versionableTree;
        this.computeChangesjob = new LocalChangesComputer(schedulingRule);
        this.copyFileAreaRoot = copyFileAreaRoot;
        this.computeChangesjob.requestRefresh();
    }

    public synchronized void cancelChanges(ILocalChange[] canceled) {
        ILocalChange[] allCanceled = this.forgetChanges(canceled);
        this.notifier.changesCanceled(this.context, allCanceled);
    }

    public synchronized void cancelChanges(IShareable root) {
        ILocalChange[] allCanceled = this.forgetChanges(root);
        this.notifier.changesCanceled(this.context, allCanceled);
    }

    private void changeCanceled(LocalChange change) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeCanceled(this.context, change);
        }
    }

    private void changeOccurred(LocalChange change) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeOccurred(this.context, change);
        }
    }

    public synchronized void confirmChanges(ILocalChange[] confirmed) {
        ILocalChange[] allConfirmed = this.forgetChanges(confirmed);
        this.notifier.changesConfirmed(this.context, allConfirmed);
    }

    private ILocalChange[] forgetChanges(ILocalChange[] toForget) {
        ArrayList<LocalChange> closure = new ArrayList<LocalChange>();
        int i = 0;
        while (i < toForget.length) {
            if (!toForget[i].isCanceled()) {
                LocalChange c = (LocalChange)toForget[i];
                closure.add(c);
                c.cancel();
                c.getNode().removeChange(c);
                this.localChanges.remove(c.getItemId());
            }
            ++i;
        }
        return closure.toArray(new ILocalChange[closure.size()]);
    }

    private ILocalChange[] forgetChanges(IShareable shareable) {
        LocalChangeNode startingPoint = this.changeTree.getNode(shareable.getLocalFullPath(), false);
        if (startingPoint == null) {
            return new ILocalChange[0];
        }
        ArrayList closure = new ArrayList();
        startingPoint.collect(closure);
        for (LocalChange c : closure) {
            c.cancel();
            this.localChanges.remove(c.getItemId());
        }
        this.clear(startingPoint);
        return closure.toArray(new ILocalChange[closure.size()]);
    }

    public synchronized ILocalChange getPendingChange(IVersionableHandle item) {
        if (item == null) {
            return NoOpChange.NO_OP;
        }
        LocalChange c = this.localChanges.get(item.getItemId());
        if (c == null) {
            return NoOpChange.NO_OP;
        }
        c.setWild();
        return c;
    }

    public ILocalChange[] getPendingChanges() {
        return this.getPendingChanges(false);
    }

    public synchronized ILocalChange[] getPendingChanges(boolean consume) {
        ILocalChange[] changes;
        ILocalChange[] iLocalChangeArray = changes = this.getPendingChanges(this.changeTree, consume);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            ((LocalChange)change).setWild();
            ++n2;
        }
        return changes;
    }

    public synchronized ILocalChange[] getPendingChanges(IPath root, boolean consume) {
        ILocalChange[] changes;
        LocalChangeNode rootNode = this.changeTree.getNode(root, false);
        if (rootNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        ILocalChange[] iLocalChangeArray = changes = this.getPendingChanges(rootNode, consume);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            ((LocalChange)change).setWild();
            ++n2;
        }
        return changes;
    }

    public synchronized ILocalChange[] getPendingChangesAt(IPath root) {
        ILocalChange[] changes;
        LocalChangeNode rootNode = this.changeTree.getNode(root, false);
        if (rootNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        ILocalChange[] iLocalChangeArray = changes = rootNode.getChanges().toArray(new LocalChange[rootNode.getChanges().size()]);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange c = iLocalChangeArray[n2];
            ((LocalChange)c).setWild();
            ++n2;
        }
        return changes;
    }

    private ILocalChange[] getPendingChanges(LocalChangeNode startingPoint, boolean consume) {
        Assert.isNotNull((Object)startingPoint);
        ArrayList result = new ArrayList();
        startingPoint.collect(result);
        if (consume) {
            for (LocalChange change : result) {
                this.localChanges.remove(change.getItemId());
                change.cancel();
            }
            this.clear(startingPoint);
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    public void trackFileAddition(IPath path, IFolderHandle targetParent, IShareable shareable, IProgressMonitor monitor) {
        if (path == null) {
            throw new IllegalArgumentException(Messages.LocalChangeTracker_4);
        }
        if (targetParent == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.LocalChangeTracker_5, (Object)path));
        }
        if (shareable != null && this.shouldTrackerIgnore(shareable, null)) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle target = this.versionableTree.getVersionableHandle(path);
        if (target != null) {
            Assert.isTrue((target.getItemType() == IFileItem.ITEM_TYPE ? 1 : 0) != 0);
        } else {
            target = this.versionableTree.getDeletedVersionable(targetParent, path.lastSegment(), (IProgressMonitor)progress.newChild(50));
            if (target == null || target.getItemType() != IFileItem.ITEM_TYPE) {
                this.versionableTree.createVersionable(path, IFileItem.ITEM_TYPE, (IProgressMonitor)progress.newChild(50));
            } else {
                this.versionableTree.restoreVersionable(path, target, (IProgressMonitor)progress.newChild(50));
            }
        }
        progress.done();
    }

    public void trackFileChange(IPath path, IFileItemHandle target, IShareable shareable) {
        Assert.isNotNull((Object)path);
        if (shareable != null && this.shouldTrackerIgnore(shareable, null)) {
            return;
        }
        if (target == null) {
            Assert.isTrue((boolean)false, (String)(String.valueOf(path.toString()) + " cannot be null"));
        }
        this.versionableTree.trackFileChange((IVersionableHandle)target, path);
    }

    public boolean shouldTrackerIgnore(IShareable shareable, IProgressMonitor mon) {
        if (shareable == null) {
            throw new IllegalArgumentException(Messages.LocalChangeTracker_7);
        }
        if (!shareable.shouldBeIgnored()) {
            return false;
        }
        if (SharingManager.getInstance().getItemInfo(shareable) != null) {
            return false;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        try {
            IFolderHandle parent = (IFolderHandle)this.versionableTree.getVersionableHandle(shareable.getLocalFullPath().removeLastSegments(1));
            IVersionableHandle deleted = this.versionableTree.getDeletedVersionable(parent, shareable.getLocalFullPath().lastSegment(), null);
            boolean bl = deleted == null;
            return bl;
        }
        finally {
            progress.done();
        }
    }

    public void trackFileDeletion(IPath path, IFileItemHandle target, IFolderHandle targetParent, IShareable shareable) {
    }

    public void trackFolderAddition(IPath path, IFolderHandle targetParent, IShareable shareable, IProgressMonitor monitor) {
        if (path == null) {
            throw new IllegalArgumentException(Messages.LocalChangeTracker_8);
        }
        if (targetParent == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.LocalChangeTracker_9, (Object)path));
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle target = this.versionableTree.getVersionableHandle(path);
        if (target != null) {
            Assert.isTrue((target.getItemType() == IFolder.ITEM_TYPE ? 1 : 0) != 0);
        } else {
            target = this.versionableTree.getDeletedVersionable(targetParent, path.lastSegment(), (IProgressMonitor)progress.newChild(50));
            if (target == null || target.getItemType() != IFolder.ITEM_TYPE) {
                this.versionableTree.createVersionable(path, IFolder.ITEM_TYPE, (IProgressMonitor)progress.newChild(50));
            } else {
                this.versionableTree.restoreVersionable(path, target, (IProgressMonitor)progress.newChild(50));
            }
        }
        progress.done();
    }

    public void trackFolderDeletion(IPath path, IFolderHandle target, IFolderHandle targetParent, IShareable shareable) {
    }

    public void trackMove(IPath srcPath, IPath destPath, IVersionableHandle target, IFolderHandle sourceParent, IFolderHandle destinationParent, IShareable sourceShareable) {
    }

    public void trackDeletion(IPath path, IVersionableHandle target, IFolderHandle targetParent, IShareable shareable) throws FileSystemClientException {
        if (target instanceof IFileItemHandle) {
            this.trackFileDeletion(path, (IFileItemHandle)target, targetParent, shareable);
        } else if (target instanceof IFolderHandle) {
            this.trackFolderDeletion(path, (IFolderHandle)target, targetParent, shareable);
        } else {
            throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LocalChangeTracker_10, (Object)target.getClass().getSimpleName())));
        }
    }

    public void trackAddition(IPath path, IFolderHandle targetParent, Shareable shareable, IProgressMonitor monitor) {
        if (shareable.getFileStorage().isFolder()) {
            this.trackFolderAddition(path, targetParent, shareable, monitor);
        } else {
            this.trackFileAddition(path, targetParent, shareable, monitor);
        }
    }

    private void clear(LocalChangeNode startingPoint) {
        startingPoint.prune();
    }

    public void syncChanges() {
        this.computeChangesjob.rejoin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPendingChanges() throws FileSystemClientException {
        Object pair;
        SharingManager shareManager = SharingManager.getInstance();
        HashMap<DateRecord, Long> modifiedInFuture = new HashMap<DateRecord, Long>();
        while (true) {
            HashMap<DateRecord, Long> hashMap = this.needDates;
            synchronized (hashMap) {
                if (this.needDates.isEmpty()) {
                    break;
                }
                Iterator<Map.Entry<DateRecord, Long>> it = this.needDates.entrySet().iterator();
                pair = it.next();
                it.remove();
            }
            DateRecord rec = (DateRecord)pair.getKey();
            long hashedAt = (Long)pair.getValue();
            IShareable shareable = shareManager.findShareable(this.copyFileAreaRoot, rec.versionable, rec.component, rec.connection, null);
            if (shareable == null) continue;
            long stamp = ((Shareable)shareable).getFileStorage().getLocalTimeStamp();
            if (stamp != hashedAt) {
                if (stamp >= hashedAt) continue;
                modifiedInFuture.put(rec, hashedAt);
                continue;
            }
            FileItemInfo oldInfo = shareManager.getItemInfo(shareable);
            Assert.isNotNull((Object)oldInfo);
            Assert.isNotNull((Object)oldInfo.getHash());
            FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), ((Shareable)shareable).getFileStorage().getModificationStamp(), oldInfo.getParent(), oldInfo.getName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getContentType(), oldInfo.getStoredContentId(), oldInfo.getStoredDeltaPredecessor(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredChecksum(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isExecutable(), oldInfo.isOriginalExecutable());
            SharingManager.getInstance().setItemInfo(shareable, newInfo, null);
        }
        pair = this.needDates;
        synchronized (pair) {
            this.needDates.putAll(modifiedInFuture);
        }
        List<IVersionableTree.IChangeType> changes = this.versionableTree.getChangedItems();
        ArrayList<LocalChange> localChanges = new ArrayList<LocalChange>(changes.size());
        HashSet<UUID> modifiedItems = new HashSet<UUID>();
        block13: for (IVersionableTree.IChangeType ct : changes) {
            switch (ct.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    if (ct.getItem() instanceof IFolderHandle) {
                        localChanges.add(new LocalFolderDeletion(this.context, ct.getCurrentPath(), ct.getOriginalPath(), (IFolderHandle)ct.getItem(), ct.getPreviousParent()));
                    } else {
                        localChanges.add(new LocalFileDeletion(this.context, ct.getCurrentPath(), ct.getOriginalPath(), (IFileItemHandle)ct.getItem(), ct.getPreviousParent()));
                    }
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                case 3: {
                    int type = 0;
                    if (ct.isContentChange()) {
                        type = 1;
                    }
                    if (ct.isFlagChange()) {
                        type |= 0x20;
                    }
                    LocalMoveFrom moveFrom = new LocalMoveFrom(this.context, ct.getCurrentMovedFromPath(), ct.getOriginalPath(), ct.getItem(), ct.getPreviousParent(), type);
                    LocalMoveTo moveTo = new LocalMoveTo(this.context, ct.getCurrentPath(), ct.getItem(), ct.getCurrentParent(), type);
                    LocalChangeTracker.setCounterpart(moveFrom, moveTo);
                    localChanges.add(moveTo);
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                case 4: {
                    if (ct.getItem() instanceof IFolderHandle) {
                        localChanges.add(new LocalFolderAddition(this.context, ct.getCurrentPath(), (IFolderHandle)ct.getItem(), ct.getCurrentParent()));
                    } else {
                        localChanges.add(new LocalFileAddition(this.context, ct.getCurrentPath(), (IFileItemHandle)ct.getItem(), ct.getCurrentParent()));
                    }
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                default: {
                    int type = 0;
                    if (ct.isContentChange()) {
                        type = 1;
                    }
                    if (ct.isFlagChange()) {
                        type |= 0x20;
                    }
                    if (type == 0) continue block13;
                    localChanges.add(new LocalFileChange(this.context, ct.getCurrentPath(), ct.getOriginalPath(), (IFileItemHandle)ct.getItem(), type));
                    modifiedItems.add(ct.getItem().getItemId());
                }
            }
        }
        Iterator<Map.Entry<UUID, LocalChange>> i = this.localChanges.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<UUID, LocalChange> e = i.next();
            if (modifiedItems.contains(e.getKey())) continue;
            e.getValue().cancel();
            e.getValue().getNode().removeChange(e.getValue());
            this.changeCanceled(e.getValue());
            i.remove();
        }
        for (LocalChange c : localChanges) {
            IShareable shareable;
            LocalChange oldChange = this.localChanges.get(c.getItemId());
            if (oldChange != null) {
                if (c.equals(oldChange)) continue;
                oldChange.cancel();
                oldChange.getNode().removeChange(oldChange);
                this.changeCanceled(oldChange);
            }
            if (!c.isType(8) && (shareable = c.getShareable()) != null && shareable.shouldBeIgnored()) continue;
            LocalChangeNode node = this.changeTree.getNode(c.getPath(), true);
            LocalChangeTracker.setNode(node, c);
            this.localChanges.put(c.getItemId(), c);
            this.changeOccurred(c);
        }
    }

    public void computePendingChanges(IShareable root, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ArrayList<FileSystemClientException> exceptions = new ArrayList<FileSystemClientException>();
        final CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(root.getRoot());
        IShare share = root.getShare();
        ISchedulingRule rule = cfa.lock(share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle(), (IProgressMonitor)progress.newChild(1));
        try {
            final ArrayList<IShareable> toVisit = new ArrayList<IShareable>();
            toVisit.add(root);
            do {
                progress.setWorkRemaining(99);
                final ArrayList toDelete = new ArrayList();
                IShareable next = (IShareable)toVisit.remove(toVisit.size() - 1);
                next.accept(new IShareableVisitor(){

                    public boolean visit(IShareable shareable, IProgressMonitor monitor) {
                        if (shareable.shouldBeIgnored()) {
                            return false;
                        }
                        IFileStorage fileStorage = ((Shareable)shareable).getFileStorage();
                        IFileStorage parent = fileStorage.getParent();
                        if (parent == null) {
                            return true;
                        }
                        if (!((Shareable)shareable).isLocal()) {
                            toDelete.add(shareable);
                            return false;
                        }
                        FileItemInfo info = cfa.getItemInfo(shareable.getLocalFullPath());
                        if (info != null && info.isFolder() != fileStorage.isFolder()) {
                            toDelete.add(shareable);
                            toVisit.add(shareable);
                            return false;
                        }
                        if (info == null) {
                            if (fileStorage.isFolder()) {
                                LocalChangeTracker.this.trackFolderAddition(shareable.getLocalFullPath(), (IFolderHandle)LocalChangeTracker.this.versionableTree.getVersionableHandle(parent.getFullPath()), shareable, monitor);
                            } else {
                                LocalChangeTracker.this.trackFileAddition(shareable.getLocalFullPath(), (IFolderHandle)LocalChangeTracker.this.versionableTree.getVersionableHandle(parent.getFullPath()), shareable, monitor);
                            }
                        } else if (!info.isFolder() && info.getHash() != null) {
                            boolean contentChange = false;
                            try {
                                try {
                                    SharingManager.getInstance().disableChangeMonitoring();
                                    InputStream in = fileStorage.getContents();
                                    contentChange = fileStorage.isContentChangedFrom(info.getLastModification(), info.getContentLength(), shareable, in, monitor);
                                }
                                catch (FileSystemClientException e) {
                                    if (e.getStatus().getCode() != 203) {
                                        exceptions.add(e);
                                    }
                                    SharingManager.getInstance().enableChangeMonitoring();
                                    return true;
                                }
                            }
                            finally {
                                SharingManager.getInstance().enableChangeMonitoring();
                            }
                            if (contentChange) {
                                LocalChangeTracker.this.versionableTree.trackFileChange(info.getVersionableHandle(), shareable.getLocalFullPath());
                            } else if (fileStorage.isExecutable() != info.isOriginalExecutable()) {
                                LocalChangeTracker.this.versionableTree.trackFileChange(info.getVersionableHandle(), shareable.getLocalFullPath());
                                contentChange = true;
                            }
                            if (!contentChange) {
                                FileItemInfo touchedInfo = new FileItemInfo(info.getVersionableHandle(), fileStorage.getModificationStamp(), info.getParent(), info.getName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredContentId(), info.getStoredDeltaPredecessor(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredChecksum(), info.getStoredNumLineDelimiters(), info.isExecutable(), info.isOriginalExecutable());
                                try {
                                    cfa.setItemInfo(shareable, touchedInfo, monitor);
                                }
                                catch (FileSystemClientException e) {
                                    exceptions.add(e);
                                }
                            }
                        }
                        return true;
                    }
                }, Integer.MAX_VALUE, true, true, (IProgressMonitor)progress.newChild(68));
                SubMonitor subProgress = progress.newChild(10);
                subProgress.setWorkRemaining(toDelete.size());
                for (IShareable shareable : toDelete) {
                    try {
                        cfa.deleteTreeInfo(shareable, false, (IProgressMonitor)subProgress.newChild(1));
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                }
                subProgress.done();
            } while (!toVisit.isEmpty());
            if (!exceptions.isEmpty()) {
                MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.LocalChangeTracker_11, null);
                for (FileSystemClientException ex : exceptions) {
                    multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
                }
                throw new FileSystemClientException((IStatus)multi);
            }
        }
        finally {
            cfa.release(rule, (IProgressMonitor)progress.newChild(1));
            this.computeChangesjob.requestRefresh();
            progress.done();
        }
    }

    public LocalChangeContext getContext() {
        return this.context;
    }

    public void metadataChanged() {
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatelessVersionable(long hashedAt, IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            DateRecord rec = new DateRecord(handle, component, connection);
            this.needDates.remove(rec);
            this.needDates.put(rec, hashedAt);
        }
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDatelessVersionable(IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            DateRecord rec = new DateRecord(handle, component, connection);
            this.needDates.remove(rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatelessVersionable(long hashedAt, IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        Long oldDate;
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            oldDate = this.needDates.get(new DateRecord(handle, component, connection));
        }
        return oldDate != null && oldDate == hashedAt;
    }

    private static class DateRecord {
        IVersionableHandle versionable;
        IComponentHandle component;
        IContextHandle connection;

        DateRecord(IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
            this.versionable = handle;
            this.component = component;
            this.connection = connection;
        }

        public int hashCode() {
            return this.versionable.getItemId().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof DateRecord)) {
                return false;
            }
            DateRecord other = (DateRecord)o;
            return this.versionable.sameItemId((IItemHandle)other.versionable) && this.component.sameItemId((IItemHandle)other.component) && this.connection.sameItemId((IItemHandle)other.connection);
        }

        public String toString() {
            return "DateRecord(" + this.versionable.toString() + ")";
        }
    }

    class LocalChangesComputer
    extends Job {
        volatile long lastRecompute;
        volatile long lastRequest;

        public LocalChangesComputer(ISchedulingRule rule) {
            super(Messages.LocalChangeTracker_1);
            this.setPriority(30);
            this.setRule(rule);
            this.setSystem(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ISchedulingRule rule = LocalChangeTracker.this.versionableTree.lock((IProgressMonitor)progress.newChild(1));
                try {
                    long time = System.nanoTime();
                    long lastReq = this.lastRequest;
                    long remaining = (lastReq + 200000000L - time) / 1000000L;
                    if (remaining > 5L) {
                        this.schedule(remaining);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    this.runRecompute();
                    progress.worked(98);
                    return Status.OK_STATUS;
                }
                finally {
                    LocalChangeTracker.this.versionableTree.unlock(rule, (IProgressMonitor)progress.newChild(1));
                    progress.done();
                }
            }
            catch (FileSystemClientException e) {
                return FileSystemStatus.getStatusFor((Throwable)((Object)e));
            }
        }

        public boolean belongsTo(Object family) {
            return family == CHANGES_COMPUTER_JOB_FAMILY;
        }

        public void requestRefresh() {
            this.lastRequest = System.nanoTime();
            if (this.getState() == 4) {
                this.cancel();
            }
            this.schedule(200L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runRecompute() throws FileSystemClientException {
            this.lastRecompute = System.nanoTime();
            LocalChangeTracker localChangeTracker = LocalChangeTracker.this;
            synchronized (localChangeTracker) {
                LocalChangeTracker.this.refreshPendingChanges();
            }
        }

        public void rejoin() {
            if (LocalChangeTracker.this.versionableTree.isLocked()) {
                this.cancel();
                if (this.lastRequest <= this.lastRecompute) {
                    return;
                }
                try {
                    this.runRecompute();
                }
                catch (FileSystemClientException e) {
                    LoggingHelper.log(e);
                }
            } else {
                while (true) {
                    if (this.getState() == 0) {
                        if (this.lastRequest <= this.lastRecompute) {
                            return;
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        this.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

